/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.kdjsystem.mlink.shop.ImageUpload.NaverUploadImageDto;
import com.kdjsystem.mlink.shop.ImageUpload.UploadSession;
import com.kdjsystem.mlink.shop.ImageUpload.UploadSessionFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

class UploadTask
implements Callable<NaverUploadImageDto> {
    private final String imagePath;
    private final Map<String, String> loginCookie;

    public UploadTask(String imagePath, Map<String, String> loginCookie) {
        this.imagePath = imagePath;
        this.loginCookie = loginCookie;
    }

    @Override
    public NaverUploadImageDto call() throws Exception {
        UploadSession session = UploadSessionFactory.create(this.loginCookie);
        String uploadUrl = String.format("https://ecommerce.upphoto.naver.com%s/%s", session.getUploadPath().replace("simpleUploader", "simpleUpload"), 0);
        String uploadReferer = String.format("https://ecommerce.upphoto.naver.com%s/%s", session.getUploadPath().replace("simpleUpload", "simpleUploader/?pin="), session.getPincode());
        File file = new File(this.imagePath);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream fs = new FileInputStream(file);){
                Connection.Response response = Jsoup.connect((String)uploadUrl).userAgent("Mozilla").referrer(uploadReferer).header("Origin", "https://ecommerce.upphoto.naver.com").data("image", file.getName(), (InputStream)fs).data("pin", session.getPincode()).cookies(this.loginCookie).method(Connection.Method.POST).timeout(60000).execute();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{NaverUploadImageDto.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                StringReader reader = new StringReader(response.body());
                NaverUploadImageDto result = (NaverUploadImageDto)unmarshaller.unmarshal((Reader)reader);
                result.setThumbnail("http://shop1.phinf.naver.net/" + result.getThumbnail());
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JAXBException e) {
            throw new IOException("\uc5c5\ub85c\ub4dc \uc2e4\ud328: " + this.imagePath + " (" + e.getMessage() + ")", e);
        }
    }
}

