/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueueCapacityCalculator {
    private static final Logger logger = LoggerFactory.getLogger(QueueCapacityCalculator.class);
    private static final long APPROX_MEM_PER_TASK = 0x200000L;
    private static final double RESERVE_RATIO = 0.25;
    private static final int MIN_CAPACITY = 10;
    private static final int MAX_CAPACITY = 50000;
    private static final int DEFAULT_CAPACITY = 1000;

    private QueueCapacityCalculator() {
    }

    public static int calculateQueueCapacity() {
        long maxHeapMB = Runtime.getRuntime().maxMemory() / 0x100000L;
        YDMAStringUtil.Print("Max Heap Memory: " + maxHeapMB + " MB");
        try {
            Runtime rt = Runtime.getRuntime();
            long maxHeap = rt.maxMemory();
            long totalHeap = rt.totalMemory();
            long freeHeap = maxHeap - (totalHeap - rt.freeMemory());
            long reserveHeap = (long)Math.floor((double)freeHeap * 0.25);
            long count = reserveHeap / 0x200000L;
            int cap = (int)Math.max(10L, Math.min(count, 50000L));
            logger.info("Calculated queue capacity: {}", (Object)cap);
            return cap;
        }
        catch (Throwable t) {
            logger.warn("Failed to calculate queue capacity, using default {}", (Object)1000, (Object)t);
            return 1000;
        }
    }
}

