/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.ImageUpload.EasyCloudUsageService;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.ProductFactory;
import com.kdjsystem.mlink.shop.common.QueueCapacityCalculator;
import com.kdjsystem.mlink.shop.common.SchedulerService;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.mlink.MLinkAPI;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.IndexDistributionDao;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShopWorkService {
    private static final Logger logger = LoggerFactory.getLogger(ShopWorkService.class);
    private static final ShopWorkService INSTANCE = new ShopWorkService();
    private static final long SHOP_WORK_INTERVAL_SEC = 3L;
    private static final long USER_STATUS_INTERVAL_MIN = 10L;
    private static final long USAGE_INTERVAL_MIN = 15L;
    private static final long INDEX_DISTRIBUTION_INTERVAL_MIN = 60L;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3, new CustomThreadFactory("UnifiedScheduler-"));
    private ScheduledFuture<?> processQueueFuture;
    private ScheduledFuture<?> userStatusFuture;
    private ScheduledFuture<?> cloudinaryHealthFuture;
    private ScheduledFuture<?> userPaidPeriodFuture;
    private ScheduledFuture<?> indexDistributionFuture;
    private volatile boolean schedulerActive = false;
    private ThreadPoolExecutor workerPool;
    private final Set<String> processingGrps = ConcurrentHashMap.newKeySet();
    private Semaphore dispatchSemaphore;
    private final AtomicLong taskCounter = new AtomicLong(0L);

    private ShopWorkService() {
        int threads = this.determineThreadCount();
        this.dispatchSemaphore = new Semaphore(threads);
        int queueCapacity = QueueCapacityCalculator.calculateQueueCapacity();
        logger.info("Initializing work workerPool with capacity (based on JVM heap): {}", (Object)queueCapacity);
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(queueCapacity);
        ThreadPoolExecutor workerPool = new ThreadPoolExecutor(threads, threads * 2, 10L, TimeUnit.SECONDS, workQueue);
        workerPool.setRejectedExecutionHandler((r, exec) -> {
            this.stopSchedulerTasks();
            logger.warn("WorkerPool saturated \u2192 scheduler tasks cancelled");
            try {
                exec.getQueue().put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Interrupted while enqueueing task", ie);
            }
            if (exec.getQueue().remainingCapacity() > 0) {
                this.startSchedulerTasks();
                logger.info("WorkerPool recovered \u2192 scheduler tasks restarted");
            }
        });
        this.workerPool = workerPool;
    }

    private int determineThreadCount() {
        int threads;
        int cores = Runtime.getRuntime().availableProcessors();
        int maxThreads = Math.max(1, cores / 2);
        try {
            threads = ShopWorkDao.get().getMultiThreadCnt();
        }
        catch (Exception e) {
            logger.warn("Failed to fetch multi-thread count from DB, defaulting to 1", (Throwable)e);
            threads = 1;
        }
        if (threads < 1) {
            threads = 1;
        } else if (threads > maxThreads) {
            threads = maxThreads;
        }
        logger.info("Determined worker pool threads: {} (cores={}, maxAllowed={})", new Object[]{threads, cores, maxThreads});
        return threads;
    }

    public synchronized void startSchedulerTasks() {
        if (this.schedulerActive) {
            return;
        }
        this.processQueueFuture = this.scheduler.scheduleWithFixedDelay(this::processQueueSafely, 0L, 3L, TimeUnit.SECONDS);
        if (ShopCommonDao.get().isJobScheduler()) {
            SchedulerService.get().schedulerYesorNo();
        }
        this.userStatusFuture = this.scheduler.scheduleAtFixedRate(this::runUserStatusCheckSafely, 0L, 10L, TimeUnit.MINUTES);
        this.cloudinaryHealthFuture = this.scheduler.scheduleAtFixedRate(this::runCloudinaryUsageCheck, 0L, 15L, TimeUnit.MINUTES);
        this.userPaidPeriodFuture = this.scheduler.scheduleAtFixedRate(this::runuserPaidPeriodCheck, 0L, 10L, TimeUnit.MINUTES);
        this.indexDistributionFuture = this.scheduler.scheduleAtFixedRate(this::runIndexDistributionSafely, 5L, 60L, TimeUnit.MINUTES);
        this.schedulerActive = true;
    }

    private void runIndexDistributionSafely() {
        try {
            logger.info("Checking for new index distribution at {}", (Object)LocalDateTime.now());
            IndexDistributionDao.get().updateDBIndexes();
        }
        catch (Exception e) {
            logger.error("Index distribution error", (Throwable)e);
        }
    }

    public synchronized void startProcessQueueOnly() {
        if (this.processQueueFuture == null || this.processQueueFuture.isCancelled()) {
            this.processQueueFuture = this.scheduler.scheduleWithFixedDelay(this::processQueueSafely, 0L, 3L, TimeUnit.SECONDS);
            logger.info("processQueueFuture started");
        }
    }

    private synchronized void stopSchedulerTasks() {
        if (!this.schedulerActive) {
            return;
        }
        this.processQueueFuture.cancel(false);
        this.userStatusFuture.cancel(false);
        this.cloudinaryHealthFuture.cancel(false);
        this.userPaidPeriodFuture.cancel(false);
        this.schedulerActive = false;
    }

    public static ShopWorkService getInstance() {
        return INSTANCE;
    }

    public boolean isRunning() {
        return !this.scheduler.isShutdown() && !this.workerPool.isShutdown();
    }

    public void shutdown() {
        logger.info("Shutting down Unified Scheduler and Worker Pool...");
        this.scheduler.shutdown();
        this.workerPool.shutdown();
        try {
            if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
            if (!this.workerPool.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.workerPool.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        logger.info("ShopWorkService shutdown complete");
    }

    private void processQueueSafely() {
        try {
            this.processQueue();
        }
        catch (Throwable t) {
            logger.error("Uncaught error in processQueue", t);
        }
    }

    private void processQueue() {
        try {
            this.dispatch(ShopWorkDataQueue.get().getWaitData(), dto -> {
                try {
                    this.executeRegister((ShopProductSendDto)dto);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.dispatch(ShopWorkDataQueue.get().getModifyData(), dto -> {
                try {
                    this.executeModify((ShopProductSendDto)dto);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.dispatch(ShopWorkDataQueue.get().getModifySoldOutData(), dto -> {
                try {
                    this.executeModify((ShopProductSendDto)dto);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.dispatch(ShopWorkDataQueue.get().getModifyDeleteData(), dto -> {
                try {
                    this.executeModify((ShopProductSendDto)dto);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable t) {
            logger.error("Uncaught error in processQueue", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUserStatusCheckSafely() {
        Class<ShopWorkService> clazz = ShopWorkService.class;
        synchronized (ShopWorkService.class) {
            try {
                logger.info("UserStatusCheck at {}", (Object)LocalDateTime.now());
                MLinkAPI.get().setUserCountPermitAPI("Active");
            }
            catch (Exception e) {
                logger.error("UserStatusCheck error", (Throwable)e);
            }
            return;
        }
    }

    private void runCloudinaryUsageCheck() {
        try {
            logger.info("Cloudinary usage check (hourly) at {}", (Object)LocalDateTime.now());
            boolean useCloud = ShopCommonDao.get().chk_useCloudinary();
            if (!useCloud) {
                EasyCloudUsageService.get().chk_EasyCloudUsage();
            }
        }
        catch (Exception e) {
            logger.error("Cloudinary usage check error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runuserPaidPeriodCheck() {
        Class<ShopWorkService> clazz = ShopWorkService.class;
        synchronized (ShopWorkService.class) {
            try {
                logger.info("UserInf(enduse and pricetype) check at {}", (Object)LocalDateTime.now());
                MLinkAPI.get().findEnduseAndPriceType();
            }
            catch (Exception e) {
                logger.error("UserInf(enduse and pricetype) check error", (Throwable)e);
            }
            return;
        }
    }

    private void dispatch(ShopProductSendDto dto, Consumer<ShopProductSendDto> action) {
        if (dto == null) {
            return;
        }
        String grp = dto.getWorkgrp();
        if (!this.processingGrps.add(grp)) {
            logger.info("Skipping duplicate dispatch for workgrp={}", (Object)grp);
            return;
        }
        if (!this.dispatchSemaphore.tryAcquire()) {
            logger.debug("Max concurrent dispatch reached, delaying grp={}", (Object)grp);
            dto.getWorkMngDto().setWork_status("W01");
            ShopWorkDataQueue.get().notifyObservers();
            this.processingGrps.remove(grp);
            return;
        }
        dto.getWorkMngDto().setWork_status("W08");
        dto.getWorkMngDto().setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        ShopWorkDataQueue.get().notifyObservers();
        this.workerPool.execute(() -> {
            long taskId = this.taskCounter.incrementAndGet();
            try {
                try {
                    action.accept(dto);
                    this.defaultCompleted(dto, taskId);
                }
                catch (Exception e) {
                    logger.error("Error executing task {}", (Object)dto.getWorkgrp(), (Object)e);
                    this.defaultFailed(e, dto);
                    this.processingGrps.remove(grp);
                    this.dispatchSemaphore.release();
                }
            }
            finally {
                this.processingGrps.remove(grp);
                this.dispatchSemaphore.release();
            }
        });
    }

    private void executeRegister(ShopProductSendDto dto) throws Exception {
        IProduct svc = ProductFactory.getRegisterBean(dto.getShopCd());
        svc.excute(dto);
    }

    private void executeModify(ShopProductSendDto dto) throws Exception {
        IProduct svc = ProductFactory.getModifyBean(dto.getShopCd());
        svc.excute(dto);
    }

    private void defaultCompleted(ShopProductSendDto result, long taskId) {
        String msg = String.format("Task %d completed: workgrp=%s at %d", taskId, result.getWorkgrp(), System.currentTimeMillis());
        result.getWorkMngDto().setWorkgrp(result.getWorkgrp());
        ShopWorkDataQueue.get().delete(result.getWorkMngDto().getWorkgrp());
        ShopWorkDataQueue.get().notifyObservers();
        ShopWorkDataQueue.get().notifyCompleteObservers();
        logger.info(msg);
    }

    private void defaultFailed(Throwable exc, ShopProductSendDto dto) {
        dto.getWorkMngDto().setWork_status("-1");
        YDMAStringUtil.Print(exc.getMessage());
        logger.error("Task failed: workgrp={}", (Object)dto.getWorkgrp(), (Object)exc);
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private final String prefix;
        private final AtomicLong idx = new AtomicLong(1L);

        CustomThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.valueOf(this.prefix) + this.idx.getAndIncrement());
            t.setDaemon(false);
            t.setUncaughtExceptionHandler((th, ex) -> logger.error("Uncaught in {}", (Object)th.getName(), (Object)ex));
            return t;
        }
    }
}

