/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.util.LinkedList;

public class ThreadPoolQueue {
    private LinkedList<Object> queue = new LinkedList();
    private int MAX_QUEUE_SIZE = 5;
    private boolean DEBUG = false;

    public ThreadPoolQueue(int MAX_QUEUE_SIZE) {
        this.MAX_QUEUE_SIZE = MAX_QUEUE_SIZE;
    }

    public synchronized void enqueue(Object item) throws InterruptedException {
        while (this.queue.size() == this.MAX_QUEUE_SIZE) {
            this.console("enqueue waiting...");
            this.wait();
        }
        if (this.queue.size() == 0) {
            this.console("enqueue notifyall...");
            this.notifyAll();
        }
        this.console("enqueue adding...");
        this.queue.add(item);
    }

    public synchronized Object dequeue() throws InterruptedException {
        while (this.queue.size() == 0) {
            this.console("dequeue waiting...");
            this.wait();
        }
        if (this.queue.size() == this.MAX_QUEUE_SIZE) {
            this.console("dequeue notifyall...");
            this.notifyAll();
        }
        this.console("dequeue removing...");
        return this.queue.remove(0);
    }

    public void toggleDebug(boolean flag) {
        this.DEBUG = flag;
    }

    public void console(String msg) {
        if (this.DEBUG) {
            YDMAStringUtil.Print(msg);
        }
    }
}

