/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.shop.data.alwayz.IShopOrderAlwayzCommand;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AlwayzOrderSearchCommand
extends IShopOrderAlwayzCommand {
    private static IShopOrderCommand instance = new AlwayzOrderSearchCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AlwayzOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            String token = AlwayzAccessToken.get().getAccessToken(param.get(0).getShop_userid(), param.get(0).getShopPw());
            this.allOrderList(param, dtolist, token);
        }
        catch (Exception exception) {
            throw new Exception("\uc62c\uc6e8\uc774\uc988 \uc0c1\ud0dc \uac12\uc744 \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private void allOrderList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String token) throws Exception {
        block19: {
            try {
                String inputLine;
                URL url = new URL("https://alwayz-seller-back.ilevit.com/sellers/orders/status");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
                connection.setRequestProperty("x-access-token", token);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String body = response.toString();
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                int status2 = jsonObject.get("status").getAsInt();
                if (status2 != 200) break block19;
                JsonArray dataArray = (JsonArray)jsonObject.get("data");
                int i = 0;
                while (i < dataArray.size()) {
                    JsonObject object = (JsonObject)dataArray.get(i);
                    String dataStatus = object.get("status").getAsString();
                    int dataCount = Integer.parseInt(object.get("totalOrderNum").toString());
                    try {
                        if (dataStatus.equals("canceling-pre-shipping-post-excel")) {
                            this.processOrderStatus(object, dataCount, param, dtolist, "C01");
                        } else if (dataStatus.equals("canceled-pre-shipping")) {
                            this.processOrderStatus(object, dataCount, param, dtolist, "C02");
                        } else if (dataStatus.equals("refunding") || dataStatus.equals("canceling-shipping")) {
                            this.processOrderStatus(object, dataCount, param, dtolist, "R01");
                        } else if (dataStatus.equals("refunded") || dataStatus.equals("canceled-shipping")) {
                            this.processOrderStatus(object, dataCount, param, dtolist, "R02");
                        } else if (dataStatus.equals("shipping-sending") || dataStatus.equals("shipping")) {
                            this.processOrderStatus(object, dataCount, param, dtolist, "403");
                        } else if (dataStatus.equals("arrived")) {
                            this.processOrderStatus(object, dataCount, param, dtolist, "410");
                        } else if (dataStatus.equals("reviewed")) {
                            this.processOrderStatus(object, dataCount, param, dtolist, "410");
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    private void processOrderStatus(JsonObject object, int dataCount, List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String orderStatus) {
        if (dataCount > 0) {
            JsonArray topKOrders = (JsonArray)object.get("topKOrders");
            int t = 0;
            while (t < topKOrders.size()) {
                try {
                    JsonObject orderData = (JsonObject)topKOrders.get(t);
                    JsonObject itemInfo = (JsonObject)orderData.get("itemInfo");
                    JsonObject selectedOption = (JsonObject)orderData.get("selectedOption");
                    JsonObject cancelInfo = orderData.has("cancelInfo") ? (JsonObject)orderData.get("cancelInfo") : null;
                    JsonObject refundInfo = orderData.has("refundInfo") ? (JsonObject)orderData.get("refundInfo") : null;
                    String orderid = orderData.get("_id").getAsString();
                    String mallid = itemInfo.get("itemTitle").getAsString();
                    String expid = this.setOption(object, itemInfo, selectedOption);
                    if (orderStatus.equals("C02") || orderStatus.equals("R02")) {
                        this.handleCancelInfoOrder(param, dtolist, orderid, mallid, expid, cancelInfo, refundInfo, orderStatus);
                    } else {
                        this.updateOrderList(param, dtolist, orderid, mallid, expid, orderStatus);
                    }
                }
                catch (Exception exception) {}
                ++t;
            }
        }
    }

    private void handleCancelInfoOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String orderid, String mallid, String expid, JsonObject cancelInfo, JsonObject refundInfo, String orderStatus) {
        for (ShopOrderMstDto dto : param) {
            if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
            dto.setOrder_status(orderStatus);
            dto.setResult_code("1");
            try {
                ShopOrderMstDto temp = dto.clone(orderStatus);
                String orderDate = this.dateFormat(this.getOrderDate(cancelInfo, refundInfo));
                if (orderDate != null) {
                    temp.setOrder_date(orderDate);
                }
                dtolist.add(dto);
                dtolist.add(temp);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    private String getOrderDate(JsonObject cancelInfo, JsonObject refundInfo) {
        String refundApprovedAt;
        if (cancelInfo == null && refundInfo == null) {
            return "";
        }
        String cancelApprovedAt = cancelInfo != null && cancelInfo.has("cancelApprovedAt") ? cancelInfo.get("cancelApprovedAt").getAsString() : "";
        String string = refundApprovedAt = refundInfo != null && refundInfo.has("refundApprovedAt") ? refundInfo.get("refundApprovedAt").getAsString() : "";
        if (!cancelApprovedAt.equals("")) {
            return cancelApprovedAt;
        }
        if (!refundApprovedAt.equals("")) {
            return refundApprovedAt;
        }
        return "";
    }

    private void updateOrderList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String orderid, String mallid, String expid, String orderStatus) {
        for (ShopOrderMstDto dto : param) {
            if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid)) continue;
            dto.setOrder_status(orderStatus);
            dto.setResult_code("1");
            dtolist.add(dto);
        }
    }

    private String dateFormat(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }

    private String setOption(JsonObject object, JsonObject itemInfo, JsonObject selectedOption) {
        JsonObject optionsInfo = (JsonObject)itemInfo.get("optionsInfo");
        JsonArray optionNames = (JsonArray)optionsInfo.get("optionNames");
        JsonArray totalOptions = (JsonArray)optionsInfo.get("totalOptions");
        String option2 = "";
        if (optionNames.size() == 2) {
            List optionNameList = IntStream.range(0, optionNames.size()).mapToObj(arg_0 -> ((JsonArray)optionNames).get(arg_0)).map(element -> element.getAsString()).collect(Collectors.toList());
            ArrayList option1 = new ArrayList();
            ArrayList option22 = new ArrayList();
            JsonArray totalOptionsArray1 = totalOptions.get(0).getAsJsonArray();
            IntStream.range(0, totalOptionsArray1.size()).forEach(t -> {
                boolean bl = option1.add(totalOptionsArray1.get(t).getAsJsonObject().get("name").getAsString());
            });
            JsonArray totalOptionsArray2 = totalOptions.get(1).getAsJsonArray();
            IntStream.range(0, totalOptionsArray2.size()).forEach(q -> {
                boolean bl = option22.add(totalOptionsArray2.get(q).getAsJsonObject().get("name").getAsString());
            });
            int selectedValue1 = selectedOption.get("0").getAsInt();
            int selectedValue2 = selectedOption.get("1").getAsInt();
            String optionValue1 = (String)option1.get(selectedValue1);
            String optionValue2 = (String)option22.get(selectedValue2);
            option2 = "0. " + (String)optionNameList.get(0) + ": " + optionValue1 + "\n1. " + (String)optionNameList.get(1) + ": " + optionValue2;
        } else if (optionNames.size() == 1) {
            String optionName = optionNames.get(0).getAsString();
            int selectedValue = selectedOption.get("0").getAsInt();
            String optionValue = totalOptions.get(0).getAsJsonArray().get(selectedValue).getAsJsonObject().get("name").getAsString();
            option2 = "0. " + optionName + ": " + optionValue;
        }
        return option2;
    }
}

