/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopProductSync;
import com.kdjsystem.mlink.shop.common.ProductSyncService;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ShopProductAlwayzSync
extends ProductSyncService
implements IShopProductSync {
    public ShopProductAlwayzSync(IShopProductSync productsync) {
        super(productsync);
    }

    @Override
    public List<ShopProductDto> excute(ShoppingMallDetailDto dto, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        ArrayList<ShopProductDto> syncList = new ArrayList<ShopProductDto>();
        return syncList;
    }

    @Override
    public List<ShopProductDto> complate(ShoppingMallDetailDto dto, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        ArrayList<ShopProductDto> syncList = new ArrayList<ShopProductDto>();
        ArrayList<ShopProductDto> totlaSyncList = new ArrayList<ShopProductDto>();
        boolean flag = true;
        int page = 0;
        int saveTotal = 0;
        int applycnt = 0;
        try {
            while (flag) {
                YDMAStringUtil.Print("page = " + ++page);
                String json = "{\"condition\":{\"type\":\"item\",\"itemCondition\":{\"createdAt\":{\"$gt\":\"" + this.dateFormat1(dto.getDatefrom()) + "\"}},\"itemSortCondition\":{\"createdAt\":-1}},\"page\":" + page + ",\"pageLimit\":20}";
                Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/items/v2/list-request").header("Connection", "keep-alive").header("x-access-token", dto.getApikey()).header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(json).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
                int status2 = jsonObject.get("status").getAsInt();
                if (status2 == 2000) {
                    JsonObject data2 = (JsonObject)jsonObject.get("data");
                    JsonArray itemsInfo = (JsonArray)data2.get("itemsInfo");
                    if (itemsInfo.size() > 0) {
                        ArrayList<ShopProductDto> total;
                        block19: {
                            syncList = new ArrayList();
                            monitor.beginTask("\ub370\uc774\ud130\ub97c \uac00\uc838\uc624\ub294 \uc911 \uc785\ub2c8\ub2e4.", itemsInfo.size());
                            int i = 0;
                            while (i < itemsInfo.size()) {
                                JsonObject object = (JsonObject)itemsInfo.get(i);
                                ShopProductDto syncDto = new ShopProductDto();
                                syncDto.setGoods_nm(object.get("itemTitle").getAsString());
                                syncDto.setShopprodno(object.get("_id").getAsString());
                                syncDto.setInsertdt(this.dateFormat2(object.get("createdAt").getAsString()));
                                syncDto.setMarket_price(object.get("individualPurchasePrice").getAsString());
                                syncDto.setGoods_price(object.get("individualPurchasePrice").getAsString());
                                syncDto.setGoods_consumer_price(object.get("individualPurchasePrice").getAsString());
                                syncDto.setCompayny_goods_cd(object.has("recommendItemCode") ? object.get("recommendItemCode").getAsString() : "");
                                syncDto.setSaleStatusCd(object.get("soldOut").getAsBoolean() ? String.valueOf(4000) : String.valueOf(8000));
                                if (syncDto.getCompayny_goods_cd().equals("")) {
                                    syncDto.setCompayny_goods_cd(syncDto.getShopprodno());
                                }
                                syncList.add(syncDto);
                                if (itemsInfo.size() > 0) {
                                    try {
                                        monitor.subTask("[\uc0c1\ud488\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \uc911 \uc785\ub2c8\ub2e4.] " + syncDto.getCompayny_goods_cd() + " " + (i + 1) + " of " + itemsInfo.size() + "...");
                                        monitor.worked(1);
                                        if (monitor.isCanceled()) {
                                            monitor.done();
                                            break;
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                ++i;
                            }
                            total = new ArrayList<ShopProductDto>();
                            saveTotal += syncList.size();
                            try {
                                monitor.subTask("[\uc0c1\ud488\uc815\ubcf4\ub97c \uc800\uc7a5 \uc911 \uc785\ub2c8\ub2e4.]");
                                monitor.worked(1);
                                if (!monitor.isCanceled()) break block19;
                                monitor.done();
                                break;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        ArrayList<ProductItemDto> infoTotal = new ArrayList<ProductItemDto>();
                        ArrayList<ShopProductDto> inTotal = new ArrayList<ShopProductDto>();
                        for (ShopProductDto sync : syncList) {
                            ShopProductDto infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", sync.getCompayny_goods_cd());
                            if (infoDto != null) {
                                ShopProductDto find = total.stream().filter(d -> d.getCompayny_goods_cd().equals(infoDto.getCompayny_goods_cd())).findAny().orElse(null);
                                if (find != null) continue;
                                infoDto.setGoods_nm(sync.getGoods_nm());
                                infoDto.setGoods_price(sync.getGoods_price());
                                infoDto.setMarket_price(sync.getGoods_price());
                                infoDto.setGoods_consumer_price(sync.getGoods_price());
                                infoDto.setShopprodno(sync.getShopprodno());
                                infoDto.setInsertdt(sync.getInsertdt());
                                infoDto.setSaleenddt(sync.getSaleenddt());
                                infoDto.setShopcd(dto.getShopcd());
                                infoDto.setShopseq(dto.getShopseq());
                                infoDto.setShopuserid(dto.getShoppingid());
                                infoDto.setSendstats(sync.getSaleStatusCd());
                                infoDto.setTax_yn("0");
                                total.add(infoDto);
                                if (!monitor.isCanceled()) continue;
                                monitor.done();
                                break;
                            }
                            if (!sync.getSaleStatusCd().equals(Integer.toString(8000))) continue;
                            ShopProductDto inDto = new ShopProductDto();
                            inDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                            inDto.setCompayny_goods_cd(sync.getCompayny_goods_cd());
                            inDto.setGoods_nm(sync.getGoods_nm());
                            inDto.setGoods_price(sync.getGoods_price());
                            inDto.setGoods_cost(sync.getGoods_price());
                            inDto.setMarket_price(sync.getGoods_price());
                            inDto.setShopprodno(sync.getShopprodno());
                            inDto.setInsertdt(sync.getInsertdt());
                            inDto.setSaleenddt(sync.getSaleenddt());
                            inDto.setShopcd(dto.getShopcd());
                            inDto.setShopseq(dto.getShopseq());
                            inDto.setShopuserid(dto.getShoppingid());
                            inDto.setSendstats(Integer.toString(8000));
                            inDto.setStatus("0");
                            inDto.setClass_cd3("999999999");
                            ProductItemDto newInfoDto = new ProductItemDto();
                            newInfoDto.setIcode(sync.getCompayny_goods_cd());
                            newInfoDto.setIname(sync.getGoods_nm());
                            newInfoDto.setPrice(sync.getGoods_price());
                            newInfoDto.setPrice_consumer(sync.getGoods_price());
                            newInfoDto.setStatus("0");
                            newInfoDto.setClass_cd3("999999999");
                            newInfoDto.setDelivery_qty("0");
                            newInfoDto.setIslimit("0");
                            newInfoDto.setCate_depth("3");
                            newInfoDto.setCert_type("0");
                            newInfoDto.setSearch("shop0000");
                            String[] image = new String[24];
                            int i = 0;
                            while (i < image.length) {
                                image[i] = "";
                                ++i;
                            }
                            newInfoDto.setImg(image);
                            newInfoDto.setDelivery_amount("0");
                            infoTotal.add(newInfoDto);
                            inTotal.add(inDto);
                        }
                        if (monitor.isCanceled()) {
                            monitor.done();
                            break;
                        }
                        if (total.size() > 0) {
                            applycnt += total.size();
                            ShopProductDao.get().setProductInfoInsertNUpdate(total);
                        }
                        if (infoTotal == null || infoTotal.size() <= 0) continue;
                        DomesinShopDao.get().saveInfoReverse(infoTotal, monitor);
                        ArrayList<ShopProductDto> ItemList2 = new ArrayList<ShopProductDto>();
                        for (ShopProductDto inList1 : inTotal) {
                            ShopProductDto infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", inList1.getCompayny_goods_cd());
                            infoDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                            infoDto.setCompayny_goods_cd(inList1.getCompayny_goods_cd());
                            infoDto.setGoods_nm(inList1.getGoods_nm());
                            infoDto.setGoods_price(inList1.getGoods_price());
                            infoDto.setGoods_cost(inList1.getGoods_price());
                            infoDto.setMarket_price(inList1.getGoods_price());
                            infoDto.setShopprodno(inList1.getShopprodno());
                            infoDto.setInsertdt(inList1.getInsertdt());
                            infoDto.setSaleenddt(inList1.getSaleenddt());
                            infoDto.setShopcd(dto.getShopcd());
                            infoDto.setShopseq(dto.getShopseq());
                            infoDto.setShopuserid(dto.getShoppingid());
                            infoDto.setSendstats(Integer.toString(8000));
                            infoDto.setStatus("0");
                            infoDto.setTax_yn("0");
                            ItemList2.add(infoDto);
                        }
                        ShopProductDao.get().setProductInfoInsertNUpdate(ItemList2);
                        continue;
                    }
                    flag = false;
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        YDMAStringUtil.Print("target = " + saveTotal + "apply = " + applycnt);
        return totlaSyncList;
    }

    private String dateFormat1(String inputDate) {
        LocalDate date = LocalDate.parse(inputDate);
        LocalDateTime dateTime = date.atStartOfDay();
        ZonedDateTime utcDateTime = dateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of("UTC"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        String formattedDate = utcDateTime.format(formatter);
        return formattedDate;
    }

    private String dateFormat2(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }
}

