/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.auction;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.auction.IShopOrderAuctionCommand;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

class AuctionOrderNewCommand
extends IShopOrderAuctionCommand {
    private static IShopOrderCommand instance = new AuctionOrderNewCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AuctionOrderNewCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return super.Search(URL2, startdt, enddt);
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        this.getNewOrder(param, ret);
        this.OrderOk(param, ret);
        this.getDeliveryCompleted(param, ret);
        return ret;
    }

    public List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret) throws Exception {
        ShopOrderMstDto orderDto = param.get(0);
        orderDto.setResult_code("0");
        ret.addAll(param);
        String site = "";
        String shopid = orderDto.getShopid();
        if (shopid.equals("shop0067") || shopid.equals("shop00671")) {
            site = "1";
        } else if (shopid.equals("shop0068") || shopid.equals("shop00681")) {
            site = "2";
        }
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        IShopCommonLogin i = new IShopCommonLogin(){};
        Map<String, String> cookies = i.loginCookie(id, pw, shopid, true, authKey);
        StringBuilder urlBuilder = new StringBuilder("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery");
        urlBuilder.append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append("&searchDateType=").append("&searchSDT=").append("&searchEDT=").append("&searchKey=").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=").append("&totalAccumulate=-").append("&searchTransPolicyType=");
        Document doc = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).get();
        Elements hiddens = doc.select("input[type=hidden]");
        Map<String, String> datas = ChromeScript.get().getElementIdOrValue(hiddens);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        String url = "https://www.esmplus.com/Escrow/Order/NewOrderSearch";
        String referrer = "https://www.esmplus.com/Escrow/Order/NewOrder?menuCode=TDM105";
        Connection.Response rs = Jsoup.connect((String)url).cookies(cookies).referrer(referrer).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", String.valueOf(datas.get("hddSearchAccount")) + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchDistrType", "AL").data("searchAllYn", "N").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchTransPolicyType", "").execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray jsonArray = (JsonArray)jsonobject.get("data");
        List<ShopOrderMstDto> params = this.getJsonManager(jsonArray, param, "100", cookies);
        Map<String, List<ShopOrderMstDto>> grouped = params.stream().collect(Collectors.groupingBy(dto -> String.valueOf(dto.getMall_product_id()) + "_" + dto.getUser_name() + "_" + dto.getUser_tel()));
        for (List<ShopOrderMstDto> group : grouped.values()) {
            if (group.size() <= 1) continue;
            int deliveryFee = this.calculateDeliveryFee(group);
            for (ShopOrderMstDto dto2 : group) {
                dto2.setDelv_cost(String.valueOf(deliveryFee));
                if (deliveryFee <= 0) continue;
                dto2.setDelivery_method_str2("\uc120\ubd88");
            }
        }
        if (params != null) {
            ret.addAll(params);
        }
        return ret;
    }

    public List<ShopOrderMstDto> OrderOk(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret) throws Exception {
        ShopOrderMstDto orderDto = param.get(0);
        String shopid = orderDto.getShopid();
        String site = null;
        if (shopid.equals("shop0067") || shopid.equals("shop00671")) {
            site = "1";
        } else if (shopid.equals("shop0068") || shopid.equals("shop00681")) {
            site = "2";
        }
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        IShopCommonLogin i = new IShopCommonLogin(){};
        Map<String, String> cookies = i.loginCookie(id, pw, shopid, true, authKey);
        StringBuilder urlBuilder = new StringBuilder("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery").append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append("&searchDateType=").append("&searchSDT=").append("&searchEDT=").append("&searchKey=").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=").append("&totalAccumulate=-").append("&searchTransPolicyType=");
        Document doc = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).get();
        Elements hiddens = doc.select("input[type=hidden]");
        Map<String, String> datas = ChromeScript.get().getElementIdOrValue(hiddens);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        String baseUrl = "https://www.esmplus.com/Escrow/Delivery/GeneralDeliverySearch";
        String referrerUrl = "https://www.esmplus.com/Escrow/Delivery/GeneralDelivery?gbn=0&status=0&type=&searchAccount=" + datas.get("hddSearchAccount") + "^" + id + "^" + site + "&searchDateType=ODD&searchSDT=" + startdate + "&searchEDT=" + enddate + "&searchKey=ON&searchKeyword=&searchDeliveryType=&searchOrderType=" + "&searchPacking=false&totalAccumulate=-&listAllView=false&searchDistrType=AL&searchTransPolicyType=";
        Connection.Response rs = Jsoup.connect((String)baseUrl).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", String.valueOf(datas.get("hddSearchAccount")) + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(referrerUrl).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray jsonArray = (JsonArray)jsonobject.get("data");
        String baseUrl2 = "https://www.esmplus.com/Escrow/Delivery/OverseasDeliverySearch";
        String referrerUrl2 = "https://www.esmplus.com/Escrow/Delivery/GeneralDelivery?gbn=0&status=0&type=&searchAccount=" + datas.get("hddSearchAccount") + "^" + id + "^" + site + "&searchDateType=ODD&searchSDT=" + startdate + "&searchEDT=" + enddate + "&searchKey=ON&searchKeyword=&searchDeliveryType=&searchOrderType=" + "&searchPacking=false&totalAccumulate=-&listAllView=false&searchDistrType=AL&searchTransPolicyType=";
        Connection.Response rs1 = Jsoup.connect((String)baseUrl2).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", String.valueOf(datas.get("hddSearchAccount")) + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(referrerUrl2).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        String body1 = rs1.body();
        JsonObject jsonobject1 = (JsonObject)jsonparser.parse(body1);
        JsonArray jsonArray1 = (JsonArray)jsonobject1.get("data");
        List<ShopOrderMstDto> params = this.getJsonManager(jsonArray, param, "100", cookies);
        List<ShopOrderMstDto> params1 = this.getJsonManager(jsonArray1, param, "100", cookies);
        if (params != null || params1 != null) {
            ret.addAll(params);
            ret.addAll(params1);
        }
        return ret;
    }

    public List<ShopOrderMstDto> getDeliveryCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret) throws Exception {
        Connection.Response rs;
        String body;
        JsonParser jsonparser;
        JsonObject jsonobject;
        JsonArray jsonArray;
        List<ShopOrderMstDto> params;
        ShopOrderMstDto orderDto = param.get(0);
        orderDto.setResult_code("0");
        String site = null;
        String shopid = orderDto.getShopid();
        if (shopid.equals("shop0067") || shopid.equals("shop00671")) {
            site = "1";
        } else if (shopid.equals("shop0068") || shopid.equals("shop00681")) {
            site = "2";
        }
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        IShopCommonLogin i = new IShopCommonLogin(){};
        Map<String, String> cookies = i.loginCookie(id, pw, shopid, true, authKey);
        StringBuilder urlBuilder = new StringBuilder("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery");
        urlBuilder.append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append("&searchDateType=").append("&searchSDT=").append("&searchEDT=").append("&searchKey=").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=").append("&totalAccumulate=-").append("&searchTransPolicyType=");
        Document doc = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).get();
        Elements hiddens = doc.select("input[type=hidden]");
        Map<String, String> datas = ChromeScript.get().getElementIdOrValue(hiddens);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdate);
        Date edate = formatter.parse(enddate);
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            YDMAProgressBar.get().setValue("\uc625\uc158/\uc9c0\ub9c8\ucf13\uc740 1\ub144 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc218\uc815\ub41c \ub0a0\uc9dc\ub85c \uac80\uc0c9\ud569\ub2c8\ub2e4.", 0);
            startdate = formatter.format(cal2.getTime());
        }
        if ((params = this.getJsonManager2(jsonArray = (JsonArray)(jsonobject = (JsonObject)(jsonparser = new JsonParser()).parse(body = (rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/BuyDecisionSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://www.esmplus.com/Escrow/Delivery/BuyDecision?").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", String.valueOf(datas.get("hddSearchAccount")) + "^" + id + "^" + site).data("searchDateType", "TRD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchStatus", "").data("searchAllYn", "N").data("SortFeild", "TransDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").data("searchGlobalShopType", "").data("searchOverseaDeliveryYn", "").execute()).body())).get("data"), param, "410", cookies)) != null) {
            ret.addAll(params);
        }
        return ret;
    }

    public int calculateDeliveryFee(List<ShopOrderMstDto> group) {
        return group.stream().mapToInt(dto -> {
            String cost = dto.getDelv_cost().replaceAll(",", "").trim();
            if ("\ubb34\ub8cc".equals(cost)) {
                return 0;
            }
            try {
                return Integer.parseInt(cost);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }).max().orElse(0);
    }

    private List<ShopOrderMstDto> getJsonManager(JsonArray jsonArray, List<ShopOrderMstDto> param, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            if (jsonArray.size() > 0) {
                Integer i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i.intValue());
                    if (!ShopOrderDao.get().isOrdered(object.get("OrderNo").getAsString())) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_status(orderStatus);
                        dto.setOrder_date(object.get("OrderDate").getAsString());
                        dto.setDelv_msg(this.setHtmlTagDelete(object.get("DeliveryMemo").getAsString()));
                        dto.setSale_cnt(object.get("OrderQty").getAsString());
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        dto.setReceive_name(object.get("RcverName").getAsString());
                        dto.setMall_product_id(object.get("GoodsNo").getAsString());
                        dto.setCompayny_goods_cd(this.setHtmlTagDelete(object.get("SellerMngCode").getAsString()));
                        dto.setP_product_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        String addOption = this.setHtmlTagDelete(object.get("AddOption").getAsString());
                        dto.setP_sku_value(String.valueOf(this.setHtmlTagDelete(object.get("SelOption").getAsString())) + "," + addOption);
                        dto.setWon_cost("0");
                        dto.setMall_won_cost(object.get("SttlExpectedAmnt").getAsString());
                        dto.setSale_cost(object.get("SellPrice").getAsString().replace(",", ""));
                        String fee = this.setHtmlTagDelete(object.get("DeliveryFee").getAsString());
                        String deleveryfee = "";
                        if (fee.equals("\uc0c1\uc138\ubcf4\uae30")) {
                            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Member/SignIn/GetCoreAuthToken").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("SellerId", param.get(0).getShop_userid()).data("MenuCode", "tdp132").data("Param", "OrderNo=" + object.get("SiteOrderNo").getAsString()).referrer("https://www.esmplus.com/Home/SSO?id=" + param.get(0).getShop_userid() + "&code=TDP132&Param=OrderNo%3D" + object.get("SiteOrderNo").getAsString()).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
                            String body = rs.body();
                            String url = URLDecoder.decode(body, "UTF-8");
                            url = url.replaceAll("\"", "");
                            Thread.sleep(2000L);
                            Document doc = Jsoup.connect((String)url).cookies(cookies).followRedirects(true).ignoreContentType(true).get();
                            Elements ele = doc.select("td").eq(2);
                            deleveryfee = ele.text();
                        } else {
                            deleveryfee = object.get("DeliveryFee").getAsString();
                        }
                        dto.setDelv_cost(deleveryfee);
                        if (object.get("DeliveryFeeType").getAsString().equals("\uc120\ubd88") && deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                            dto.setDelivery_method_str2("\ubb34\ub8cc");
                        } else {
                            dto.setDelivery_method_str2(object.get("DeliveryFeeType").getAsString());
                        }
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                        dto.setTotal_cost(object.get("OrderAmnt").getAsString().replace(",", ""));
                        int paycost = YDMAStringUtil.convertToInt(object.get("SellPrice").getAsString()) + YDMAStringUtil.convertToInt(deleveryfee);
                        dto.setPay_cost(Integer.toString(paycost));
                        dto.setProduct_id("");
                        dto.setCompno(param.get(0).getCompno());
                        dto.setOrder_id(object.get("SiteOrderNo").getAsString());
                        dto.setLabel(object.get("OrderNo").getAsString());
                        dto.setUser_id(object.get("BuyerID").getAsString());
                        dto.setUser_name(object.get("BuyerName").getAsString());
                        dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                        dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                        dto.setUser_email("");
                        dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                        dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                        dto.setReceive_email("");
                        dto.setReceive_zipcode(object.get("ZipCode").getAsString());
                        dto.setReceive_addr(this.setHtmlTagDelete(object.get("RcverInfoAd").getAsString()));
                        dto.setProduct_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        dto.setBox_ea("0");
                        dto.setCopy_idx(object.get("CartNo").getAsString());
                        dto.setSku_value(this.setHtmlTagDelete(object.get("SelOption").getAsString()));
                        dto.setMall_exp_cd("0");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                    i = i + 1;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158 \uc2e0\uaddc \uac00\uc838\uc624\uae30 \uc5d1\uc140 \ub9cc\ub4dc\ub294 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private List<ShopOrderMstDto> getJsonManager2(JsonArray jsonArray, List<ShopOrderMstDto> param, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            if (jsonArray.size() > 0) {
                Integer i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i.intValue());
                    if (!ShopOrderDao.get().isOrdered(object.get("SiteOrderNo").getAsString())) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_status(orderStatus);
                        dto.setOrder_date(object.get("OrderDate").getAsString());
                        dto.setDelv_msg(object.get("DeliveryMemo").isJsonNull() ? "" : this.setHtmlTagDelete(object.get("DeliveryMemo").getAsString()));
                        dto.setSale_cnt(object.get("OrderQty").getAsString());
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        dto.setReceive_name(object.get("RcverName").getAsString());
                        dto.setMall_product_id(object.get("GoodsNo").getAsString());
                        dto.setCompayny_goods_cd(this.setHtmlTagDelete(object.get("SellerMngCode").getAsString()));
                        dto.setP_product_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        String addOption = this.setHtmlTagDelete(object.get("AddOption").getAsString());
                        dto.setP_sku_value(String.valueOf(this.setHtmlTagDelete(object.get("SelOption").getAsString())) + "," + addOption);
                        dto.setWon_cost("0");
                        dto.setMall_won_cost(object.get("SttlExpectedAmnt").getAsString());
                        dto.setSale_cost(object.get("SellPrice").getAsString().replace(",", ""));
                        String fee = this.setHtmlTagDelete(object.get("DeliveryFee").getAsString());
                        String deleveryfee = "";
                        if (fee.equals("\uc0c1\uc138\ubcf4\uae30")) {
                            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Member/SignIn/GetCoreAuthToken").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("SellerId", param.get(0).getShop_userid()).data("MenuCode", "tdp132").data("Param", "OrderNo=" + object.get("SiteOrderNo").getAsString()).referrer("https://www.esmplus.com/Home/SSO?id=" + param.get(0).getShop_userid() + "&code=TDP132&Param=OrderNo%3D" + object.get("SiteOrderNo").getAsString()).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
                            String body = rs.body();
                            String url = URLDecoder.decode(body, "UTF-8");
                            url = url.replaceAll("\"", "");
                            Thread.sleep(2000L);
                            Document doc = Jsoup.connect((String)url).cookies(cookies).followRedirects(true).ignoreContentType(true).get();
                            Elements ele = doc.select("td").eq(2);
                            deleveryfee = ele.text();
                            dto.setDelivery_method_str2(doc.select("td").eq(3).text().equals("-") ? "\ubb34\ub8cc" : "\uc120\ubd88");
                        } else {
                            deleveryfee = object.get("DeliveryFee").getAsString();
                        }
                        dto.setDelv_cost(deleveryfee);
                        if (deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                            dto.setDelivery_method_str2("\ubb34\ub8cc");
                        } else {
                            dto.setDelivery_method_str2("\uc120\ubd88");
                        }
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                        dto.setProduct_id("");
                        dto.setCompno(param.get(0).getCompno());
                        dto.setOrder_id(object.get("SiteOrderNo").getAsString());
                        dto.setLabel(object.get("OrderNo").getAsString());
                        dto.setUser_id(object.get("BuyerID").getAsString());
                        dto.setUser_name(object.get("BuyerName").getAsString());
                        dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                        dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                        dto.setUser_email("");
                        dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                        dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                        dto.setReceive_email("");
                        dto.setReceive_zipcode("");
                        dto.setReceive_addr("");
                        dto.setTotal_cost(object.get("OrderAmnt").getAsString().replace(",", ""));
                        int paycost = YDMAStringUtil.convertToInt(object.get("SellPrice").getAsString()) + YDMAStringUtil.convertToInt(deleveryfee);
                        dto.setPay_cost(Integer.toString(paycost));
                        dto.setProduct_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        dto.setBox_ea("0");
                        dto.setCopy_idx(object.get("CartNo").getAsString());
                        dto.setSku_value(this.setHtmlTagDelete(object.get("SelOption").getAsString()));
                        dto.setMall_exp_cd("0");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                    i = i + 1;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158 \uc8fc\ubb38\uc218\uc9d1 \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private String setHtmlTagDelete(String value) {
        return value.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
    }
}

