/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.shop.data.naverstore.NaverStoreGenerateSignature;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

class NaverStoreOrderNewCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderNewCommand();
    JsonParser parser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
        String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(param.get(0).getStartDt());
        Date edate = formatter.parse(param.get(0).getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            if (!YDMAProgressBar.get().isNullBar()) {
                YDMAProgressBar.get().setValue("\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 - 1\ub144 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc218\uc815\ub41c \ub0a0\uc9dc\ub85c \uac80\uc0c9\ud569\ub2c8\ub2e4.", 0);
            }
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)(range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 90 == 0 ? (int)range / 90 : (int)range / 90 + 1;
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 89);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        if (param.get(0).getVendorId().equals("N")) {
            int i = 0;
            while (i < num) {
                this.getNewOrder(param, retList, start, end, "PAY_COMPLETED");
                cal1.add(5, 90);
                cal2.add(5, 90);
                start = String.valueOf(cal1.getTimeInMillis());
                end = String.valueOf(cal2.getTimeInMillis());
                ++i;
            }
        } else {
            this.getNewOrderApi(param, retList);
        }
        return retList;
    }

    public List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end, String orderType) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        List<String> list = Arrays.asList(param.get(0).getApikey().split(","));
        try {
            cookies = list != null && list.size() > 1 ? is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), list.get(0), list.get(1)) : is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1());
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements data2 = doc.select("script");
            String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
            String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
            String strParam = this.getNewOrderStringParam(merchantNo, orderType, start, end);
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").cookies(cookies).header("content-type", "application/json").header("Content-Length", Integer.toString(strParam.length())).header("Host", "sell.smartstore.naver.com").requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject body = this.parser.parse(response.body()).getAsJsonObject();
            JsonObject object = body.get("data").getAsJsonObject();
            JsonObject deliveryList = object.get("deliveryList").getAsJsonObject();
            JsonArray elements = deliveryList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                List<ShopOrderMstDto> param1 = this.setData(param, elements, cookies);
                param1.forEach(d -> d.setResult_code("1"));
                retList.addAll(param1);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return retList;
    }

    public List<ShopOrderMstDto> setData(List<ShopOrderMstDto> param, JsonArray order_arr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : order_arr) {
            boolean ordMatch;
            JsonObject object = order.getAsJsonObject();
            ShopOrderMstDto dto = new ShopOrderMstDto();
            if (param.get(0).getOrder_id() != null && (ordMatch = param.stream().anyMatch(s -> s.getOrder_id().equals(object.get("orderNo").toString())))) continue;
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setOrder_status(this.getStatus(object.get("productOrderStatus").getAsString()));
            dto.setP_product_name(object.get("productName").getAsString());
            String orddt = YDMATimeUtil.getDate(object.get("orderDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setSale_cnt(object.get("orderQuantity").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_email("");
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setShopid(param.get(0).getShopid());
            dto.setShop_userid(param.get(0).getShop_userid());
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
            dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
            dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
            String receiverAddr = this.jsonElementNullStr(object.get("receiverDisplayBaseAddress")).concat(" ").concat(this.jsonElementNullStr(object.get("receiverDisplayDetailAddress")));
            dto.setReceive_addr(receiverAddr);
            dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            String ordamt = object.get("productPayAmt").getAsString();
            dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
            dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(param.get(0).getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setResult_code("1");
            String json = "{\"searchKeywordType\":\"CHANNEL_PRODUCT_NO\",\"searchKeyword\":\"" + object.get("productNo").getAsString() + "\"," + "\"productName\":\"\",\"modelName\":\"\",\"manufacturerName\":\"\",\"brandName\":\"\"," + "\"searchPaymentType\":\"ALL\",\"searchPeriodType\":\"PROD_REG_DAY\",\"deliveryAttributeType\":\"\"," + "\"productKindType\":\"\",\"etcCondition\":\"\",\"subscriptionType\":\"\"," + "\"fromDate\":\"\",\"toDate\":\"\"," + "\"viewData\":{\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\"," + "\"AFFILIATE\",\"\"],\"pageSize\":100},\"searchOrderType\":\"REG_DATE\"," + "\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\"," + "\"WINDOW\",\"AFFILIATE\"],\"page\":0,\"size\":100,\"sort\":[]}";
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            JsonObject data2 = (JsonObject)this.parser.parse(rs.body());
            JsonArray contents = (JsonArray)data2.get("content");
            JsonObject data1 = (JsonObject)contents.get(0);
            String code = data1.get("id").getAsString();
            dto.setMall_product_id(String.valueOf(code) + "," + object.get("productNo").getAsString());
            list.add(dto);
        }
        return list;
    }

    public List<ShopOrderMstDto> getDeliveryCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        try {
            IShopCommonLogin is = new IShopCommonLogin(){};
            Map<Object, Object> cookies = new HashMap();
            List<String> list = Arrays.asList(param.get(0).getApikey().split(","));
            cookies = list != null && list.size() > 1 ? is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), list.get(0), list.get(1)) : is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1());
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/iframe/sale/purchaseDecision").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements data2 = doc.select("script");
            String user = ((Node)((Element)data2.get(5)).childNodes().get(0)).toString();
            JsonObject jsonobject = (JsonObject)this.parser.parse(user.substring(user.indexOf("{"), user.lastIndexOf("}") + 1));
            YDMAStringUtil.Print(jsonobject);
            String json = "{\"operationName\":\"SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision\",\"variables\":{\"merchantNo\":\"" + jsonobject.get("merchantNo").getAsString() + "\",\"serviceType\":\"MP\",\"paging_page\":1," + "\"paging_size\":500,\"sort_type\":\"RECENTLY_ORDER_YMDT\",\"sort_type\":\"PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT\"," + "\"sort_direction\":\"DESC\",\"rangeType\":\"PURCHASE_DECISION_COMPLETED\"," + "\"dateRange_from\":\"" + start + "\",\"dateRange_to\":\"" + end + "\",\"detailedOrderStatus\":\"ALL\"}," + "\"query\":\"query SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision($merchantNo: String!, $serviceType: String!, $claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $sort_direction: SortDirectionType, $sort_type: SortType) {\\n  purchaseDecisionList: SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision(merchantNo: $merchantNo, serviceType: $serviceType, claimStatus: $claimStatus, dateRange_from: $dateRange_from, dateRange_to: $dateRange_to, detailSearch_keyword: $detailSearch_keyword, detailSearch_type: $detailSearch_type, paging_page: $paging_page, paging_size: $paging_size, rangeType: $rangeType, sort_direction: $sort_direction, sort_type: $sort_type) {\\n    elements {\\n      ...purchaseDecisionElementField\\n      __typename\\n    }\\n    pagination {\\n      ...paginationField\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\\nfragment purchaseDecisionElementField on PurchaseDecisionMp {\\n  branchId\\n  merchantChannelNo\\n  deliveryFeeAmt\\n  deliveryFeeClass\\n  deliveryMethod\\n  biztalkAccountId\\n  deliveryInvoiceNo\\n  productPayAmt\\n  orderStatus\\n  productUnitPrice\\n  purchaseDecisionCompleteDateTime\\n  orderQuantity\\n  productName\\n  orderMemberName\\n  payDateTime\\n  productOrderNo\\n  productOptionContents\\n  deliveryFeeRatingClass\\n  orderMemberId\\n  knowledgeShoppingCommissionAmt\\n  remoteAreaCostChargeAmt\\n  productOptionAmt\\n  salesCommissionPrepay\\n  productNo\\n  payLocationType\\n  totalDiscountAmt\\n  orderNo\\n  payMeansClass\\n  productClass\\n  commissionClassType\\n  inflowPath\\n  receiverName\\n  settlementExpectAmt\\n  deliveryNo\\n  deliveryCompleteDateTime\\n  saleChannelType\\n  sellerDiscountAmt\\n  deliveryCompanyName\\n  deliveryFeeDiscountAmt\\n  dispatchDateTime\\n  sellerProductManagementCode\\n  payCommissionAmt\\n  syncDateTime\\n  productOrderStatus\\n  sellerInternalCode2\\n  sellingInterlockCommissionClassType\\n  sellingInterlockCommissionInflowPath\\n  sellerInternalCode1\\n  deliveryBundleGroupSeq\\n  productUrl\\n  __typename\\n}\\n\\nfragment paginationField on Pagination {\\n  size\\n  totalElements\\n  page\\n  totalPages\\n  __typename\\n}\\n\"}";
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/sale/purchaseDecision").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            jsonobject = (JsonObject)this.parser.parse(rs.body());
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("purchaseDecisionList");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                List<ShopOrderMstDto> param1 = this.getExcelFileManagerJson(param, jsonArray, cookies);
                param1.forEach(d -> d.setResult_code("1"));
                retList.addAll(param1);
            }
            return retList;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private List<ShopOrderMstDto> getExcelFileManagerJson(List<ShopOrderMstDto> param, JsonArray jsonArray, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                if (!ShopOrderDao.get().isOrdered(object.get("orderNo").getAsString())) {
                    String orddt;
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    if (object.get("orderStatus").getAsString().equals("WAITING_DISPATCH")) {
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_id(object.get("orderNo").getAsString());
                        dto.setOrder_status(this.getStatus(object.get("productOrderStatus").getAsString()));
                        dto.setP_product_name(object.get("productName").getAsString());
                        orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
                        dto.setOrder_date(orddt);
                        dto.setProduct_name(object.get("productName").getAsString());
                        dto.setSale_cnt(object.get("orderQuantity").getAsString());
                        dto.setUser_name(object.get("orderMemberName").getAsString());
                        dto.setUser_email("");
                        dto.setUser_id(object.get("orderMemberId").getAsString());
                        dto.setReceive_name(object.get("receiverName").getAsString());
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        String json = "{\"searchKeywordType\":\"CHANNEL_PRODUCT_NO\",\"searchKeyword\":\"" + object.get("productNo").getAsString() + "\"," + "\"productName\":\"\",\"modelName\":\"\",\"manufacturerName\":\"\",\"brandName\":\"\"," + "\"searchPaymentType\":\"ALL\",\"searchPeriodType\":\"PROD_REG_DAY\",\"deliveryAttributeType\":\"\"," + "\"productKindType\":\"\",\"etcCondition\":\"\",\"subscriptionType\":\"\"," + "\"fromDate\":\"\",\"toDate\":\"\"," + "\"viewData\":{\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\"," + "\"AFFILIATE\",\"\"],\"pageSize\":100},\"searchOrderType\":\"REG_DATE\"," + "\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\"," + "\"WINDOW\",\"AFFILIATE\"],\"page\":0,\"size\":100,\"sort\":[]}";
                        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                        String body1 = rs.body();
                        JsonObject data2 = (JsonObject)this.parser.parse(body1);
                        JsonArray contents = (JsonArray)data2.get("content");
                        JsonObject data1 = (JsonObject)contents.get(0);
                        String code = data1.get("id").getAsString();
                        dto.setMall_product_id(String.valueOf(code) + "," + object.get("productNo").getAsString());
                        dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
                        dto.setReceive_addr(this.jsonElementNullStr(object.get("receiverAddress")));
                        dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
                        dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
                        dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
                        dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
                        dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
                        dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
                        dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
                        String ordamt = object.get("productPayAmt").getAsString();
                        dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
                        dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
                        dto.setTotal_cost(ordamt);
                        dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
                        dto.setCompno(param.get(0).getCompno());
                        dto.setReceive_email("");
                        dto.setWon_cost("0");
                        dto.setBox_ea("0");
                        dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
                        dto.setP_sku_id("");
                        dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
                        dto.setResult_code("1");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dtolist.add(dto);
                    } else if (object.get("orderStatus").getAsString().equals("PURCHASE_DECIDED")) {
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_id(object.get("orderNo").getAsString());
                        dto.setOrder_status("410");
                        dto.setP_product_name(object.get("productName").getAsString());
                        orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
                        dto.setOrder_date(orddt);
                        dto.setProduct_name(object.get("productName").getAsString());
                        dto.setSale_cnt(object.get("orderQuantity").getAsString());
                        dto.setUser_name(object.get("orderMemberName").getAsString());
                        dto.setUser_email("");
                        dto.setUser_id(object.get("orderMemberId").getAsString());
                        dto.setReceive_name(object.get("receiverName").getAsString());
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        dto.setMall_product_id(object.get("productNo").getAsString());
                        dto.setReceive_zipcode("");
                        dto.setReceive_addr("");
                        dto.setUser_tel("");
                        dto.setUser_cel("");
                        dto.setReceive_tel("");
                        dto.setReceive_cel("");
                        dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
                        dto.setDelv_msg("");
                        dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
                        String ordamt = object.get("productPayAmt").getAsString();
                        dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
                        dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
                        dto.setTotal_cost(ordamt);
                        dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
                        dto.setCompno(param.get(0).getCompno());
                        dto.setReceive_email("");
                        dto.setWon_cost("0");
                        dto.setBox_ea("0");
                        dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
                        dto.setP_sku_id("");
                        dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
                        dto.setResult_code("1");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dtolist.add(dto);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc2a4\ud1a0\uc5b4\ud31c\uc218\uc9d1\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private String getDelivery(String jsonElementNullStr) {
        String value = "";
        switch (jsonElementNullStr) {
            case "PREPAYED": 
            case "\uc120\uacb0\uc81c": {
                value = "\uc120\uacb0\uc81c";
                break;
            }
            case "\ubb34\ub8cc": 
            case "FREE": {
                value = "\ubb34\ub8cc";
            }
        }
        return value;
    }

    @Override
    public String jsonElementNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    private String getStatus(String string) {
        String value = "";
        switch (string) {
            case "PLACE_ORDER": 
            case "NEW_ORDER": 
            case "PAYED": 
            case "PLACE_ORDER_RELEASE": {
                value = "100";
            }
        }
        return value;
    }

    public String getNewOrderStringParam(String merchantNo, String type, String startDate, String endDate) throws Exception {
        NewOrder newOrder = new NewOrder();
        newOrder.operationName = "smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery";
        newOrder.variables.merchantNo = merchantNo;
        newOrder.variables.serviceType = "MP";
        newOrder.variables.pagingPage = 1;
        newOrder.variables.pagingSize = 100;
        newOrder.variables.sortType = "RECENTLY_ORDER_YMDT";
        newOrder.variables.sortDirection = "DESC";
        newOrder.variables.rangeType = type;
        newOrder.variables.dateRange_from = startDate;
        newOrder.variables.dateRange_to = endDate;
        newOrder.variables.orderStatus = "WAITING_DISPATCH";
        newOrder.variables.detailedOrderStatus = "ALL";
        newOrder.query = "query smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery($dateRange_from: String, $dateRange_to: String, $delayDispatchGuideTreatStateType: DelayDispatchGuideTreatStateType, $deliveryDirectionClass: DeliveryDirectionClassType, $deliveryMethodType: DeliveryMethodType, $deliveryNo: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $detailedOrderStatus: DetailedSearchOrderStatusType, $deviceClassType: DeviceClassType, $merchantNo: String!, $orderStatus: SearchOrderStatusType, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  deliveryList: smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery(\n    dateRange_from: $dateRange_from\n    dateRange_to: $dateRange_to\n    delayDispatchGuideTreatStateType: $delayDispatchGuideTreatStateType\n    deliveryDirectionClass: $deliveryDirectionClass\n    deliveryMethodType: $deliveryMethodType\n    deliveryNo: $deliveryNo\n    detailSearch_keyword: $detailSearch_keyword\n    detailSearch_type: $detailSearch_type\n    detailedOrderStatus: $detailedOrderStatus\n    deviceClassType: $deviceClassType\n    merchantNo: $merchantNo\n    orderStatus: $orderStatus\n    paging_page: $paging_page\n    paging_size: $paging_size\n    rangeType: $rangeType\n    serviceType: $serviceType\n    sort_direction: $sort_direction\n    sort_type: $sort_type\n  ) {\n    elements {\n      ...deliveryElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment deliveryElementField on SaleDeliverySeller {\n  returnCareTarget\n  branchId\n  merchantChannelNo\n  deliveryFeeClass\n  deliveryInvoiceNo\n  orderQuantity\n  productName\n  payDateTime\n  deliveryDateTime\n  deliveryFeeRatingClass\n  productOrderMemo\n  orderMemberId\n  remoteAreaCostChargeAmt\n  payLocationType\n  totalDiscountAmt\n  orderNo\n  payMeansClass\n  productClass\n  oneYearOrderAmt\n  saleChannelType\n  oneYearOrderCount\n  deliveryCompanyName\n  sellerProductManagementCode\n  grade\n  orderMemberTelNo\n  deliveryFeeAmt\n  claimNo\n  deliveryMethod\n  deliveryMethodPay\n  biztalkAccountId\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  sixMonthOrderAmt\n  orderStatus\n  productUnitPrice\n  waybillPrintDateTime\n  threeMonthOrderCount\n  orderMemberName\n  productOrderNo\n  deliveryCompanyCode\n  productOptionContents\n  dispatchDueDateTime\n  knowledgeShoppingCommissionAmt\n  productOptionAmt\n  productNo\n  individualCustomUniqueCode\n  orderDateTime\n  placingOrderDateTime\n  inflowPath\n  receiverName\n  settlementExpectAmt\n  deliveryNo\n  threeMonthOrderAmt\n  sellerDiscountAmt\n  deliveryFeeDiscountAmt\n  dispatchDateTime\n  sixMonthOrderCount\n  receiverZipCode\n  payCommissionAmt\n  takingGoodsPlaceAddress\n  syncDateTime\n  productOrderStatus\n  sellerInternalCode2\n  sellerOptionManagementCode\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  subscriptionRound\n  subscriptionPeriodCount\n  fulfillmentCompanyName\n  receiverIntegratedAddress\n  receiverDisplayBaseAddress\n  receiverDisplayDetailAddress\n  deliveryAttributeText\n  hopeDelivery\n  initTotalDiscountAmt\n  initProductPayAmt\n  quantityClaimYn\n  quantityClaimNo\n  subscriptionHopeDelivery\n  membershipsArrivalGuaranteeClaimSupportTarget\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)newOrder);
    }

    public List<ShopOrderMstDto> getNewOrderApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList) throws Exception {
        NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
        String startdt = param.get(0).getStartDt().substring(0, 8);
        String enddt = param.get(0).getEndDt().substring(0, 8);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date sdate = formatter.parse(startdt);
        Date edate = formatter.parse(enddt);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(sdate);
        String clientId = param.get(0).getEDITAUTHKEY1();
        String clientSecret = param.get(0).getEDITAPIKEY();
        Long timestamp = System.currentTimeMillis();
        String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
        String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
        int i = 0;
        while (i < (int)range) {
            this.getOrder(accessToken, sdate, param, retList);
            cal1.add(5, 1);
            startdt = formatter.format(cal1.getTime());
            sdate = formatter.parse(startdt);
            ++i;
        }
        return retList;
    }

    private void getOrder(String accessToken, Date date, List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList) {
        block25: {
            ArrayList<String> orderId = new ArrayList<String>();
            OkHttpClient client = new OkHttpClient();
            String datePatternNaverApi = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            SimpleDateFormat format = new SimpleDateFormat(datePatternNaverApi);
            String[] status2 = new String[]{"PAYED", "CLAIM_REJECTED"};
            try {
                JsonObject object;
                String body;
                Response response;
                Object var13_17;
                Throwable throwable;
                int j = 0;
                while (j < 2) {
                    Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format.format(date) + "Z" + "&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                    Thread.sleep(450L);
                    throwable = null;
                    var13_17 = null;
                    try {
                        response = client.newCall(request2).execute();
                        try {
                            body = response.body().string();
                            object = (JsonObject)this.parser.parse(body);
                            if (object.get("data") != null) {
                                JsonObject jsonObject = object.get("data").getAsJsonObject();
                                JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                                for (JsonElement data2 : datas) {
                                    JsonObject JsonObject2 = data2.getAsJsonObject();
                                    orderId.add(JsonObject2.get("productOrderId").getAsString());
                                }
                            }
                        }
                        finally {
                            if (response != null) {
                                response.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    ++j;
                }
                if (orderId.size() == 0) break block25;
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + orderId + "}"));
                Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(requestBody).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
                throwable = null;
                var13_17 = null;
                try {
                    response = client.newCall(request2).execute();
                    try {
                        body = response.body().string();
                        object = (JsonObject)this.parser.parse(body);
                        JsonArray jsonArray = object.get("data").getAsJsonArray();
                        if (jsonArray.size() > 0) {
                            List<ShopOrderMstDto> param1 = this.setData2(param, jsonArray, accessToken);
                            param1.forEach(d -> d.setResult_code("1"));
                            retList.addAll(param1);
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print(e.getMessage());
            }
        }
    }

    public List<ShopOrderMstDto> setData2(List<ShopOrderMstDto> param, JsonArray order_arr, String accessToken) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : order_arr) {
            String ordererTel;
            boolean ordMatch;
            JsonObject object = order.getAsJsonObject();
            JsonObject productOrder = object.getAsJsonObject("productOrder");
            JsonObject orders = object.getAsJsonObject("order");
            JsonObject shippingAddress = productOrder.getAsJsonObject("shippingAddress");
            ShopOrderMstDto dto = new ShopOrderMstDto();
            String productId = productOrder.get("productOrderId").getAsString();
            if (param.get(0).getOrder_id() != null && (ordMatch = param.stream().anyMatch(s -> s.getOrder_id().equals(object.get("orderNo").toString())))) continue;
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(orders.get("orderId").getAsString());
            dto.setOrder_status(this.getStatus(productOrder.get("productOrderStatus").getAsString()));
            dto.setP_product_name(productOrder.get("productName").getAsString());
            String orddt = orders.get("orderDate").getAsString().substring(0, 19).replace("T", " ");
            dto.setOrder_date(orddt);
            dto.setProduct_name(productOrder.get("productName").getAsString());
            dto.setSale_cnt(productOrder.get("quantity").getAsString());
            dto.setUser_name(orders.get("ordererName").getAsString());
            dto.setUser_email("");
            dto.setReceive_name(shippingAddress.get("name").getAsString());
            dto.setShopid(param.get(0).getShopid());
            dto.setShop_userid(param.get(0).getShop_userid());
            dto.setUser_id(orders.get("ordererId").getAsString());
            dto.setP_sku_value(productOrder.get("productOption") == null ? "" : productOrder.get("productOption").getAsString());
            dto.setSku_value(productOrder.get("productOption") == null ? "" : productOrder.get("productOption").getAsString());
            dto.setMall_exp_cd(productId);
            if (orders.get("ordererTel") == null) {
                ordererTel = "";
            } else {
                String str = orders.get("ordererTel").getAsString();
                String first = str.substring(0, str.length() - 8);
                String middle = str.substring(str.length() - 8, str.length() - 4);
                String last = str.substring(str.length() - 4);
                ordererTel = String.valueOf(first) + "-" + middle + "-" + last;
            }
            dto.setUser_tel(ordererTel);
            dto.setUser_cel(ordererTel);
            dto.setReceive_tel(shippingAddress.get("tel2") == null ? "" : shippingAddress.get("tel2").getAsString());
            dto.setReceive_cel(shippingAddress.get("tel1") == null ? "" : shippingAddress.get("tel1").getAsString());
            dto.setReceive_zipcode(shippingAddress.get("zipCode") == null ? "" : shippingAddress.get("zipCode").getAsString());
            String receiverAddr = shippingAddress.get("baseAddress") == null ? "" : shippingAddress.get("baseAddress").getAsString().concat(" ").concat(shippingAddress.get("detailedAddress") == null ? "" : shippingAddress.get("detailedAddress").getAsString());
            dto.setReceive_addr(receiverAddr);
            dto.setDelv_cost(productOrder.get("deliveryFeeAmount") == null ? "" : productOrder.get("deliveryFeeAmount").getAsString());
            dto.setDelv_msg(productOrder.get("shippingMemo") == null ? "" : productOrder.get("shippingMemo").getAsString());
            dto.setDelivery_method_str2(this.getDelivery(productOrder.get("shippingFeeType") == null ? "" : productOrder.get("shippingFeeType").getAsString()));
            String ordamt = productOrder.get("totalPaymentAmount").getAsString();
            dto.setMall_won_cost(productOrder.get("expectedSettlementAmount") == null ? "" : productOrder.get("expectedSettlementAmount").getAsString());
            dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(productOrder.get("deliveryFeeAmount").getAsString())));
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(productOrder.get("unitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(param.get(0).getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(productOrder.get("sellerProductCode")));
            dto.setResult_code("1");
            dto.setMall_product_id(String.valueOf(productOrder.get("originalProductId").getAsString()) + "," + productOrder.get("productId").getAsString());
            list.add(dto);
        }
        return list;
    }

    private class NewOrder {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="sort_type")
            private String sortType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="orderStatus")
            private String orderStatus;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="dateRange_from")
            private String dateRange_from;
            @JsonProperty(value="dateRange_to")
            private String dateRange_to;
            @JsonProperty(value="detailedOrderStatus")
            private String detailedOrderStatus;

            private Variables() {
            }
        }
    }
}

