/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.shop.data.naverstore.NaverStoreGenerateSignature;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class NaverStoreOrderSearchCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderSearchCommand();
    JsonParser parser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderSearchCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return super.Search(URL2, startdt, enddt);
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        List<String> list = Arrays.asList(param.get(0).getApikey().split(","));
        try {
            cookies = list != null && list.size() > 1 ? is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), list.get(0), list.get(1)) : is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1());
            String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
            String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
            if (param.get(0).getVendorId().equals("N")) {
                this.orderCancel(param, ret, cookies, start, end);
                this.orderReturnList(param, ret, cookies, start, end);
                this.orderExChange(param, ret, cookies, start, end);
                this.delvCompleted(param, ret, cookies, start, end);
                this.delvCompleted2(param, ret, cookies, start, end);
            } else {
                NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
                String startdt = param.get(0).getStartDt().substring(0, 8);
                String enddt = param.get(0).getEndDt().substring(0, 8);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                Date sdate = formatter.parse(startdt);
                Date edate = formatter.parse(enddt);
                long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
                Calendar cal1 = Calendar.getInstance();
                cal1.setTime(sdate);
                String clientId = param.get(0).getEDITAUTHKEY1();
                String clientSecret = param.get(0).getEDITAPIKEY();
                Long timestamp = System.currentTimeMillis();
                String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
                String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
                OkHttpClient client = new OkHttpClient();
                int i = 0;
                while (i < (int)range) {
                    this.orderCancelApi(param, ret, accessToken, sdate, client);
                    this.orderReturnListApi(param, ret, accessToken, sdate, client);
                    this.orderExChangeApi(param, ret, accessToken, sdate, client);
                    this.delvCompletedApi(param, ret, accessToken, sdate, client);
                    cal1.add(5, 1);
                    startdt = formatter.format(cal1.getTime());
                    sdate = formatter.parse(startdt);
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return ret;
    }

    private void delvCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery/situation").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        String DeliveryComplted = this.getDeliveryCompltedOrderStringParam(merchantNo, start, end);
        rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json").cookies(cookies).requestBody(DeliveryComplted).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
        JsonObject obj1 = (JsonObject)jsonobject.get("data");
        JsonObject obj2 = (JsonObject)obj1.get("deliveryStatusListMp");
        JsonArray jsonArray = (JsonArray)obj2.get("elements");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("productNo").getAsString();
                String expid = object.get("productOrderNo").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setResult_code("1");
                    dto.setOrder_status("410");
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void delvCompleted2(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/sale/purchaseDecision").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        String PurchaseDecision = this.getPurchaseDecisionOrderStringParam(merchantNo, start, end);
        rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json").cookies(cookies).requestBody(PurchaseDecision).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
        JsonObject obj1 = (JsonObject)jsonobject.get("data");
        JsonObject obj2 = (JsonObject)obj1.get("purchaseDecisionList");
        JsonArray jsonArray = (JsonArray)obj2.get("elements");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("productNo").getAsString();
                String expid = object.get("productOrderNo").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setResult_code("1");
                    dto.setOrder_status("410");
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderCancel(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        int k = 0;
        while (k < 2) {
            String status2 = this.getStatusCancel(k);
            String strParam = this.getCancelOrderStringParam(merchantNo, status2);
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json").cookies(cookies).requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("cancelListMp");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status(this.getStatusCancel(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("C02")) {
                            ShopOrderMstDto temp = dto.clone("C02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("claimRequestAdmissionDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception exception) {}
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private void orderReturnList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/claim/return").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatusReturn(k);
            String strParam = this.getReturnOrderStringParam(merchantNo, status2);
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(strParam).referrer("https://sell.smartstore.naver.com/o/v3/iframe/claim/return").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("returnList");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status(this.getStatusReturn(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("R02")) {
                            ShopOrderMstDto temp = dto.clone("R02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("refundDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception exception) {}
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private String getStatusCancel(String asString) {
        String value = "";
        switch (asString) {
            case "CANCEL_REQUEST": {
                value = "C01";
                break;
            }
            case "CANCELING": {
                value = "C01";
                break;
            }
            case "ADMIN_CANCEL_DONE": 
            case "CANCEL_DONE": {
                value = "C02";
                break;
            }
            case "CANCEL_REJECT": {
                value = "C01";
            }
        }
        return value;
    }

    private String getStatusCancel(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "CANCEL_REQUEST";
                break;
            }
            case 1: {
                value = "CANCEL_DONE";
            }
        }
        return value;
    }

    private String getStatusReturn(String asString) {
        String value = "";
        switch (asString) {
            case "RETURN_REQUEST": {
                value = "R01";
                break;
            }
            case "COLLECTING": {
                value = "R01";
                break;
            }
            case "COLLECT_DONE": {
                value = "R01";
                break;
            }
            case "RETURN_DONE": {
                value = "R02";
                break;
            }
            case "RETURN_REJECT": {
                value = "R01";
            }
        }
        return value;
    }

    private String getStatusReturn(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "RETURN_REQUEST";
                break;
            }
            case 1: {
                value = "RETURN_COLLECTING";
                break;
            }
            case 2: {
                value = "RETURN_COLLECT_DONE";
                break;
            }
            case 3: {
                value = "RETURN_DONE";
            }
        }
        return value;
    }

    private void orderExChange(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/claim/exchange").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatus(k);
            String strParam = this.getExchangeOrderStringParam(merchantNo, status2);
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(strParam).referrer("https://sell.smartstore.naver.com/o/v3/iframe/claim/exchange").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("exchangeList");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status(this.getStatusexChange(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("E02")) {
                            dto.setOrder_status("E02");
                            dto.setResult_code("1");
                            ShopOrderMstDto temp = dto.clone("E02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("redeliveryOperationDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception exception) {}
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    @Override
    public String jsonElementNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    private String getStatus(int i) {
        String value = "";
        switch (i) {
            case 0: {
                value = "EXCHANGE_REQUEST";
                break;
            }
            case 1: {
                value = "EXCHANGE_COLLECTING";
                break;
            }
            case 2: {
                value = "EXCHANGE_COLLECT_DONE";
                break;
            }
            case 3: {
                value = "EXCHANGE_DONE";
            }
        }
        return value;
    }

    private String getStatusexChange(String string) {
        String value = "";
        switch (string) {
            case "EXCHANGE_REQUEST": {
                value = "E01";
                break;
            }
            case "COLLECTING": {
                value = "E01";
                break;
            }
            case "COLLECT_DONE": {
                value = "E01";
                break;
            }
            case "EXCHANGE_REDELIVERING": {
                value = "E02";
                break;
            }
            case "EXCHANGE_DONE": {
                value = "E02";
                break;
            }
            case "EXCHANGE_REJECT": {
                value = "E01";
            }
        }
        return value;
    }

    private void orderCancelApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate, OkHttpClient client) throws IOException, CloneNotSupportedException {
        JsonObject object;
        Response response;
        Object var14_17;
        Throwable throwable;
        Request request2;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z" + "&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                throwable = null;
                var14_17 = null;
                try {
                    response = client.newCall(request2).execute();
                    try {
                        object = (JsonObject)this.parser.parse(response.body().string());
                        if (object.get("data") != null) {
                            JsonObject jsonObject = object.get("data").getAsJsonObject();
                            JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                            for (JsonElement data2 : datas) {
                                JsonObject jsonObject2 = data2.getAsJsonObject();
                                if (!jsonObject2.get("claimType").getAsString().equals("CANCEL")) continue;
                                orderId.add(jsonObject2.get("productOrderId").getAsString());
                            }
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++j;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + orderId + "}"));
            request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            var14_17 = null;
            try {
                response = client.newCall(request2).execute();
                try {
                    object = (JsonObject)this.parser.parse(response.body().string());
                    elements = object.get("data").getAsJsonArray();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object2 = (JsonObject)elements.get(i);
                JsonObject order = object2.get("order").getAsJsonObject();
                JsonObject productOrder = object2.get("productOrder").getAsJsonObject();
                JsonObject cancel = object2.get("cancel").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status(this.getStatusCancel(cancel.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("C02")) {
                        ShopOrderMstDto temp = dto.clone("C02");
                        try {
                            String orddt = cancel.get("cancelCompletedDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception exception) {}
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderReturnListApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate, OkHttpClient client) throws IOException, CloneNotSupportedException {
        JsonObject object;
        Response response;
        Object var14_17;
        Throwable throwable;
        Request request2;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z" + "&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                throwable = null;
                var14_17 = null;
                try {
                    response = client.newCall(request2).execute();
                    try {
                        object = (JsonObject)this.parser.parse(response.body().string());
                        if (object.get("data") != null) {
                            JsonObject jsonObject = object.get("data").getAsJsonObject();
                            JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                            for (JsonElement data2 : datas) {
                                JsonObject jsonObject2 = data2.getAsJsonObject();
                                if (!jsonObject2.get("claimType").getAsString().equals("RETURN")) continue;
                                orderId.add(jsonObject2.get("productOrderId").getAsString());
                            }
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++j;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + orderId + "}"));
            request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            var14_17 = null;
            try {
                response = client.newCall(request2).execute();
                try {
                    object = (JsonObject)this.parser.parse(response.body().string());
                    elements = object.get("data").getAsJsonArray();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object2 = (JsonObject)elements.get(i);
                JsonObject order = object2.get("order").getAsJsonObject();
                JsonObject productOrder = object2.get("productOrder").getAsJsonObject();
                JsonObject returns = object2.get("return").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status(this.getStatusReturn(returns.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("R02")) {
                        ShopOrderMstDto temp = dto.clone("R02");
                        try {
                            String orddt = returns.get("returnCompletedDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception exception) {}
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderExChangeApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate, OkHttpClient client) throws IOException, CloneNotSupportedException {
        JsonObject object;
        Response response;
        Object var14_17;
        Throwable throwable;
        Request request2;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z" + "&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                throwable = null;
                var14_17 = null;
                try {
                    response = client.newCall(request2).execute();
                    try {
                        object = (JsonObject)this.parser.parse(response.body().string());
                        if (object.get("data") != null) {
                            JsonObject jsonObject = object.get("data").getAsJsonObject();
                            JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                            for (JsonElement data2 : datas) {
                                JsonObject jsonObject2 = data2.getAsJsonObject();
                                if (!jsonObject2.get("claimType").getAsString().equals("EXCHANGE")) continue;
                                orderId.add(jsonObject2.get("productOrderId").getAsString());
                            }
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++j;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + orderId + "}"));
            request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            var14_17 = null;
            try {
                response = client.newCall(request2).execute();
                try {
                    object = (JsonObject)this.parser.parse(response.body().string());
                    elements = object.get("data").getAsJsonArray();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object2 = (JsonObject)elements.get(i);
                JsonObject order = object2.get("order").getAsJsonObject();
                JsonObject productOrder = object2.get("productOrder").getAsJsonObject();
                JsonObject exchange = object2.get("exchange").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status(this.getStatusexChange(exchange.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("E02")) {
                        dto.setOrder_status("E02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("E02");
                        try {
                            String orddt = exchange.get("reDeliveryOperationDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception exception) {}
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void delvCompletedApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate, OkHttpClient client) throws Exception {
        Response response22;
        Throwable throwable;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        JsonArray elements = new JsonArray();
        try {
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z").get().addHeader("Authorization", accessToken).build();
            Thread.sleep(450L);
            Throwable throwable2 = null;
            throwable = null;
            try {
                response22 = client.newCall(request2).execute();
                try {
                    JsonObject object = (JsonObject)this.parser.parse(response22.body().string());
                    if (object.get("data") != null) {
                        JsonObject jsonObject = object.get("data").getAsJsonObject();
                        JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                        for (JsonElement data2 : datas) {
                            JsonObject jsonObject2 = data2.getAsJsonObject();
                            if (!jsonObject2.get("productOrderStatus").getAsString().equals("DELIVERED") && !jsonObject2.get("productOrderStatus").getAsString().equals("PURCHASE_DECIDED") && !jsonObject2.get("productOrderStatus").getAsString().equals("DELIVERING")) continue;
                            orderId.add(jsonObject2.get("productOrderId").getAsString());
                        }
                    }
                }
                finally {
                    if (response22 != null) {
                        response22.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + orderId + "}"));
            Request request3 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            response22 = null;
            try (Response response = client.newCall(request3).execute();){
                JsonObject object = (JsonObject)this.parser.parse(response.body().string());
                elements = object.get("data").getAsJsonArray();
            }
            catch (Throwable response22) {
                if (throwable == null) {
                    throwable = response22;
                } else if (throwable != response22) {
                    throwable.addSuppressed(response22);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object = (JsonObject)elements.get(i);
                JsonObject delivery = object.get("delivery").getAsJsonObject();
                String delComplted = "";
                if (delivery.get("deliveryStatus") != null) {
                    delComplted = delivery.get("deliveryStatus").getAsString();
                }
                if (delComplted.equals("DELIVERY_COMPLETION")) {
                    JsonObject order = object.get("order").getAsJsonObject();
                    JsonObject productOrder = object.get("productOrder").getAsJsonObject();
                    String orderid = order.get("orderId").getAsString();
                    String mallid = productOrder.get("productId").getAsString();
                    String expid = productOrder.get("productOrderId").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setResult_code("1");
                        dto.setOrder_status("410");
                        ret.add(dto);
                    }
                }
                ++i;
            }
        }
    }

    private String getDeliveryCompltedOrderStringParam(String merchantNo, String startDate, String endDate) throws Exception {
        SyncOrder deliveryComplted = new SyncOrder();
        deliveryComplted.operationName = "SmartStoreFindDeliveryStatusesBySummaryInfoType_ForSaleDeliveryStatus";
        ((SyncOrder)deliveryComplted).variables.summaryInfoType = "DELIVERED";
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = 1;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.serviceType = "MP";
        String[] sellerSearchType = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        ((SyncOrder)deliveryComplted).variables.sellerOrderSearchTypes = sellerSearchType;
        deliveryComplted.query = "query SmartStoreFindDeliveryStatusesBySummaryInfoType_ForSaleDeliveryStatus($merchantNo: String!, $paging_page: Int, $paging_size: Int, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [SellerOrderSearchType]!) {\r\n  deliveryStatusListMp: SmartStoreFindDeliveryStatusesBySummaryInfoType_ForSaleDeliveryStatus(\r\n    merchantNo: $merchantNo\r\n    paging_page: $paging_page\r\n    paging_size: $paging_size\r\n    serviceType: $serviceType\r\n    sort_direction: $sort_direction\r\n    sort_type: $sort_type\r\n    summaryInfoType: $summaryInfoType\r\n    sellerOrderSearchTypes: $sellerOrderSearchTypes\r\n  ) {\r\n    elements {\r\n      ...deliveryStatusElementField\r\n      __typename\r\n    }\r\n    pagination {\r\n      ...paginationField\r\n      __typename\r\n    }\r\n    __typename\r\n  }\r\n}\r\n\r\nfragment deliveryStatusElementField on SaleDeliveryStatusSeller {\r\n  returnCareTarget\r\n  branchId\r\n  merchantChannelNo\r\n  deliveryFeeClass\r\n  mistakenInvoiceRegDateTime\r\n  deliveryInvoiceNo\r\n  orderQuantity\r\n  productName\r\n  mistakenInvoiceReason\r\n  payDateTime\r\n  deliveryFeeRatingClass\r\n  mistakenInvoiceYn\r\n  orderMemberId\r\n  remoteAreaCostChargeAmt\r\n  invoiceNo\r\n  purchaseDecisionRequestDateTime\r\n  totalDiscountAmt\r\n  orderNo\r\n  productClass\r\n  deliveryCompleteDateTime\r\n  purchaseDecisionExtensionReason\r\n  purchaseDecisionExtensionStatusType\r\n  saleChannelType\r\n  receiverAddress\r\n  deliveryCompanyName\r\n  sellerProductManagementCode\r\n  claimStatus\r\n  orderMemberTelNo\r\n  purchaseDecisionExtensionDateTime\r\n  deliveryFeeAmt\r\n  deliveryMethod\r\n  biztalkAccountId\r\n  receiverTelNo2\r\n  productPayAmt\r\n  receiverTelNo1\r\n  orderStatus\r\n  productUnitPrice\r\n  orderMemberName\r\n  productOrderNo\r\n  deliveryCompanyCode\r\n  productOptionContents\r\n  productOptionAmt\r\n  productNo\r\n  purchaseDecisionExpectDateTime\r\n  receiverName\r\n  deliveryNo\r\n  purchaseDecisionRequestOperator\r\n  sellerDiscountAmt\r\n  deliveryFeeDiscountAmt\r\n  dispatchDateTime\r\n  receiverZipCode\r\n  syncDateTime\r\n  productOrderStatus\r\n  sellerInternalCode2\r\n  sellerInternalCode1\r\n  deliveryBundleGroupSeq\r\n  productUrl\r\n  fulfillmentCompanyName\r\n  deliveryAttributeText\r\n  __typename\r\n}\r\n\r\nfragment paginationField on Pagination {\r\n  size\r\n  totalElements\r\n  page\r\n  totalPages\r\n  __typename\r\n}";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)deliveryComplted);
    }

    private String getPurchaseDecisionOrderStringParam(String merchantNo, String startDate, String endDate) throws Exception {
        DeliveryCompleted deliveryComplted = new DeliveryCompleted();
        deliveryComplted.operationName = "SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision";
        deliveryComplted.variables.dateRangeFrom = startDate;
        deliveryComplted.variables.dateRangeTo = endDate;
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = 1;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.rangeType = "PURCHASE_DECISION_COMPLETED";
        deliveryComplted.variables.serviceType = "MP";
        deliveryComplted.variables.sortDirection = "DESC";
        deliveryComplted.variables.sortType = "PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT";
        StringBuilder sb = new StringBuilder();
        sb.append("query SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision(\r\n");
        sb.append("  $merchantNo: String!,\r\n");
        sb.append("  $serviceType: String!,\r\n");
        sb.append("  $claimStatus: ClaimStatusType,\r\n");
        sb.append("  $dateRange_from: String,\r\n");
        sb.append("  $dateRange_to: String,\r\n");
        sb.append("  $detailSearch_keyword: String,\r\n");
        sb.append("  $detailSearch_type: DetailSearchType,\r\n");
        sb.append("  $paging_page: Int,\r\n");
        sb.append("  $paging_size: Int,\r\n");
        sb.append("  $rangeType: RangeType,\r\n");
        sb.append("  $sort_direction: SortDirectionType,\r\n");
        sb.append("  $sort_type: SortType\r\n");
        sb.append(") {\r\n");
        sb.append("  purchaseDecisionList: SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision(\r\n");
        sb.append("    merchantNo: $merchantNo,\r\n");
        sb.append("    serviceType: $serviceType,\r\n");
        sb.append("    claimStatus: $claimStatus,\r\n");
        sb.append("    dateRange_from: $dateRange_from,\r\n");
        sb.append("    dateRange_to: $dateRange_to,\r\n");
        sb.append("    detailSearch_keyword: $detailSearch_keyword,\r\n");
        sb.append("    detailSearch_type: $detailSearch_type,\r\n");
        sb.append("    paging_page: $paging_page,\r\n");
        sb.append("    paging_size: $paging_size,\r\n");
        sb.append("    rangeType: $rangeType,\r\n");
        sb.append("    sort_direction: $sort_direction,\r\n");
        sb.append("    sort_type: $sort_type\r\n");
        sb.append("  ) {\r\n");
        sb.append("    elements {\r\n");
        sb.append("      ...purchaseDecisionElementField\r\n");
        sb.append("      __typename\r\n");
        sb.append("    }\r\n");
        sb.append("    pagination {\r\n");
        sb.append("      ...paginationField\r\n");
        sb.append("      __typename\r\n");
        sb.append("    }\r\n");
        sb.append("    __typename\r\n");
        sb.append("  }\r\n");
        sb.append("}\r\n");
        sb.append("\r\n");
        sb.append("fragment purchaseDecisionElementField on PurchaseDecisionSeller {\r\n");
        sb.append("  returnCareTarget\r\n");
        sb.append("  branchId\r\n");
        sb.append("  merchantChannelNo\r\n");
        sb.append("  deliveryFeeAmt\r\n");
        sb.append("  deliveryFeeClass\r\n");
        sb.append("  deliveryMethod\r\n");
        sb.append("  biztalkAccountId\r\n");
        sb.append("  deliveryInvoiceNo\r\n");
        sb.append("  productPayAmt\r\n");
        sb.append("  orderStatus\r\n");
        sb.append("  productUnitPrice\r\n");
        sb.append("  purchaseDecisionCompleteDateTime\r\n");
        sb.append("  orderQuantity\r\n");
        sb.append("  productName\r\n");
        sb.append("  orderMemberName\r\n");
        sb.append("  payDateTime\r\n");
        sb.append("  productOrderNo\r\n");
        sb.append("  productOptionContents\r\n");
        sb.append("  deliveryFeeRatingClass\r\n");
        sb.append("  orderMemberId\r\n");
        sb.append("  knowledgeShoppingCommissionAmt\r\n");
        sb.append("  remoteAreaCostChargeAmt\r\n");
        sb.append("  productOptionAmt\r\n");
        sb.append("  productNo\r\n");
        sb.append("  payLocationType\r\n");
        sb.append("  totalDiscountAmt\r\n");
        sb.append("  orderNo\r\n");
        sb.append("  payMeansClass\r\n");
        sb.append("  productClass\r\n");
        sb.append("  inflowPath\r\n");
        sb.append("  receiverName\r\n");
        sb.append("  settlementExpectAmt\r\n");
        sb.append("  deliveryNo\r\n");
        sb.append("  deliveryCompleteDateTime\r\n");
        sb.append("  saleChannelType\r\n");
        sb.append("  sellerDiscountAmt\r\n");
        sb.append("  deliveryCompanyName\r\n");
        sb.append("  deliveryFeeDiscountAmt\r\n");
        sb.append("  dispatchDateTime\r\n");
        sb.append("  sellerProductManagementCode\r\n");
        sb.append("  payCommissionAmt\r\n");
        sb.append("  syncDateTime\r\n");
        sb.append("  productOrderStatus\r\n");
        sb.append("  sellerInternalCode2\r\n");
        sb.append("  sellerInternalCode1\r\n");
        sb.append("  deliveryBundleGroupSeq\r\n");
        sb.append("  productUrl\r\n");
        sb.append("  fulfillmentCompanyName\r\n");
        sb.append("  sellerOptionManagementCode\r\n");
        sb.append("  deliveryAttributeText\r\n");
        sb.append("  initTotalDiscountAmt\r\n");
        sb.append("  initProductPayAmt\r\n");
        sb.append("  membershipsArrivalGuaranteeClaimSupportTarget\r\n");
        sb.append("  __typename\r\n");
        sb.append("}\r\n");
        sb.append("\r\n");
        sb.append("fragment paginationField on Pagination {\r\n");
        sb.append("  size\r\n");
        sb.append("  totalElements\r\n");
        sb.append("  page\r\n");
        sb.append("  totalPages\r\n");
        sb.append("  __typename\r\n");
        sb.append("}");
        deliveryComplted.query = sb.toString();
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)deliveryComplted);
    }

    private String getCancelOrderStringParam(String merchantNo, String status2) throws Exception {
        SyncOrder cancelOrder = new SyncOrder();
        cancelOrder.operationName = "findClaimCancelsBySummaryInfoTypeMp_ForClaimCancel";
        cancelOrder.variables.merchantNo = merchantNo;
        cancelOrder.variables.serviceType = "MP";
        cancelOrder.variables.pagingPage = 1;
        cancelOrder.variables.pagingSize = 100;
        ((SyncOrder)cancelOrder).variables.summaryInfoType = status2;
        String[] sellerOrderSearchTypes = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        ((SyncOrder)cancelOrder).variables.sellerOrderSearchTypes = sellerOrderSearchTypes;
        cancelOrder.query = "query findClaimCancelsBySummaryInfoTypeMp_ForClaimCancel($merchantNo: String!, $paging_page: Int, $paging_size: Int, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [SellerOrderSearchType]!) {\r\n  cancelListMp: findClaimCancelsBySummaryInfoTypeMp_ForClaimCancel(\r\n    merchantNo: $merchantNo\r\n    paging_page: $paging_page\r\n    paging_size: $paging_size\r\n    serviceType: $serviceType\r\n    sort_direction: $sort_direction\r\n    sort_type: $sort_type\r\n    summaryInfoType: $summaryInfoType\r\n    sellerOrderSearchTypes: $sellerOrderSearchTypes\r\n  ) {\r\n    elements {\r\n      ...cancelElementField\r\n      __typename\r\n    }\r\n    pagination {\r\n      ...paginationField\r\n      __typename\r\n    }\r\n    __typename\r\n  }\r\n}\r\n\r\nfragment cancelElementField on CancelClaimSeller {\r\n  deliveryFeeAmt\r\n  deliveryFeeClass\r\n  biztalkAccountId\r\n  giftName\r\n  receiverTelNo2\r\n  productPayAmt\r\n  receiverTelNo1\r\n  productUnitPrice\r\n  cancelDateTime\r\n  orderQuantity\r\n  productName\r\n  claimRequestOperatorType\r\n  clamRequestDateTime\r\n  orderMemberName\r\n  payDateTime\r\n  productOrderNo\r\n  productOptionContents\r\n  deliveryFeeRatingClass\r\n  orderMemberId\r\n  orderMemberNo\r\n  productOptionAmt\r\n  discountAmtChangedInfo\r\n  productNo\r\n  refundExpectDateTime\r\n  totalDiscountAmt\r\n  claimRequestAdmissionOperator\r\n  orderNo\r\n  productClass\r\n  receiverName\r\n  deliveryFeeChangedInfo\r\n  claimRequestReason\r\n  refundOperator\r\n  saleChannelType\r\n  receiverAddress\r\n  deliveryFeeDiscountAmt\r\n  receiverZipCode\r\n  sellerProductManagementCode\r\n  syncDateTime\r\n  productOrderStatus\r\n  sellerInternalCode2\r\n  claimRequestAdmissionDateTime\r\n  sellerInternalCode1\r\n  deliveryBundleGroupSeq\r\n  productUrl\r\n  claimStatus\r\n  orderMemberTelNo\r\n  fulfillmentCompanyName\r\n  deliveryAttributeText\r\n  __typename\r\n}\r\n\r\nfragment paginationField on Pagination {\r\n  size\r\n  totalElements\r\n  page\r\n  totalPages\r\n  __typename\r\n}";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)cancelOrder);
    }

    private String getReturnOrderStringParam(String merchantNo, String status2) throws Exception {
        SyncOrder returnOrder = new SyncOrder();
        returnOrder.operationName = "findClaimReturnsBySummaryInfoTypeMp_ForClaimReturn";
        returnOrder.variables.merchantNo = merchantNo;
        returnOrder.variables.serviceType = "MP";
        returnOrder.variables.pagingPage = 1;
        returnOrder.variables.pagingSize = 100;
        ((SyncOrder)returnOrder).variables.summaryInfoType = status2;
        String[] sellerOrderSearchTypes = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        ((SyncOrder)returnOrder).variables.sellerOrderSearchTypes = sellerOrderSearchTypes;
        returnOrder.query = "query findClaimReturnsBySummaryInfoTypeMp_ForClaimReturn($merchantNo: String!, $paging_page: Int, $paging_size: Int, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [SellerOrderSearchType]!) {\r\n  returnList: findClaimReturnsBySummaryInfoTypeMp_ForClaimReturn(\r\n    merchantNo: $merchantNo\r\n    paging_page: $paging_page\r\n    paging_size: $paging_size\r\n    serviceType: $serviceType\r\n    sort_direction: $sort_direction\r\n    sort_type: $sort_type\r\n    summaryInfoType: $summaryInfoType\r\n    sellerOrderSearchTypes: $sellerOrderSearchTypes\r\n  ) {\r\n    elements {\r\n      ...returnElementField\r\n      __typename\r\n    }\r\n    pagination {\r\n      ...paginationField\r\n      __typename\r\n    }\r\n    __typename\r\n  }\r\n}\r\n\r\nfragment returnElementField on ClaimReturnSeller {\r\n  returnCareTarget\r\n  deliveryFeeClass\r\n  holdbackStatus\r\n  deliveryInvoiceNo\r\n  claimExtraFeePayAmt\r\n  orderQuantity\r\n  productName\r\n  payDateTime\r\n  deliveryFeeRatingClass\r\n  orderMemberId\r\n  discountAmtChangedInfo\r\n  refundExpectDateTime\r\n  claimCollectStatusExposureText\r\n  totalDiscountAmt\r\n  orderNo\r\n  productClass\r\n  claimCollectDateTime\r\n  deliveryFeeChangedInfo\r\n  claimRequestDateTime\r\n  claimRequestReason\r\n  backDeliveryInvoiceNo\r\n  refundOperator\r\n  saleChannelType\r\n  deliveryCompanyName\r\n  sellerProductManagementCode\r\n  holdbackReleaseDateTime\r\n  claimStatus\r\n  holdbackConfigDateTime\r\n  orderMemberTelNo\r\n  orderMemberNo\r\n  deliveryFeeAmt\r\n  claimNo\r\n  backDeliveryMethodExposureText\r\n  deliveryMethod\r\n  biztalkAccountId\r\n  branchDeliveryStartDateTime\r\n  branchDeliveryEndDateTime\r\n  branchId\r\n  merchantChannelNo\r\n  giftName\r\n  receiverTelNo2\r\n  productPayAmt\r\n  receiverTelNo1\r\n  claimCollectStatus\r\n  productUnitPrice\r\n  claimRequestOperatorType\r\n  orderMemberName\r\n  productOrderNo\r\n  productOptionContents\r\n  claimCollectAddress\r\n  claimDeliveryFeeAmt\r\n  productOptionAmt\r\n  productNo\r\n  returnReceiveAddress\r\n  backDeliveryCompanyName\r\n  receiverName\r\n  deliveryNo\r\n  refundDateTime\r\n  deliveryFeeDiscountAmt\r\n  claimRejectDetail\r\n  backDeliveryMethod\r\n  syncDateTime\r\n  productOrderStatus\r\n  backDeliveryNo\r\n  sellerInternalCode2\r\n  sellerInternalCode1\r\n  deliveryBundleGroupSeq\r\n  productUrl\r\n  claimDeliveryFeePayMethod\r\n  claimExtraFeePayMethod\r\n  fulfillmentCompanyName\r\n  collectRemoteAreaCostChargeAmt\r\n  claimRequestReasonCollectFail\r\n  deliveryAttributeText\r\n  __typename\r\n}\r\n\r\nfragment paginationField on Pagination {\r\n  size\r\n  totalElements\r\n  page\r\n  totalPages\r\n  __typename\r\n}";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)returnOrder);
    }

    private String getExchangeOrderStringParam(String merchantNo, String status2) throws Exception {
        SyncOrder exchangeOrder = new SyncOrder();
        exchangeOrder.operationName = "SmartStoreFindClaimExchangesBySummaryInfoType_ForClaimExchange";
        exchangeOrder.variables.merchantNo = merchantNo;
        exchangeOrder.variables.serviceType = "MP";
        exchangeOrder.variables.pagingPage = 1;
        exchangeOrder.variables.pagingSize = 100;
        ((SyncOrder)exchangeOrder).variables.summaryInfoType = status2;
        String[] sellerOrderSearchTypes = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        ((SyncOrder)exchangeOrder).variables.sellerOrderSearchTypes = sellerOrderSearchTypes;
        exchangeOrder.query = "query SmartStoreFindClaimExchangesBySummaryInfoType_ForClaimExchange($merchantNo: String!, $serviceType: String!, $paging_page: Int, $paging_size: Int, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [SellerOrderSearchType]!) {\r\n  exchangeList: SmartStoreFindClaimExchangesBySummaryInfoType_ForClaimExchange(\r\n    merchantNo: $merchantNo\r\n    serviceType: $serviceType\r\n    paging_page: $paging_page\r\n    paging_size: $paging_size\r\n    sort_direction: $sort_direction\r\n    sort_type: $sort_type\r\n    summaryInfoType: $summaryInfoType\r\n    sellerOrderSearchTypes: $sellerOrderSearchTypes\r\n  ) {\r\n    elements {\r\n      ...exchangeElementField\r\n      __typename\r\n    }\r\n    pagination {\r\n      ...paginationField\r\n      __typename\r\n    }\r\n    __typename\r\n  }\r\n}\r\n\r\nfragment exchangeElementField on ClaimExchangeSeller {\r\n  lastClaimNo\r\n  beforeClaimNo\r\n  reDeliveryAddress\r\n  returnCareTarget\r\n  branchId\r\n  merchantChannelNo\r\n  deliveryFeeClass\r\n  redeliveryOperationDateTime\r\n  holdbackStatus\r\n  deliveryInvoiceNo\r\n  claimExtraFeePayAmt\r\n  reDeliveryNo\r\n  orderQuantity\r\n  productName\r\n  claimType\r\n  payDateTime\r\n  deliveryFeeRatingClass\r\n  purchaseDecisionExtensionReasonDetailContent\r\n  orderMemberId\r\n  reDeliveryStatus\r\n  claimCollectStatusExposureText\r\n  totalDiscountAmt\r\n  claimRejectDetailContent\r\n  orderNo\r\n  productClass\r\n  claimCollectDateTime\r\n  reDeliveryInvoiceNo\r\n  purchaseDecisionExtensionReason\r\n  claimRequestReason\r\n  backDeliveryInvoiceNo\r\n  exchangeRequestDateTime\r\n  reDeliveryCompanyName\r\n  deliveryCompanyName\r\n  sellerProductManagementCode\r\n  holdbackReleaseDateTime\r\n  claimStatus\r\n  holdbackConfigDateTime\r\n  orderMemberTelNo\r\n  orderMemberNo\r\n  purchaseDecisionExtensionDateTime\r\n  deliveryFeeAmt\r\n  claimNo\r\n  backDeliveryMethodExposureText\r\n  deliveryMethod\r\n  biztalkAccountId\r\n  giftName\r\n  receiverTelNo2\r\n  productPayAmt\r\n  receiverTelNo1\r\n  claimCollectStatus\r\n  productUnitPrice\r\n  claimRequestOperatorType\r\n  orderMemberName\r\n  productOrderNo\r\n  productOptionContents\r\n  claimCollectAddress\r\n  claimDeliveryFeeAmt\r\n  productOptionAmt\r\n  productNo\r\n  purchaseDecisionExpectDateTime\r\n  returnReceiveAddress\r\n  backDeliveryCompanyName\r\n  receiverName\r\n  deliveryNo\r\n  deliveryFeeDiscountAmt\r\n  reDeliveryMethod\r\n  syncDateTime\r\n  productOrderStatus\r\n  backDeliveryNo\r\n  sellerInternalCode2\r\n  sellerInternalCode1\r\n  deliveryBundleGroupSeq\r\n  productUrl\r\n  claimDeliveryFeePayMethod\r\n  claimExtraFeePayMethod\r\n  fulfillmentCompanyName\r\n  collectRemoteAreaCostChargeAmt\r\n  claimRequestReasonCollectFail\r\n  deliveryAttributeText\r\n  purchaseDecisionExtensionStatusType\r\n  __typename\r\n}\r\n\r\nfragment paginationField on Pagination {\r\n  size\r\n  totalElements\r\n  page\r\n  totalPages\r\n  __typename\r\n}";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)exchangeOrder);
    }

    private boolean orderCheck(ShopOrderMstDto dto, String orderid, String mallid, String expid) {
        return dto.getOrder_id().equals(orderid) && dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) && dto.getMall_exp_cd().equals(expid);
    }

    private class DeliveryCompleted {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="dateRange_from")
            private String dateRangeFrom;
            @JsonProperty(value="dateRange_to")
            private String dateRangeTo;
            @JsonProperty(value="detailedOrderStatus")
            private String detailedOrderStatus;
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="orderStatus")
            private String orderStatus;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="sort_type")
            private String sortType;

            private Variables() {
            }
        }
    }

    private class SyncOrder {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="sort_type")
            private String sortType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="summaryInfoType")
            public String summaryInfoType;
            @JsonProperty(value="sellerOrderSearchTypes")
            public String[] sellerOrderSearchTypes;

            private Variables() {
            }
        }
    }
}

