/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TossShoppingOrderNewCommand
extends IShopOrderTossShoppingCommand {
    OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    private static IShopOrderCommand instance = new TossShoppingOrderNewCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        List<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
        String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(param.get(0).getStartDt());
        Date edate = formatter.parse(param.get(0).getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(2, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            if (!YDMAProgressBar.get().isNullBar()) {
                YDMAProgressBar.get().setValue("\ud1a0\uc2a4\uc1fc\ud551 - 1\uac1c\uc6d4 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4.", 0);
            }
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)((range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 30L == 0L ? range / 30L : range / 30L + 1L);
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        retList = this.getNewOrder(param, retList, start, end);
        cal1.add(5, 30);
        cal2.add(5, 30);
        start = String.valueOf(cal1.getTimeInMillis());
        end = String.valueOf(cal2.getTimeInMillis());
        return retList;
    }

    public List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        try {
            cookies = is.getTossCookies(param.get(0).getShop_userid(), param.get(0).getShopPw());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String startFormatted = dateFormat.format(new Date(Long.parseLong(start)));
            String endFormatted = dateFormat.format(new Date());
            String strParam = "";
            String[] orderStatus = new String[]{"\uacb0\uc81c\uc644\ub8cc", "\uc0c1\ud488\uc900\ube44\uc911", "\ubc1c\uc1a1\uc9c0\uc5f0"};
            JsonParser parser = new JsonParser();
            JsonObject body = new JsonObject();
            JsonObject successObject = new JsonObject();
            JsonArray results = new JsonArray();
            String url = "https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/order/histories/paging";
            int i = 0;
            while (i < 3) {
                strParam = this.getNewOrderStringParam(param.get(0).getApikey(), startFormatted, endFormatted, orderStatus[i]);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)strParam);
                Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody).addHeader("Content-Type", "application/json");
                for (Map.Entry<Object, Object> entry : cookies.entrySet()) {
                    requestBuilder.addHeader("Cookie", String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                }
                Request request2 = requestBuilder.build();
                Object object = null;
                Object var22_24 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    String responseBody;
                    if (response.isSuccessful() && (results = (successObject = (body = parser.parse(responseBody = response.body().string()).getAsJsonObject()).getAsJsonObject("success")).getAsJsonArray("results")).size() > 0) {
                        List<ShopOrderMstDto> param1 = this.setData(param, results, cookies);
                        param1.forEach(d -> d.setResult_code("1"));
                        retList.addAll(param1);
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return retList;
    }

    public String getNewOrderStringParam(String merchantId, String startDate, String endDate, String orderStatus) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("orderProductStatus", orderStatus);
        json.addProperty("masking", Boolean.valueOf(true));
        json.add("stockIds", (JsonElement)new JsonArray());
        json.addProperty("page", (Number)1);
        json.addProperty("pageSize", (Number)200);
        json.addProperty("sortDirection", "DESC");
        return json.toString();
    }

    public List<ShopOrderMstDto> setData(List<ShopOrderMstDto> param, JsonArray orderArr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Request.Builder requestBuilder = new Request.Builder().url("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/merchants/70001/my-settlement-configs?&checkIsMaintenanceTime=false").get().addHeader("Content-Type", "application/json");
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            requestBuilder.addHeader("Cookie", String.valueOf(entry.getKey()) + "=" + entry.getValue());
        }
        Request request2 = requestBuilder.build();
        double paymentFeeRate = 0.016;
        double salesFeeRate = 0.08;
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonParser parser = new JsonParser();
                JsonObject object = (JsonObject)parser.parse(response.body().string());
                if (object.get("resultType").getAsString().equals("SUCCESS")) {
                    JsonObject successObject = object.get("success").getAsJsonObject();
                    paymentFeeRate = successObject.get("tossMoneyFeeRate").getAsDouble() / 100.0;
                    salesFeeRate = successObject.get("feeRate").getAsDouble() / 100.0;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uacb0\uc81c \uc218\uc218\ub8cc\uc728 \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec\ubc23\uc0dd \uc5d0\ub7ec\uba54\uc138\uc9c0 [" + e + "]  \n \uae30\ubcf8\uac12\uc73c\ub85c \uac00\uc838\uc634");
        }
        for (JsonElement element : orderArr) {
            JsonObject orderObject = element.getAsJsonObject();
            ShopOrderMstDto dto = new ShopOrderMstDto();
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(orderObject.get("orderId").getAsString());
            dto.setMall_product_id(orderObject.get("productId").getAsString());
            dto.setMall_order_id(orderObject.get("orderProductId").getAsString());
            dto.setP_product_name(orderObject.get("productName").getAsString());
            dto.setProduct_name(orderObject.get("productName").getAsString());
            dto.setOrder_status(this.getStatus(orderObject.get("orderProductStatus").getAsString()));
            String orderDate = orderObject.get("orderedAt").getAsString().replace("T", " ");
            dto.setOrder_date(orderDate);
            dto.setUser_name(orderObject.get("ordererName").getAsString());
            dto.setUser_tel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("ordererPhone").getAsString()));
            dto.setUser_cel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("ordererPhone").getAsString()));
            dto.setReceive_name(orderObject.get("receiverName").getAsString());
            dto.setReceive_addr(String.valueOf(orderObject.get("address").getAsString()) + " " + orderObject.get("detailAddress").getAsString());
            dto.setReceive_tel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("receiverPhone").getAsString()));
            dto.setReceive_cel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("receiverPhone").getAsString()));
            dto.setDelv_msg(orderObject.get("shippingNote").getAsString());
            dto.setSale_cnt(orderObject.get("quantity").getAsString());
            dto.setPay_cost(orderObject.get("price").getAsString());
            int saleCount = Integer.parseInt(dto.getSale_cnt());
            int payCost = Integer.parseInt(dto.getPay_cost());
            dto.setSale_cost(String.valueOf(payCost / saleCount));
            String totalCost = orderObject.get("price").getAsString();
            dto.setTotal_cost(totalCost);
            dto.setReceive_zipcode(orderObject.get("zipCode").getAsString());
            dto.setP_sku_value(orderObject.get("optionName") == null ? "" : orderObject.get("optionName").getAsString());
            dto.setSku_value(orderObject.get("optionName") == null ? "" : orderObject.get("optionName").getAsString());
            dto.setShopid(param.get(0).getShopid());
            dto.setShop_userid(param.get(0).getShop_userid());
            dto.setCompno(param.get(0).getCompno());
            if (orderObject.get("deliveryFee") == null) {
                dto.setDelv_cost("0");
            } else {
                dto.setDelv_cost(orderObject.get("deliveryFee").getAsString());
            }
            if (dto.getDelv_cost().equals("0")) {
                dto.setDelivery_method_str2("\ubb34\ub8cc");
            } else {
                dto.setDelivery_method_str2("\uc120\uacb0\uc81c");
            }
            int price2 = Integer.parseInt(totalCost);
            int paymentFee = (int)Math.floor((double)price2 * paymentFeeRate);
            int paymentFeeWithVat = (int)Math.floor((double)paymentFee * 1.1);
            int salesFee = (int)Math.floor((double)price2 * salesFeeRate);
            int salesFeeWithVat = (int)Math.floor((double)salesFee * 1.1);
            int mallExpcd = price2 - paymentFeeWithVat - salesFeeWithVat;
            dto.setMall_exp_cd("0");
            dto.setMall_won_cost(String.valueOf(mallExpcd));
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            String compayny_goods_cd = "";
            compayny_goods_cd = !orderObject.has("productManagementCode") || orderObject.get("productManagementCode").isJsonNull() ? this.getCompanyGoodsCd(orderObject.get("productId").getAsString(), param.get(0).getShopid()) : orderObject.get("productManagementCode").getAsString();
            dto.setCompayny_goods_cd(compayny_goods_cd);
            list.add(dto);
        }
        return list;
    }

    public static String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            return phoneNumber;
        }
        if (phoneNumber.startsWith("02")) {
            if (phoneNumber.length() == 10) {
                return phoneNumber.replaceAll("(02)(\\d{4})(\\d{4})", "$1-$2-$3");
            }
            if (phoneNumber.length() == 9) {
                return phoneNumber.replaceAll("(02)(\\d{3})(\\d{4})", "$1-$2-$3");
            }
        }
        if (phoneNumber.length() == 11) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{4})(\\d{4})", "$1-$2-$3");
        }
        if (phoneNumber.length() == 10) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3");
        }
        return phoneNumber;
    }

    private String getCompanyGoodsCd(String productId, String shopId) {
        String company_goods_cd = "";
        try {
            company_goods_cd = ShopCommonDao.get().getCompanyGoodsCd(productId, shopId);
        }
        catch (Exception exception) {}
        return company_goods_cd;
    }

    private String getStatus(String string) {
        String status2 = "";
        switch (string) {
            case "\uc0c1\ud488\uc900\ube44\uc911": 
            case "\uacb0\uc81c\uc644\ub8cc": 
            case "\ubc1c\uc1a1\uc9c0\uc5f0": {
                status2 = "100";
            }
        }
        return status2;
    }
}

