/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.kdjsystem.mlink.shop.dao.ProdReceiveSetDto;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.SimpleThreadPool;

public class JobContext {
    private static JobContext instance = new JobContext();
    private StdSchedulerFactory schedulerFactory = null;
    private Scheduler scheduler = null;
    private String _key;
    private String _group;
    private List<ScheduleInfoDto> _dtos;
    private List<ProductSchedulerSyncDTO> _syncInfos;
    private ScheduleInfoDto dto;
    private List<ShopOrderMstDto> list;
    private List<ProdReceiveSetDto> _list;

    public static JobContext get() {
        try {
            if (JobContext.instance.scheduler == null || JobContext.instance.scheduler.isShutdown()) {
                instance.initSchedulerFactory();
                JobContext.instance.scheduler = JobContext.instance.schedulerFactory.getScheduler();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    private void initSchedulerFactory() throws Exception {
        Properties mergedProps = new Properties();
        mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        mergedProps.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
        mergedProps.setProperty("org.quartz.scheduler.instanceName", "UfloClusterHeartbeatScheduler");
        mergedProps.setProperty("org.quartz.scheduler.instanceId", "UfloHeartbeatDetectionScheduler");
        mergedProps.setProperty("org.quartz.threadPool.threadCount", "10");
        this.schedulerFactory = new StdSchedulerFactory();
        this.schedulerFactory.initialize(mergedProps);
        this.scheduler = this.schedulerFactory.getScheduler();
    }

    private JobContext() {
    }

    public JobContext addJobNamGroup(String name, String group, ScheduleInfoDto dto, List<ShopOrderMstDto> list) {
        this._key = name;
        this._group = group;
        this.dto = dto;
        this.list = list;
        return this;
    }

    public JobContext addJobNamGroup(String name, String group, Object dtos) {
        this._key = name;
        this._group = group;
        if (this._group.contains("OLD_PROD") || this._group.contains("CLEAR")) {
            this._dtos = (List)dtos;
        } else if (this._group.contains("SYNC")) {
            this._syncInfos = (List)dtos;
        }
        return this;
    }

    public JobContext addJobNamGroup(String name, String group, ScheduleInfoDto dto, List<ProdReceiveSetDto> list, String a) {
        this._key = name;
        this._group = group;
        this.dto = dto;
        this._list = list;
        return this;
    }

    public JobContext addJob(Class<? extends Job> jobClass, String execKey, String cronExpression) throws SchedulerException {
        JobDataMap jobDataMap = new JobDataMap();
        if (this._key.equals("Order") || this._key.equals("Question")) {
            jobDataMap.put(this._key, (Object)this.dto);
            jobDataMap.put("SHOP", this.list);
            jobDataMap.put("EXEC_KEY", execKey);
        } else if (this._key.equals("PRODUCT")) {
            jobDataMap.put("WORK_GROUP", this._group);
            jobDataMap.put("EXEC_KEY", execKey);
            if (this._group.contains("OLD_PROD") || this._group.contains("CLEAR")) {
                jobDataMap.put(this._key, this._dtos);
            } else if (this._group.contains("SYNC")) {
                jobDataMap.put(this._key, this._syncInfos);
            }
        } else if (this._key.equals("PROD_RCV")) {
            jobDataMap.put(this._key, (Object)this.dto);
            jobDataMap.put("DOMESHOP", this._list);
            jobDataMap.put("EXEC_KEY", execKey);
        }
        JobKey jobKey = new JobKey(this._key, this._group);
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobKey).usingJobData(jobDataMap).build();
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobDetail).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        this.scheduler.scheduleJob(jobDetail, trigger);
        return this;
    }

    public void clearKey(String key) {
        try {
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.anyGroup());
            for (JobKey jobKey : jobKeys) {
                if (!jobKey.getName().equals(key)) continue;
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() throws SchedulerException {
        this.scheduler.start();
    }

    public void stop() throws SchedulerException {
        this.scheduler.shutdown();
    }
}

