/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.CaffeineCategoryCache;
import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.HttpClientEx;
import com.kdjsystem.mlink.shop.dao.NaverCateApiInfoDto;
import com.kdjsystem.mlink.shop.dao.ProductDomeItemDto;
import com.kdjsystem.mlink.shop.dao.ProductDomeResultDto;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.mlink.MLinkOption;
import com.kdjsystem.mlink.shop.mlink.MLinkOptionList;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.ShoppingMallDao;
import com.kdjsystem.mlink.tot.ui.MlinkFreeInfomationDialog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.swt.widgets.Shell;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.chrome.ChromeDriver;

public class MLinkCommon {
    final OkHttpClient client = new OkHttpClient();
    public static MLinkCommon instance = new MLinkCommon();
    public static final String LOGIN_HOST = "http://api.kdjsystem.com:8080";
    public static final String DATA_HOST = "http://insulove8.cafe24.com";
    public static String UserId = "";
    public static String UserPassword = "";
    public static String UserApiKey = "";
    public static String FailReason = "";
    public static List<CategoryItemDomesin> category;
    Map<String, String> cookie;
    public int saveLength = 0;
    JsonParser parser = new JsonParser();

    private MLinkCommon() {
    }

    public static MLinkCommon get() {
        return instance;
    }

    public boolean LoadCategory() throws Exception {
        HashMap<String, String> postPara = null;
        String response = "";
        String path = "/API/COUPANG/category.php";
        YDMAStringUtil.Print("[DoMeSin] load category start...");
        postPara = new HashMap<String, String>();
        postPara.put("id", UserId);
        postPara.put("api_key", UserApiKey);
        String postForm = this.ConvertDictionaryToParameter(postPara);
        response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), postForm);
        if (response == null) {
            return false;
        }
        ObjectMapper mapper = new ObjectMapper();
        CategoryDomesin Category2 = null;
        Category2 = (CategoryDomesin)mapper.readValue(response, CategoryDomesin.class);
        if (Category2.code.equals("0000")) {
            int maxDebug = Category2.data.length > 5 ? 5 : Category2.data.length;
            YDMAStringUtil.Print("    debug counts: " + maxDebug);
            int idx = 0;
            while (idx < maxDebug) {
                YDMAStringUtil.Print("    [" + idx + "]");
                YDMAStringUtil.Print("      cid: " + Category2.data[idx].cid);
                YDMAStringUtil.Print("      name: " + Category2.data[idx].name);
                YDMAStringUtil.Print("      deep: " + Category2.data[idx].deep);
                YDMAStringUtil.Print("      parent_cid: " + Category2.data[idx].parent_cid);
                YDMAStringUtil.Print("      ca_qty: " + Category2.data[idx].ca_qty);
                YDMAStringUtil.Print("      fullcat: " + Category2.data[idx].fullcat);
                YDMAStringUtil.Print("      ec: " + Category2.data[idx].ec);
                ++idx;
            }
        } else {
            FailReason = "\uce74\ud14c\uace0\ub9ac\uc5d0 \uc815\uc758\ub418\uc9c0 \uc54a\uc740 \uc5d0\ub7ec\uac00 \uc788\uc2b5\ub2c8\ub2e4...";
            YDMAStringUtil.Print("    Error: " + FailReason);
        }
        category = Arrays.asList(Category2.data);
        YDMAStringUtil.Print("[DoMeSin] load category finish...");
        return true;
    }

    public String getParentClassCd(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.parent_cid).findAny().orElse("");
    }

    public String getCateName(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.name).findAny().orElse("");
    }

    public String getFullCateName(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.fullcat).findAny().orElse("");
    }

    public Map<String, String> GetProductQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date_type", "0");
        parameters.put("start_date", "2020-03-01");
        parameters.put("end_date", "2020-03-09");
        parameters.put("cid_type", "1");
        parameters.put("min_amount", "0");
        parameters.put("max_amount", "0");
        parameters.put("vender_m_code_type", "0");
        parameters.put("vender_m_code", "");
        parameters.put("icode_type", "0");
        parameters.put("icode_arr", "");
        parameters.put("q", "");
        parameters.put("is_overseas", "");
        parameters.put("is_tax", "");
        parameters.put("isreturn", "");
        parameters.put("islimit", "");
        parameters.put("delivery_type", "");
        parameters.put("list_option_use", "");
        parameters.put("adult", "");
        parameters.put("status", "1");
        return parameters;
    }

    public MLinkOptionList getOptionList(String option2) {
        MLinkOptionList optionList = new MLinkOptionList();
        ArrayList<MLinkOption> ret_options = new ArrayList<MLinkOption>();
        List lines = Arrays.stream(option2.split("\\r|\\n")).collect(Collectors.toList());
        YDMAStringUtil.Print();
        String title = (String)lines.get(0);
        lines.remove(0);
        title = title.replace("[", "");
        title = title.replace("]", "");
        int dan = title.indexOf("=") > 0 ? 2 : 1;
        optionList.setDan(dan);
        if (dan == 1) {
            String char_1_nm = title.indexOf("\uc0c9\uc0c1") > 0 ? "\uce7c\ub77c" : title;
            optionList.setChar_1_nm(char_1_nm);
        } else {
            String[] charnms = title.split("=");
            if (charnms[0].indexOf("\uc0c9\uc0c1") > 0) {
                optionList.setChar_1_nm("\uce7c\ub77c");
            } else {
                optionList.setChar_1_nm(charnms[0]);
            }
            optionList.setChar_2_nm(charnms[1]);
        }
        for (String line : lines) {
            MLinkOption dto = new MLinkOption();
            List<String> lst_option = Arrays.asList(line.split("="));
            if (dan == 1) {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2("");
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            } else {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2(lst_option.get(1));
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            }
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(p -> p.getOptionName2()).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }

    public String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.stream().collect(Collectors.joining("&"));
    }

    public boolean isAlertPresent(ChromeDriver driver) {
        try {
            driver.switchTo().alert();
            return true;
        }
        catch (NoAlertPresentException noAlertPresentException) {
            return false;
        }
    }

    public ShopOrderMstDto InvoiceSearch(List<ShopOrderMstDto> list) {
        ShopOrderMstDto dto = new ShopOrderMstDto();
        YDMAProgressBar.get().start("\uc1a1\uc815\ubc88\ud638\uc870\ud68c\uc911", 100, 10, true);
        YDMAProgressBar.get().setValue("\uc1a1\uc7a5\uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 100);
        ChromeDriver driver = ChromeExtention.getInstace().getDriver();
        String URL2 = "https://search.naver.com/search.naver?sm=top_hty&fbm=1&ie=utf8&query=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C";
        driver.get(URL2);
        Map<String, String> cookies = ChromeScript.get().getCookies(driver);
        try {
            try {
                Connection.Response rs = Jsoup.connect((String)"https://m.search.naver.com/p/csearch/ocontent/util/headerjson.nhn?_callback=window.__jindo2_callback._306&callapi=parceltracking&t_code=04&t_invoice=111111111111111&passportKey=QlqbAzK6P6uUT%2FL8neG%2Fr%2FyP1sO5S33Gvcf8ZeNoLqY%3D").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("_callback", "window.__jindo2_callback._306").data("callapi", "parceltracking").data("t_code", list.get(0).getNaverexpcode()).data("t_invoice", list.get(0).getInvoice_no()).data("passportKey", "QlqbAzK6P6uUT/L8neG/r/yP1sO5S33Gvcf8ZeNoLqY=").referrer(" https://search.naver.com/search.naver?sm=tab_hty.top&where=nexearch&query=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C&oquery=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C&tqi=" + cookies.get("page_uid")).method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
                String body = rs.body();
                body = body.substring(body.indexOf("{"), body.lastIndexOf(")"));
                JsonObject jsonobject = (JsonObject)this.parser.parse(body);
                if (jsonobject.get("message") != null) {
                    JsonObject message = (JsonObject)jsonobject.get("message");
                    String error = message.get("error") == null ? "" : message.get("error").getAsString();
                    YDMAProgressBar.get().setValue(String.format("\uace0\uac1d\uba85 : %s, \ud0dd\ubc30\uc5c5\uccb4 : %s, \uc1a1\uc7a5\ubc88\ud638 : %s, \ub0b4\uc6a9 : %s", list.get(0).getReceive_name(), list.get(0).getDelvnm(), list.get(0).getInvoice_no(), error), 100);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                driver.close();
                driver.quit();
            }
        }
        finally {
            driver.close();
            driver.quit();
        }
        return dto;
    }

    public ProductResultDto getProductMapping(String response, String shopcd) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ProductDomeResultDto productDomemall = null;
        productDomemall = (ProductDomeResultDto)mapper.readValue(response, ProductDomeResultDto.class);
        ProductResultDto productResultDto = this.getProductItem(productDomemall, shopcd);
        return productResultDto;
    }

    private ProductResultDto getProductItem(ProductDomeResultDto productDomemall, String shopcd) throws InterruptedException {
        ProductResultDto resultDto = new ProductResultDto();
        resultDto.code = productDomemall.code;
        resultDto.current_page = productDomemall.current_page;
        resultDto.message = productDomemall.message;
        resultDto.total_count = productDomemall.total_count;
        resultDto.total_page = productDomemall.total_page;
        resultDto.mb_point = productDomemall.mb_point;
        resultDto.hasNext = productDomemall.hasNext;
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        if (productDomemall.items == null) {
            return resultDto;
        }
        for (ProductDomeItemDto item : productDomemall.items) {
            if (item == null || item.getIcode() == null) continue;
            ProductItemDto dto = new ProductItemDto(item);
            if (shopcd.equals("shop0319")) {
                dto.setIcode("DMM" + dto.getIcode());
            } else if (shopcd.equals("shop9994")) {
                dto.setIcode("3MRO" + dto.getIcode());
            } else if (shopcd.equals("shop9995")) {
                dto.setIcode("ZEN" + dto.getIcode());
            }
            items.add(dto);
        }
        resultDto.items = items;
        return resultDto;
    }

    public String convertToJson(Map<String, String> parameters) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(parameters);
        return json;
    }

    public String getTableNm(String shopcd) {
        String tablenm = "";
        switch (shopcd) {
            case "shop9992": {
                tablenm = "SHOPPRODINFO_WTRADING";
                break;
            }
            case "shop0286": {
                tablenm = "SHOPPRODINFO_FUNN";
                break;
            }
            case "shop0316": {
                tablenm = "SHOPPRODINFO_TOBIZON";
                break;
            }
            case "shop0319": {
                tablenm = "SHOPPRODINFO_DOMEGGOOK";
                break;
            }
            case "shop5001": {
                tablenm = "SHOPPRODINFO_HUBSELLER";
                break;
            }
            case "shop0203": {
                tablenm = "SHOPPRODINFO_DOMECHANGGO";
                break;
            }
            case "shop9994": {
                tablenm = "SHOPPRODINFO_THREEMRO";
                break;
            }
            case "shop9995": {
                tablenm = "SHOPPRODINFO_ZENTRADE";
                break;
            }
            case "shop0120": {
                tablenm = "SHOPPRODINFO_OWNERCLAN";
                break;
            }
            case "shop0283": {
                tablenm = "SHOPPRODINFO_DOMESIN";
                break;
            }
            case "shop0284": {
                tablenm = "SHOPPRODINFO_DOMESIN2";
                break;
            }
            case "shop9991": {
                tablenm = "SHOPPRODINFO_DOMEATOZ";
                break;
            }
            default: {
                tablenm = "";
            }
        }
        return tablenm;
    }

    public List<ShopProductDto> getCategorysShopCidSetting(List<ShopProductDto> parents, List<ShopProductDto> childs) throws Exception {
        ShopProductDao.ShopCateItem shopCateItem = null;
        try {
            for (ShopProductDto child : childs) {
                String shop_cid;
                String class_cd4 = String.valueOf(child.getClass_cd4());
                String class_cd3 = String.valueOf(child.getClass_cd3());
                String string = shop_cid = !class_cd4.isEmpty() ? class_cd4 : class_cd3;
                if (child.getShop_cid_info() == null || child.getShop_cid_info().equals("")) {
                    ShopProductDto parent = parents.stream().filter(d -> d.getProdseq().equals(child.getProdseq())).findAny().get();
                    child.setShop_cid_info(parent.getShop_cid_info());
                }
                ShopProductDao.get();
                shopCateItem = ShopProductDao.getCateJson(child.getShop_cid_info(), child.getShopcd());
                if (shopCateItem == null) continue;
                child.setShopCid(shopCateItem.getCid());
                child.setCatno(shop_cid);
                if (child.getShopcd().equals("shop00671")) {
                    child.setEsmCid(shopCateItem.getEsm_auction());
                    continue;
                }
                if (!child.getShopcd().equals("shop00681")) continue;
                child.setEsmCid(shopCateItem.getEsm_gmarket());
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \uc124\uc815 \uc900\ube44 \uc911\uc5d0 \ucd08\uae30\ud654\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc804\uc1a1\ud560 \uc0c1\ud488 \uc218\ub97c \uc904\uc778 \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574 \uc8fc\uc138\uc694.");
        }
        return childs;
    }

    public ProductResultDto getProductUploadMapping(List<List<String>> sheetContents) throws Exception {
        ProductResultDto productResult = new ProductResultDto();
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        int rowNum = 1;
        for (List<String> list : sheetContents) {
            ArrayList<String> listTemp = new ArrayList<String>();
            listTemp.add(String.valueOf(rowNum));
            int i = 0;
            while (i < list.size()) {
                listTemp.add(list.get(i).trim());
                ++i;
            }
            String prodcd = ((String)listTemp.get(3)).toString();
            if (prodcd.length() == 0) continue;
            ProductItemDto dto = new ProductItemDto();
            dto.setSearch(((String)listTemp.get(1)).toString());
            dto.setVender_code(((String)listTemp.get(2)).toString());
            dto.setIcode(((String)listTemp.get(3)).toString());
            dto.setIname(((String)listTemp.get(4)).toString());
            dto.setKeyword(((String)listTemp.get(5)).toString());
            String[] strimg = ((String)listTemp.get(6)).toString().replace("[", "").replace("]", "").split(",");
            dto.setImg(strimg);
            dto.setContent(((String)listTemp.get(7)).toString());
            dto.setSelect_option(((String)listTemp.get(8)).toString());
            dto.setPrice(((String)listTemp.get(9)).toString());
            dto.setIslimit(((String)listTemp.get(10)).toString());
            dto.setLimit_price(((String)listTemp.get(11)).toString());
            dto.setDelivery_type(((String)listTemp.get(12)).toString());
            dto.setDelivery_amount(((String)listTemp.get(13)).toString());
            dto.setR_delivery_amount(((String)listTemp.get(14)).toString());
            dto.setDelivery_qty(((String)listTemp.get(15)).toString());
            dto.setIsreturn(((String)listTemp.get(16)).toString());
            dto.setItype(((String)listTemp.get(17)).toString());
            dto.setTax(((String)listTemp.get(18)).toString());
            dto.setIcountry(((String)listTemp.get(19)).toString());
            dto.setCate_depth(((String)listTemp.get(20)).toString());
            dto.setCid(((String)listTemp.get(21)).toString());
            dto.setCateg_nm(((String)listTemp.get(22)).toString());
            dto.setEs(((String)listTemp.get(23)).toString());
            dto.setGosi_code(((String)listTemp.get(24)).toString());
            dto.setGosi1(((String)listTemp.get(25)).toString());
            dto.setGosi2(((String)listTemp.get(26)).toString());
            dto.setGosi3(((String)listTemp.get(27)).toString());
            dto.setGosi4(((String)listTemp.get(28)).toString());
            dto.setGosi5(((String)listTemp.get(29)).toString());
            dto.setGosi6(((String)listTemp.get(30)).toString());
            dto.setGosi7(((String)listTemp.get(31)).toString());
            dto.setGosi8(((String)listTemp.get(32)).toString());
            dto.setGosi9(((String)listTemp.get(33)).toString());
            dto.setGosi10(((String)listTemp.get(34)).toString());
            dto.setGosi11(((String)listTemp.get(35)).toString());
            dto.setGosi12(((String)listTemp.get(36)).toString());
            dto.setGosi13(((String)listTemp.get(37)).toString());
            dto.setGosi14(((String)listTemp.get(38)).toString());
            dto.setGosi15(((String)listTemp.get(39)).toString());
            dto.setGosi16(((String)listTemp.get(40)).toString());
            dto.setGosi17(((String)listTemp.get(41)).toString());
            dto.setGosi18(((String)listTemp.get(42)).toString());
            dto.setGosi19(((String)listTemp.get(43)).toString());
            dto.setGosi20(((String)listTemp.get(44)).toString());
            dto.setGosi21(((String)listTemp.get(45)).toString());
            dto.setGosi22(((String)listTemp.get(46)).toString());
            dto.setStatus(((String)listTemp.get(47)).toString());
            dto.setMaker(((String)listTemp.get(48)).toString());
            dto.setBrand(((String)listTemp.get(49)).toString());
            dto.setReg_datetime(((String)listTemp.get(50)).toString());
            dto.setUp_datetime(((String)listTemp.get(51)).toString());
            dto.setAdult(((String)listTemp.get(52)).toString());
            dto.setCert_type(((String)listTemp.get(53)).toString());
            dto.setCert(((String)listTemp.get(54)).toString());
            dto.setCert_no(((String)listTemp.get(55)).toString());
            dto.setNotice(((String)listTemp.get(56)).toString());
            dto.setPrice_consumer(((String)listTemp.get(57)).toString());
            dto.setText_option(((String)listTemp.get(58)).toString());
            dto.setIs_overseas(((String)listTemp.get(59)).toString());
            dto.setEs_coupang(((String)listTemp.get(61)).toString());
            dto.setEs_auction(((String)listTemp.get(62)).toString());
            dto.setEsm_auction(((String)listTemp.get(63)).toString());
            dto.setEs_gmarket(((String)listTemp.get(64)).toString());
            dto.setEsm_gmarket(((String)listTemp.get(65)).toString());
            dto.setEs_11st(((String)listTemp.get(66)).toString());
            dto.setEs_interpark(((String)listTemp.get(67)).toString());
            dto.setEs_storefarm(((String)listTemp.get(68)).toString());
            dto.setEs_wemarket(((String)listTemp.get(69)).toString());
            dto.setEs_kakao(((String)listTemp.get(70)).toString());
            dto.setEs_tmon(((String)listTemp.get(71)).toString());
            dto.setEs_ssg(((String)listTemp.get(72)).toString());
            dto.setEs_lotteon(((String)listTemp.get(73)).toString());
            dto.setEs_melchi(((String)listTemp.get(74)).toString());
            dto.setEs_tossShopping(((String)listTemp.get(75)).toString());
            dto.setEs_alwayz(((String)listTemp.get(76)).toString());
            items.add(dto);
        }
        productResult.items = items;
        return productResult;
    }

    public void setCompanyGoodsCd(ShopOrderMstDto dto, ShopPreferencesDto shopPreferencesDto) throws Exception {
        if (shopPreferencesDto.getProdcpyyn().equals("Y")) {
            String companyGoodsCd = dto.getCompayny_goods_cd();
            String extractedCode = null;
            if (companyGoodsCd != null) {
                if (companyGoodsCd.contains("_")) {
                    int underscoreIndex = dto.getCompayny_goods_cd().indexOf("_");
                    if (underscoreIndex != -1) {
                        if (shopPreferencesDto.getProdcpy_loc().equals("right")) {
                            extractedCode = companyGoodsCd.substring(0, underscoreIndex);
                        } else if (shopPreferencesDto.getProdcpy_loc().equals("left")) {
                            extractedCode = companyGoodsCd.substring(underscoreIndex + 1);
                        }
                    }
                } else {
                    extractedCode = companyGoodsCd;
                }
                if (extractedCode != null) {
                    dto.setCompayny_goods_cd(extractedCode);
                }
            }
        }
    }

    public void setValueYDMAprogrssBarisScheduler(YDMAProgressBar console, String message, int page) {
        if (console == null) {
            YDMAProgressBar.get().setValue(message, page);
        } else {
            console.setValue(message, page);
        }
    }

    public boolean isNotNullEmpty(String val) {
        if (val == null) {
            return false;
        }
        return !val.trim().isEmpty();
    }

    public ProductResultDto getProductUploadMappingByEsellsers(Map<Integer, HashMap<String, String>> readExcelManager, String shopcd, boolean useNaverCate) throws Exception {
        ProductResultDto productResult = new ProductResultDto();
        HashMap<String, String> categoryInfoCache = new HashMap<String, String>();
        HashMap<String, String> fullCategoryNameCache = new HashMap<String, String>();
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        List<NaverCateApiInfoDto> cateInfos = ShopCommonDao.get().getNaverCateApiInfos();
        for (Map.Entry<Integer, HashMap<String, String>> entry : readExcelManager.entrySet()) {
            String prodcd;
            if (entry.getKey() == 0) continue;
            HashMap<String, String> data2 = entry.getValue();
            String check1 = data2.get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d");
            String check2 = data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85");
            String check3 = data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4");
            if (check1 != null && !check1.isEmpty() || check2 != null && !check2.isEmpty() || check3 != null && !check3.isEmpty() || (prodcd = data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc")).length() == 0) continue;
            ProductItemDto dto = new ProductItemDto();
            dto.setIcode(prodcd);
            dto.setVender_code(data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc"));
            dto.setFolder(data2.get("\ud3f4\ub354\uba85"));
            dto.setIname(data2.get("\uc0c1\ud488\uba85*"));
            String cateCd = "";
            if (useNaverCate && !cateInfos.isEmpty()) {
                cateCd = this.getTopCategoryCidFromNaverByProductName(dto.getIname(), cateInfos);
                if (cateCd.equals("")) {
                    cateCd = data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*");
                }
            } else {
                cateCd = data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*");
            }
            if (cateCd.equals("")) continue;
            dto.setCid(cateCd);
            dto.setPrice(data2.get("\ud310\ub9e4\uac00*"));
            dto.setQty(data2.get("\uc218\ub7c9*"));
            dto.setLimitQty(data2.get("\ucd5c\ub300\uad6c\ub9e4\uc218\ub7c9"));
            dto.setLowLimitQty(data2.get("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9"));
            dto.setIcountry(data2.get("\uc6d0\uc0b0\uc9c0*"));
            dto.setOrigin(data2.get("G\ub9c8\ucf13,\uc625\uc158 \uc6d0\uc0b0\uc9c0 \uc720\ud615"));
            dto.setMaker(data2.get("\uc218\uc785\uc0ac"));
            List<String> imgList = Arrays.asList(data2.get("\ubaa9\ub85d \uc774\ubbf8\uc9c0*"), data2.get("\uc774\ubbf8\uc9c01(\ub300\ud45c/\uae30\ubcf8\uc774\ubbf8\uc9c0)*"), data2.get("\uc774\ubbf8\uc9c02"), data2.get("\uc774\ubbf8\uc9c03"), data2.get("\uc774\ubbf8\uc9c04"), data2.get("\uc774\ubbf8\uc9c05"));
            String[] imgArray = imgList.toArray(new String[0]);
            dto.setImg(imgArray);
            dto.setContent(data2.get("\uc0c1\uc138\uc124\uba85*"));
            dto.setEsm_auction(data2.get("ESM \ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc124\uba85"));
            dto.setEsm_auction(data2.get("ESM \uad11\uace0\ud64d\ubcf4 \uc0c1\uc138\uc124\uba85"));
            dto.setSelect_option(data2.get("\uc120\ud0dd\uc0ac\ud56d \ud0c0\uc785"));
            dto.setSelect_option_name(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc635\uc158\uba85"));
            dto.setSelect_option_config(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc0c1\uc138\uc815\ubcf4"));
            dto.setSelect_option_use(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc7ac\uace0 \uc0ac\uc6a9\uc5ec\ubd80"));
            dto.setText_option(data2.get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d"));
            dto.setText_option_name(data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85"));
            dto.setText_option_config(data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4"));
            dto.setBrand(data2.get("\ube0c\ub79c\ub4dc"));
            dto.setModel(data2.get("\ubaa8\ub378\uba85"));
            dto.setMaker(data2.get("\uc81c\uc870\uc0ac"));
            if (data2.get("\uacfc\uc138\uc5ec\ubd80") == null || data2.get("\uacfc\uc138\uc5ec\ubd80").isEmpty()) continue;
            dto.setTax(data2.get("\uacfc\uc138\uc5ec\ubd80").equals("\uacfc\uc138") ? "0" : "1");
            dto.setAdult(data2.get("\ub098\uc774\uc81c\ud55c"));
            dto.setMake_datetime(data2.get("\uc81c\uc870\uc77c\uc790"));
            dto.setUse_datetime(data2.get("\uc720\ud6a8\uc77c\uc790"));
            dto.setHongbo(data2.get("\ud64d\ubcf4\ubb38\uad6c"));
            dto.setItype(data2.get("\uc0c1\ud488\uc0c1\ud0dc"));
            dto.setCost(data2.get("\uc6d0\uac00"));
            dto.setPrice_consumer(data2.get("\uacf5\uae09\uac00"));
            dto.setLimit_price(data2.get("\ub3c4\uc11c\uc815\uac00"));
            dto.setIsbn(data2.get("ISBN"));
            dto.setMoonhwa(data2.get("\ubb38\ud654\ube44 \uc18c\ub4dd\uacf5\uc81c"));
            dto.setKeyword(data2.get("\uac80\uc0c9\uc5b4(\ud0dc\uadf8)"));
            dto.setCert(data2.get("\uc778\uc99d\uc815\ubcf4"));
            dto.setGosi_code(data2.get("\uc694\uc57d\uc815\ubcf4 \uc0c1\ud488\uad70 \ucf54\ub4dc*"));
            dto.setGosi1(data2.get("\uac121"));
            dto.setGosi2(data2.get("\uac122"));
            dto.setGosi3(data2.get("\uac123"));
            dto.setGosi4(data2.get("\uac124"));
            dto.setGosi5(data2.get("\uac125"));
            dto.setGosi6(data2.get("\uac126"));
            dto.setGosi7(data2.get("\uac127"));
            dto.setGosi8(data2.get("\uac128"));
            dto.setGosi9(data2.get("\uac129"));
            dto.setGosi10(data2.get("\uac1210"));
            dto.setGosi11(data2.get("\uac1211"));
            dto.setGosi12(data2.get("\uac1212"));
            dto.setGosi13(data2.get("\uac1213"));
            dto.setGosi14(data2.get("\uac1214"));
            dto.setGosi15(data2.get("\uac1215"));
            dto.setGosi16(data2.get("\uac1216"));
            dto.setGosi17(data2.get("\uac1217"));
            dto.setGosi18(data2.get("\uac1218"));
            dto.setGosi19(data2.get("\uac1219"));
            dto.setGosi20(data2.get("\uac1220"));
            dto.setGosi21(data2.get("\uac1221"));
            dto.setGosi22(data2.get("\uac1222"));
            dto.setGosi23(data2.get("\uac1223"));
            dto.setGosi24(data2.get("\uac1224"));
            dto.setGosi25(data2.get("\uac1225"));
            dto.setGosi26(data2.get("\uac1226"));
            dto.setGosi27(data2.get("\uac1227"));
            dto.setGosi28(data2.get("\uac1228"));
            dto.setGosi29(data2.get("\uac1229"));
            dto.setErr_message(data2.get("\uae30\ubcf8\uc815\ubcf4 \uc624\ub958\uba54\uc2dc\uc9c0"));
            String deliveryFee = data2.get("\ubc30\uc1a1\ube44");
            dto.setDelivery_amount(deliveryFee.equals("") ? "0" : deliveryFee);
            dto.setStatus("0");
            if (!categoryInfoCache.containsKey(cateCd)) {
                ShopProductDao.get();
                categoryInfoCache.put(cateCd, ShopProductDao.getCategoryInfo(cateCd));
            }
            if (!fullCategoryNameCache.containsKey(cateCd)) {
                fullCategoryNameCache.put(cateCd, CaffeineCategoryCache.getInstance().getFullCategoryName(cateCd));
            }
            dto.setCategoryInfo((String)categoryInfoCache.get(cateCd));
            dto.setCateg_nm((String)fullCategoryNameCache.get(cateCd));
            dto.seteSellersExcelYN("Y");
            dto.setSearch(shopcd);
            items.add(dto);
        }
        productResult.items = items;
        return productResult;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getTopCategoryCidFromNaverByProductName(String productName, List<NaverCateApiInfoDto> cateInfos) {
        String encodedName = null;
        try {
            encodedName = URLEncoder.encode(productName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\uac80\uc0c9\uc5b4 \uc778\ucf54\ub529 \uc2e4\ud328", e);
        }
        String url = "https://openapi.naver.com/v1/search/shop.json?query=" + encodedName + "&display=1&start=1&sort=sim";
        String body = "";
        boolean success = false;
        while (!success && !cateInfos.isEmpty()) {
            Request request2 = new Request.Builder().url(url).get().addHeader("X-Naver-Client-Id", cateInfos.get(0).getClientID()).addHeader("X-Naver-Client-Secret", cateInfos.get(0).getClientSecret()).build();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    body = response.body().string();
                    if (!response.isSuccessful()) {
                        if (body.contains("\ucd08\uacfc")) {
                            cateInfos.remove(0);
                            continue;
                        }
                        throw new Exception("\uc694\uccad \uc2e4\ud328: " + body);
                    }
                    success = true;
                    JsonObject object = this.parser.parse(body).getAsJsonObject();
                    if (object.get("total").getAsInt() > 0) {
                        JsonArray items = object.get("items").getAsJsonArray();
                        JsonObject item = items.get(0).getAsJsonObject();
                        String category1 = item.get("category1").getAsString();
                        String category2 = item.get("category2").getAsString();
                        String category3 = item.get("category3").getAsString();
                        String category4 = item.get("category4").getAsString();
                        StringJoiner cateJoiner = new StringJoiner(">");
                        if (!category1.isEmpty()) {
                            cateJoiner.add(category1);
                        }
                        if (!category2.isEmpty()) {
                            cateJoiner.add(category2);
                        }
                        if (!category3.isEmpty()) {
                            cateJoiner.add(category3);
                        }
                        if (!category4.isEmpty()) {
                            cateJoiner.add(category4);
                        }
                        String catFullName = cateJoiner.toString();
                        List<List<String>> result = ShoppingMallDao.get().ShopSearchToCategoryKeyword("shop0055", catFullName);
                        if (result.size() > 0) {
                            String catInfo = ShopCommonDao.get().getEsCodeNaver(result.get(0).get(0));
                            String[] splitJson = catInfo.split("[|]");
                            if (splitJson.length > 1) {
                                return splitJson[0];
                            }
                            return "";
                        }
                        return "";
                    }
                    return "";
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public boolean isPaymentCompleted() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date enduse = null;
        try {
            enduse = formatter.parse(YDMASessonUtil.getUserInfo().getEnduse());
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        Date today = new Date();
        String priceType = YDMASessonUtil.getUserInfo().getPricetype();
        return today.before(enduse) && this.isPriceType(priceType);
    }

    private boolean isPriceType(String priceType) {
        return priceType.equals("1") || priceType.equals("2") || priceType.equals("3") || priceType.equals("4") || priceType.equals("5") || priceType.equals("6");
    }

    public void mlinkFreeInfo(Shell shell) {
        MlinkFreeInfomationDialog d = new MlinkFreeInfomationDialog(shell);
        d.open();
    }

    private static final class CategoryDomesin {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="data")
        public CategoryItemDomesin[] data;

        private CategoryDomesin() {
        }
    }

    private static final class CategoryItemDomesin {
        public String cid;
        public String name;
        public String deep;
        public String parent_cid;
        public String ca_qty;
        public String fullcat;
        public String ec;

        private CategoryItemDomesin() {
        }

        public String toString() {
            return "CategoryItemDomesin [cid=" + this.cid + ", name=" + this.name + ", deep=" + this.deep + ", parent_cid=" + this.parent_cid + ", ca_qty=" + this.ca_qty + ", fullcat=" + this.fullcat + ", ec=" + this.ec + "]";
        }
    }

    public static class ImageArray {
        public List<String> img;
    }

    public static class Products {
        List<Item> products = new ArrayList<Item>();

        public static class Item {
            int quantity;
            String itemKey;
            List<String> optionAttributes = new ArrayList<String>();
            List<String> additionalAttributes = new ArrayList<String>();
        }
    }
}

