/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.kdjsystem.mlink.shop.dao.EnvironmentBackupDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;

public class MLinkDBBackupDao {
    public static MLinkDBBackupDao instance = new MLinkDBBackupDao();

    private MLinkDBBackupDao() {
    }

    public static MLinkDBBackupDao get() {
        return instance;
    }

    public EnvironmentBackupDto getBackupCnt(EnvironmentBackupDto tab) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(*) FROM " + tab.getTname();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        tab.setCnt(result);
        return tab;
    }

    public EnvironmentBackupDto getBackupSQL(EnvironmentBackupDto tab) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> columnNameSel = new ArrayList<String>();
        ArrayList<String> columnNameIns = new ArrayList<String>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT * FROM " + tab.getTname();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                ResultSetMetaData metadata = rs.getMetaData();
                int columnCount = metadata.getColumnCount();
                int i = 1;
                while (i <= columnCount) {
                    columnNameSel.add("'" + metadata.getColumnName(i).toLowerCase() + "'," + metadata.getColumnName(i));
                    columnNameIns.add(metadata.getColumnName(i));
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        tab.setSelsql(columnNameSel.stream().collect(Collectors.joining(",")));
        tab.setInssql(columnNameIns.stream().collect(Collectors.joining(",")));
        return tab;
    }

    public EnvironmentBackupDto getBackupPrimaryKeys(EnvironmentBackupDto tab) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> pkColumnSet = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                rs = connection.getMetaData().getPrimaryKeys(null, connection.getSchema(), tab.getTname());
                while (rs.next()) {
                    String pkColumnName = rs.getString("COLUMN_NAME");
                    pkColumnSet.add(pkColumnName);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        String[] columns = tab.getInssql().split(",");
        ArrayList<String> columnName = new ArrayList<String>(Arrays.asList(columns));
        for (String colnm : columnName) {
            if (pkColumnSet.stream().anyMatch(s -> s.startsWith(colnm))) continue;
            result.add(colnm);
        }
        tab.setOrgcolums(String.valueOf(result.stream().collect(Collectors.joining("=?,"))) + "=?");
        return tab;
    }

    public String getEnvironmentBackup(int s, EnvironmentBackupDto tab) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                ArrayList<String> lstSelect = new ArrayList<String>();
                lstSelect.add("SELECT JSON_ARRAYAGG(JSON_OBJECT(\n");
                lstSelect.add(tab.getSelsql());
                lstSelect.add(")) FROM " + tab.getTname().toUpperCase() + "  limit ?, 1000");
                String str_select = lstSelect.stream().collect(Collectors.joining());
                pstmt = connection.prepareStatement(str_select);
                pstmt.setInt(1, s);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getString(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getRestoreCreateSQL(EnvironmentBackupDto tab) throws Exception {
        ArrayList<String> lstSelect = new ArrayList<String>();
        int colLst = tab.getInssql().split(",").length;
        String repeated = String.join((CharSequence)"", Collections.nCopies(colLst, "?,"));
        repeated = repeated.substring(0, repeated.length() - 1);
        lstSelect.add("INSERT INTO " + tab.getTname() + " (" + tab.getInssql() + ") \n");
        lstSelect.add("values(" + repeated + ") \n");
        lstSelect.add("ON DUPLICATE KEY UPDATE " + tab.getOrgcolums());
        String result = lstSelect.stream().collect(Collectors.joining());
        return result;
    }

    public void setSystemConfRestore(String sql, ShopPreferencesDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, dto.getCompno());
                pstmt.setString(++rowIdx, dto.getSuggprocnt());
                pstmt.setString(++rowIdx, dto.getOrdperiod());
                pstmt.setString(++rowIdx, dto.getOrdstatus());
                pstmt.setString(++rowIdx, dto.getOrdimptper());
                pstmt.setString(++rowIdx, dto.getProdmng());
                pstmt.setString(++rowIdx, dto.getProdlink());
                pstmt.setString(++rowIdx, dto.getProdfail());
                pstmt.setString(++rowIdx, dto.getExcepkeywdyn());
                pstmt.setString(++rowIdx, dto.getExcepkeywd());
                pstmt.setString(++rowIdx, dto.getProdnm_lenmngyn());
                pstmt.setString(++rowIdx, dto.getStscperiod());
                pstmt.setString(++rowIdx, dto.getEnddate());
                pstmt.setString(++rowIdx, dto.getDeliverynm());
                pstmt.setString(++rowIdx, dto.getProdsearchyn());
                pstmt.setInt(++rowIdx, dto.getProccnt());
                pstmt.setString(++rowIdx, dto.getDeliverycost());
                pstmt.setString(++rowIdx, dto.getProddup1());
                pstmt.setString(++rowIdx, dto.getProddup2());
                pstmt.setString(++rowIdx, dto.getSuggprocnt());
                pstmt.setString(++rowIdx, dto.getOrdperiod());
                pstmt.setString(++rowIdx, dto.getOrdstatus());
                pstmt.setString(++rowIdx, dto.getOrdimptper());
                pstmt.setString(++rowIdx, dto.getProdmng());
                pstmt.setString(++rowIdx, dto.getProdlink());
                pstmt.setString(++rowIdx, dto.getProdfail());
                pstmt.setString(++rowIdx, dto.getExcepkeywdyn());
                pstmt.setString(++rowIdx, dto.getExcepkeywd());
                pstmt.setString(++rowIdx, dto.getProdnm_lenmngyn());
                pstmt.setString(++rowIdx, dto.getStscperiod());
                pstmt.setString(++rowIdx, dto.getEnddate());
                pstmt.setString(++rowIdx, dto.getDeliverynm());
                pstmt.setString(++rowIdx, dto.getProdsearchyn());
                pstmt.setInt(++rowIdx, dto.getProccnt());
                pstmt.setString(++rowIdx, dto.getDeliverycost());
                pstmt.setString(++rowIdx, dto.getProddup1());
                pstmt.setString(++rowIdx, dto.getProddup2());
                YDMAStringUtil.Print("[setSystemConfRestore]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void setShopDtlRestore(String sql, ShoppingMallDetailDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, dto.getCompno());
                pstmt.setString(++rowIdx, dto.getShopcd());
                pstmt.setString(++rowIdx, dto.getShopseq());
                pstmt.setString(++rowIdx, dto.getShoppingid());
                pstmt.setString(++rowIdx, dto.getPassword());
                pstmt.setString(++rowIdx, dto.getNicknm2());
                pstmt.setString(++rowIdx, dto.getNicknm1());
                pstmt.setString(++rowIdx, dto.getAuthkey1());
                pstmt.setString(++rowIdx, dto.getAuthkey2());
                pstmt.setString(++rowIdx, dto.getOrderexcel1());
                pstmt.setString(++rowIdx, dto.getOrderexcel2());
                pstmt.setString(++rowIdx, dto.getOrderexcel3());
                pstmt.setString(++rowIdx, dto.getApikey());
                pstmt.setString(++rowIdx, dto.getSuppstditem());
                pstmt.setString(++rowIdx, dto.getSuppstdrati());
                pstmt.setString(++rowIdx, dto.getDealtread());
                pstmt.setString(++rowIdx, dto.getShopcompar());
                pstmt.setString(++rowIdx, dto.getEditauthkey1());
                pstmt.setString(++rowIdx, dto.getEditapikey());
                pstmt.setString(++rowIdx, dto.getRegcnt());
                pstmt.setString(++rowIdx, dto.getExcessyn());
                pstmt.setString(++rowIdx, dto.getExcesscnt());
                pstmt.setString(++rowIdx, dto.getShopgrp());
                pstmt.setString(++rowIdx, dto.getCookiekey());
                pstmt.setString(++rowIdx, dto.getCookies());
                pstmt.setString(++rowIdx, dto.getShoppingid());
                pstmt.setString(++rowIdx, dto.getPassword());
                pstmt.setString(++rowIdx, dto.getNicknm2());
                pstmt.setString(++rowIdx, dto.getNicknm1());
                pstmt.setString(++rowIdx, dto.getAuthkey1());
                pstmt.setString(++rowIdx, dto.getAuthkey2());
                pstmt.setString(++rowIdx, dto.getOrderexcel1());
                pstmt.setString(++rowIdx, dto.getOrderexcel2());
                pstmt.setString(++rowIdx, dto.getOrderexcel3());
                pstmt.setString(++rowIdx, dto.getApikey());
                pstmt.setString(++rowIdx, dto.getSuppstditem());
                pstmt.setString(++rowIdx, dto.getSuppstdrati());
                pstmt.setString(++rowIdx, dto.getDealtread());
                pstmt.setString(++rowIdx, dto.getShopcompar());
                pstmt.setString(++rowIdx, dto.getEditauthkey1());
                pstmt.setString(++rowIdx, dto.getEditapikey());
                pstmt.setString(++rowIdx, dto.getRegcnt());
                pstmt.setString(++rowIdx, dto.getExcessyn());
                pstmt.setString(++rowIdx, dto.getExcesscnt());
                pstmt.setString(++rowIdx, dto.getShopgrp());
                pstmt.setString(++rowIdx, dto.getCookiekey());
                pstmt.setString(++rowIdx, dto.getCookies());
                YDMAStringUtil.Print("[setShopDtlRestore]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void setShopDtlDomeRestore(String sql, ShoppingMallDetailDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, dto.getCompno());
                pstmt.setString(++rowIdx, dto.getShopcd());
                pstmt.setString(++rowIdx, dto.getShopseq());
                pstmt.setString(++rowIdx, dto.getShoppingid());
                pstmt.setString(++rowIdx, dto.getPassword());
                pstmt.setString(++rowIdx, dto.getNicknm2());
                pstmt.setString(++rowIdx, dto.getNicknm1());
                pstmt.setString(++rowIdx, dto.getAuthkey1());
                pstmt.setString(++rowIdx, dto.getAuthkey2());
                pstmt.setString(++rowIdx, dto.getOrderexcel1());
                pstmt.setString(++rowIdx, dto.getOrderexcel2());
                pstmt.setString(++rowIdx, dto.getOrderexcel3());
                pstmt.setString(++rowIdx, dto.getApikey());
                pstmt.setString(++rowIdx, dto.getSuppstditem());
                pstmt.setString(++rowIdx, dto.getSuppstdrati());
                pstmt.setString(++rowIdx, dto.getDealtread());
                pstmt.setString(++rowIdx, dto.getShopcompar());
                pstmt.setString(++rowIdx, dto.getEditauthkey1());
                pstmt.setString(++rowIdx, dto.getEditapikey());
                pstmt.setString(++rowIdx, dto.getRegcnt());
                pstmt.setString(++rowIdx, dto.getExcessyn());
                pstmt.setString(++rowIdx, dto.getExcesscnt());
                pstmt.setString(++rowIdx, dto.getShopgrp());
                pstmt.setString(++rowIdx, dto.getCookiekey());
                pstmt.setString(++rowIdx, dto.getCookies());
                pstmt.setString(++rowIdx, dto.getShoppingid());
                pstmt.setString(++rowIdx, dto.getPassword());
                pstmt.setString(++rowIdx, dto.getNicknm2());
                pstmt.setString(++rowIdx, dto.getNicknm1());
                pstmt.setString(++rowIdx, dto.getAuthkey1());
                pstmt.setString(++rowIdx, dto.getAuthkey2());
                pstmt.setString(++rowIdx, dto.getOrderexcel1());
                pstmt.setString(++rowIdx, dto.getOrderexcel2());
                pstmt.setString(++rowIdx, dto.getOrderexcel3());
                pstmt.setString(++rowIdx, dto.getApikey());
                pstmt.setString(++rowIdx, dto.getSuppstditem());
                pstmt.setString(++rowIdx, dto.getSuppstdrati());
                pstmt.setString(++rowIdx, dto.getDealtread());
                pstmt.setString(++rowIdx, dto.getShopcompar());
                pstmt.setString(++rowIdx, dto.getEditauthkey1());
                pstmt.setString(++rowIdx, dto.getEditapikey());
                pstmt.setString(++rowIdx, dto.getRegcnt());
                pstmt.setString(++rowIdx, dto.getExcessyn());
                pstmt.setString(++rowIdx, dto.getExcesscnt());
                pstmt.setString(++rowIdx, dto.getShopgrp());
                pstmt.setString(++rowIdx, dto.getCookiekey());
                pstmt.setString(++rowIdx, dto.getCookies());
                YDMAStringUtil.Print("[setShopDtlDomeRestore]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void setShopMstRestore(String sql, ShoppingMallDetailDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, dto.getCompno());
                pstmt.setString(++rowIdx, dto.getShopcd());
                pstmt.setString(++rowIdx, dto.getDealtrade());
                pstmt.setString(++rowIdx, dto.getIdnum());
                pstmt.setString(++rowIdx, dto.getDealtrade());
                pstmt.setString(++rowIdx, dto.getIdnum());
                YDMAStringUtil.Print("[setShopMstRestore]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void setShopMstDomeRestore(String sql, ShoppingMallDetailDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, dto.getCompno());
                pstmt.setString(++rowIdx, dto.getShopcd());
                pstmt.setString(++rowIdx, dto.getDealtrade());
                pstmt.setString(++rowIdx, dto.getIdnum());
                pstmt.setString(++rowIdx, dto.getDealtrade());
                pstmt.setString(++rowIdx, dto.getIdnum());
                YDMAStringUtil.Print("[setShopMstDomeRestore]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }
}

