/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCateDao;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkOption;
import com.kdjsystem.mlink.shop.mlink.MLinkOptionList;
import com.kdjsystem.mlink.shop.mlink.MLinkSessonUtil;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class MLinkShopDao {
    public static MLinkShopDao instance = new MLinkShopDao();

    private MLinkShopDao() {
    }

    public static MLinkShopDao get() {
        return instance;
    }

    public static String getParentClassCd(String shopcd, String level, String code) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(UPCODE,'') AS UPCODE \r\n");
                sql.append(" FROM DOMECATEG  \r\n");
                sql.append(" WHERE SHOPCD= ? \r\n");
                sql.append(" AND LEVEL = ? \r\n");
                sql.append(" AND CODE = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, level);
                pstmt.setString(3, code);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setUpcode(rs.getString("UPCODE"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getUpcode();
    }

    public static String getCateName(String shopcd, String code) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(NAME,'') AS NAME \r\n");
                sql.append(" FROM DOMECATEG  \r\n");
                sql.append(" WHERE SHOPCD= ? \r\n");
                sql.append(" AND CODE = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, code);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setName(rs.getString("NAME"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getName();
    }

    public static ShopCateDto getNewCategorys(String id) throws Exception {
        ShopCateDto list = new ShopCateDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ID, ifnull(SHOPCATE,'') as SHOPCATE, ifnull(DOMECATG,'') as DOMECATG\r\n\tFROM category WHERE id =?");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            pstmt.setString(1, id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.setId(rs.getString("ID"));
                list.setShopcate(rs.getString("SHOPCATE"));
                list.setDomecatg(rs.getString("DOMECATG"));
            }
            if (list.getId() == null || list.getId().equals("")) {
                ShopCateDto shopCateDto = list;
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                return shopCateDto;
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public static ShopCateDto getNewCategoryOld(Connection connection, String id) throws Exception {
        ShopCateDto list = new ShopCateDto();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ID, ifnull(SHOPCATE,'') as SHOPCATE, ifnull(DOMECATG,'') as DOMECATG FROM CATEGORY  WHERE ID = (SELECT max(ID) FROM CATEGORY_OLD WHERE OLD_ID =?)");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, id);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.setId(rs.getString("ID"));
                    list.setShopcate(rs.getString("SHOPCATE"));
                    list.setDomecatg(rs.getString("DOMECATG"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public static String getNewCategoryFullCateName(String id) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FULL_NAME\r\n\tFROM category WHERE id =?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, id);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setName(rs.getString("FULL_NAME"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getName();
    }

    public static String getFullCateName(String shopcd, String code) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(FULLCAT,'') AS FULLCAT \r\n");
                sql.append(" FROM DOMECATEG  \r\n");
                sql.append(" WHERE SHOPCD= ? \r\n");
                sql.append(" AND CODE = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, code);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setName(rs.getString("FULLCAT"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getName();
    }

    public static void saveCategory(List<ProductItemDto> list, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "INSERT INTO shopcatinf \r\n\t(COMPNO, SHOPCD, SHOPCATNO, SHOPCATNM, SHOPCATSITENM, EBAYCATCD, SHOPSMLCATCD, SERVICEPROD, USE_YN, SHOPGENERAL, SHOPID, INSERTDT) \r\n\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON  DUPLICATE KEY UPDATE  EBAYCATCD=?,  SHOPSMLCATCD=?  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                List shopcateinfos = null;
                shopcateinfos = list.get(0).isModifyMode() ? list.stream().filter(p -> p.isCategoryModify()).map(p -> new ShopCateInfo(p.getCid(), p.getEs_auction(), p.getEs_gmarket(), p.getEs_11st(), p.getEs_interpark(), p.getEs_storefarm(), p.getEsm_auction(), p.getEsm_gmarket(), "", p.getEs_coupang(), p.getCate_depth())).distinct().collect(Collectors.toList()) : list.stream().map(p -> new ShopCateInfo(p.getCid(), p.getEs_auction(), p.getEs_gmarket(), p.getEs_11st(), p.getEs_interpark(), p.getEs_storefarm(), p.getEsm_auction(), p.getEsm_gmarket(), "", p.getEs_coupang(), p.getCate_depth())).distinct().collect(Collectors.toList());
                List<String> shopList = MLinkSessonUtil.ManagerShop;
                for (ShopCateInfo shopcateinf : shopcateinfos) {
                    String class_cd4 = "";
                    String class_cd3 = "";
                    if (shopcateinf.cate_dept.equals("4")) {
                        class_cd4 = shopcateinf.cid;
                        class_cd3 = MLinkShopDao.getParentClassCd(list.get(0).getSearch(), "4", class_cd4);
                    } else {
                        class_cd3 = shopcateinf.cid;
                    }
                    String class_cd2 = MLinkShopDao.getParentClassCd(list.get(0).getSearch(), "3", class_cd3);
                    String class_cd1 = MLinkShopDao.getParentClassCd(list.get(0).getSearch(), "2", class_cd2);
                    String cateName = MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd3);
                    String full_cateName = MLinkShopDao.getFullCateName(list.get(0).getSearch(), class_cd3);
                    MLinkCateDao.get().categoryLargeInsert(class_cd1, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd1), "0", "1", "MLink", "", list.get(0).getSearch());
                    MLinkCateDao.get().categoryMidiumInsert(class_cd1, class_cd2, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd2), "0", "1", "MLink", "", list.get(0).getSearch());
                    MLinkCateDao.get().categorySmallInsert(class_cd2, class_cd3, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd3), "0", "1", "MLink", "", "", list.get(0).getSearch());
                    if (shopcateinf.cate_dept.equals("4")) {
                        MLinkCateDao.get().categoryDetailInsert(class_cd3, class_cd4, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd4), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", list.get(0).getSearch());
                    }
                    for (String shopcd : shopList) {
                        String esm_code = "";
                        String code = "";
                        switch (shopcd) {
                            case "shop0075": {
                                code = shopcateinf.es_coupang;
                                break;
                            }
                            case "shop0004": {
                                code = shopcateinf.es_interpark;
                                break;
                            }
                            case "shop0068": 
                            case "shop00681": {
                                code = shopcateinf.es_gmarket;
                                esm_code = shopcateinf.esm_gmarket;
                                break;
                            }
                            case "shop0067": 
                            case "shop00671": {
                                code = shopcateinf.es_auction;
                                esm_code = shopcateinf.esm_auction;
                                break;
                            }
                            case "shop0055": {
                                code = shopcateinf.es_storefarm;
                                break;
                            }
                            case "shop0003": 
                            case "shop00031": {
                                code = shopcateinf.es_11st;
                            }
                        }
                        if (code.isEmpty()) continue;
                        String seq = shopcateinf.cid;
                        MLinkCateDao.get().setProductMstShopCategoryUpdate(shopcateinf.cid, shopcd, String.valueOf(seq), "3", list.get(0).getSearch());
                        String catenm = shopcd.concat("_").concat(cateName);
                        int i = 0;
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setString(++i, shopcd);
                        pstmt.setString(++i, seq);
                        pstmt.setString(++i, catenm);
                        pstmt.setString(++i, full_cateName);
                        pstmt.setString(++i, esm_code);
                        pstmt.setString(++i, code);
                        pstmt.setString(++i, "\uc77c\ubc18\ubc30\uc1a1\uc0c1\ud488");
                        pstmt.setString(++i, "Y");
                        pstmt.setString(++i, "01");
                        pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++i, esm_code);
                        pstmt.setString(++i, code);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    ++result;
                    ++row;
                    if (workload > 0) {
                        try {
                            monitor.subTask("[\uce74\ud14c\uace0\ub9ac \uc815\ubcf4 \ucc98\ub9ac\uc911..] " + result + " of " + workload + "...");
                            monitor.worked(1);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public String getOptionJson(String optionString) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        List<MLinkOption> options = MLinkCommon.get().getOptionList((String)optionString).options;
        String json = mapper.writeValueAsString(options);
        return json;
    }

    public String getGosiInfoJson(ProductItemDto item) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ShopGosiInfo shopGosiInfo = new ShopGosiInfo();
        shopGosiInfo.setGosi1(item.getGosi1());
        shopGosiInfo.setGosi2(item.getGosi2());
        shopGosiInfo.setGosi3(item.getGosi3());
        shopGosiInfo.setGosi4(item.getGosi4());
        shopGosiInfo.setGosi5(item.getGosi5());
        shopGosiInfo.setGosi6(item.getGosi6());
        shopGosiInfo.setGosi7(item.getGosi7());
        shopGosiInfo.setGosi8(item.getGosi8());
        shopGosiInfo.setGosi9(item.getGosi9());
        shopGosiInfo.setGosi10(item.getGosi10());
        shopGosiInfo.setGosi11(item.getGosi11());
        shopGosiInfo.setGosi12(item.getGosi12());
        shopGosiInfo.setGosi13(item.getGosi13());
        shopGosiInfo.setGosi14(item.getGosi14());
        shopGosiInfo.setGosi15(item.getGosi15());
        shopGosiInfo.setGosi16(item.getGosi16());
        shopGosiInfo.setGosi17(item.getGosi17());
        shopGosiInfo.setGosi18(item.getGosi18());
        shopGosiInfo.setGosi19(item.getGosi19());
        shopGosiInfo.setGosi20(item.getGosi20());
        shopGosiInfo.setGosi21(item.getGosi21());
        shopGosiInfo.setGosi22(item.getGosi22());
        String json = mapper.writeValueAsString((Object)shopGosiInfo);
        return json;
    }

    public static String getCateJson(ProductItemDto item) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        List<String> shopList = MLinkSessonUtil.ManagerShop;
        ArrayList<ShopCateItem> cate_list = new ArrayList<ShopCateItem>();
        for (String shopcd : shopList) {
            ShopCateItem cateItem = new ShopCateItem();
            String esm_gmarket = shopcd.equals("shop00681") ? item.getEsm_gmarket() : "";
            String esm_auction = shopcd.equals("shop00671") ? item.getEsm_auction() : "";
            cateItem.shopcd = shopcd;
            cateItem.esm_gmarket = esm_gmarket;
            cateItem.esm_auction = esm_auction;
            cateItem.cid = MLinkShopDao.getCategoryCd(shopcd, item);
            cate_list.add(cateItem);
        }
        String json = mapper.writeValueAsString(cate_list);
        return json;
    }

    public boolean excelUpdateOrdInfo(List<ProductItemDto> contents) throws Exception {
        boolean ret = false;
        try {
            try {
                excelupdateProdThread op = new excelupdateProdThread(contents);
                new ProgressMonitorDialog(new Shell()).run(true, true, (IRunnableWithProgress)op);
                ret = true;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {}
        return ret;
    }

    public boolean saveOrdInfo(List<ProductItemDto> contents) throws Exception {
        boolean ret = false;
        try {
            try {
                saveProdThread op = new saveProdThread(contents);
                new ProgressMonitorDialog(new Shell()).run(true, true, (IRunnableWithProgress)op);
                ret = true;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {}
        return ret;
    }

    public static String getCategoryCd(String shopcd, ProductItemDto item) {
        switch (shopcd) {
            case "shop0067": 
            case "shop00671": {
                return item.getEs_auction();
            }
            case "shop0068": 
            case "shop00681": {
                return item.getEs_gmarket();
            }
            case "shop0004": {
                return item.getEs_interpark();
            }
            case "shop0055": {
                return item.getEs_storefarm();
            }
            case "shop0003": 
            case "shop00031": {
                return item.getEs_11st();
            }
            case "shop0075": {
                return item.getEs_coupang();
            }
            case "shop0411": {
                return String.valueOf(item.getEs_ssg());
            }
            case "shop0287": {
                return String.valueOf(item.getEs_wemarket());
            }
            case "shop0076": {
                return String.valueOf(item.getEs_tmon());
            }
            case "shop0273": {
                return String.valueOf(item.getEs_kakao());
            }
            case "shop0372": {
                return String.valueOf(item.getEs_lotteon());
            }
            case "shop0106": {
                return String.valueOf(item.getEs_melchi());
            }
        }
        return "";
    }

    public static void saveShopOptProdInfo(List<ProductItemDto> contents, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection2 = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist2 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection2 = DBCPInit.getInstance().getConnection();
                connection2.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("PRODSEQ");
                lstInsert.add("SKUSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("PRODCD");
                lstInsert.add("OPTPRODCD");
                lstInsert.add("OPTPRODNM");
                lstInsert.add("OPTSPECDES");
                lstInsert.add("OPTSAFESTOCK");
                lstInsert.add("OPTVERTSTOCK");
                lstInsert.add("OPTADDAMT");
                lstInsert.add("LIMIT_PRICE");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("PRODCD");
                lstUpdate.add("OPTPRODCD");
                lstUpdate.add("OPTPRODNM");
                lstUpdate.add("OPTSPECDES");
                lstUpdate.add("OPTSAFESTOCK");
                lstUpdate.add("OPTVERTSTOCK");
                lstUpdate.add("OPTADDAMT");
                lstUpdate.add("LIMIT_PRICE");
                lstUpdate.add("MODIFYDT");
                lstUpdate.add("MODIFYID");
                String sql2 = MLinkShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shop_optprodinfo");
                sql2 = sql2.toUpperCase();
                pstmt2 = connection2.prepareStatement(sql2);
                statementlist2.add(pstmt2);
                String sql = "SELECT prodseq  FROM shopprodinfo where compno = ? and compayny_goods_cd=? ";
                sql = sql.toUpperCase();
                pstmt = connection2.prepareStatement(sql);
                for (ProductItemDto list : contents) {
                    if (list.isModifyMode() && !list.isOptionModify()) continue;
                    YDMAStringUtil.Print();
                    String optionString = list.getSelect_option();
                    int prodseq = 0;
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.getIcode());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        prodseq = rs.getInt(1);
                    }
                    if (optionString.isEmpty()) continue;
                    YDMAStringUtil.Print();
                    List<MLinkOption> options = MLinkCommon.get().getOptionList((String)optionString).options;
                    int i = 1;
                    for (MLinkOption option2 : options) {
                        int rowIdx2 = 0;
                        pstmt2.setInt(++rowIdx2, prodseq);
                        pstmt2.setInt(++rowIdx2, i);
                        pstmt2.setString(++rowIdx2, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt2.setString(++rowIdx2, list.getIcode());
                        String optrprodcd = list.getIcode().concat("-").concat(YDMAStringUtil.leftPad(String.valueOf(i), 2, "0"));
                        pstmt2.setString(++rowIdx2, optrprodcd);
                        pstmt2.setString(++rowIdx2, option2.getOptionName1());
                        pstmt2.setString(++rowIdx2, !option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "" : ":" + option2.getOptionName2()) : "");
                        int cnt = option2.getSoldOut() == 0 ? 999 : 0;
                        pstmt2.setInt(++rowIdx2, cnt);
                        pstmt2.setInt(++rowIdx2, cnt);
                        int price2 = option2.getOptionPrice() - YDMAStringUtil.convertToInt(list.getPrice());
                        pstmt2.setInt(++rowIdx2, price2);
                        pstmt2.setInt(++rowIdx2, option2.getCompliancePrice());
                        pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt2.setString(++rowIdx2, list.getIcode());
                        pstmt2.setString(++rowIdx2, optrprodcd);
                        pstmt2.setString(++rowIdx2, option2.getOptionName1());
                        pstmt2.setString(++rowIdx2, !option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "" : ":" + option2.getOptionName2()) : "");
                        pstmt2.setInt(++rowIdx2, cnt);
                        pstmt2.setInt(++rowIdx2, cnt);
                        pstmt2.setInt(++rowIdx2, price2);
                        pstmt2.setInt(++rowIdx2, option2.getCompliancePrice());
                        pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt2.addBatch();
                        pstmt2.clearParameters();
                        ++i;
                        ++row;
                    }
                    if (++result > 1 && result % 1000 == 0) {
                        pstmt2.executeBatch();
                        connection2.setAutoCommit(true);
                        pstmt2.clearBatch();
                        connection2.setAutoCommit(false);
                        row = 0;
                    }
                    if (workload <= 0) continue;
                    try {
                        monitor.subTask("[\uc635\uc158\uc815\ubcf4 \ucc98\ub9ac\uc911..]  " + result + " of " + workload + "...");
                        monitor.worked(1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (row > 0) {
                    YDMAStringUtil.Print(pstmt2.toString());
                    pstmt2.executeBatch();
                    connection2.setAutoCommit(true);
                    pstmt2.clearBatch();
                }
            }
            catch (Exception ex) {
                connection2.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection2, statementlist2, rs);
        }
    }

    public static String getInsertOrUpdateQueryMapper(List<String> lstInsert, List<String> lstUpdate, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("INSERT INTO %s ", tableName));
        String head = lstInsert.stream().collect(Collectors.joining(",", "(", ") "));
        String bottom = lstInsert.stream().map(p -> String.valueOf("?")).collect(Collectors.joining(",", " VALUES (", ") "));
        sb_result.append(head);
        sb_result.append(bottom);
        if (lstUpdate != null) {
            sb_result.append("\r\n ON DUPLICATE KEY  UPDATE \r\n");
            String str_update = lstUpdate.stream().map(p -> p.concat(" = ?")).collect(Collectors.joining(","));
            sb_result.append(str_update);
        }
        return sb_result.toString();
    }

    public static int saveShopProdInfo(List<ProductItemDto> contents, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String compno = YDMASessonUtil.getUserInfo().getCompno();
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                new StringBuilder();
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("COMPNO");
                lstInsert.add("GOODS_NM");
                lstInsert.add("GOODS_KEYWORD");
                lstInsert.add("MODEL_NM");
                lstInsert.add("BRAND_NM");
                lstInsert.add("COMPAYNY_GOODS_CD");
                lstInsert.add("PARTNER_ID");
                lstInsert.add("GOODS_SEARCH");
                lstInsert.add("SHOP_CID_INFO");
                lstInsert.add("SELECT_OPTION");
                lstInsert.add("TEXT_OPTION");
                lstInsert.add("CLASS_CD1");
                lstInsert.add("CLASS_CD2");
                lstInsert.add("CLASS_CD3");
                lstInsert.add("CLASS_CD4");
                lstInsert.add("MAKER");
                lstInsert.add("ORIGIN");
                lstInsert.add("STATUS");
                lstInsert.add("TAX_YN");
                lstInsert.add("DELV_TYPE");
                lstInsert.add("DELV_COST");
                lstInsert.add("GOODS_COST");
                lstInsert.add("GOODS_PRICE");
                lstInsert.add("GOODS_CONSUMER_PRICE");
                lstInsert.add("ISLIMIT");
                lstInsert.add("LIMIT_PRICE");
                lstInsert.add("IS_OVERSEAS");
                lstInsert.add("ADULT");
                lstInsert.add("ISRETURN");
                lstInsert.add("ITYPE");
                lstInsert.add("CHAR_1_NM");
                lstInsert.add("CHAR_2_NM");
                lstInsert.add("CHAR_2_VAL");
                lstInsert.add("IMG_PATH");
                lstInsert.add("IMG_PATH1");
                lstInsert.add("IMG_PATH2");
                lstInsert.add("IMG_PATH3");
                lstInsert.add("IMG_PATH4");
                lstInsert.add("IMG_PATH5");
                lstInsert.add("IMG_PATH6");
                lstInsert.add("IMG_PATH7");
                lstInsert.add("IMG_PATH8");
                lstInsert.add("IMG_PATH9");
                lstInsert.add("GOODS_REMARKS");
                lstInsert.add("CERT_TYPE");
                lstInsert.add("CERT");
                lstInsert.add("CERTNO");
                lstInsert.add("STOCK_USE_YN");
                lstInsert.add("OPT_TYPE");
                lstInsert.add("PROP_EDIT_YN");
                lstInsert.add("PROP1_CD");
                lstInsert.add("PROP_VAL1");
                lstInsert.add("PROP_VAL2");
                lstInsert.add("PROP_VAL3");
                lstInsert.add("PROP_VAL4");
                lstInsert.add("PROP_VAL5");
                lstInsert.add("PROP_VAL6");
                lstInsert.add("PROP_VAL7");
                lstInsert.add("PROP_VAL8");
                lstInsert.add("PROP_VAL9");
                lstInsert.add("PROP_VAL10");
                lstInsert.add("PROP_VAL11");
                lstInsert.add("PROP_VAL12");
                lstInsert.add("PROP_VAL13");
                lstInsert.add("PROP_VAL14");
                lstInsert.add("PROP_VAL15");
                lstInsert.add("PROP_VAL16");
                lstInsert.add("PROP_VAL17");
                lstInsert.add("PROP_VAL18");
                lstInsert.add("PROP_VAL19");
                lstInsert.add("PROP_VAL20");
                lstInsert.add("PROP_VAL21");
                lstInsert.add("PROP_VAL22");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                lstInsert.add("ShopSendStatus");
                lstInsert.add("ShopModifyContent");
                lstInsert.add("GMCATEGNM");
                lstInsert.add("DELV_QTY");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("GOODS_NM");
                lstUpdate.add("MODEL_NM");
                lstUpdate.add("GOODS_KEYWORD");
                lstUpdate.add("BRAND_NM");
                lstUpdate.add("COMPAYNY_GOODS_CD");
                lstUpdate.add("GOODS_SEARCH");
                lstUpdate.add("SHOP_CID_INFO");
                lstUpdate.add("SELECT_OPTION");
                lstUpdate.add("TEXT_OPTION");
                lstUpdate.add("CLASS_CD1");
                lstUpdate.add("CLASS_CD2");
                lstUpdate.add("CLASS_CD3");
                lstUpdate.add("CLASS_CD4");
                lstUpdate.add("MAKER");
                lstUpdate.add("ORIGIN");
                lstUpdate.add("STATUS");
                lstUpdate.add("TAX_YN");
                lstUpdate.add("DELV_TYPE");
                lstUpdate.add("DELV_COST");
                lstUpdate.add("GOODS_COST");
                lstUpdate.add("GOODS_PRICE");
                lstUpdate.add("GOODS_CONSUMER_PRICE");
                lstUpdate.add("ISLIMIT");
                lstUpdate.add("LIMIT_PRICE");
                lstUpdate.add("IS_OVERSEAS");
                lstUpdate.add("ADULT");
                lstUpdate.add("ISRETURN");
                lstUpdate.add("ITYPE");
                lstUpdate.add("CHAR_1_NM");
                lstUpdate.add("CHAR_2_NM");
                lstUpdate.add("CHAR_2_VAL");
                lstUpdate.add("IMG_PATH");
                lstUpdate.add("IMG_PATH1");
                lstUpdate.add("IMG_PATH2");
                lstUpdate.add("IMG_PATH3");
                lstUpdate.add("IMG_PATH4");
                lstUpdate.add("IMG_PATH5");
                lstUpdate.add("IMG_PATH6");
                lstUpdate.add("IMG_PATH7");
                lstUpdate.add("IMG_PATH8");
                lstUpdate.add("IMG_PATH9");
                lstUpdate.add("GOODS_REMARKS");
                lstUpdate.add("CERT_TYPE");
                lstUpdate.add("CERT");
                lstUpdate.add("CERTNO");
                lstUpdate.add("STOCK_USE_YN");
                lstUpdate.add("OPT_TYPE");
                lstUpdate.add("PROP_EDIT_YN");
                lstUpdate.add("PROP1_CD");
                lstUpdate.add("PROP_VAL1");
                lstUpdate.add("PROP_VAL2");
                lstUpdate.add("PROP_VAL3");
                lstUpdate.add("PROP_VAL4");
                lstUpdate.add("PROP_VAL5");
                lstUpdate.add("PROP_VAL6");
                lstUpdate.add("PROP_VAL7");
                lstUpdate.add("PROP_VAL8");
                lstUpdate.add("PROP_VAL9");
                lstUpdate.add("PROP_VAL10");
                lstUpdate.add("PROP_VAL11");
                lstUpdate.add("PROP_VAL12");
                lstUpdate.add("PROP_VAL13");
                lstUpdate.add("PROP_VAL14");
                lstUpdate.add("PROP_VAL15");
                lstUpdate.add("PROP_VAL16");
                lstUpdate.add("PROP_VAL17");
                lstUpdate.add("PROP_VAL18");
                lstUpdate.add("PROP_VAL19");
                lstUpdate.add("PROP_VAL20");
                lstUpdate.add("PROP_VAL21");
                lstUpdate.add("PROP_VAL22");
                if (workload > 0) {
                    lstUpdate.add("INSERTDT");
                    lstUpdate.add("INSERTID");
                } else {
                    lstUpdate.add("MODIFYDT");
                    lstUpdate.add("MODIFYID");
                }
                lstUpdate.add("ShopSendStatus");
                lstUpdate.add("ShopModifyContent");
                lstUpdate.add("GMCATEGNM");
                lstUpdate.add("DELV_QTY");
                String sql = MLinkShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shopprodinfo");
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductItemDto list : contents) {
                    int rowIdx = 0;
                    if (list.isModifyMode() && !list.isBaseInfoModify()) continue;
                    String cate_json = MLinkShopDao.getCateJson(list);
                    String select_option = list.getSelect_option();
                    String class_cd4 = "";
                    String class_cd3 = "";
                    if (list.getCate_depth().equals("4")) {
                        class_cd4 = list.getCid();
                        class_cd3 = MLinkShopDao.getParentClassCd(list.getSearch(), "4", class_cd4);
                    } else {
                        class_cd3 = list.getCid();
                    }
                    String class_cd2 = MLinkShopDao.getParentClassCd(list.getSearch(), "3", class_cd3);
                    String class_cd1 = MLinkShopDao.getParentClassCd(list.getSearch(), "2", class_cd2);
                    pstmt.setString(++rowIdx, compno);
                    pstmt.setString(++rowIdx, YDMAStringUtil.setTextStrtok(list.getIname(), 100));
                    pstmt.setString(++rowIdx, list.getSearch());
                    pstmt.setString(++rowIdx, list.getIcode());
                    pstmt.setString(++rowIdx, list.getBrand());
                    pstmt.setString(++rowIdx, list.getIcode());
                    pstmt.setString(++rowIdx, list.getVender_code());
                    pstmt.setString(++rowIdx, list.getKeyword());
                    pstmt.setString(++rowIdx, cate_json);
                    pstmt.setString(++rowIdx, select_option);
                    pstmt.setString(++rowIdx, list.getText_option());
                    pstmt.setString(++rowIdx, class_cd1);
                    pstmt.setString(++rowIdx, class_cd2);
                    pstmt.setString(++rowIdx, class_cd3);
                    pstmt.setString(++rowIdx, class_cd4);
                    pstmt.setString(++rowIdx, list.getMaker());
                    pstmt.setString(++rowIdx, list.getIcountry());
                    pstmt.setString(++rowIdx, list.getStatus());
                    pstmt.setString(++rowIdx, list.getTax());
                    pstmt.setString(++rowIdx, list.getDelivery_type());
                    pstmt.setString(++rowIdx, list.getDelivery_amount());
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice_consumer()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIslimit()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getLimit_price()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIs_overseas()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getAdult()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIsreturn()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getItype()));
                    MLinkOptionList options = MLinkCommon.get().getOptionList(list.getSelect_option());
                    String option2 = options.getChar_1_nm().isEmpty() ? "\ub2e8\ud488" : options.getChar_1_nm();
                    pstmt.setString(++rowIdx, option2);
                    pstmt.setString(++rowIdx, options.getChar_2_nm());
                    pstmt.setString(++rowIdx, options.getChar_2_val());
                    ArrayList<String> imgs = new ArrayList<String>();
                    int i = 0;
                    while (i < 10) {
                        if (i > list.getImg().length - 1) {
                            imgs.add("");
                        } else {
                            imgs.add(list.getImg()[i]);
                        }
                        ++i;
                    }
                    for (String img : imgs) {
                        pstmt.setString(++rowIdx, img);
                    }
                    String content = list.getContent().replaceAll("\"", "'");
                    content = content.replaceAll("\\\\", "");
                    pstmt.setString(++rowIdx, content);
                    pstmt.setString(++rowIdx, list.getCert_type());
                    pstmt.setString(++rowIdx, list.getCert());
                    pstmt.setString(++rowIdx, list.getCert_no());
                    pstmt.setString(++rowIdx, "N");
                    pstmt.setString(++rowIdx, "9");
                    pstmt.setString(++rowIdx, "Y");
                    pstmt.setString(++rowIdx, "0" + list.getGosi_code());
                    pstmt.setString(++rowIdx, list.getGosi1());
                    pstmt.setString(++rowIdx, list.getGosi2());
                    pstmt.setString(++rowIdx, list.getGosi3());
                    pstmt.setString(++rowIdx, list.getGosi4());
                    pstmt.setString(++rowIdx, list.getGosi5());
                    pstmt.setString(++rowIdx, list.getGosi6());
                    pstmt.setString(++rowIdx, list.getGosi7());
                    pstmt.setString(++rowIdx, list.getGosi8());
                    pstmt.setString(++rowIdx, list.getGosi9());
                    pstmt.setString(++rowIdx, list.getGosi10());
                    pstmt.setString(++rowIdx, list.getGosi11());
                    pstmt.setString(++rowIdx, list.getGosi12());
                    pstmt.setString(++rowIdx, list.getGosi13());
                    pstmt.setString(++rowIdx, list.getGosi14());
                    pstmt.setString(++rowIdx, list.getGosi15());
                    pstmt.setString(++rowIdx, list.getGosi16());
                    pstmt.setString(++rowIdx, list.getGosi17());
                    pstmt.setString(++rowIdx, list.getGosi18());
                    pstmt.setString(++rowIdx, list.getGosi19());
                    pstmt.setString(++rowIdx, list.getGosi20());
                    pstmt.setString(++rowIdx, list.getGosi21());
                    pstmt.setString(++rowIdx, list.getGosi22());
                    pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setInt(++rowIdx, list.getShopSendStatus());
                    String modifyContent = list.getChange_list();
                    pstmt.setString(++rowIdx, modifyContent);
                    pstmt.setString(++rowIdx, list.getPa_gmarket());
                    pstmt.setString(++rowIdx, list.getDelivery_qty());
                    String[] chgitems = MLinkShopDao.isShopProductInfoExits(compno, list.getIcode());
                    if (chgitems[0] != null && chgitems[0].contains("2")) {
                        pstmt.setString(++rowIdx, chgitems[5]);
                    } else {
                        pstmt.setString(++rowIdx, YDMAStringUtil.setTextStrtok(list.getIname(), 100));
                    }
                    pstmt.setString(++rowIdx, list.getIcode());
                    pstmt.setString(++rowIdx, list.getSearch());
                    pstmt.setString(++rowIdx, list.getBrand());
                    pstmt.setString(++rowIdx, list.getIcode());
                    if (chgitems[0] != null && chgitems[0].contains("3")) {
                        pstmt.setString(++rowIdx, chgitems[6]);
                    } else {
                        pstmt.setString(++rowIdx, list.getKeyword());
                    }
                    pstmt.setString(++rowIdx, cate_json);
                    pstmt.setString(++rowIdx, select_option);
                    pstmt.setString(++rowIdx, list.getText_option());
                    if (chgitems[0] != null && chgitems[0].contains("1")) {
                        pstmt.setString(++rowIdx, chgitems[1]);
                        pstmt.setString(++rowIdx, chgitems[2]);
                        pstmt.setString(++rowIdx, chgitems[3]);
                        pstmt.setString(++rowIdx, chgitems[4]);
                    } else {
                        pstmt.setString(++rowIdx, class_cd1);
                        pstmt.setString(++rowIdx, class_cd2);
                        pstmt.setString(++rowIdx, class_cd3);
                        pstmt.setString(++rowIdx, class_cd4);
                    }
                    pstmt.setString(++rowIdx, list.getMaker());
                    pstmt.setString(++rowIdx, list.getIcountry());
                    pstmt.setString(++rowIdx, list.getStatus());
                    pstmt.setString(++rowIdx, list.getTax().equals("0") ? "1" : "2");
                    pstmt.setString(++rowIdx, list.getDelivery_type());
                    pstmt.setString(++rowIdx, list.getDelivery_amount());
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice_consumer()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIslimit()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getLimit_price()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIs_overseas()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getAdult()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIsreturn()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getItype()));
                    pstmt.setString(++rowIdx, option2);
                    pstmt.setString(++rowIdx, options.getChar_2_nm());
                    pstmt.setString(++rowIdx, options.getChar_2_val());
                    for (String img : imgs) {
                        pstmt.setString(++rowIdx, img);
                    }
                    pstmt.setString(++rowIdx, content);
                    pstmt.setString(++rowIdx, list.getCert_type());
                    pstmt.setString(++rowIdx, list.getCert());
                    pstmt.setString(++rowIdx, list.getCert_no());
                    pstmt.setString(++rowIdx, "N");
                    pstmt.setString(++rowIdx, "9");
                    pstmt.setString(++rowIdx, "Y");
                    pstmt.setString(++rowIdx, "0" + list.getGosi_code());
                    pstmt.setString(++rowIdx, list.getGosi1());
                    pstmt.setString(++rowIdx, list.getGosi2());
                    pstmt.setString(++rowIdx, list.getGosi3());
                    pstmt.setString(++rowIdx, list.getGosi4());
                    pstmt.setString(++rowIdx, list.getGosi5());
                    pstmt.setString(++rowIdx, list.getGosi6());
                    pstmt.setString(++rowIdx, list.getGosi7());
                    pstmt.setString(++rowIdx, list.getGosi8());
                    pstmt.setString(++rowIdx, list.getGosi9());
                    pstmt.setString(++rowIdx, list.getGosi10());
                    pstmt.setString(++rowIdx, list.getGosi11());
                    pstmt.setString(++rowIdx, list.getGosi12());
                    pstmt.setString(++rowIdx, list.getGosi13());
                    pstmt.setString(++rowIdx, list.getGosi14());
                    pstmt.setString(++rowIdx, list.getGosi15());
                    pstmt.setString(++rowIdx, list.getGosi16());
                    pstmt.setString(++rowIdx, list.getGosi17());
                    pstmt.setString(++rowIdx, list.getGosi18());
                    pstmt.setString(++rowIdx, list.getGosi19());
                    pstmt.setString(++rowIdx, list.getGosi20());
                    pstmt.setString(++rowIdx, list.getGosi21());
                    pstmt.setString(++rowIdx, list.getGosi22());
                    pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    if (chgitems[0] != null && chgitems[0].length() > 0) {
                        pstmt.setInt(++rowIdx, 6100);
                    } else {
                        pstmt.setInt(++rowIdx, list.getShopSendStatus());
                    }
                    pstmt.setString(++rowIdx, modifyContent);
                    pstmt.setString(++rowIdx, list.getPa_gmarket());
                    pstmt.setString(++rowIdx, list.getDelivery_qty());
                    ++result;
                    ++row;
                    if (workload > 0) {
                        try {
                            monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \ucc98\ub9ac\uc911..] " + list.getIcode() + " " + result + " of " + workload + "...");
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                monitor.done();
                                break;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    YDMAStringUtil.Print("[insert shopprodinfo]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public List<ShopOrderMstDto> getNaverDeliveryCode(List<ShopOrderMstDto> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(URL,'') from expressdeliverys where CODE = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, list.get(0).getDelvcode());
                YDMAStringUtil.Print("[getCategorySearchList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.get(0).setDelvurl(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setShopProductInUpdate(List<ShopProductDto> parentList) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodin set \r\n");
                sql.append("CLASS_CD1 = ? ,\r\n ");
                sql.append("CLASS_CD2 = ? ,\r\n ");
                sql.append("CLASS_CD3 = ? ,\r\n ");
                sql.append("CLASS_CD4 = ? ,\r\n ");
                sql.append("GOODS_NM = ? ,\r\n ");
                sql.append("GOODS_SEARCH = ? ,\r\n ");
                sql.append("MODEL_NM = ? ,\r\n ");
                sql.append("BRAND_NM = ? ,\r\n ");
                sql.append("SELECT_OPTION = ? ,\r\n ");
                sql.append("TEXT_OPTION = ? ,\r\n ");
                sql.append("GOODS_COST = ? ,\r\n ");
                sql.append("ISLIMIT = ? ,\r\n ");
                sql.append("LIMIT_PRICE = ? ,\r\n ");
                sql.append("IS_OVERSEAS = ? ,\r\n ");
                sql.append("ADULT = ? ,\r\n ");
                sql.append("ISRETURN = ? ,\r\n ");
                sql.append("ITYPE = ? ,\r\n ");
                sql.append("CHAR_1_NM = ? ,\r\n ");
                sql.append("CHAR_2_NM = ? ,\r\n ");
                sql.append("CHAR_2_VAL = ? ,\r\n ");
                sql.append("CERT_TYPE = ? ,\r\n ");
                sql.append("CERT = ? ,\r\n ");
                sql.append("CERTNO = ? ,\r\n ");
                sql.append("STOCK_USE_YN = ? ,\r\n ");
                sql.append("OPT_TYPE = ? ,\r\n ");
                sql.append("PROP_EDIT_YN = ? ,\r\n ");
                sql.append("MAKER = ? ,\r\n ");
                sql.append("ORIGIN = ? ,\r\n ");
                sql.append("STATUS = ? ,\r\n ");
                sql.append("TAX_YN = ? ,\r\n ");
                sql.append("DELV_TYPE = ? ,\r\n ");
                sql.append("DELV_COST = ? ,\r\n ");
                sql.append("GOODS_PRICE = ? ,\r\n ");
                sql.append("GOODS_CONSUMER_PRICE = ? ,\r\n ");
                sql.append("IMG_PATH = ? ,\r\n ");
                sql.append("IMG_PATH1 = ? ,\r\n ");
                sql.append("IMG_PATH2 = ? ,\r\n ");
                sql.append("IMG_PATH3 = ? ,\r\n ");
                sql.append("IMG_PATH4 = ? ,\r\n ");
                sql.append("IMG_PATH5 = ? ,\r\n ");
                sql.append("IMG_PATH6 = ? ,\r\n ");
                sql.append("IMG_PATH7 = ? ,\r\n ");
                sql.append("IMG_PATH8 = ? ,\r\n ");
                sql.append("IMG_PATH9 = ? ,\r\n ");
                sql.append("GOODS_REMARKS = ? ,\r\n ");
                sql.append("PROP1_CD = ? ,\r\n ");
                sql.append("PROP_VAL1 = ? ,\r\n ");
                sql.append("PROP_VAL2 = ? ,\r\n ");
                sql.append("PROP_VAL3 = ? ,\r\n ");
                sql.append("PROP_VAL4 = ? ,\r\n ");
                sql.append("PROP_VAL5 = ? ,\r\n ");
                sql.append("PROP_VAL6 = ? ,\r\n ");
                sql.append("PROP_VAL7 = ? ,\r\n ");
                sql.append("PROP_VAL8 = ? ,\r\n ");
                sql.append("PROP_VAL9 = ? ,\r\n ");
                sql.append("PROP_VAL10 = ? ,\r\n ");
                sql.append("PROP_VAL11 = ? ,\r\n ");
                sql.append("PROP_VAL12 = ? ,\r\n ");
                sql.append("PROP_VAL13 = ? ,\r\n ");
                sql.append("PROP_VAL14 = ? ,\r\n ");
                sql.append("PROP_VAL15 = ? ,\r\n ");
                sql.append("PROP_VAL16 = ? ,\r\n ");
                sql.append("PROP_VAL17 = ? ,\r\n ");
                sql.append("PROP_VAL18 = ? ,\r\n ");
                sql.append("PROP_VAL19 = ? ,\r\n ");
                sql.append("PROP_VAL20 = ? ,\r\n ");
                sql.append("PROP_VAL21 = ? ,\r\n ");
                sql.append("PROP_VAL22 = ? ,\r\n ");
                sql.append("SHOPMODIFYCONTENT = ? ,\r\n ");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("modifydt = ? ,\r\n ");
                sql.append("modifyid = ? \r\n ");
                sql.append("where sendseq = ? and compno = ? ");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ShopProductDto dto : parentList) {
                    List<ShopProductDto> childList = this.isShopProductInExits(dto.getProdseq());
                    for (ShopProductDto dtoch : childList) {
                        int j = 0;
                        if (dtoch.getSelfmod_no().contains("1")) {
                            pstmt.setString(++j, dtoch.getClass_cd1());
                            pstmt.setString(++j, dtoch.getClass_cd2());
                            pstmt.setString(++j, dtoch.getClass_cd3());
                            pstmt.setString(++j, dtoch.getClass_cd4());
                        } else {
                            pstmt.setString(++j, dto.getClass_cd1());
                            pstmt.setString(++j, dto.getClass_cd2());
                            pstmt.setString(++j, dto.getClass_cd3());
                            pstmt.setString(++j, dto.getClass_cd4());
                        }
                        if (dtoch.getSelfmod_no().contains("2")) {
                            pstmt.setString(++j, dtoch.getGoods_nm());
                        } else {
                            pstmt.setString(++j, dto.getGoods_nm());
                        }
                        if (dtoch.getSelfmod_no().contains("3")) {
                            pstmt.setString(++j, dtoch.getGoods_search());
                        } else {
                            pstmt.setString(++j, dto.getGoods_search());
                        }
                        pstmt.setString(++j, dto.getModel_nm());
                        pstmt.setString(++j, dto.getBrand_nm());
                        pstmt.setString(++j, dto.getSelect_option());
                        pstmt.setString(++j, dto.getText_option());
                        pstmt.setString(++j, dto.getGoods_cost());
                        pstmt.setString(++j, dto.getIslimit());
                        pstmt.setString(++j, dto.getLimit_price());
                        pstmt.setString(++j, dto.getIs_overseas());
                        pstmt.setString(++j, dto.getAdult());
                        pstmt.setString(++j, dto.getIsreturn());
                        pstmt.setString(++j, dto.getItype());
                        pstmt.setString(++j, dto.getChar_1_nm());
                        pstmt.setString(++j, dto.getChar_2_nm());
                        pstmt.setString(++j, dto.getChar_2_val());
                        pstmt.setString(++j, dto.getCert_type());
                        pstmt.setString(++j, dto.getCert());
                        pstmt.setString(++j, dto.getCertno());
                        pstmt.setString(++j, dto.getStock_use_yn());
                        pstmt.setString(++j, dto.getOpt_type());
                        pstmt.setString(++j, dto.getProp_edit_yn());
                        pstmt.setString(++j, dto.getMaker());
                        pstmt.setString(++j, dto.getOrigin());
                        pstmt.setString(++j, dto.getStatus());
                        pstmt.setString(++j, dto.getTax_yn());
                        pstmt.setString(++j, dto.getDelv_type());
                        pstmt.setString(++j, dto.getDelv_cost());
                        pstmt.setString(++j, dto.getGoods_price());
                        pstmt.setString(++j, dto.getGoods_consumer_price());
                        pstmt.setString(++j, dto.getImg_path());
                        pstmt.setString(++j, dto.getImg_path1());
                        pstmt.setString(++j, dto.getImg_path2());
                        pstmt.setString(++j, dto.getImg_path3());
                        pstmt.setString(++j, dto.getImg_path4());
                        pstmt.setString(++j, dto.getImg_path5());
                        pstmt.setString(++j, dto.getImg_path6());
                        pstmt.setString(++j, dto.getImg_path7());
                        pstmt.setString(++j, dto.getImg_path8());
                        pstmt.setString(++j, dto.getImg_path9());
                        pstmt.setString(++j, dto.getGoods_remarks());
                        pstmt.setString(++j, dto.getProp1_cd());
                        pstmt.setString(++j, dto.getProp_val1());
                        pstmt.setString(++j, dto.getProp_val2());
                        pstmt.setString(++j, dto.getProp_val3());
                        pstmt.setString(++j, dto.getProp_val4());
                        pstmt.setString(++j, dto.getProp_val5());
                        pstmt.setString(++j, dto.getProp_val6());
                        pstmt.setString(++j, dto.getProp_val7());
                        pstmt.setString(++j, dto.getProp_val8());
                        pstmt.setString(++j, dto.getProp_val9());
                        pstmt.setString(++j, dto.getProp_val10());
                        pstmt.setString(++j, dto.getProp_val11());
                        pstmt.setString(++j, dto.getProp_val12());
                        pstmt.setString(++j, dto.getProp_val13());
                        pstmt.setString(++j, dto.getProp_val14());
                        pstmt.setString(++j, dto.getProp_val15());
                        pstmt.setString(++j, dto.getProp_val16());
                        pstmt.setString(++j, dto.getProp_val17());
                        pstmt.setString(++j, dto.getProp_val18());
                        pstmt.setString(++j, dto.getProp_val19());
                        pstmt.setString(++j, dto.getProp_val20());
                        pstmt.setString(++j, dto.getProp_val21());
                        pstmt.setString(++j, dto.getProp_val22());
                        pstmt.setString(++j, dto.getShopmodifycontent());
                        if (dtoch.getSendstats().equals(String.valueOf(9000))) {
                            pstmt.setInt(++j, 9000);
                        } else if (dtoch.getSendstats().equals(String.valueOf(6000))) {
                            pstmt.setInt(++j, 6000);
                        } else if (dtoch.getSendstats().equals(String.valueOf(8000)) && dtoch.getSelfmod_no().length() > 0) {
                            pstmt.setInt(++j, 6000);
                        } else {
                            pstmt.setInt(++j, 7000);
                        }
                        pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++j, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.setString(++j, dtoch.getSendseq());
                        pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                        YDMAStringUtil.Print("[setShopProductInUpdate]" + pstmt.toString());
                        ++result;
                        ++row;
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    if (result <= true || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    private List<ShopProductDto> isShopProductInExits(String prodseq) {
        ArrayList<ShopProductDto> dtolist;
        block12: {
            dtolist = new ArrayList<ShopProductDto>();
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT sendseq AS SENDSEQ, \t\tifnull(SHOPSENDSTATUS,9000) as SHOPSENDSTATUS, \t\tifnull(SELFMOD_NO,'') as SELFMOD_NO  FROM shopprodin  WHERE PRODSEQ=? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, prodseq);
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        ShopProductDto dto = new ShopProductDto();
                        dto.setSendseq(rs.getString("SENDSEQ"));
                        dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                        dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                        dtolist.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dtolist;
    }

    private static String[] isShopProductInfoExits(String compno, String company_goods_cd) {
        String[] result;
        block12: {
            new ArrayList();
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            result = new String[20];
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT ifnull(SELFMOD_NO,'') as SELFMOD_NO,\t\tifnull(CLASS_CD1,'') as CLASS_CD1,\t\tifnull(CLASS_CD2,'') as CLASS_CD2,\t\tifnull(CLASS_CD3,'') as CLASS_CD3,\t\tifnull(CLASS_CD4,'') as CLASS_CD4,\t\tifnull(GOODS_NM,'') as GOODS_NM,ifnull(GOODS_KEYWORD,'') as GOODS_KEYWORD,\t\tifnull(IMG_PATH,'') as IMG_PATH,ifnull(IMG_PATH1,'') as IMG_PATH1,\t\tifnull(IMG_PATH2,'') as IMG_PATH2,ifnull(IMG_PATH3,'') as IMG_PATH3,\t\tifnull(IMG_PATH4,'') as IMG_PATH4,\t\tifnull(GOODS_REMARKS,'') as GOODS_REMARKS  FROM shopprodinfo  WHERE compno=?    and COMPAYNY_GOODS_CD=?";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, compno);
                    pstmt_orddtl.setString(2, company_goods_cd);
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        int idx = 0;
                        result[idx++] = rs.getString("SELFMOD_NO");
                        result[idx++] = rs.getString("CLASS_CD1");
                        result[idx++] = rs.getString("CLASS_CD2");
                        result[idx++] = rs.getString("CLASS_CD3");
                        result[idx++] = rs.getString("CLASS_CD4");
                        result[idx++] = rs.getString("GOODS_NM");
                        result[idx++] = rs.getString("GOODS_KEYWORD");
                        result[idx++] = rs.getString("IMG_PATH");
                        result[idx++] = rs.getString("IMG_PATH1");
                        result[idx++] = rs.getString("IMG_PATH2");
                        result[idx++] = rs.getString("IMG_PATH3");
                        result[idx++] = rs.getString("IMG_PATH4");
                        result[idx++] = rs.getString("GOODS_REMARKS");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void saveShopOptProdIn(List<ProductItemDto> contents) throws Exception {
        int row = 0;
        Connection connection2 = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist2 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection2 = DBCPInit.getInstance().getConnection();
                connection2.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("SENDSEQ");
                lstInsert.add("SKUSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("SHOPPRODNO");
                lstInsert.add("SHOPPRODSKU_NM");
                lstInsert.add("PRODSEQ");
                lstInsert.add("OPTPRODCD");
                lstInsert.add("OPTPRODNM");
                lstInsert.add("OPTSPECDES");
                lstInsert.add("OPTSAFESTOCK");
                lstInsert.add("OPTVERTSTOCK");
                lstInsert.add("OPTADDAMT");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("SHOPPRODSKU_NM");
                lstUpdate.add("OPTPRODCD");
                lstUpdate.add("OPTPRODNM");
                lstUpdate.add("OPTSPECDES");
                lstUpdate.add("OPTSAFESTOCK");
                lstUpdate.add("OPTVERTSTOCK");
                lstUpdate.add("OPTADDAMT");
                lstUpdate.add("MODIFYDT");
                lstUpdate.add("MODIFYID");
                String sql2 = MLinkShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shop_optprodin");
                sql2 = sql2.toUpperCase();
                pstmt2 = connection2.prepareStatement(sql2);
                statementlist2.add(pstmt2);
                String sql = "SELECT sendseq,shopprodno,prodseq   FROM shopprodin  where compno = ?    and compayny_goods_cd= ? ";
                sql = sql.toUpperCase();
                pstmt = connection2.prepareStatement(sql);
                for (ProductItemDto list : contents) {
                    String optionString;
                    if (list.isModifyMode() && !list.isOptionModify() || (optionString = list.getSelect_option()).isEmpty()) continue;
                    YDMAStringUtil.Print();
                    List<MLinkOption> options = MLinkCommon.get().getOptionList((String)optionString).options;
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.getIcode());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int sendseq = rs.getInt(1);
                        String shopprodno = rs.getString(2);
                        int prodseq = rs.getInt(3);
                        int i = 0;
                        for (MLinkOption option2 : options) {
                            int rowIdx2 = 0;
                            pstmt2.setInt(++rowIdx2, sendseq);
                            pstmt2.setInt(++rowIdx2, ++i);
                            pstmt2.setString(++rowIdx2, YDMASessonUtil.getCompnoInfo().getCompno());
                            pstmt2.setString(++rowIdx2, shopprodno);
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setInt(++rowIdx2, prodseq);
                            String optrprodcd = list.getIcode().concat("-").concat(YDMAStringUtil.leftPad(String.valueOf(i), 2, "0"));
                            pstmt2.setString(++rowIdx2, optrprodcd);
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setString(++rowIdx2, !option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "" : ":" + option2.getOptionName2()) : "");
                            int cnt = option2.getSoldOut() == 0 ? 999 : 0;
                            pstmt2.setInt(++rowIdx2, cnt);
                            pstmt2.setInt(++rowIdx2, cnt);
                            int price2 = option2.getOptionPrice() - YDMAStringUtil.convertToInt(list.getPrice());
                            pstmt2.setInt(++rowIdx2, price2);
                            pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                            pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setString(++rowIdx2, optrprodcd);
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setString(++rowIdx2, !option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "" : ":" + option2.getOptionName2()) : "");
                            pstmt2.setInt(++rowIdx2, cnt);
                            pstmt2.setInt(++rowIdx2, cnt);
                            pstmt2.setInt(++rowIdx2, price2);
                            pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                            pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                            YDMAStringUtil.Print(pstmt2.toString());
                            ++row;
                            pstmt2.addBatch();
                            pstmt2.clearParameters();
                        }
                    }
                }
                if (row > 0) {
                    pstmt2.executeBatch();
                    connection2.setAutoCommit(true);
                    pstmt2.clearBatch();
                }
            }
            catch (Exception ex) {
                connection2.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection2, statementlist2, rs);
        }
    }

    public static int excelProductInUpdate(List<ProductItemDto> list, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodin set \r\n");
                sql.append("GOODS_NM = ? ,\r\n ");
                sql.append("GOODS_SEARCH = ? ,\r\n ");
                sql.append("IMG_PATH = ? ,\r\n ");
                sql.append("IMG_PATH1 = ? ,\r\n ");
                sql.append("IMG_PATH2 = ? ,\r\n ");
                sql.append("IMG_PATH3 = ? ,\r\n ");
                sql.append("IMG_PATH4 = ? ,\r\n ");
                sql.append("GOODS_REMARKS = ? ,\r\n ");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("modifydt = ? , \r\n ");
                sql.append("modifyid = ? , \r\n ");
                sql.append("SELFMOD_NO = ? \r\n ");
                sql.append("where compno = ? and COMPAYNY_GOODS_CD = ?");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductItemDto dto : list) {
                    int j = 0;
                    pstmt.setString(++j, dto.getIname());
                    pstmt.setString(++j, dto.getSearch());
                    pstmt.setString(++j, dto.getImg()[0]);
                    pstmt.setString(++j, dto.getImg()[1]);
                    pstmt.setString(++j, dto.getImg()[2]);
                    pstmt.setString(++j, dto.getImg()[3]);
                    pstmt.setString(++j, dto.getImg()[4]);
                    pstmt.setString(++j, dto.getContent());
                    pstmt.setInt(++j, 6000);
                    pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++j, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++j, "1:2:3:4:5:");
                    pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++j, dto.getIcode());
                    YDMAStringUtil.Print("[excelProductInfoUpdate]" + pstmt.toString());
                    ++result;
                    ++row;
                    try {
                        monitor.subTask("[\uc1fc\ud551\ubab0 \uc0c1\ud488\uc815\ubcf4 \ucc98\ub9ac\uc911..] " + dto.getIcode() + " " + result + " of " + workload + "...");
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            monitor.done();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public static int excelProductInfoUpdate(List<ProductItemDto> list, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodinfo set \r\n");
                sql.append("GOODS_NM = ? ,\r\n ");
                sql.append("GOODS_SEARCH = ? ,\r\n ");
                sql.append("IMG_PATH = ? ,\r\n ");
                sql.append("IMG_PATH1 = ? ,\r\n ");
                sql.append("IMG_PATH2 = ? ,\r\n ");
                sql.append("IMG_PATH3 = ? ,\r\n ");
                sql.append("IMG_PATH4 = ? ,\r\n ");
                sql.append("GOODS_REMARKS = ? ,\r\n ");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("modifydt = ? ,\r\n ");
                sql.append("SELFMOD_NO = ? \r\n ");
                sql.append("where compno = ? and COMPAYNY_GOODS_CD = ?");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductItemDto dto : list) {
                    int j = 0;
                    pstmt.setString(++j, dto.getIname());
                    pstmt.setString(++j, dto.getSearch());
                    pstmt.setString(++j, dto.getImg()[0]);
                    pstmt.setString(++j, dto.getImg()[1]);
                    pstmt.setString(++j, dto.getImg()[2]);
                    pstmt.setString(++j, dto.getImg()[3]);
                    pstmt.setString(++j, dto.getImg()[4]);
                    pstmt.setString(++j, dto.getContent());
                    pstmt.setInt(++j, 6100);
                    pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++j, ":1:2:3:4:5");
                    pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++j, dto.getIcode());
                    ++result;
                    ++row;
                    try {
                        monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \ucc98\ub9ac\uc911..] " + dto.getIcode() + " " + result + " of " + workload + "...");
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            monitor.done();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    YDMAStringUtil.Print("[excelProductInfoUpdate]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    private static class ShopCateInfo {
        private String cid;
        public String cate_dept;
        private String es_auction;
        private String es_gmarket;
        private String es_11st;
        private String es_interpark;
        private String es_storefarm;
        private String esm_auction;
        private String esm_gmarket;
        private String es_cafe24;
        private String es_coupang;
        private String es_godomall;

        public ShopCateInfo(String cid, String es_auction, String es_gmarket, String es_11st, String es_interpark, String es_storefarm, String esm_auction, String esm_gmarket, String es_cafe24, String es_coupang, String cate_dept) {
            this.cid = cid;
            this.es_auction = es_auction;
            this.es_gmarket = es_gmarket;
            this.es_11st = es_11st;
            this.es_interpark = es_interpark;
            this.es_storefarm = es_storefarm;
            this.esm_auction = esm_auction;
            this.esm_gmarket = esm_gmarket;
            this.es_cafe24 = es_cafe24;
            this.es_coupang = es_coupang;
            this.es_coupang = this.es_godomall;
            this.cate_dept = cate_dept;
        }
    }

    private static class ShopCateItem {
        private String shopcd;
        private String esm_gmarket;
        private String esm_auction;
        private String cid;

        private ShopCateItem() {
        }

        public String getShopcd() {
            return this.shopcd;
        }

        public void setShopcd(String shopcd) {
            this.shopcd = shopcd;
        }

        public String getEsm_gmarket() {
            return this.esm_gmarket;
        }

        public void setEsm_gmarket(String esm_gmarket) {
            this.esm_gmarket = esm_gmarket;
        }

        public String getEsm_auction() {
            return this.esm_auction;
        }

        public void setEsm_auction(String esm_auction) {
            this.esm_auction = esm_auction;
        }

        public String getCid() {
            return this.cid;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }
    }

    private static class ShopGosiInfo {
        private String gosi1;
        private String gosi2;
        private String gosi3;
        private String gosi4;
        private String gosi5;
        private String gosi6;
        private String gosi7;
        private String gosi8;
        private String gosi9;
        private String gosi10;
        private String gosi11;
        private String gosi12;
        private String gosi13;
        private String gosi14;
        private String gosi15;
        private String gosi16;
        private String gosi17;
        private String gosi18;
        private String gosi19;
        private String gosi20;
        private String gosi21;
        private String gosi22;

        private ShopGosiInfo() {
        }

        public String getGosi1() {
            return this.gosi1;
        }

        public void setGosi1(String gosi1) {
            this.gosi1 = gosi1;
        }

        public String getGosi2() {
            return this.gosi2;
        }

        public void setGosi2(String gosi2) {
            this.gosi2 = gosi2;
        }

        public String getGosi3() {
            return this.gosi3;
        }

        public void setGosi3(String gosi3) {
            this.gosi3 = gosi3;
        }

        public String getGosi4() {
            return this.gosi4;
        }

        public void setGosi4(String gosi4) {
            this.gosi4 = gosi4;
        }

        public String getGosi5() {
            return this.gosi5;
        }

        public void setGosi5(String gosi5) {
            this.gosi5 = gosi5;
        }

        public String getGosi6() {
            return this.gosi6;
        }

        public void setGosi6(String gosi6) {
            this.gosi6 = gosi6;
        }

        public String getGosi7() {
            return this.gosi7;
        }

        public void setGosi7(String gosi7) {
            this.gosi7 = gosi7;
        }

        public String getGosi8() {
            return this.gosi8;
        }

        public void setGosi8(String gosi8) {
            this.gosi8 = gosi8;
        }

        public String getGosi9() {
            return this.gosi9;
        }

        public void setGosi9(String gosi9) {
            this.gosi9 = gosi9;
        }

        public String getGosi10() {
            return this.gosi10;
        }

        public void setGosi10(String gosi10) {
            this.gosi10 = gosi10;
        }

        public String getGosi11() {
            return this.gosi11;
        }

        public void setGosi11(String gosi11) {
            this.gosi11 = gosi11;
        }

        public String getGosi12() {
            return this.gosi12;
        }

        public void setGosi12(String gosi12) {
            this.gosi12 = gosi12;
        }

        public String getGosi13() {
            return this.gosi13;
        }

        public void setGosi13(String gosi13) {
            this.gosi13 = gosi13;
        }

        public String getGosi14() {
            return this.gosi14;
        }

        public void setGosi14(String gosi14) {
            this.gosi14 = gosi14;
        }

        public String getGosi15() {
            return this.gosi15;
        }

        public void setGosi15(String gosi15) {
            this.gosi15 = gosi15;
        }

        public String getGosi16() {
            return this.gosi16;
        }

        public void setGosi16(String gosi16) {
            this.gosi16 = gosi16;
        }

        public String getGosi17() {
            return this.gosi17;
        }

        public void setGosi17(String gosi17) {
            this.gosi17 = gosi17;
        }

        public String getGosi18() {
            return this.gosi18;
        }

        public void setGosi18(String gosi18) {
            this.gosi18 = gosi18;
        }

        public String getGosi19() {
            return this.gosi19;
        }

        public void setGosi19(String gosi19) {
            this.gosi19 = gosi19;
        }

        public String getGosi20() {
            return this.gosi20;
        }

        public void setGosi20(String gosi20) {
            this.gosi20 = gosi20;
        }

        public String getGosi21() {
            return this.gosi21;
        }

        public void setGosi21(String gosi21) {
            this.gosi21 = gosi21;
        }

        public String getGosi22() {
            return this.gosi22;
        }

        public void setGosi22(String gosi22) {
            this.gosi22 = gosi22;
        }
    }

    private static class excelupdateProdThread
    implements IRunnableWithProgress {
        private int workload;
        List<ProductItemDto> contents;

        public excelupdateProdThread(List<ProductItemDto> contents) {
            this.workload = contents.size();
            this.contents = contents;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("\ub370\uc774\ud130 \uc800\uc7a5\uc911..", this.workload * 2);
            try {
                monitor.subTask("info");
                MLinkShopDao.excelProductInfoUpdate(this.contents, monitor, this.workload);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return;
                }
                monitor.subTask("in");
                MLinkShopDao.excelProductInUpdate(this.contents, monitor, this.workload);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            monitor.done();
        }
    }

    private static class saveProdThread
    implements IRunnableWithProgress {
        private int workload;
        List<ProductItemDto> contents;

        public saveProdThread(List<ProductItemDto> contents) {
            this.workload = contents.size();
            this.contents = contents;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("\ub370\uc774\ud130 \uc800\uc7a5\uc911..", this.workload * 3);
            try {
                monitor.subTask("saveShopProdInfo");
                MLinkShopDao.saveShopProdInfo(this.contents, monitor, this.workload);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return;
                }
                monitor.subTask("saveShopOptProdInfo");
                MLinkShopDao.saveShopOptProdInfo(this.contents, monitor, this.workload);
                monitor.subTask("saveCategory");
                MLinkShopDao.saveCategory(this.contents, monitor, this.workload);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            monitor.done();
        }
    }
}

