/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.sellmall;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.HttpClientEx;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.shop.dao.ProductResultSellmallDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkDomeOrderCollectConnection;
import com.kdjsystem.mlink.shop.sellmall.SellmallAPI;
import com.kdjsystem.mlink.shop.sellmall.SellmallOption;
import com.kdjsystem.mlink.shop.sellmall.SellmallOptionList;
import com.kdjsystem.mlink.shop.sellmall.SellmallSessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.openqa.selenium.chrome.ChromeDriver;

public class SellmallCommon {
    public static SellmallCommon instance = new SellmallCommon();
    public static List<CategoryItemSellmall> category;
    public static final String LOGIN_HOST = "http://shopapi.kdjsystem.com";
    ChromeDriver driver;

    private SellmallCommon() {
    }

    public static SellmallCommon get() {
        return instance;
    }

    public String getParentClassCd(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.parent_cid).findAny().orElse("");
    }

    public String getCateName(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.name).findAny().orElse("");
    }

    public String getFullCateName(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.fullcat).findAny().orElse("");
    }

    public SellmallOptionList getOptionList(String option2) {
        SellmallOptionList optionList = new SellmallOptionList();
        ArrayList<SellmallOption> ret_options = new ArrayList<SellmallOption>();
        List lines = Arrays.stream(option2.split("\\r|\\n")).collect(Collectors.toList());
        String title = (String)lines.get(0);
        lines.remove(0);
        title = title.replace("[", "");
        title = title.replace("]", "");
        int dan = title.indexOf("=") > 0 ? 2 : 1;
        optionList.setDan(dan);
        if (dan == 1) {
            String char_1_nm = title.indexOf("\uc0c9\uc0c1") > 0 ? "\uce7c\ub77c" : title;
            optionList.setChar_1_nm(char_1_nm);
        } else {
            String[] charnms = title.split("=");
            if (charnms[0].indexOf("\uc0c9\uc0c1") > 0) {
                optionList.setChar_1_nm("\uce7c\ub77c");
            } else {
                optionList.setChar_1_nm(charnms[0]);
            }
            optionList.setChar_2_nm(charnms.length > 1 ? charnms[1] : "");
        }
        for (String line : lines) {
            SellmallOption dto = new SellmallOption();
            List<String> lst_option = Arrays.asList(line.split("="));
            if (lst_option.size() < 6) continue;
            if (dan == 1) {
                if (lst_option.get(5).equals("1")) {
                    dto.setOptionName1(String.valueOf(lst_option.get(0)) + "(\ud488\uc808)");
                } else {
                    dto.setOptionName1(lst_option.get(0));
                }
                dto.setOptionName2("");
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            } else {
                dto.setOptionName1(lst_option.get(0));
                if (lst_option.get(5).equals("1")) {
                    dto.setOptionName2(String.valueOf(lst_option.get(1)) + "(\ud488\uc808)");
                } else {
                    dto.setOptionName2(lst_option.get(1));
                }
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            }
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(p -> p.getOptionName2()).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }

    public ProductResultDto getProductMapping(String response) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ProductResultSellmallDto productResultSellmallDto = null;
        try {
            productResultSellmallDto = (ProductResultSellmallDto)mapper.readValue(response, ProductResultSellmallDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        ProductResultDto productResult = new ProductResultDto();
        try {
            productResult.total_count = String.valueOf(productResultSellmallDto.getTotal_count());
            productResult.total_page = String.valueOf(productResultSellmallDto.getTotal_page());
            productResult.current_page = String.valueOf(productResultSellmallDto.current_page);
            ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
            for (ProductResultSellmallDto.Items dto : productResultSellmallDto.items) {
                ProductItemDto item = new ProductItemDto();
                item.setSearch("shop7777");
                item.setIcode("SEL" + dto.getIcode());
                item.setIname(dto.getIname());
                item.setIname_del(dto.getIname_del());
                item.setCid(dto.getCid());
                item.setCateg_nm(dto.getCateg_nm());
                item.setCate_depth(dto.getCate_depth());
                item.setEs(dto.getEs_code());
                item.setIcountry(dto.getIcountry());
                item.setMaker(dto.getMaker());
                item.setBrand(dto.getBrand());
                item.setTax(dto.getTax().equals("2") ? "1" : "0");
                item.setVender_code(dto.getVender_code());
                item.setDelivery_type(dto.getDelivery_type().equals("02") ? "1" : (dto.getDelivery_type().equals("03") ? "2" : (dto.getDelivery_type().equals("04") ? "3" : "0")));
                item.setDelivery_amount(dto.getDelivery_amount());
                item.setDelivery_qty(dto.getDelivery_qty());
                item.setR_delivery_amount(dto.getR_delivery_amount());
                item.setKeyword(dto.getKeyword());
                item.setPrice(dto.getPrice());
                item.setPrice_consumer(dto.getPrice_consumer());
                item.setIslimit(dto.getIslimit().equals("\ud310\ub9e4\uac00\uaca9\uc900\uc218") ? "1" : "0");
                item.setLimit_price(dto.getLimit_price());
                item.setContent(dto.getContent());
                String[] img = new String[dto.getImage().size()];
                int i = 0;
                while (i < dto.getImage().size()) {
                    img[i] = dto.getImage().get(i);
                    ++i;
                }
                item.setImg(img);
                if (dto.getOptions().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    String title = String.format("%s%s", dto.getOptionNm(), dto.getOptionNm2() == null ? "" : (dto.getOptionNm2().equals("") ? "" : "=" + dto.getOptionNm2()));
                    sb.append("[" + title + "]\n");
                    for (ProductResultSellmallDto.Items.Options opt : dto.getOptions()) {
                        if (opt.getOptionName2().equals("")) {
                            sb.append(opt.getOptionName1().concat("==").concat(String.valueOf(opt.getOptionPrice())).concat("=" + opt.getCompliance_price()).concat("=" + opt.getConsumer_price() + "=").concat(opt.getStatus().equals("1") ? "0" : "1").concat("\n"));
                            continue;
                        }
                        sb.append(opt.getOptionName1().concat("=").concat(opt.getOptionName2()).concat("=").concat(String.valueOf(opt.getOptionPrice())).concat("=" + opt.getCompliance_price()).concat("=" + opt.getConsumer_price() + "=").concat(opt.getStatus().equals("1") ? "0" : "1").concat("\n"));
                    }
                    item.setSelect_option(sb.toString());
                    item.setText_option("");
                } else {
                    item.setSelect_option("");
                    item.setText_option("");
                }
                item.setNotice(dto.getNotice());
                item.setItype(dto.getItype());
                item.setStatus(dto.getStatus().equals("2") ? "1" : (dto.getStatus().equals("3") ? "2" : (dto.getStatus().equals("0") ? "3" : "0")));
                item.setAdult(dto.getAdult().equals("1") ? "1" : "0");
                item.setReg_datetime(dto.getReg_datetime().replaceAll("T", " "));
                item.setUp_datetime(dto.getUp_datetime() == null ? "" : (dto.getUp_datetime().equals("") ? "" : dto.getUp_datetime().replaceAll("T", " ")));
                item.setIsreturn(dto.getIsreturn());
                item.setIs_overseas(dto.getIs_overseas() == null ? "" : (dto.getIs_overseas().equals("Y") ? "1" : "0"));
                item.setCert_type(dto.getCert_type() == null ? "0" : (dto.getCert_type().equals("") ? "0" : dto.getCert_type()));
                item.setCert(dto.getCert());
                item.setCert_no(dto.getCert_no());
                item.setGosi_code(dto.getGosi_code());
                if (dto.getGosi() != null) {
                    i = 0;
                    while (i < dto.getGosi().size()) {
                        switch (i) {
                            case 0: {
                                item.setGosi1(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 1: {
                                item.setGosi2(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 2: {
                                item.setGosi3(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 3: {
                                item.setGosi4(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 4: {
                                item.setGosi5(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 5: {
                                item.setGosi6(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 6: {
                                item.setGosi7(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 7: {
                                item.setGosi8(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 8: {
                                item.setGosi9(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 9: {
                                item.setGosi10(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 10: {
                                item.setGosi11(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 11: {
                                item.setGosi12(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 12: {
                                item.setGosi13(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 13: {
                                item.setGosi14(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 14: {
                                item.setGosi15(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 15: {
                                item.setGosi16(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 16: {
                                item.setGosi17(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 17: {
                                item.setGosi18(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 18: {
                                item.setGosi19(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 19: {
                                item.setGosi20(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 20: {
                                item.setGosi21(dto.getGosi().get(i).getTitle());
                                break;
                            }
                            case 21: {
                                item.setGosi22(dto.getGosi().get(i).getTitle());
                            }
                        }
                        ++i;
                    }
                }
                items.add(item);
            }
            productResult.items = items;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return productResult;
    }

    public List<ProductItemDto> getExistNotProductList(List<ProductItemDto> items) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ProductItemDto> retItems = new ArrayList<ProductItemDto>();
        try {
            connection = DBCPInit.getInstance().getConnection();
            String sql = "SELECT 1  FROM shopprodinfo where compno = ? and compayny_goods_cd=? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            for (ProductItemDto list : items) {
                int count = 0;
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, list.getIcode());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                if (count != 0) continue;
                retItems.add(list);
            }
            ArrayList<ProductItemDto> arrayList = retItems;
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            return arrayList;
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
        }
    }

    public String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.stream().collect(Collectors.joining("&"));
    }

    public String ConvertDictionaryToParameterObject(Map<String, Object> parameters) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            if (key.equals("seq")) continue;
            String value = parameters.get(key).toString();
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.stream().collect(Collectors.joining("&"));
    }

    public ShopOrderMstDto InvoiceSearch(List<ShopOrderMstDto> list) {
        new ArrayList();
        ShopOrderMstDto dto = new ShopOrderMstDto();
        YDMAProgressBar.get().start("\uc1a1\uc815\ubc88\ud638\uc870\ud68c\uc911", 100, 10, true);
        YDMAProgressBar.get().setValue("\uc1a1\uc7a5\uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 100);
        this.driver = ChromeExtention.getInstace().getDriver();
        String URL2 = "https://search.naver.com/search.naver?sm=top_hty&fbm=1&ie=utf8&query=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C";
        this.driver.get(URL2);
        Map<String, String> cookies = ChromeScript.get().getCookies(this.driver);
        try {
            try {
                Connection.Response rs = Jsoup.connect((String)"https://m.search.naver.com/p/csearch/ocontent/util/headerjson.nhn?_callback=window.__jindo2_callback._306&callapi=parceltracking&t_code=04&t_invoice=111111111111111&passportKey=QlqbAzK6P6uUT%2FL8neG%2Fr%2FyP1sO5S33Gvcf8ZeNoLqY%3D").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("_callback", "window.__jindo2_callback._306").data("callapi", "parceltracking").data("t_code", list.get(0).getNaverexpcode()).data("t_invoice", list.get(0).getInvoice_no()).data("passportKey", "QlqbAzK6P6uUT/L8neG/r/yP1sO5S33Gvcf8ZeNoLqY=").referrer(" https://search.naver.com/search.naver?sm=tab_hty.top&where=nexearch&query=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C&oquery=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C&tqi=" + cookies.get("page_uid")).method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
                String body = rs.body();
                body = body.substring(body.indexOf("{"), body.lastIndexOf(")"));
                JsonParser jsonparser = new JsonParser();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
                if (jsonobject.get("message") != null) {
                    JsonObject message = (JsonObject)jsonobject.get("message");
                    String error = message.get("error") == null ? "" : message.get("error").getAsString();
                    YDMAProgressBar.get().setValue(String.format("\uace0\uac1d\uba85 : %s, \ud0dd\ubc30\uc5c5\uccb4 : %s, \uc1a1\uc7a5\ubc88\ud638 : %s, \ub0b4\uc6a9 : %s", list.get(0).getReceive_name(), list.get(0).getDelvnm(), list.get(0).getInvoice_no(), error), 100);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.driver.close();
                this.driver.quit();
            }
        }
        finally {
            this.driver.close();
            this.driver.quit();
        }
        return dto;
    }

    public Map<String, ProductResultDto> OrderOneItemSalesNSoldCheck(List<ShopOrderMstDto> list) throws Exception {
        int page = 1;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, ProductResultDto> resultProdList = new HashMap<String, ProductResultDto>();
        parameters.put("page", "0");
        parameters.put("size", "100");
        String response = null;
        for (ShopOrderMstDto dto : list) {
            String path = "/v1/product/search_product";
            parameters.put("icode_arr", dto.getCompayny_goods_cd().replaceAll("SEL", ""));
            String postForm = SellmallCommon.get().ConvertDictionaryToParameterObject(parameters);
            HttpClientEx httpClientEx = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").addParam("X-AUTH-TOKEN", SellmallSessonUtil.get().getData());
            SellmallAPI.get();
            response = httpClientEx.Get("http://localhost:8080".concat(path).concat("?").concat(postForm));
            ProductResultDto productSellmall = this.getProductMapping(response);
            if (productSellmall.items.size() > 0) {
                resultProdList.put(String.valueOf(page), productSellmall);
            }
            ++page;
        }
        return resultProdList;
    }

    public List<ShopOrderMstDto> OrderListComplate(List<ShopOrderMstDto> list) throws Exception {
        int page = 0;
        int order = 0;
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        Map<String, List<ShopOrderMstDto>> mapList = list.stream().collect(Collectors.groupingBy(ShopOrderMstDto::getReceive_addr));
        ArrayList<OrderSellmall> datas = new ArrayList<OrderSellmall>();
        for (String key : mapList.keySet()) {
            List<ShopOrderMstDto> orderList = mapList.get(key);
            OrderSellmall data2 = new OrderSellmall();
            data2.c_name = orderList.get(0).getReceive_name();
            String phone = orderList.get(0).getReceive_cel().equals("") ? orderList.get(0).getReceive_tel() : orderList.get(0).getReceive_cel();
            String phone2 = orderList.get(0).getReceive_tel().equals("") ? orderList.get(0).getReceive_cel() : orderList.get(0).getReceive_tel();
            data2.c_hp = phone;
            data2.c_tel = phone2;
            data2.c_zip = orderList.get(0).getReceive_zipcode() == null ? "" : orderList.get(0).getReceive_zipcode();
            data2.c_addr = orderList.get(0).getReceive_addr();
            data2.c_addr_detail = orderList.get(0).getReceive_detail() == null ? "." : orderList.get(0).getReceive_detail();
            data2.c_ship_memo = orderList.get(0).getDelv_msg() == null ? "" : orderList.get(0).getDelv_msg();
            data2.c_memo = orderList.get(0).getOrder_id() == null ? "" : orderList.get(0).getOrder_id();
            for (ShopOrderMstDto dto : orderList) {
                OrderSellmallItem item = new OrderSellmallItem();
                item.icode = dto.getCompayny_goods_cd();
                if (dto.getP_sku_value2() == null) {
                    dto.setP_sku_value2("");
                }
                if (dto.getP_sku_value2().contains(":")) {
                    item.option1 = dto.getP_sku_value2().split(":")[0];
                    item.option2 = dto.getP_sku_value2().split(":")[1];
                } else {
                    item.option1 = dto.getP_sku_value2().substring(dto.getP_sku_value2().indexOf(":") + 1, dto.getP_sku_value2().length());
                    item.option2 = "";
                }
                item.qty = Long.parseLong(dto.getSale_cnt());
                data2.items.add(item);
            }
            datas.add(data2);
        }
        for (OrderSellmall data3 : datas) {
            String path = "/v1/order/send";
            String response = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String json = mapper.writeValueAsString((Object)data3);
            response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(LOGIN_HOST.concat(path), json);
            JsonParser jsonparser = new JsonParser();
            JsonObject object = (JsonObject)jsonparser.parse(response);
            List choice = list.stream().filter(d -> d.getReceive_addr().equals(data3.getC_addr()) && d.getReceive_name().equals(data3.getC_name())).collect(Collectors.toList());
            if (object.get("code").getAsString().equals("0000")) {
                object.get("delivery_amount").getAsInt();
                for (ShopOrderMstDto dto : choice) {
                    dto.setDosinOrder_code(object.get("order_code").getAsString());
                    dto.setOrder_status("500");
                    JsonArray cfr_ignored_0 = (JsonArray)object.get("order_list_detail");
                    dto.setDs_order_status("\ub3c4\ub9e4\uc2e0\uaddc");
                    dto.setResult_code("1");
                    ++order;
                    YDMAProgressBar.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt(), object.get("message").getAsString()), ++page);
                }
            } else {
                for (ShopOrderMstDto dto : choice) {
                    YDMAProgressBar.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getCompayny_goods_cd(), dto.getSale_cnt(), object.get("message").getAsString()), ++page);
                    dto.setResult_code("-1");
                }
            }
            retList.addAll(choice);
        }
        YDMAProgressBar.get().setValue("---------------------------------------------------------------------------------------", page);
        YDMAProgressBar.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \uc8fc\ubb38\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", order), page);
        return retList;
    }

    public ProductResultDto getProductUploadMapping(List<List<String>> sheetContents) throws Exception {
        ProductResultDto productResult = new ProductResultDto();
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        int rowNum = 1;
        for (List<String> list : sheetContents) {
            ArrayList<String> listTemp = new ArrayList<String>();
            listTemp.add(String.valueOf(rowNum));
            int i = 0;
            while (i < list.size()) {
                listTemp.add(list.get(i).trim());
                ++i;
            }
            String prodcd = ((String)listTemp.get(3)).toString();
            if (prodcd.length() == 0) continue;
            ProductItemDto dto = new ProductItemDto();
            dto.setSearch("shop7777");
            dto.setIcode("SEL" + ((String)listTemp.get(1)).toString());
            dto.setCid(((String)listTemp.get(3)).toString());
            dto.setEs(((String)listTemp.get(3)).toString());
            dto.setIname(((String)listTemp.get(4)).toString());
            dto.setIcountry(((String)listTemp.get(9)).toString());
            dto.setMaker(((String)listTemp.get(11)).toString());
            List strimage = Arrays.asList(((String)listTemp.get(14)).toString(), ((String)listTemp.get(15)).toString(), ((String)listTemp.get(16)).toString(), ((String)listTemp.get(17)).toString(), ((String)listTemp.get(18)).toString(), ((String)listTemp.get(13)).toString()).stream().filter(d -> d != null).filter(d -> !d.isEmpty()).collect(Collectors.toList());
            String[] strimg = strimage.toString().replace("[", "").replace("]", "").split(",");
            dto.setImg(strimg);
            dto.setContent(((String)listTemp.get(19)).toString());
            dto.setSelect_option(((String)listTemp.get(24)).toString());
            dto.setBrand(((String)listTemp.get(30)).toString());
            dto.setModel(((String)listTemp.get(31)).toString());
            dto.setTax(((String)listTemp.get(32)).toString().equals("\uacfc\uc138") ? "0" : "1");
            dto.setAdult(((String)listTemp.get(33)).toString());
            dto.setItype(((String)listTemp.get(35)).toString());
            dto.setPrice(((String)listTemp.get(40)).toString());
            dto.setPrice_consumer(((String)listTemp.get(41)).toString());
            dto.setGosi_code(((String)listTemp.get(43)).toString());
            dto.setGosi1(((String)listTemp.get(45)).toString());
            dto.setGosi2(((String)listTemp.get(46)).toString());
            dto.setGosi3(((String)listTemp.get(47)).toString());
            dto.setGosi4(((String)listTemp.get(48)).toString());
            dto.setGosi5(((String)listTemp.get(49)).toString());
            dto.setGosi6(((String)listTemp.get(50)).toString());
            dto.setGosi7(((String)listTemp.get(51)).toString());
            dto.setGosi8(((String)listTemp.get(52)).toString());
            dto.setGosi9(((String)listTemp.get(53)).toString());
            dto.setGosi10(((String)listTemp.get(54)).toString());
            dto.setGosi11(((String)listTemp.get(55)).toString());
            dto.setGosi12(((String)listTemp.get(56)).toString());
            dto.setGosi13(((String)listTemp.get(57)).toString());
            dto.setGosi14(((String)listTemp.get(58)).toString());
            dto.setGosi15(((String)listTemp.get(59)).toString());
            dto.setGosi16(((String)listTemp.get(60)).toString());
            dto.setGosi17(((String)listTemp.get(61)).toString());
            dto.setGosi18(((String)listTemp.get(62)).toString());
            dto.setGosi19(((String)listTemp.get(63)).toString());
            dto.setGosi20(((String)listTemp.get(64)).toString());
            dto.setGosi21(((String)listTemp.get(65)).toString());
            dto.setGosi22(((String)listTemp.get(66)).toString());
            dto.setLimit_price(((String)listTemp.get(75)).toString());
            dto.seteSellersExcelYN("Y");
            items.add(dto);
        }
        productResult.items = items;
        return productResult;
    }

    public List<ShopOrderMstDto> OrderListComplateCallBack(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopDto, YDMAProgressBar console) throws Exception {
        int page = 0;
        int order = 0;
        for (ShopOrderMstDto dto : list) {
            String orderCode;
            List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
            String path = "/API/v11/order_status.php";
            OrderSellMallCallback data2 = new OrderSellMallCallback();
            data2.api_key = DomesinSessonUtil.get().getApiKey();
            data2.m_id = DomesinSessonUtil.get().getUserId();
            data2.order_code = orderCode = dto.getDosinOrder_code().contains("-") ? dto.getDosinOrder_code().split("-")[0] : dto.getDosinOrder_code();
            String response = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String json = mapper.writeValueAsString((Object)data2);
            response = this.getApiList(LOGIN_HOST.concat(path), json);
            JsonParser jsonparser = new JsonParser();
            JsonObject object = (JsonObject)jsonparser.parse(response);
            if (object.get("code").getAsString().equals("0000")) {
                JsonArray jsonarray = new JsonArray();
                jsonarray = (JsonArray)object.get("order_list_detail");
                int i = 0;
                while (i < jsonarray.size()) {
                    String delv;
                    JsonObject obj = (JsonObject)jsonarray.get(i);
                    String status2 = obj.get("status").getAsString();
                    String claim_status = obj.get("claim_status").getAsString();
                    String string = delv = obj.get("del_corp").isJsonNull() ? "" : obj.get("del_corp").getAsString().replaceAll(" ", "");
                    if (status2.equals("\ubc30\uc1a1\uc900\ube44\uc911")) {
                        dto.setOrder_status("501");
                        if (claim_status.length() == 0) {
                            dto.setDs_order_status(status2);
                        } else {
                            dto.setDs_order_status(claim_status);
                        }
                    } else if (status2.equals("\uc2e0\uaddc\uc8fc\ubb38")) {
                        dto.setOrder_status("500");
                        dto.setDs_order_status(status2);
                    }
                    try {
                        if (!delv.equals("")) {
                            ShopDeliveryDto delvname = MLinkDomeOrderCollectConnection.get().findDelvName(dto, delv, datasource);
                            if (dto.getDomeOrderId().equals(obj.get("order_list_code").getAsString())) {
                                dto.setDelivery_id(delvname.getDlvID());
                                dto.setInvoice_no(obj.get("del_no") == null ? "" : obj.get("del_no").getAsString());
                            } else {
                                dto.setDelivery_id(delvname.getDlvID());
                                dto.setInvoice_no(obj.get("del_no") == null ? "" : obj.get("del_no").getAsString());
                            }
                            if (claim_status.equals("")) {
                                dto.setOrder_status("402");
                                dto.setDs_order_status(status2);
                            }
                        } else {
                            dto.setDelivery_id("");
                            dto.setInvoice_no(obj.get("del_no") == null ? "" : obj.get("del_no").getAsString());
                        }
                    }
                    catch (Exception exception) {
                        throw new Exception("\ud0dd\ubc30\uc0ac \ucf54\ub4dc\uac00 \ub2e4\ub974\uac70\ub098 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\uad00\ub9ac\uc790\uc5d0\uac8c \ubb38\uc758 \ubc14\ub78d\ub2c8\ub2e4.");
                    }
                    dto.setResult_code("1");
                    ++i;
                }
                ++order;
                MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, ++page, object.get("message").getAsString(), true, console);
                continue;
            }
            MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, ++page, object.get("message").getAsString(), false, console);
        }
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, String.format("[\uc140\ubab0 \uacb0\uacfc] \ub3d9\uae30\ud654 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4", order), page);
        return list;
    }

    private String getApiList(String host, String json) throws Exception {
        String result = null;
        new ArrayList();
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            URIBuilder uriBuilder = new URIBuilder().setPath(host);
            StringEntity params = new StringEntity(json, "UTF-8");
            client = HttpClients.createDefault();
            HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
            requestPatch.addHeader("content-type", "application/json");
            requestPatch.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)requestPatch);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                result = resObject.toString();
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return result;
    }

    private static final class CategoryItemSellmall {
        public String cid;
        public String name;
        public String deep;
        public String parent_cid;
        public String ca_qty;
        public String fullcat;
        public String ec;

        private CategoryItemSellmall() {
        }

        public String toString() {
            return "CategoryItemDomesin [cid=" + this.cid + ", name=" + this.name + ", deep=" + this.deep + ", parent_cid=" + this.parent_cid + ", ca_qty=" + this.ca_qty + ", fullcat=" + this.fullcat + ", ec=" + this.ec + "]";
        }
    }

    private static final class CategorySellmall {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="data")
        public CategoryItemSellmall[] data;

        private CategorySellmall() {
        }
    }

    private static class LoginResponse {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="m_id")
        public String m_id;
        @JsonProperty(value="api_key")
        public String api_key;
        @JsonProperty(value="notice_url")
        public String notice_url;

        private LoginResponse() {
        }

        public String toString() {
            return "LoginResponse [code=" + this.code + ", m_id=" + this.m_id + ", api_key=" + this.api_key + ", notice_url=" + this.notice_url + "]";
        }
    }

    private static class OrderDomesinCallback {
        String api_key;
        String m_id;
        String order_code;

        private OrderDomesinCallback() {
        }

        public String getApi_key() {
            return this.api_key;
        }

        public void setApi_key(String api_key) {
            this.api_key = api_key;
        }

        public String getM_id() {
            return this.m_id;
        }

        public void setM_id(String m_id) {
            this.m_id = m_id;
        }

        public String getOrder_code() {
            return this.order_code;
        }

        public void setOrder_code(String order_code) {
            this.order_code = order_code;
        }
    }

    private static class OrderDomesinCallbackIcode {
        String api_key;
        String m_id;
        String icode;

        private OrderDomesinCallbackIcode() {
        }

        public String getApi_key() {
            return this.api_key;
        }

        public void setApi_key(String api_key) {
            this.api_key = api_key;
        }

        public String getM_id() {
            return this.m_id;
        }

        public void setM_id(String m_id) {
            this.m_id = m_id;
        }

        public String getIcode() {
            return this.icode;
        }

        public void setIcode(String icode) {
            this.icode = icode;
        }
    }

    private static class OrderSellMallCallback {
        String api_key;
        String m_id;
        String order_code;

        private OrderSellMallCallback() {
        }

        public String getApi_key() {
            return this.api_key;
        }

        public void setApi_key(String api_key) {
            this.api_key = api_key;
        }

        public String getM_id() {
            return this.m_id;
        }

        public void setM_id(String m_id) {
            this.m_id = m_id;
        }

        public String getOrder_code() {
            return this.order_code;
        }

        public void setOrder_code(String order_code) {
            this.order_code = order_code;
        }
    }

    private static class OrderSellmall {
        String c_name;
        String c_hp;
        String c_tel;
        String c_zip;
        String c_addr;
        String c_addr_detail;
        String c_ship_memo;
        String c_memo;
        List<OrderSellmallItem> items = new ArrayList<OrderSellmallItem>();

        private OrderSellmall() {
        }

        public String getC_name() {
            return this.c_name;
        }

        public void setC_name(String c_name) {
            this.c_name = c_name;
        }

        public String getC_hp() {
            return this.c_hp;
        }

        public void setC_hp(String c_hp) {
            this.c_hp = c_hp;
        }

        public String getC_tel() {
            return this.c_tel;
        }

        public void setC_tel(String c_tel) {
            this.c_tel = c_tel;
        }

        public String getC_zip() {
            return this.c_zip;
        }

        public void setC_zip(String c_zip) {
            this.c_zip = c_zip;
        }

        public String getC_addr() {
            return this.c_addr;
        }

        public void setC_addr(String c_addr) {
            this.c_addr = c_addr;
        }

        public String getC_addr_detail() {
            return this.c_addr_detail;
        }

        public void setC_addr_detail(String c_addr_detail) {
            this.c_addr_detail = c_addr_detail;
        }

        public String getC_ship_memo() {
            return this.c_ship_memo;
        }

        public void setC_ship_memo(String c_ship_memo) {
            this.c_ship_memo = c_ship_memo;
        }

        public String getC_memo() {
            return this.c_memo;
        }

        public void setC_memo(String c_memo) {
            this.c_memo = c_memo;
        }

        public List<OrderSellmallItem> getItems() {
            return this.items;
        }

        public void setItems(List<OrderSellmallItem> items) {
            this.items = items;
        }
    }

    private static class OrderSellmallItem {
        String icode;
        String option1;
        String option2;
        Long qty;

        private OrderSellmallItem() {
        }

        public String getIcode() {
            return this.icode;
        }

        public void setIcode(String icode) {
            this.icode = icode;
        }

        public String getOption1() {
            return this.option1;
        }

        public void setOption1(String option1) {
            this.option1 = option1;
        }

        public String getOption2() {
            return this.option2;
        }

        public void setOption2(String option2) {
            this.option2 = option2;
        }

        public Long getQty() {
            return this.qty;
        }

        public void setQty(Long qty) {
            this.qty = qty;
        }
    }
}

