/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot;

import com.kdjsystem.mlink.shop.common.ShopWorkService;
import com.kdjsystem.mlink.tot.InstanceSocketServer;
import com.kdjsystem.mlink.tot.TrustAllUIServices;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.p2Handlers.CloudPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Hashtable;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.kdjsystem.mlink.tot";
    private static Activator plugin;
    private InstanceSocketServer socketServer;
    private Thread serverThread;
    private static final int PORT = 55000;
    private ServiceRegistration<?> policyRegistration;
    private ServiceTracker<IProvisioningAgent, IProvisioningAgent> agentTracker;
    private final UIServices uiServices = new TrustAllUIServices();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerP2Policy(context);
        this.agentTracker = new ServiceTracker<IProvisioningAgent, IProvisioningAgent>(context, IProvisioningAgent.class, null){

            public IProvisioningAgent addingService(ServiceReference<IProvisioningAgent> ref) {
                IProvisioningAgent agent = (IProvisioningAgent)super.addingService(ref);
                if (agent != null) {
                    try {
                        agent.registerService(UIServices.SERVICE_NAME, (Object)Activator.this.uiServices);
                        YDMAStringUtil.Print("Activator: UIServices registered to p2 agent.");
                    }
                    catch (Exception e) {
                        YDMAStringUtil.Print("Activator: UIServices registration failed: " + e.getMessage());
                    }
                }
                return agent;
            }

            public void removedService(ServiceReference<IProvisioningAgent> ref, IProvisioningAgent agent) {
                try {
                    if (agent != null) {
                        agent.unregisterService(UIServices.SERVICE_NAME, (Object)Activator.this.uiServices);
                    }
                }
                catch (Exception exception) {}
                super.removedService(ref, (Object)agent);
            }
        };
        this.agentTracker.open();
        try {
            this.socketServer = new InstanceSocketServer(55000);
            this.serverThread = new Thread((Runnable)this.socketServer, "InstanceSocketServer");
            this.serverThread.setDaemon(true);
            this.serverThread.start();
            YDMAStringUtil.Print("Activator: Socket server created.");
        }
        catch (IOException iOException) {
            YDMAStringUtil.Print("Activator: Socket server already running. This instance will act as a client.");
        }
    }

    public void stop(BundleContext context) throws Exception {
        ShopWorkService svc;
        int updatedCount = Activator.decrementSocketServerCount();
        YDMAStringUtil.Print("Activator stop: Updated count after DEC = " + updatedCount);
        if (updatedCount == 0 && this.socketServer != null) {
            this.socketServer.stop();
        }
        if ((svc = ShopWorkService.getInstance()).isRunning()) {
            svc.shutdown();
        }
        if (this.agentTracker != null) {
            this.agentTracker.close();
            this.agentTracker = null;
        }
        if (this.policyRegistration != null) {
            try {
                this.policyRegistration.unregister();
            }
            catch (Exception exception) {}
            this.policyRegistration = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private void registerP2Policy(BundleContext context) {
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", 1000);
        this.policyRegistration = context.registerService(Policy.class.getName(), (Object)new CloudPolicy(), props);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int connectToSocketServerIncrement() {
        int updatedCount = -1;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Socket socket = new Socket("127.0.0.1", 55000);
                try {
                    PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                    try {
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                            out.println("INC");
                            String response = in.readLine();
                            updatedCount = Integer.parseInt(response);
                            YDMAStringUtil.Print("Connected to socket server with INC. Updated count: " + updatedCount);
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    if (socket == null) return updatedCount;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (socket == null) throw throwable;
                    socket.close();
                    throw throwable;
                }
                socket.close();
                return updatedCount;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return updatedCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getCurrentCountFromSocketServer() {
        int count = -1;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Socket socket = new Socket("127.0.0.1", 55000);
                try {
                    PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                    try {
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                            out.println("GET");
                            String response = in.readLine();
                            count = Integer.parseInt(response);
                            YDMAStringUtil.Print("Connected to socket server with GET. Current count: " + count);
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    if (socket == null) return count;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (socket == null) throw throwable;
                    socket.close();
                    throw throwable;
                }
                socket.close();
                return count;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int decrementSocketServerCount() {
        int updatedCount = -1;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Socket socket = new Socket("127.0.0.1", 55000);
                try {
                    PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                    try {
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                            out.println("DEC");
                            String response = in.readLine();
                            updatedCount = Integer.parseInt(response);
                            YDMAStringUtil.Print("Connected to socket server with DEC. Updated count: " + updatedCount);
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    if (socket == null) return updatedCount;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (socket == null) throw throwable;
                    socket.close();
                    throw throwable;
                }
                socket.close();
                return updatedCount;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return updatedCount;
    }
}

