/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public final class P2AutoUpdater {
    private static final boolean SHOW_PROGRESS_VIEW = false;
    public static final AtomicBoolean RESTARTING_FOR_UPDATE = new AtomicBoolean(false);
    private static final URI[] DEFAULT_REPOS = new URI[]{URI.create("http://itsm.kdjsystem.com/mlink/b2b/repository")};

    private P2AutoUpdater() {
    }

    public static void scheduleAutoUpdate(final boolean autoRestart) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        P2AutoUpdater.ensureAtLeastOneRepo();
        ProvisioningUI ui = ProvisioningUI.getDefaultUI();
        LoadMetadataRepositoryJob loadJob = new LoadMetadataRepositoryJob(ui);
        loadJob.setUser(true);
        loadJob.setSystem(false);
        loadJob.setName("\uc5e0\ub9c1\ud06c \uc5c5\ub370\uc774\ud2b8: \uba54\ud0c0\ub370\uc774\ud130 \ub85c\ub4dc \uc911\u2026");
        loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                Display.getDefault().asyncExec(() -> P2AutoUpdater.runUpdate(autoRestart));
            }
        });
        Job.getJobManager().cancel(LoadMetadataRepositoryJob.LOAD_FAMILY);
        loadJob.schedule();
    }

    private static void runUpdate(final boolean autoRestart) {
        ProvisioningUI ui = ProvisioningUI.getDefaultUI();
        Policy policy = ui.getPolicy();
        policy.setGroupByCategory(false);
        policy.setShowLatestVersionsOnly(true);
        UpdateOperation op = ui.getUpdateOperation(null, null);
        IStatus resolve = op.resolveModal(null);
        if (resolve.getCode() == 10000) {
            return;
        }
        if (!resolve.isOK() && resolve.getSeverity() == 4) {
            return;
        }
        ProvisioningJob job = op.getProvisioningJob(null);
        if (job == null) {
            return;
        }
        job.setUser(true);
        job.setSystem(false);
        job.setName("\uc5e0\ub9c1\ud06c \uc5c5\ub370\uc774\ud2b8: \uc124\uce58/\uc801\uc6a9 \uc911\u2026");
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                if (event.getResult().isOK()) {
                    Display.getDefault().asyncExec(() -> {
                        if (autoRestart) {
                            RESTARTING_FOR_UPDATE.set(true);
                            PlatformUI.getWorkbench().restart();
                        } else {
                            RESTARTING_FOR_UPDATE.set(true);
                            PlatformUI.getWorkbench().restart();
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    private static void ensureAtLeastOneRepo() {
        ProvisioningSession session;
        ProvisioningUI ui = ProvisioningUI.getDefaultUI();
        RepositoryTracker tracker = ui.getRepositoryTracker();
        if (tracker.getKnownRepositories(session = ui.getSession()).length == 0) {
            URI[] uRIArray = DEFAULT_REPOS;
            int n = DEFAULT_REPOS.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                try {
                    tracker.addRepository(uri, null, session);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
    }

    private static void openProgressViewIfPossible() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                page.showView("org.eclipse.ui.views.ProgressView");
            }
        }
        catch (Exception exception) {}
    }
}

