/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.FtpUtil;
import com.kdjsystem.mlink.tot.common.YDMAPluginUtils;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.PickupDto;
import com.kdjsystem.mlink.tot.data.dao.ProductMstDao;
import com.kdjsystem.mlink.tot.data.xml.YDWMXmlManager;
import com.kdjsystem.mlink.tot.ui.SBNetOrderReceiveDialog;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class SabangNetDao {
    String sabangGetClaimurl = "http://sbadmin01.sabangnet.co.kr/RTL_API/xml_clm_info.html?xml_url=";
    String sabangGetOrderUrl = "http://sbadmin01.sabangnet.co.kr/RTL_API/xml_order_info.html?xml_url=";
    String sabangSetProducturl = "http://sbadmin01.sabangnet.co.kr/RTL_API/xml_goods_info.html?xml_url=";
    String sabangSetQuestionurl = "http://sbadmin01.sabangnet.co.kr/RTL_API/xml_cs_ans.html?xml_url=";
    String sabangSetPickupExpressurl = "https://sbadmin14.sabangnet.co.kr/RTL_API/xml_order_invoice.html?xml_url=";
    String PickupExpressurl = "http://openapi.epost.go.kr/postal/RegisterDeliveryService?wsdl";

    public List<String> getSabangNetOrderIdx(String dateFrom, String dateTo) throws Exception {
        ArrayList<String> contents = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SABORDNO FROM ORDDTL  WHERE orddt >= ? and orddt <= ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dateFrom);
                pstmt.setString(2, dateTo);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getSabangNetOrderIdx]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    contents.add(rs.getString(1));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getSabangNetClaimList(String dateFrom, String dateTo) throws Exception {
        List<List<String>> responseContents = null;
        StringBuffer response = new StringBuffer();
        YDWMXmlManager.updateGetClaimListTemplate(dateFrom, dateTo);
        FtpUtil.uploadXmlFileToWeb('C');
        String fileName = YDMAProperties.getInstance().getAppProperty("sabang.claimTempateFile");
        String url = String.valueOf(this.sabangGetClaimurl) + "http://itsm.kdjsystem.com/xmldir/" + fileName;
        YDMAStringUtil.Print("\ud074\ub808\uc784 \uc694\uccad URL " + url);
        URL obj = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
        int responseCode = httpConnection.getResponseCode();
        if (responseCode == 200) {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
            String inputLine = null;
            while ((inputLine = buffReader.readLine()) != null) {
                response.append(inputLine);
            }
            buffReader.close();
        }
        httpConnection.disconnect();
        YDMAStringUtil.Print("Sabang claim list Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
        responseContents = this.getResponseClaim(response.toString());
        return responseContents;
    }

    public List<List<String>> getResponseClaim(String responseData) throws Exception {
        YDMAStringUtil.Print("Sabang claim list Api \uc751\ub2f5 : " + responseData);
        ArrayList<List<String>> responseContents = new ArrayList<List<String>>();
        SBNetOrderReceiveDialog d = new SBNetOrderReceiveDialog(YDMAPluginUtils.getShell(), responseData, responseContents, 'C');
        d.open();
        return responseContents;
    }

    public List<List<String>> getSabangNetOrderList(String dateFrom, String dateTo) throws Exception {
        List<List<String>> responseContents = null;
        StringBuffer response = new StringBuffer();
        YDWMXmlManager.updateGetOrderListTemplate(dateFrom, dateTo);
        FtpUtil.uploadXmlFileToWeb('O');
        String fileName = YDMAProperties.getInstance().getAppProperty("sabang.orderTempateFile");
        String url = String.valueOf(this.sabangGetOrderUrl) + "http://itsm.kdjsystem.com/xmldir/" + fileName;
        YDMAStringUtil.Print("\uc8fc\ubb38\ub0b4\uc5ed \uc694\uccad URL " + url);
        URL obj = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
        int responseCode = httpConnection.getResponseCode();
        if (responseCode == 200) {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
            String inputLine = null;
            while ((inputLine = buffReader.readLine()) != null) {
                response.append(inputLine);
            }
            buffReader.close();
        }
        httpConnection.disconnect();
        YDMAStringUtil.Print("Sabang orderlist Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
        responseContents = this.getResponseOrder(response.toString());
        return responseContents;
    }

    public List<List<String>> getResponseOrder(String responseData) throws Exception {
        ArrayList<List<String>> responseContents = new ArrayList<List<String>>();
        SBNetOrderReceiveDialog d = new SBNetOrderReceiveDialog(YDMAPluginUtils.getShell(), responseData, responseContents, 'O');
        d.open();
        return responseContents;
    }

    public List<List<String>> sendProductListToSabangNet(List<List<String>> contents, boolean isNew, Shell shell) throws Exception {
        List<List<String>> responseContents = null;
        StringBuffer response = new StringBuffer();
        for (List<String> list : contents) {
            if (!list.get(2).contains(",") && !list.get(2).contains("*")) continue;
            MessageDialog.openInformation((Shell)shell, (String)"aa", (String)"\uc120\ud0dd\ud558\uc2e0 \ub0b4\uc6a9\uc911 \uc0c1\ud488\uba85\uc5d0 (',','*')\uc758 \ub0b4\uc6a9\uc774 \uc788\uc5b4 \ub4f1\ub85d\ud560\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            responseContents = new ArrayList<List<String>>();
            return responseContents;
        }
        YDWMXmlManager.updateSendProductListTemplate(contents, isNew, shell);
        FtpUtil.uploadXmlFileToWeb('P');
        try {
            String fileName = YDMAProperties.getInstance().getAppProperty("sabang.productTempateFile");
            String url = String.valueOf(this.sabangSetProducturl) + "http://itsm.kdjsystem.com/xmldir/" + fileName;
            YDMAStringUtil.Print("\uc0c1\ud488\ub4f1\ub85d \uc694\uccad URL " + url);
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("Sabang sendProduct Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
            if (responseCode == 200) {
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
                String inputLine = null;
                while ((inputLine = buffReader.readLine()) != null) {
                    response.append(inputLine);
                }
                buffReader.close();
            }
            httpConnection.disconnect();
            responseContents = this.getResponseProduct(response.toString());
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return responseContents;
    }

    public List<List<String>> sendPickupExpressSabangNet(List<List<String>> contents, Shell shell) throws Exception {
        ArrayList<List<String>> responseContents = new ArrayList<List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer response = new StringBuffer();
        YDWMXmlManager.updateSendPickupExpressSabangNetTemplate(contents, shell);
        FtpUtil.uploadXmlFileToWeb('S');
        YDMAStringUtil.Print();
        try {
            String fileName = YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTempateFile");
            String url = String.valueOf(this.sabangSetPickupExpressurl) + "http://itsm.kdjsystem.com/xmldir/" + fileName;
            YDMAStringUtil.Print("\uc0c1\ud488\ub4f1\ub85d \uc694\uccad URL " + url);
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("Sabang sendProduct Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
            if (responseCode == 200) {
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
                String inputLine = null;
                while ((inputLine = buffReader.readLine()) != null) {
                    response.append(inputLine);
                }
                buffReader.close();
            }
            httpConnection.disconnect();
            YDMAStringUtil.Print("SendProduct responseData :\n" + response.toString());
            String html = response.toString();
            Document doc = Jsoup.parseBodyFragment((String)html);
            Elements body = doc.select("body");
            int i = 0;
            while (i < body.size()) {
                list.add(body.text());
                ++i;
            }
            responseContents.add(list);
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return responseContents;
    }

    public List<List<String>> sendPickupExpressSabangNet2(List<PickupDto> contents, Shell shell) throws Exception {
        ArrayList<List<String>> responseContents = new ArrayList<List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer response = new StringBuffer();
        YDWMXmlManager.updateSendPickupExpressSabangNetTemplate2(contents, shell);
        FtpUtil.uploadXmlFileToWeb('S');
        YDMAStringUtil.Print();
        try {
            String fileName = YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTempateFile");
            String url = String.valueOf(this.sabangSetPickupExpressurl) + "http://itsm.kdjsystem.com/xmldir/" + fileName;
            YDMAStringUtil.Print("\uc0c1\ud488\ub4f1\ub85d \uc694\uccad URL " + url);
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("Sabang sendProduct Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
            if (responseCode == 200) {
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
                String inputLine = null;
                while ((inputLine = buffReader.readLine()) != null) {
                    response.append(inputLine);
                }
                buffReader.close();
            }
            httpConnection.disconnect();
            YDMAStringUtil.Print("SendProduct responseData :\n" + response.toString());
            String html = response.toString();
            Document doc = Jsoup.parseBodyFragment((String)html);
            Elements body = doc.select("body");
            int i = 0;
            while (i < body.size()) {
                list.add(body.text());
                ++i;
            }
            responseContents.add(list);
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return responseContents;
    }

    public List<List<String>> sendQnaListToSabangNet(List<List<String>> contents) throws Exception {
        ArrayList<List<String>> responseContents = new ArrayList<List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer response = new StringBuffer();
        int k = 0;
        while (k < contents.size()) {
            int i = 0;
            while (i < contents.get(k).size()) {
                if (contents.get(k).get(i) == null) {
                    contents.get(k).set(i, "");
                }
                ++i;
            }
            ++k;
        }
        YDWMXmlManager.SendQuestionTemplate(contents);
        FtpUtil.uploadXmlFileToWeb('Q');
        String fileName = YDMAProperties.getInstance().getAppProperty("sabang.questionTempateFile");
        String url = String.valueOf(this.sabangSetQuestionurl) + "http://itsm.kdjsystem.com/xmldir/" + fileName;
        YDMAStringUtil.Print("\uc0c1\ud488\ub4f1\ub85d \uc694\uccad URL " + url);
        URL obj = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
        int responseCode = httpConnection.getResponseCode();
        YDMAStringUtil.Print("Sabang sendQuestion Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
        if (responseCode == 200) {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
            String inputLine = null;
            while ((inputLine = buffReader.readLine()) != null) {
                response.append(inputLine);
            }
            buffReader.close();
        }
        httpConnection.disconnect();
        YDMAStringUtil.Print("SendProduct responseData :\n" + response.toString());
        String html = response.toString();
        Document doc = Jsoup.parseBodyFragment((String)html);
        Elements body = doc.select("body font");
        int i = 0;
        while (i < body.size()) {
            list.add(body.text());
            ++i;
        }
        responseContents.add(list);
        return responseContents;
    }

    public List<List<String>> getResponseProduct(String responseData) throws Exception {
        ArrayList<List<String>> responseContents = new ArrayList();
        responseContents = YDWMXmlManager.parseResponseProduct(responseData);
        return responseContents;
    }

    public List<List<String>> getResponseProduct11st(String responseData, String prodcd) throws Exception {
        ArrayList<List<String>> responseContents = new ArrayList();
        responseContents = YDWMXmlManager.parseResponseProduct11st(responseData, prodcd);
        return responseContents;
    }

    public List<List<String>> getProdcutListSendToSabangNet(int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT prodcd," + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + " prodnm, ifnull(specdes,'') as specdes, ifnull(price, 0), ifnull(tagprice, 0), remark, ea, ifnull(optchk, ''), " + "  ifnull(repstt, ''), ifnull(addtn1, ''), ifnull(addtn2, ''), ifnull(searchwd,''), ifnull(infornum,''), ifnull(propertynum,'') ,ifnull(useyn,'') " + "\tFROM PRODMST A " + " WHERE ifnull(sabcd,'') = ''\tAND NOT EXISTS (SELECT 1 FROM OPTPRODMST B WHERE A.prodcd=B.OPTPRODCD and A.compno = B.compno and A.brandcd = B.brandcd) " + " AND IFNULL(A.DELYN,'N') = 'N' and A.compno = ? and A.brandcd =? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                YDMAStringUtil.Print("[getProdcutListToSendSabangNet]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("" + ++rowno);
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getProdcutListSendToSabangNetAgain(int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT prodcd, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "prodnm, ifnull(specdes,'') as specdes, ifnull(price, 0), ifnull(tagprice, 0), remark, ea, ifnull(optchk, ''), " + "  ifnull(repstt, ''), ifnull(addtn1, ''), ifnull(addtn2, ''), ifnull(searchwd,''), ifnull(infornum,''), ifnull(propertynum,''), ifnull(useyn,'') " + "\tFROM PRODMST A " + " WHERE ifnull(sabcd,'') <> ''\t" + " AND NOT EXISTS (SELECT 1 FROM OPTPRODMST B WHERE A.prodcd=B.OPTPRODCD and A.compno = B.compno and A.brandcd = B.brandcd ) " + " AND IFNULL(A.DELYN,'N') = 'N' and A.compno = ? and A.brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                YDMAStringUtil.Print("[getProdcutListToSendSabangNetAgain]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("" + ++rowno);
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void processSabangNetProductLog(List<List<String>> contents) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                for (List<String> list : contents) {
                    if (!list.get(0).equals("SUCCESS")) continue;
                    ArrayList<List<String>> temp = new ArrayList<List<String>>();
                    temp.add(list);
                    String prodcd = list.get(3);
                    if (this.isMasterProdCD(prodcd)) {
                        this.updateProdmst(connection, statementlist, temp);
                        continue;
                    }
                    this.updateProddtl(connection, statementlist, temp);
                }
                this.deleteEcountProdlog(connection, statementlist, contents);
                this.insertEcountProdlog(connection, statementlist, contents);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public boolean isMasterProdCD(String prodcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select prodcd from v_products where prodcd = ? and compno = ? and prodcd = prodcdm ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isMastProdCD]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public void updateProdmst(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        String sql_prodmst = " Update PRODMST set sabcd = ?  where prodcd = ? and compno = ? ";
        PreparedStatement pstmt = connection.prepareStatement(sql_prodmst);
        pstmtlist.add(pstmt);
        for (List<String> list : contents) {
            if (!list.get(0).equals("SUCCESS")) continue;
            int idx = 0;
            String sabcd = list.get(2);
            pstmt.setString(++idx, sabcd);
            String prodcd = list.get(3);
            pstmt.setString(++idx, prodcd);
            pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.addBatch();
            YDMAStringUtil.Print("[updateProdmst]" + pstmt.toString());
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void updateProddtl(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        String sql_proddtl = " Update proddtl set sabcd = ?  where PRODDTCD = ? and compno = ? ";
        PreparedStatement pstmt = connection.prepareStatement(sql_proddtl);
        pstmtlist.add(pstmt);
        for (List<String> list : contents) {
            if (!list.get(0).equals("SUCCESS")) continue;
            int idx = 0;
            String sabcd = list.get(2);
            pstmt.setString(++idx, sabcd);
            String prodcd = list.get(3);
            pstmt.setString(++idx, prodcd);
            pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.addBatch();
            YDMAStringUtil.Print("[updateProddtl]" + pstmt.toString());
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void deleteEcountProdlog(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        String sql = "DELETE FROM ECOUNTPRODLOG where prodcd = ? and gubun='S' and compno = ? ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtlist.add(pstmt);
        for (List<String> list : contents) {
            if (list.get(0).equals("FAIL")) {
                pstmt.setString(1, list.get(2));
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            } else if (list.get(0).equals("SUCCESS")) {
                pstmt.setString(1, list.get(3));
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            }
            YDMAStringUtil.Print("[deleteEcountProdlog]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void insertEcountProdlog(Connection connection, List<PreparedStatement> pstmtList, List<List<String>> contents) throws Exception {
        String sql = "insert into ECOUNTPRODLOG  (compno, prodcd, gubun, state, errcd, errdsc, errtime)  values (?, ?, ?, ?, ?, ?, ?) ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtList.add(pstmt);
        for (List<String> list : contents) {
            if (!list.get(0).equals("FAIL")) continue;
            int idx = 0;
            pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setString(++idx, list.get(2));
            pstmt.setString(++idx, ProductMstDao.GUBUN_S);
            pstmt.setString(++idx, list.get(0));
            pstmt.setString(++idx, "");
            pstmt.setString(++idx, list.get(1));
            pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
            YDMAStringUtil.Print("[insertEcountProdlog]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public List<List<String>> sendProductListToEdit11st(List<String> list, Shell shell, List<String> dtllist, List<String> idlist) throws Exception {
        List<List<String>> responseContents = null;
        StringBuffer response = new StringBuffer();
        new ProductMstDao();
        String prodcd = "";
        FtpUtil.uploadXmlFileToWeb('T');
        try {
            YDMAProperties.getInstance().getAppProperty("11st.productListTempateFile");
            StringBuffer fileData = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\SendProductList11st.xml"), "EUC-KR"));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                fileData.append(buf, 0, numRead);
            }
            reader.close();
            String text = "text/xml";
            String xml_string_to_send = fileData.toString();
            String url = "http://api.11st.co.kr/rest/prodservices/product/" + list.get(113);
            OutputStream os = null;
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            httpConnection.setDoOutput(true);
            httpConnection.setRequestMethod("PUT");
            httpConnection.setRequestProperty("Content-Type", text);
            httpConnection.setRequestProperty("openapikey", idlist.get(12));
            httpConnection.setRequestProperty("Content-Length", Integer.toString(xml_string_to_send.length()));
            os = httpConnection.getOutputStream();
            os.write(xml_string_to_send.getBytes("euc-kr"));
            os.flush();
            os.close();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("Sabang sendProduct Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
            if (responseCode == 200) {
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
                String inputLine = null;
                while ((inputLine = buffReader.readLine()) != null) {
                    response.append(inputLine);
                }
                buffReader.close();
            }
            httpConnection.disconnect();
            responseContents = this.getResponseProduct11st(response.toString(), prodcd);
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return responseContents;
    }

    public List<List<String>> sendProductListTo11stDiscontinued(List<List<String>> contents, boolean isNew, Shell shell, String prodcd) throws Exception {
        List<List<String>> responseContents = null;
        StringBuffer response = new StringBuffer();
        try {
            String text = "text/xml";
            String api = "b043773df271a0a504cf0405a6bcdec5";
            ProductMstDao dao = new ProductMstDao();
            List<String> list = dao.getProductMstList(prodcd);
            String url = "";
            if (!list.get(33).equals("")) {
                url = "http://api.11st.co.kr/rest/prodstatservice/stat/stopdisplay/" + list.get(33);
            }
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            httpConnection.setDoOutput(true);
            httpConnection.setRequestMethod("PUT");
            httpConnection.setRequestProperty("Content-Type", text);
            httpConnection.setRequestProperty("openapikey", api);
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("Sabang sendProduct Api \uc751\ub2f5 \ucf54\ub4dc: " + responseCode);
            if (responseCode == 200) {
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
                String inputLine = null;
                while ((inputLine = buffReader.readLine()) != null) {
                    response.append(inputLine);
                }
                buffReader.close();
            }
            httpConnection.disconnect();
            responseContents = this.getResponseProduct11st(response.toString(), prodcd);
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return responseContents;
    }
}

