/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.ProductMstDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class VProductsDao {
    public static String GUBUN_E = "E";
    public static String GUBUN_S = "S";

    public List<ProductMstDto> getVProdcutListByOption(int opt, String optStr) throws Exception {
        ArrayList<ProductMstDto> list = new ArrayList<ProductMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select prodcd, ifnull(p.prodnm,''), ifnull(p.specdes,'')   from prodmst as p  where compno = ? ";
                if (opt == 0) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  p.prodcd like ? ";
                    }
                    sql = String.valueOf(sql) + " order by p.prodcd ";
                } else if (opt == 1) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  p.prodnm like ? ";
                    }
                    sql = String.valueOf(sql) + " order by p.prodnm ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if ((opt == 0 || opt == 1) && optStr.length() != 0) {
                    pstmt.setString(2, "%" + optStr + "%");
                }
                YDMAStringUtil.Print("[getProdcutListByOption]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    ProductMstDto dto = new ProductMstDto();
                    dto.setRowno("" + ++rowno);
                    dto.setProdcd(rs.getString(++i));
                    dto.setProdnm(rs.getString(++i));
                    dto.setSpecdes(rs.getString(++i));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<String> getVProdcutInfoByProdcd(String prodcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select prodcd, ifnull(prodnm,''), ifnull(specdes,'')  from v_products  where prodcd=? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getVProdcutInfoByProdcd]" + pstmt.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int i = 0;
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public boolean isExistProduct(String prodcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select prodcd from v_products where prodcd = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistVProduct]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }
}

