/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class JImageCropComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private BufferedImage img;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private boolean cropping;

    public JImageCropComponent(BufferedImage img) {
        this.img = img;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setImage(BufferedImage img) {
        this.img = img;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.img, 0, 0, this);
        if (this.cropping) {
            g.setColor(Color.RED);
            g.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.max(this.x1, this.x2), Math.max(this.y1, this.y2));
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.cropping = true;
        this.x2 = evt.getX();
        this.y2 = evt.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.x1 = evt.getX();
        this.y1 = evt.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        BufferedImage cropped;
        this.cropping = false;
        this.img = cropped = this.crop(new Rectangle(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.max(this.x1, this.x2), Math.max(this.y1, this.y2)));
    }

    private BufferedImage crop(Rectangle rectangle) {
        return null;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

