/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.tot.common.BrandCombo;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.BrandsDto;
import com.kdjsystem.mlink.tot.data.dao.HousingDao;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;

public class OrderSaleWareListDialog
extends CommandDialog {
    public static String ID = "com.kdjsystem.mlink.tot.command.OrderSaleWareListDialog.ID";
    String TITLE = "3\uac1c\uc6d4 \ud3c9\ud310 \ubc0f \uc7ac\uace0\ud604\ud669 \ucd9c\ub825";
    DateTime dt_orddt;
    Combo cb_exp;
    private Combo cb_brands;
    private BrandCombo bcb_brands;
    private Button btn_ok;
    private Button btn_cancel;

    public OrderSaleWareListDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite containerx = new Composite(container, 2048);
        containerx.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        containerx.setLayout((Layout)new GridLayout(1, false));
        Composite composite_2 = new Composite(containerx, 0);
        composite_2.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        Composite composite = new Composite(containerx, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText("\ud68c\uc0ac");
        this.cb_brands = new Combo(composite, 0);
        this.cb_brands.setItems(new String[]{"\ud68c\uc0ac\uc120\ud0dd"});
        GridData gd_cb_brands = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cb_brands.widthHint = 100;
        this.cb_brands.setLayoutData((Object)gd_cb_brands);
        this.cb_brands.select(0);
        this.bcb_brands = new BrandCombo(this.cb_brands);
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setAlignment(131072);
        lblNewLabel.setText("\uae30\uc900\uc77c\uc790");
        this.dt_orddt = new DateTime(composite, 2048);
        Composite composite_1 = new Composite(containerx, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.setBrandNameCheck();
        return container;
    }

    private void setBrandNameCheck() {
        try {
            List<BrandsDto> contents = YDMASessonUtil.getBrandcodelist();
            for (BrandsDto list : contents) {
                this.bcb_brands.add(list.getBrandnm(), list.getBrandcd(), list.getDspseq());
            }
            this.bcb_brands.selectIdex(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int printSaleWareListForOrder(String dateStr, List<List<String>> sheetContents) throws Exception {
        int Excelcount = 0;
        JFrame frame = new JFrame("\uc801\uc815\uc7ac\uace0 \ucd9c\ub825\uc911....");
        frame.setDefaultCloseOperation(2);
        JProgressBar bar = new JProgressBar();
        Container container = frame.getContentPane();
        container.add((Component)bar, "Center");
        frame.setSize(570, 80);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        frame.setLocation(screen.width / 2 - 285, screen.height / 2 - 40);
        String salePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("wareh.salePath"));
        String newfile = String.valueOf(salePath) + File.separator + "\ud310\ub9e4\uc640 \uc7ac\uace0\ud604\ud669.xlsx";
        YDMAStringUtil.Print(newfile);
        newfile = newfile.replace(".xlsx", "_" + dateStr + ".xlsx");
        String[] headerColumns = new String[]{"No.", "\uc0c1\ud488\ucf54\ub4dc", "\uc0c1\ud488\uba85", "\uaddc\uaca9", "3\uac1c\uc6d4", "2.5\uac1c\uc6d4", "2\uac1c\uc6d4", "1.5\uac1c\uc6d4", "\uc6d4\ud3c9\ud310", "\ucc3d\uace0\uc7ac\uace0", "\uc778\ucc9c\ud56d\uc7ac\uace0", "\ubc18\ud488\ubbf8\ud655\uc778", "\ud604\uc7ac\uace0", "\uc548\uc804\uc7ac\uace0"};
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("Sheet");
        if (sheet == null) {
            return -1;
        }
        Row row_head = sheet.createRow(0);
        int i = 0;
        while (i < headerColumns.length) {
            Cell cell = row_head.createCell(i);
            cell.setCellValue(headerColumns[i]);
            if (i == 1) {
                sheet.setColumnWidth(i, 5000);
            } else if (i == 2) {
                sheet.setColumnWidth(i, 10000);
            } else if (i == 3) {
                sheet.setColumnWidth(i, 4000);
            } else {
                sheet.setColumnWidth(i, 3000);
            }
            ++i;
        }
        int rowIdx = 1;
        for (List<String> rowContents : sheetContents) {
            String stock = rowContents.get(9);
            String safestock = rowContents.get(13);
            Row row = sheet.createRow(rowIdx);
            int i2 = 0;
            while (i2 < headerColumns.length) {
                XSSFColor color_temp;
                Cell cell = row.createCell(i2);
                String value = rowContents.get(i2);
                cell.setCellValue(value);
                XSSFCellStyle temp = workbook.createCellStyle();
                if (i2 == 1 || i2 == 2 || i2 == 3) {
                    temp.setAlignment((short)1);
                } else {
                    temp.setAlignment((short)2);
                }
                if (Integer.parseInt(stock) < Integer.parseInt(safestock)) {
                    color_temp = new XSSFColor();
                    color_temp.setIndexed((int)IndexedColors.CORAL.getIndex());
                    temp.setFillForegroundColor(color_temp);
                } else {
                    color_temp = new XSSFColor();
                    color_temp.setIndexed((int)IndexedColors.WHITE.getIndex());
                    temp.setFillForegroundColor(color_temp);
                }
                temp.setFillPattern((short)1);
                cell.setCellStyle((CellStyle)temp);
                ++i2;
            }
            ++rowIdx;
            if (sheetContents.size() != ++Excelcount) {
                bar.setMaximum(sheetContents.size());
                bar.setValue(Excelcount);
                bar.setStringPainted(true);
                frame.setVisible(true);
                continue;
            }
            frame.setVisible(false);
        }
        FileOutputStream fileOut = new FileOutputStream(newfile);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
        YDMAStringUtil.Print(" \ucd9c\uace0 \ub9ac\uc2a4\ud2b8 \uc0dd\uc131 \uc885\ub8cc");
        return 0;
    }

    protected void okPressed() {
        String dateStr = YDMATimeUtil.getOrddtDate(this.dt_orddt);
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.TITLE, (String)"\ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        try {
            HousingDao dao = new HousingDao();
            List<List<String>> sheetContents = dao.getSaleWareQtyList(dateStr, brandcd);
            if (sheetContents.size() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.TITLE, (String)"\uc785\ub825\uc815\ubcf4\uc640 \uc77c\uce58\ud558\ub294  \ub370\uc774\ud0c0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
            List<String> list = dao.getSafetyStock(sheetContents, brandcd);
            int i = 0;
            while (i < sheetContents.size()) {
                sheetContents.get(i).add(list.get(i));
                ++i;
            }
            this.printSaleWareListForOrder(dateStr, sheetContents);
            boolean flag = MessageDialog.openQuestion((Shell)this.getShell(), (String)this.TITLE, (String)("3\uac1c\uc6d4 \ud3c9\ud310 \ubc0f \uc7ac\uace0\ud604\ud669\uc744 \ucd9c\ub825\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + dateStr + "] \n\uc791\uc5c5\uc744 \uacc4\uc18d\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?"));
            if (!flag) {
                super.cancelPressed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.TITLE, (String)e.getMessage());
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btn_ok = this.createButton(parent, 0, "\ucd9c\ub825", false);
        this.btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.btn_ok.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc800\uc7a5.png"));
        this.btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(256, 268);
    }
}

