/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.tot.common.BrandCombo;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YMDAResourceManager;
import com.kdjsystem.mlink.tot.data.dao.BrandsDto;
import com.kdjsystem.mlink.tot.data.dao.ExpDao;
import com.kdjsystem.mlink.tot.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.tot.ui.MyCellRenderer;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import com.kdjsystem.mlink.tot.ui.ProductExpDetail;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ProductExpManager
extends Composite {
    public static String ID = "com.kdjsystem.mlink.tot.command.ProductExp.ID";
    public static String TITLE = "\ubc30\uc1a1\uad00\ub9ac";
    String[][] column_name = new String[][]{{"No.", "45"}, {"\uc0c1\ud488\ucf54\ub4dc", "180"}, {"I", "30"}, {"\uc0c1\ud488\uba85", "380"}, {"\uaddc\uaca9", "180"}, {"\uc8fc\ubb38\uc218\ub7c9\ud14c\uc774\ube14\uc801\uc6a9\uc81c\uc678", "120"}, {"\ud0dd\ubc30\uc0ac", "100"}, {"\ubcd1\ud569\uc218\ub7c9", "60"}, {"\ubb36\uc74c\uae30\uc900", "60"}, {"\uc1a1\uc7a5\uc218\ub7c9", "60"}, {"\uc885\ub958\uba85\uce6d", "50"}, {"\ud30c\uc77c\uc0dd\uc131\uad6c\ubd84", "90"}, {"\ud569\ub3d9\ud0dd\ubc30\uc774\uad00\ucd5c\uc18c\uc218\ub7c9", "100"}, {"\ub799\uc0c1\ud488\uc720\ubb34", "80"}, {"\ub799\uc885\ub958", "80"}, {"\ud0c0\uc81c\ud488\uacfc\ud3ec\ud568\ubc30\uc1a1", "80"}, {"\ubc30\uc1a1\ube44\uba85\uce6d", "80"}, {"\uc801\uc6a9\ud14c\uc774\ube14", "0"}};
    int selectedRowNoMst = -1;
    Combo cb_option;
    GridTableViewer tableViewer;
    Grid table;
    Text txt_count;
    Text txt_search_condition;
    private String img_path = "";
    Combo cb_brands;
    BrandCombo bcb_brands;
    String key_orddt;
    public String key_seq;

    public ProductExpManager(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        gl_composite.verticalSpacing = 1;
        composite.setLayout((Layout)gl_composite);
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayout((Layout)new GridLayout(5, false));
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_1 = new Label(composite_1, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_1.setText("\ud654\uc8fc\uc0ac(\ud68c\uc0ac)");
        this.cb_brands = new Combo(composite_1, 0);
        this.cb_brands.setItems(new String[]{"\ud68c\uc0ac\uc120\ud0dd"});
        GridData gd_cb_brands = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cb_brands.widthHint = 100;
        this.cb_brands.setLayoutData((Object)gd_cb_brands);
        this.cb_brands.select(0);
        this.bcb_brands = new BrandCombo(this.cb_brands);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        ComboViewer comboViewer = new ComboViewer(composite_1, 8);
        this.cb_option = comboViewer.getCombo();
        this.cb_option.setItems(new String[]{"\uc0c1\ud488\ucf54\ub4dc", "\uc0c1\ud488\uba85"});
        this.cb_option.select(1);
        this.txt_search_condition = new Text(composite_1, 2048);
        this.txt_search_condition.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ProductExpManager.this.txt_search_condition.getShell().setImeInputMode(20);
            }
        });
        this.txt_search_condition.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ProductExpManager.this.getProdcutListByName(ProductExpManager.this.txt_search_condition.getText().trim());
                }
            }
        });
        GridData gd_txt_search_condition = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_txt_search_condition.heightHint = 17;
        gd_txt_search_condition.widthHint = 250;
        this.txt_search_condition.setLayoutData((Object)gd_txt_search_condition);
        this.txt_search_condition.setBounds(0, 0, 73, 26);
        Button btn_search = new Button(composite_1, 0);
        GridData gd_btn_search = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_search.heightHint = 25;
        btn_search.setLayoutData((Object)gd_btn_search);
        btn_search.setToolTipText("\uac80\uc0c9");
        btn_search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductExpManager.this.getProdcutListByName(ProductExpManager.this.txt_search_condition.getText().trim());
            }
        });
        btn_search.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uac80\uc0c9.png"));
        Button btn_refresh = new Button(composite_1, 0);
        GridData gd_btn_refresh = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_refresh.heightHint = 25;
        btn_refresh.setLayoutData((Object)gd_btn_refresh);
        btn_refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductExpManager.this.getProdcutListByName("");
            }
        });
        btn_refresh.setToolTipText("\uc804\uccb4\ubcf4\uae30");
        btn_refresh.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uce74\ud14c\uace0\ub9ac.png"));
        btn_refresh.setText("\uc804\uccb4\ubcf4\uae30");
        btn_refresh.setToolTipText("\uc804\uccb4\ubcf4\uae30");
        Button btn_refresh_1 = new Button(composite_1, 0);
        btn_refresh_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gd_btn_refresh_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_refresh_1.heightHint = 25;
        btn_refresh_1.setLayoutData((Object)gd_btn_refresh_1);
        btn_refresh_1.setToolTipText("\uac80\uc0c9\uc790\ub8cc\uc800\uc7a5\ud558\uae30");
        btn_refresh_1.setText("\uc5d1\uc140\uc800\uc7a5");
        btn_refresh_1.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc5d1\uc140\uc800\uc7a5.png"));
        btn_refresh_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductExpManager.this.saveAsExcel();
            }
        });
        Composite composite_2 = new Composite(composite, 0);
        GridLayout gl_composite_2 = new GridLayout(1, false);
        gl_composite_2.verticalSpacing = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.marginHeight = 0;
        gl_composite_2.horizontalSpacing = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        composite_2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_2.setBounds(0, 0, 64, 64);
        this.tableViewer = new GridTableViewer(composite_2, 66308);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProductExpManager.this.selectedRowNoMst = ProductExpManager.this.table.getSelectionIndex();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProductExpManager.this.openDetailProductExp(false);
            }
        });
        this.table = this.tableViewer.getGrid();
        this.table.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(true);
        this.table.setLineColor(SWTResourceManager.getColor(18));
        this.table.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setBGC(14);
        myHeaderRender.setFGC(1);
        int i = 0;
        while (i < this.column_name.length) {
            String[] column = this.column_name[i];
            GridColumn tableViewerColumn_x = new GridColumn(this.table, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setWidth(Integer.parseInt(column[1]));
            tableViewerColumn_x.setText(column[0]);
            if (i == 1 || i == 2 || i == 3) {
                MyCellRenderer myCellRenderer = new MyCellRenderer();
                myCellRenderer.setColumnAlign(16384);
                tableViewerColumn_x.setCellRenderer((GridCellRenderer)myCellRenderer);
            }
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MyLableProvider());
        this.setBrandNameCheck();
        this.getProdcutListByName("");
    }

    protected void saveAsExcel() {
        if (this.tableViewer.getInput() == null || ((List)this.tableViewer.getInput()).size() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5d1\uc140\ud30c\uc77c\ub85c \uc800\uc7a5\ud560 \uc8fc\ubb38\ub0b4\uc5ed\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        FileDialog fileSelectionDialog = MyDataManagerFactory.createExcelFileSaveDialog();
        String fileSavePath = fileSelectionDialog.open();
        if (fileSavePath == null) {
            return;
        }
        try {
            this.printExpPickupList(this.key_orddt, this.key_seq, fileSavePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    private int printExpPickupList(String dateStr, String seq, String fileSavePath) throws Exception {
        List sheetContents = (List)this.tableViewer.getInput();
        String newfile = fileSavePath;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFColor color_fail = new XSSFColor();
        color_fail.setIndexed((int)IndexedColors.RED.getIndex());
        XSSFColor color_pass = new XSSFColor();
        color_pass.setIndexed((int)IndexedColors.BLUE.getIndex());
        XSSFColor color_normal = new XSSFColor();
        color_normal.setIndexed((int)IndexedColors.WHITE.getIndex());
        XSSFCellStyle cs_left = workbook.createCellStyle();
        cs_left.setAlignment((short)1);
        cs_left.setFillForegroundColor(color_normal);
        cs_left.setFillPattern((short)1);
        XSSFCellStyle cs_right = workbook.createCellStyle();
        cs_right.setAlignment((short)3);
        cs_right.setFillForegroundColor(color_normal);
        cs_right.setFillPattern((short)1);
        XSSFCellStyle cs_center = workbook.createCellStyle();
        cs_center.setAlignment((short)2);
        cs_center.setFillForegroundColor(color_normal);
        cs_center.setFillPattern((short)1);
        List lists = sheetContents.stream().collect(Collectors.toList());
        XSSFSheet sheet = workbook.createSheet("\ubc30\uc1a1\uad00\ub9ac");
        if (sheet == null) {
            return -1;
        }
        Row row_head = sheet.createRow(0);
        int i = 0;
        while (i < this.column_name.length) {
            Cell cell = row_head.createCell(i);
            cell.setCellValue(this.column_name[i][0]);
            cell.setCellStyle((CellStyle)cs_center);
            if (i == 3) {
                sheet.setColumnWidth(i, 8000);
            } else if (i == 0 || i == 4 || i == 5 || i == 7 || i == 8 || i == 9 || i == 10 || i == 12 || i == 13 || i == 14 || i == 15 || i == 16 || i == 12) {
                sheet.setColumnWidth(i, 3000);
            } else {
                sheet.setColumnWidth(i, 5000);
            }
            ++i;
        }
        int rowIdx = 1;
        for (List rowContents : lists) {
            Row row = sheet.createRow(rowIdx);
            int i2 = 0;
            while (i2 < this.column_name.length) {
                Cell cell = row.createCell(i2);
                String value = (String)rowContents.get(i2);
                cell.setCellValue(value);
                cell.setCellStyle((CellStyle)cs_center);
                ++i2;
            }
            ++rowIdx;
        }
        FileOutputStream fileOut = new FileOutputStream(newfile);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
        YDMAStringUtil.Print(String.valueOf(newfile) + " \ubc30\uc1a1 \uad00\ub9ac \uc5d1\uc140 \uc0dd\uc131 \uc885\ub8cc");
        boolean retVal = MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)("\ubc30\uc1a1 \uad00\ub9ac \ud56d\ubaa9\uc744 \uc5d1\uc140\ud30c\uc77c\ub85c \uc800\uc7a5\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + fileSavePath + "\n\ud30c\uc77c\uc744 \uc5ec\uc2dc\uaca0\uc2b5\ub2c8\uae4c?"));
        if (retVal) {
            Desktop.getDesktop().edit(new File(fileSavePath));
        }
        return 0;
    }

    private void setBrandNameCheck() {
        try {
            List<BrandsDto> contents = YDMASessonUtil.getBrandcodelist();
            for (BrandsDto list : contents) {
                this.bcb_brands.add(list.getBrandnm(), list.getBrandcd(), list.getDspseq());
            }
            this.bcb_brands.selectIdex(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getProdcutListByName(String name) {
        if (name.length() != 0 && name.length() < 2) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uac80\uc0c9\uc5b4\ub97c 2\uae00\uc790\uc774\uc0c1 \uc785\ub825\ud574\uc8fc\uc138\uc694");
            return;
        }
        try {
            this.img_path = String.format("%s\\%s", YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("Product.image.productImage")), YDMASessonUtil.getImageFolderName());
            int opt = this.cb_option.getSelectionIndex();
            ExpDao dao = new ExpDao();
            int brandcd = this.bcb_brands.getSelectionValue();
            List<List<String>> contents = dao.getProdcutListforExp(brandcd, opt, name);
            this.tableViewer.setInput(null);
            this.tableViewer.setInput(contents);
            this.selectedRowNoMst = -1;
            this.tableViewer.refresh();
            if (contents == null || contents.size() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc870\uac74\uc5d0 \ub9de\ub294  \uc0c1\ud488\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    public void openDetailProductExp(boolean isNew) {
        try {
            if (!isNew) {
                List list = (List)this.tableViewer.getInput();
                List dot_orgin = (List)list.get(this.selectedRowNoMst);
                String prodcd = (String)dot_orgin.get(1);
                ProductExpDetail d = new ProductExpDetail(this.getShell(), this, prodcd);
                d.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    class MyContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class MyLableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = "";
            List rowContent = (List)element;
            value = (String)rowContent.get(columnIndex);
            return value;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image imgValue = null;
            if (columnIndex == 2) {
                List rowContent = (List)element;
                String SRC_FILE = String.format("%s\\%s%s", ProductExpManager.this.img_path, rowContent.get(columnIndex), ".jpg");
                try {
                    imgValue = YMDAResourceManager.getImage(SRC_FILE.trim());
                    YMDAResourceManager.dispose();
                }
                catch (NullPointerException nullPointerException) {
                    imgValue = null;
                }
            }
            return imgValue;
        }
    }
}

