/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.shop.common.ShopCombo;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ProductSchedulerSyncClearSiteDetailDialog
extends CommandDialog {
    public static String TITLE = "\uc0ac\uc774\ud2b8 \uc124\uc815";
    String[] hour = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    String[] minute = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    private List<ShoppingMallDetailDto> _shopInfos;
    private String _flag;
    private CodeItem _selectItem;
    private ProductSchedulerSyncDTO _modifySelectItem;
    private Text txt_nickName;
    private Combo cb_id;
    private Combo cb_syncDay;
    private Combo cb_syncHour;
    private Combo cb_syncMin;
    private ShopCombo scb_site;
    private ShopCombo scb_id;
    private ShopCombo scb_syncDay;

    public ProductSchedulerSyncClearSiteDetailDialog(Shell parentShell, List<ShoppingMallDetailDto> shopInfos, String flag, CodeItem item) {
        super(parentShell);
        this._shopInfos = shopInfos;
        this._flag = flag;
        this._selectItem = item;
    }

    public ProductSchedulerSyncClearSiteDetailDialog(Shell shell, String flag, ProductSchedulerSyncDTO item) {
        super(shell);
        this._flag = flag;
        this._modifySelectItem = item;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite_header = new Composite(container, 0);
        composite_header.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        composite_header.setLayout((Layout)new GridLayout(1, false));
        Label lb1 = new Label(composite_header, 0);
        lb1.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 9, 1));
        lb1.setText("\uc0ac\uc774\ud2b8 \uc815\ubcf4 \uc218\uc815/\ub4f1\ub85d");
        Composite composite_content = new Composite(container, 0);
        composite_content.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        composite_content.setLayout((Layout)new GridLayout(8, false));
        Label lb2 = new Label(composite_content, 0);
        lb2.setText("   \uc0ac\uc774\ud2b8  ");
        Combo cb_site = new Combo(composite_content, 8);
        cb_site.setLayoutData((Object)new GridData(4, 4, true, false, 7, 1));
        this.scb_site = new ShopCombo(cb_site);
        Label lb3 = new Label(composite_content, 0);
        lb3.setText("   \uc544\uc774\ub514  ");
        this.cb_id = new Combo(composite_content, 8);
        this.cb_id.setLayoutData((Object)new GridData(4, 4, true, false, 7, 1));
        this.cb_id.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductSchedulerSyncClearSiteDetailDialog.this.cb_id_selectionEvent();
            }
        });
        this.scb_id = new ShopCombo(this.cb_id);
        Label lb4 = new Label(composite_content, 0);
        lb4.setText("   \ub2c9\ub124\uc784  ");
        this.txt_nickName = new Text(composite_content, 2048);
        this.txt_nickName.setLayoutData((Object)new GridData(4, 4, true, false, 7, 1));
        this.txt_nickName.setEnabled(false);
        Label lb5 = new Label(composite_content, 0);
        lb5.setText("   \uc791\uc5c5\uc2dc\uac04 ");
        Label lb6 = new Label(composite_content, 0);
        lb6.setText("\ub9e4\uc8fc ");
        GridData gd_cb_syncDay = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cb_syncDay.widthHint = 20;
        this.cb_syncDay = new Combo(composite_content, 0);
        this.cb_syncDay.setLayoutData((Object)gd_cb_syncDay);
        this.scb_syncDay = new ShopCombo(this.cb_syncDay);
        this.scb_syncDay.add("\uc6d4", "MON", 0);
        this.scb_syncDay.add("\ud654", "TUE", 1);
        this.scb_syncDay.add("\uc218", "WED", 2);
        this.scb_syncDay.add("\ubaa9", "THU", 3);
        this.scb_syncDay.add("\uae08", "FRI", 4);
        this.scb_syncDay.add("\ud1a0", "SAT", 5);
        this.scb_syncDay.add("\uc77c", "SUN", 6);
        this.scb_syncDay.select(0);
        Label lb7 = new Label(composite_content, 0);
        lb7.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lb7.setText("\uc694\uc77c ");
        this.cb_syncHour = new Combo(composite_content, 0);
        this.cb_syncHour.setItems(this.hour);
        this.cb_syncHour.select(0);
        Label lb8 = new Label(composite_content, 0);
        lb8.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lb8.setText("\uc2dc ");
        this.cb_syncMin = new Combo(composite_content, 0);
        this.cb_syncMin.setItems(this.minute);
        this.cb_syncMin.select(0);
        Label lb9 = new Label(composite_content, 0);
        lb9.setText("\ubd84");
        this.init();
        return container;
    }

    private void init() {
        try {
            if (this._flag.equals("ADD")) {
                this.scb_site.add(this._selectItem.getName(), this._selectItem.getCode(), 0);
                this.scb_site.select(0);
                this.scb_id.setDataSourceTotal(this.getShoppingIdComboItems());
            } else if (this._flag.equals("MODIFY")) {
                this.scb_site.add(ShopCommon.getShoppingMallName(this._modifySelectItem.getShopcd()), this._modifySelectItem.getShopcd(), 0);
                this.scb_site.select(0);
                this.scb_id.setDataSourceItem(new CodeItem(String.valueOf(this._modifySelectItem.getShopseq()), this._modifySelectItem.getShoppingid()));
                this.scb_id.select(0);
                this.txt_nickName.setText(this._modifySelectItem.getNickname());
                this.scb_syncDay.selectValue(this._modifySelectItem.getSyncday());
                this.cb_syncHour.select(Integer.parseInt(this._modifySelectItem.getSynchour()));
                this.cb_syncMin.select(Integer.parseInt(this._modifySelectItem.getSyncmin()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<CodeItem> getShoppingIdComboItems() {
        List datas = null;
        try {
            List shopInfos = this._shopInfos.stream().filter(p -> p.getShopcd().equals(this._selectItem.getCode())).collect(Collectors.toList());
            if (shopInfos != null) {
                datas = shopInfos.stream().map(p -> new CodeItem(p.getShopseq(), p.getShoppingid())).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datas;
    }

    private void cb_id_selectionEvent() {
        if (this._flag.equals("ADD")) {
            String nickname = this._shopInfos.stream().filter(p -> p.getShopcd().equals(this._selectItem.getCode()) && p.getShopseq().equals(this.scb_id.getSelectionItem().getCode())).map(p -> p.getNicknm1()).findFirst().orElse("");
            this.txt_nickName.setText(nickname);
        }
    }

    protected void okPressed() {
        String shopcd = this._flag.equals("ADD") ? this._selectItem.getCode() : this.scb_site.getSelectionItem().getCode();
        String day = this.scb_syncDay.getSelectionValue();
        String hour = this.cb_syncHour.getText();
        String minute = this.cb_syncMin.getText();
        try {
            if (this.cb_id.getText().equals("\uc804\uccb4")) {
                List shopInfos = this._shopInfos.stream().filter(p -> p.getShopcd().equals(shopcd)).collect(Collectors.toList());
                if (shopInfos.size() > 0) {
                    int result = 0;
                    for (ShoppingMallDetailDto shopInfo : shopInfos) {
                        result += ScheduleInfoDao.get().setScheduleSyncSiteByShopSeq(1, shopcd, shopInfo.getShopseq(), day, hour, minute);
                    }
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)("\ucd1d " + result + "\uac1c\uc758 \uc815\ubcf4\uac00 \uc815\uc0c1\uc801\uc73c\ub85c \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4."));
                }
            } else {
                String shopseq = this.scb_id.getSelectionItem().getCode();
                int result = ScheduleInfoDao.get().setScheduleSyncSiteByShopSeq(1, shopcd, shopseq, day, hour, minute);
                if (result > 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc815\uc0c1\uc801\uc73c\ub85c \uc800\uc7a5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc800\uc7a5\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
                }
            }
            super.okPressed();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btnOk = this.createButton(parent, 0, "\uc800\uc7a5", false);
        btnOk.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc800\uc7a5.png"));
        Button btnCancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        btnCancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TITLE);
        super.configureShell(newShell);
    }
}

