/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.tot.common.YDMAPluginUtils;
import com.kdjsystem.mlink.tot.data.dao.UserDao;
import com.kdjsystem.mlink.tot.data.dao.UserDto;
import com.kdjsystem.mlink.tot.ui.MyCellRenderer;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import com.kdjsystem.mlink.tot.ui.UserInfoDetail;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class UserInfo
extends Composite {
    public static String ID = "com.kdjsystem.mlink.tot.command.UserInfo.ID";
    public static String TITLE = "\uc0ac\uc6a9\uc790\uad00\ub9ac";
    String[][] column_name = new String[][]{{"No.", "65"}, {"\uc0ac\uc6a9\uc790\uba85", "250"}, {"\uc544\uc774\ub514", "200"}, {"\ube44\ubc00\ubc88\ud638", "150"}, {"\uc774\uba54\uc77c", "250"}, {"\uc0ac\uc6a9", "100"}, {"\ud68c\uc0ac\ucf54\ub4dc", "100"}, {"\ud654\uc8fc\uc0ac(\ud68c\uc0ac)", "100"}};
    int selectedRowNo = -1;
    private Text txt_search_condition;
    private Grid table;
    GridTableViewer tableViewer;

    public UserInfo(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayout((Layout)new GridLayout(7, false));
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel = new Label(composite_1, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setBounds(0, 0, 71, 20);
        lblNewLabel.setText("\uc0ac\uc6a9\uc790\uba85");
        this.txt_search_condition = new Text(composite_1, 2048);
        this.txt_search_condition.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                UserInfo.this.txt_search_condition.getShell().setImeInputMode(20);
            }
        });
        this.txt_search_condition.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    UserInfo.this.getUserListByCondition(UserInfo.this.txt_search_condition.getText().trim());
                }
            }
        });
        GridData gd_txt_search_condition = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_txt_search_condition.widthHint = 200;
        this.txt_search_condition.setLayoutData((Object)gd_txt_search_condition);
        Button btn_search = new Button(composite_1, 0);
        btn_search.setToolTipText("\ucc3e\uae30");
        btn_search.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String username = UserInfo.this.txt_search_condition.getText().trim();
                UserInfo.this.getUserListByCondition(username);
            }
        });
        btn_search.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uac80\uc0c9.png"));
        Button btn_refresh = new Button(composite_1, 0);
        GridData gd_btn_refresh = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_refresh.widthHint = 95;
        btn_refresh.setLayoutData((Object)gd_btn_refresh);
        btn_refresh.setToolTipText("\uc804\uccb4\ubcf4\uae30");
        btn_refresh.setText("\uc804\uccb4\ubcf4\uae30");
        btn_refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserInfo.this.getUserListByCondition("");
            }
        });
        btn_refresh.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/refresh.png"));
        Button btn_new = new Button(composite_1, 0);
        btn_new.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserInfo.this.openUserInfoDetail(true);
            }
        });
        GridData gd_btn_new = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_new.widthHint = 95;
        btn_new.setLayoutData((Object)gd_btn_new);
        btn_new.setText("\ub4f1\ub85d");
        btn_new.setToolTipText("\uc0ac\uc6a9\uc790\ub4f1\ub85d\ud558\uae30");
        btn_new.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/upload.gif"));
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        Composite composite_2 = new Composite(composite, 0);
        GridLayout gl_composite_2 = new GridLayout(1, false);
        gl_composite_2.horizontalSpacing = 0;
        gl_composite_2.marginHeight = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.verticalSpacing = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        composite_2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_2.setBounds(0, 0, 64, 64);
        this.tableViewer = new GridTableViewer(composite_2, 772);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UserInfo.this.selectedRowNo = UserInfo.this.table.getSelectionIndex();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (UserInfo.this.selectedRowNo > -1) {
                    UserInfo.this.openUserInfoDetail(false);
                }
            }
        });
        this.table = this.tableViewer.getGrid();
        this.table.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.table.setLinesVisible(true);
        this.table.setLineColor(SWTResourceManager.getColor(18));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setBGC(14);
        myHeaderRender.setFGC(1);
        new MyCellRenderer();
        int i = 0;
        while (i < this.column_name.length) {
            String[] column = this.column_name[i];
            GridColumn tableViewerColumn_x = new GridColumn(this.table, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setWidth(Integer.parseInt(column[1]));
            tableViewerColumn_x.setText(column[0]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MyLableProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.getUserListByCondition("");
    }

    private void openUserInfoDetail(boolean isNew) {
        try {
            if (!isNew) {
                List list = (List)this.tableViewer.getInput();
                UserDto dto = (UserDto)list.get(this.selectedRowNo);
                UserDao dao = new UserDao();
                UserDto temp = dao.getUserInfoById(dto.getUserId());
                dto.setEmail(temp.getEmail());
                dto.setProgcd(temp.getProgcd());
                dto.setRowno(temp.getRwono());
                dto.setUserId(temp.getUserId());
                dto.setUsernam(temp.getUsernam());
                dto.setUserpwd(temp.getUserpwd());
                dto.setUseyn(temp.getUseyn());
                dto.setCompno(temp.getCompno());
                dto.setBrandcd(temp.getBrandcd());
                UserInfoDetail d = new UserInfoDetail(YDMAPluginUtils.getShell(), dto, this);
                d.open();
            } else {
                UserInfoDetail d = new UserInfoDetail(YDMAPluginUtils.getShell(), null, this);
                d.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    private void getUserListByCondition(String name) {
        try {
            if (name.length() != 0 && name.length() < 2) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uac80\uc0c9\uc5b4\ub97c 2\uae00\uc790\uc774\uc0c1 \uc785\ub825\ud574\uc8fc\uc138\uc694");
                return;
            }
            UserDao dao = new UserDao();
            List<UserDto> list = dao.getUserListByName(name);
            this.tableViewer.setInput(list);
            this.selectedRowNo = -1;
            if (list == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc870\uac74\uc5d0 \ub9de\ub294  \uc0ac\uc6a9\uc790\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    private void deleteUser() {
        boolean result = MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)"\uc120\ud0dd\ud55c \uc0ac\uc6a9\uc790\ub97c \uc0ad\uc81c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?");
        if (result) {
            List list = (List)this.tableViewer.getInput();
            UserDto dto = (UserDto)list.get(this.selectedRowNo);
            UserDao dao = new UserDao();
            try {
                int count = dao.deleteUser(dto.getUserId());
                if (count == 1) {
                    this.getUserListByCondition("");
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc120\ud0dd\ud55c \uc0ac\uc6a9\uc790\ub97c \uc0ad\uc81c\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
            }
        }
    }

    class MyContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class MyLableProvider
    extends StyledCellLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            UserDto dto = (UserDto)element;
            String value = "";
            switch (columnIndex) {
                case 0: {
                    value = dto.getRwono();
                    break;
                }
                case 1: {
                    value = dto.getUsernam();
                    break;
                }
                case 2: {
                    value = dto.getUserId();
                    break;
                }
                case 3: {
                    value = "****";
                    break;
                }
                case 4: {
                    value = dto.getEmail();
                    break;
                }
                case 5: {
                    value = dto.getUseyn();
                    break;
                }
                case 6: {
                    value = dto.getCompno();
                    break;
                }
                case 7: {
                    value = dto.getBrandcd();
                    break;
                }
                default: {
                    value = "";
                }
            }
            return value;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

