/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.common.ThreadPoolQueue;
import com.kdjsystem.mlink.shop.common.ThreadPoolRunnable;
import java.util.ArrayList;
import java.util.List;

public class ThreadPool {
    private ThreadPoolQueue queue;
    private List<ThreadPoolRunnable> runnableList = new ArrayList<ThreadPoolRunnable>();
    private volatile boolean running = true;

    public ThreadPool(int MAX_THREAD_NUM, int MAX_QUEUE_SIZE) {
        this.queue = new ThreadPoolQueue(MAX_QUEUE_SIZE);
        int i = 0;
        while (i < MAX_THREAD_NUM) {
            this.runnableList.add(new ThreadPoolRunnable(i, this.queue));
            ++i;
        }
        for (ThreadPoolRunnable r : this.runnableList) {
            new Thread(r).start();
        }
    }

    public synchronized void execute(Runnable item) throws Exception {
        if (!this.running) {
            throw new Exception("Thread Pool is not running.");
        }
        this.queue.enqueue(item);
    }

    public synchronized void stop() throws InterruptedException {
        this.running = false;
        for (ThreadPoolRunnable r : this.runnableList) {
            r.stop();
        }
    }

    public void toggleDebugWithRunnable(boolean flag) {
        for (ThreadPoolRunnable r : this.runnableList) {
            r.toggleDebug(flag);
        }
    }

    public void toggleDebugWithQueue(boolean flag) {
        this.queue.toggleDebug(flag);
    }
}

