/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.interpark;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.interpark.IShopOrderInterParkCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class InterParkOrderSearchCommand2
extends IShopOrderInterParkCommand {
    private static IShopOrderCommand instance = new InterParkOrderSearchCommand2();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private InterParkOrderSearchCommand2() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            String id = param.get(0).getShop_userid();
            String pw = param.get(0).getShopPw();
            String shopcd = param.get(0).getShopid();
            String authKey = param.get(0).getAuthkey1();
            String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getStartDt(), false);
            String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false);
            IShopCommonLogin i = new IShopCommonLogin(){};
            Map<String, String> cookies = i.loginCookie(id, pw, shopcd, true, authKey);
            this.allOrderList(param, dtolist, startdt, enddt, cookies);
            this.cancleList(param, dtolist, startdt, enddt, cookies);
            this.returnList(param, dtolist, startdt, enddt, cookies);
            this.exChangeList(param, dtolist, startdt, enddt, cookies);
        }
        catch (Exception exception) {
            throw new Exception("\uc778\ud130\ud30c\ud06c \uc0c1\ud0dc\uac12 \uac00\uc838\uc624\ub294\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4. ");
        }
        return dtolist;
    }

    private void exChangeList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        Connection.Response rs = Jsoup.connect((String)("https://seller.interpark.com/api/orders/exchange-request?claimOrderStatus=&detailedSearchType=&detailedSearchValue=&searchPeriodType=exchangeRequestDate&startDate=" + startdt + "T15%3A00%3A00Z&endDate=" + enddt + "T14%3A59%3A00Z&page=1&size=50")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("http://ipss.interpark.com/order/ProOrderCancelList.do?_method=initial&_style=ipssPro").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray jsonArray = (JsonArray)(jsonobject = jsonobject.get("data").getAsJsonObject()).get("orders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                String status = object.get("clmStatNm").getAsString();
                if (status.equals("\uad50\ud658\uc694\uccad")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
                        dto.setOrder_status("E01");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                } else if (status.equals("\uad50\ud658\ubc1c\uc1a1\uc644\ub8cc")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
                        dto.setOrder_status("E02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("E02");
                        temp.setOrder_date(object.get("orderExchangeDeliveryDts").getAsString().replace("T", " ").replace("Z", ""));
                        dtolist.add(dto);
                        dtolist.add(temp);
                    }
                }
                ++i;
            }
        }
    }

    private void returnList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        Connection.Response rs = Jsoup.connect((String)("https://seller.interpark.com/api/orders/return-request?claimOrderStatus=&detailedSearchType=&detailedSearchValue=&searchPeriodType=returnRequestDate&startDate=" + startdt + "T15%3A00%3A00Z&endDate=" + enddt + "T14%3A59%3A00Z&page=1&size=50")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("http://ipss.interpark.com/order/ProOrderCancelList.do?_method=initial&_style=ipssPro").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray jsonArray = (JsonArray)(jsonobject = jsonobject.get("data").getAsJsonObject()).get("orders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                String status = object.get("clmStatNm").getAsString();
                if (status.equals("\ubc18\ud488\uc694\uccad")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
                        dto.setOrder_status("R01");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                } else if (status.equals("\ubc18\ud488\uc785\uace0\uc644\ub8cc")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
                        dto.setOrder_status("R02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("R02");
                        temp.setOrder_date(object.get("orderReturnReceiveDts").getAsString().replace("T", " ").replace("Z", ""));
                        dtolist.add(dto);
                        dtolist.add(temp);
                    }
                }
                ++i;
            }
        }
    }

    private void cancleList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        Connection.Response rs = Jsoup.connect((String)("https://seller.interpark.com/api/orders/cancel-request?claimOrderStatus=&detailedSearchType=&detailedSearchValue=&searchPeriodType=cancelRequestDate&startDate=" + startdt + "T15%3A00%3A00Z&endDate=" + enddt + "T14%3A59%3A00Z&page=1&size=50")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("http://ipss.interpark.com/order/ProOrderCancelList.do?_method=initial&_style=ipssPro").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray jsonArray = (JsonArray)(jsonobject = jsonobject.get("data").getAsJsonObject()).get("orders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                String status = object.get("clmStatNm").getAsString();
                if (status.equals("\ucde8\uc18c\uc694\uccad")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
                        dto.setOrder_status("C01");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                } else if (status.equals("\ucde8\uc18c\uc644\ub8cc")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
                        dto.setOrder_status("C02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("C02");
                        temp.setOrder_date(object.get("orderCancelComplateDts").getAsString().replace("T", " ").replace("Z", ""));
                        dtolist.add(dto);
                        dtolist.add(temp);
                    }
                }
                ++i;
            }
        }
    }

    private void allOrderList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        Connection.Response rs = Jsoup.connect((String)("https://seller.interpark.com/api/orders/total?orderStatus=all&detailedSearchType=&detailedSearchValue=&claimYn=&searchPeriodType=orderDate&startDate=" + startdt + "T15%3A00%3A00Z&endDate=" + enddt + "T14%3A59%3A00Z&adminMallYn=N&page=1&size=50")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://seller.interpark.com/views/orders/total").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray jsonArray = (JsonArray)(jsonobject = jsonobject.get("data").getAsJsonObject()).get("totalOrders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("ordclmNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!dto.getOrder_id().equals(orderid) || !dto.getProduct_name().equals(mallid) || !dto.getP_sku_value().equals(expid)) continue;
                    String ordStatus = object.get("ordclmPrdStatus").getAsString();
                    if (ordStatus.contains("\ubc1c\uc1a1\uc644\ub8cc")) {
                        dto.setOrder_status("403");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                        continue;
                    }
                    if (ordStatus.contains("\ubc30\uc1a1\uc644\ub8cc")) {
                        dto.setOrder_status("410");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                        continue;
                    }
                    if (!ordStatus.contains("\uad6c\ub9e4\ud655\uc815")) continue;
                    dto.setOrder_status("410");
                    dto.setResult_code("1");
                    dtolist.add(dto);
                }
                ++i;
            }
        }
    }
}

