/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMAProgressBar;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingOrderNewCommand
extends IShopOrderTossShoppingCommand {
    private static IShopOrderCommand instance = new TossShoppingOrderNewCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        List<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
        String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(param.get(0).getStartDt());
        Date edate = formatter.parse(param.get(0).getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(2, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            YDMAProgressBar.get().setValue("\ud1a0\uc2a4\uc1fc\ud551 - 1\uac1c\uc6d4 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4.", 0);
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)((range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 30L == 0L ? range / 30L : range / 30L + 1L);
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        retList = this.getNewOrder(param, retList, start, end);
        cal1.add(5, 30);
        cal2.add(5, 30);
        start = String.valueOf(cal1.getTimeInMillis());
        end = String.valueOf(cal2.getTimeInMillis());
        return retList;
    }

    public List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        HashMap<String, String> cookies = new HashMap();
        try {
            cookies = is.getTossCookies(param.get(0).getShop_userid(), param.get(0).getShopPw());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String startFormatted = dateFormat.format(new Date(Long.parseLong(start)));
            String endFormatted = dateFormat.format(new Date());
            String strParam = "";
            String[] orderStatus = new String[]{"\uacb0\uc81c\uc644\ub8cc", "\uc0c1\ud488\uc900\ube44\uc911", "\ubc1c\uc1a1\uc9c0\uc5f0"};
            JsonParser parser = new JsonParser();
            JsonObject body = new JsonObject();
            JsonObject successObject = new JsonObject();
            JsonArray results = new JsonArray();
            int i = 0;
            while (i < 3) {
                strParam = this.getNewOrderStringParam(param.get(0).getApikey(), startFormatted, endFormatted, orderStatus[i]);
                Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/order/histories/paging").cookies(cookies).header("content-type", "application/json").requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
                body = parser.parse(response.body()).getAsJsonObject();
                successObject = body.getAsJsonObject("success");
                results = successObject.getAsJsonArray("results");
                if (results.size() > 0) {
                    List<ShopOrderMstDto> param1 = this.setData(param, results, cookies);
                    param1.forEach(d -> d.setResult_code("1"));
                    retList.addAll(param1);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return retList;
    }

    public String getNewOrderStringParam(String merchantId, String startDate, String endDate, String orderStatus) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("orderProductStatus", orderStatus);
        json.addProperty("masking", Boolean.valueOf(true));
        json.add("stockIds", (JsonElement)new JsonArray());
        json.addProperty("page", (Number)1);
        json.addProperty("pageSize", (Number)200);
        json.addProperty("sortDirection", "DESC");
        return json.toString();
    }

    public List<ShopOrderMstDto> setData(List<ShopOrderMstDto> param, JsonArray orderArr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement element : orderArr) {
            JsonObject orderObject = element.getAsJsonObject();
            ShopOrderMstDto dto = new ShopOrderMstDto();
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(orderObject.get("orderId").getAsString());
            dto.setMall_product_id(orderObject.get("productId").getAsString());
            dto.setMall_order_id(orderObject.get("orderProductId").getAsString());
            dto.setP_product_name(orderObject.get("productName").getAsString());
            dto.setProduct_name(orderObject.get("productName").getAsString());
            dto.setOrder_status(this.getStatus(orderObject.get("orderProductStatus").getAsString()));
            String orderDate = orderObject.get("orderedAt").getAsString().replace("T", " ");
            dto.setOrder_date(orderDate);
            dto.setUser_name(orderObject.get("ordererName").getAsString());
            dto.setUser_tel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("ordererPhone").getAsString()));
            dto.setUser_cel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("ordererPhone").getAsString()));
            dto.setReceive_name(orderObject.get("receiverName").getAsString());
            dto.setReceive_addr(String.valueOf(orderObject.get("address").getAsString()) + " " + orderObject.get("detailAddress").getAsString());
            dto.setReceive_tel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("receiverPhone").getAsString()));
            dto.setReceive_cel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("receiverPhone").getAsString()));
            dto.setDelv_msg(orderObject.get("shippingNote").getAsString());
            dto.setSale_cnt(orderObject.get("quantity").getAsString());
            dto.setPay_cost(orderObject.get("price").getAsString());
            int saleCount = Integer.parseInt(dto.getSale_cnt());
            int payCost = Integer.parseInt(dto.getPay_cost());
            dto.setSale_cost(String.valueOf(payCost / saleCount));
            dto.setTotal_cost(orderObject.get("price").getAsString());
            dto.setReceive_zipcode(orderObject.get("zipCode").getAsString());
            dto.setP_sku_value(orderObject.get("optionName") == null ? "" : orderObject.get("optionName").getAsString());
            dto.setSku_value(orderObject.get("optionName") == null ? "" : orderObject.get("optionName").getAsString());
            dto.setShopid(param.get(0).getShopid());
            dto.setShop_userid(param.get(0).getShop_userid());
            dto.setCompno(param.get(0).getCompno());
            dto.setDelv_cost("0");
            if (dto.getDelv_cost().equals("0")) {
                dto.setDelivery_method_str2("\ubb34\ub8cc");
            } else {
                dto.setDelivery_method_str2("\uc120\uacb0\uc81c");
            }
            dto.setMall_exp_cd("0");
            dto.setMall_won_cost("0");
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setCompayny_goods_cd(this.getCompanyGoodsCd(orderObject.get("productId").getAsString(), param.get(0).getShopid()));
            list.add(dto);
        }
        return list;
    }

    public static String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            return phoneNumber;
        }
        if (phoneNumber.startsWith("02")) {
            if (phoneNumber.length() == 10) {
                return phoneNumber.replaceAll("(02)(\\d{4})(\\d{4})", "$1-$2-$3");
            }
            if (phoneNumber.length() == 9) {
                return phoneNumber.replaceAll("(02)(\\d{3})(\\d{4})", "$1-$2-$3");
            }
        }
        if (phoneNumber.length() == 11) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{4})(\\d{4})", "$1-$2-$3");
        }
        if (phoneNumber.length() == 10) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3");
        }
        return phoneNumber;
    }

    private String getCompanyGoodsCd(String productId, String shopId) {
        String company_goods_cd = "";
        try {
            company_goods_cd = ShopCommonDao.get().getCompanyGoodsCd(productId, shopId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return company_goods_cd;
    }

    private String getStatus(String string) {
        String status = "";
        switch (string) {
            case "\uacb0\uc81c\uc644\ub8cc": {
                status = "100";
            }
        }
        return status;
    }

    private class NewOrder {
        @JsonProperty(value="merchantNo")
        private String merchantNo;
        @JsonProperty(value="pagingPage")
        private int pagingPage;
        @JsonProperty(value="pagingSize")
        private int pagingSize;
        @JsonProperty(value="sortType")
        private String sortType;
        @JsonProperty(value="sortDirection")
        private String sortDirection;
        @JsonProperty(value="orderStatus")
        private String orderStatus;
        @JsonProperty(value="dateRangeFrom")
        private String dateRangeFrom;
        @JsonProperty(value="dateRangeTo")
        private String dateRangeTo;

        private NewOrder() {
        }
    }
}

