/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingOrderSearchCommand
extends IShopOrderTossShoppingCommand {
    private static IShopOrderCommand instance = new TossShoppingOrderSearchCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingOrderSearchCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return super.Search(URL2, startdt, enddt);
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        List<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
        String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(param.get(0).getStartDt());
        Date edate = formatter.parse(param.get(0).getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(2, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)((range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 30L == 0L ? range / 30L : range / 30L + 1L);
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        retList = this.getOrderSync(param, retList, start, end);
        cal1.add(5, 30);
        cal2.add(5, 30);
        start = String.valueOf(cal1.getTimeInMillis());
        end = String.valueOf(cal2.getTimeInMillis());
        return retList;
    }

    public List<ShopOrderMstDto> getOrderSync(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        try {
            cookies = is.getTossCookies(param.get(0).getShop_userid(), param.get(0).getShopPw());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String startFormatted = dateFormat.format(new Date(Long.parseLong(start)));
            String endFormatted = dateFormat.format(new Date());
            String strParam = this.getOrderSyncStringParam(param.get(0).getApikey(), startFormatted, endFormatted);
            Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/order/histories").cookies(cookies).header("content-type", "application/json").requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonParser parser = new JsonParser();
            JsonObject body = parser.parse(response.body()).getAsJsonObject();
            JsonObject successObject = body.getAsJsonObject("success");
            JsonArray results = successObject.getAsJsonArray("results");
            int i = 0;
            while (i < results.size()) {
                JsonObject order = results.get(i).getAsJsonObject();
                String orderId = order.get("orderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    String orddt;
                    ShopOrderMstDto temp;
                    if (!dto.getOrder_id().equals(orderId)) continue;
                    dto.setOrder_status(this.getStatus(order.get("orderProductStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("C02")) {
                        temp = dto.clone("C02");
                        try {
                            String canceledAt = order.get("canceledAt").getAsString();
                            String orddt2 = this.formatDateString(canceledAt);
                            temp.setOrder_date(orddt2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        retList.add(temp);
                    }
                    if (dto.getOrder_status().equals("R02")) {
                        temp = dto.clone("R02");
                        try {
                            orddt = this.formatCurrentDateTime();
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        retList.add(temp);
                    }
                    if (dto.getOrder_status().equals("E02")) {
                        temp = dto.clone("E02");
                        try {
                            orddt = this.formatCurrentDateTime();
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        retList.add(temp);
                    }
                    retList.add(dto);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return retList;
    }

    public String getOrderSyncStringParam(String merchantId, String startDate, String endDate) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("page", (Number)0);
        json.addProperty("pageSize", (Number)100);
        json.add("statuses", (JsonElement)new JsonArray());
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        return json.toString();
    }

    private String formatCurrentDateTime() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return now.format(formatter);
    }

    private String formatDateString(String dateStr) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(dateStr, inputFormatter);
        return dateTime.format(outputFormatter);
    }

    private String getStatus(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        if (text.contains("\uacb0\uc81c\uc644\ub8cc")) {
            return "100";
        }
        if (text.contains("\uc0c1\ud488\uc900\ube44\uc911")) {
            return "100";
        }
        if (text.contains("\ubc1c\uc1a1\uc9c0\uc5f0")) {
            return "201";
        }
        if (text.contains("\uacb0\uc81c\ucde8\uc18c")) {
            return "C02";
        }
        if (text.contains("\ubc18\ud488\uc811\uc218")) {
            return "R01";
        }
        if (text.contains("\ubc18\ud488\uc644\ub8cc")) {
            return "R02";
        }
        if (text.contains("\uad50\ud658\uc811\uc218")) {
            return "E01";
        }
        if (text.contains("\uad50\ud658\uc644\ub8cc")) {
            return "E02";
        }
        if (text.contains("\ubc30\uc1a1\uc911")) {
            return "403";
        }
        if (text.contains("\ubc30\uc1a1\uc644\ub8cc")) {
            return "410";
        }
        if (text.contains("\uad6c\ub9e4\ud655\uc815")) {
            return "410";
        }
        return "";
    }
}

