/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.feelwoo;

import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.chrome.ChromeDriver;

public class FeelwooOrderCommon {
    public static FeelwooOrderCommon instance = new FeelwooOrderCommon();

    private FeelwooOrderCommon() {
    }

    public static FeelwooOrderCommon get() {
        return instance;
    }

    public List<ShopOrderMstDto> getSearchFeelwooProd(Map<String, String> cookies, List<ShopOrderMstDto> list, ChromeDriver driver) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        try {
            for (ShopOrderMstDto dto : list) {
                Connection.Response response = Jsoup.connect((String)"https://www.feelwoo.com/goods/goods_search.php").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Origin", "https://www.feelwoo.com").referrer("https://www.feelwoo.com/goods/goods_search.php").data("keyword", dto.getCompayny_goods_cd()).data("recentCount", "10").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                Elements productElements = body.select("div.item-display.type-gallery ul li");
                for (Element productElement : productElements) {
                    boolean isSoldOut;
                    String deliveryType;
                    String imageUrl = productElement.select("div.thumbnail img").attr("src");
                    String productTitle = productElement.select("div.txt a strong").text();
                    String productLink = productElement.select("div.txt a").attr("href");
                    String goodsNo = "";
                    Pattern pattern = Pattern.compile("goodsNo=(\\d+)");
                    Matcher matcher = pattern.matcher(productLink);
                    if (matcher.find()) {
                        goodsNo = matcher.group(1);
                    }
                    String price = productElement.select("div.price strong").text().replaceAll(",", "");
                    dto.setOrdimg(imageUrl);
                    dto.setDsGoods_cost(price);
                    dto.setProduct_name(productTitle);
                    dto.setGoodsNo(goodsNo);
                    dto.setGoods_keyword("shop9990");
                    Connection.Response response2 = Jsoup.connect((String)("https://www.feelwoo.com/goods/goods_view.php?goodsNo=" + goodsNo)).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                    Document detailBody = Jsoup.parseBodyFragment((String)response2.body());
                    String productCode = detailBody.select("li:contains(\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc) > div").text();
                    String deliveryFee = detailBody.select("li.delivery > div > span").text().replaceAll("[^\\d]", "");
                    detailBody.select("li:contains(\uc6d0\uc0b0\uc9c0) > div").text();
                    String deliveryTypeText = detailBody.select("li.delivery > div > div.detail").text();
                    Pattern pattern2 = Pattern.compile("\uc8fc\ubb38\uc2dc\uacb0\uc81c\\(\uc120\uacb0\uc81c\\)");
                    Matcher matcher2 = pattern2.matcher(deliveryTypeText);
                    String string = deliveryType = matcher2.find() ? matcher2.group() : "";
                    if (deliveryType.equals("\uc8fc\ubb38\uc2dc\uacb0\uc81c(\uc120\uacb0\uc81c)")) {
                        dto.setDsdelv_type("0");
                    }
                    dto.setCompayny_goods_cd(productCode);
                    dto.setDsdelv_cost(deliveryFee);
                    dto.setDosinoption("");
                    dto.setSku_value("\ub2e8\ud488");
                    boolean bl = isSoldOut = detailBody.select("div.btn > a.soldout").size() > 0;
                    if (isSoldOut) {
                        dto.setDosinstatus("\ud488\uc808");
                    } else {
                        dto.setDosinstatus("\ud310\ub9e4\uc911");
                    }
                    ret.add(dto);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

