/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.data.dao;

import com.kdjsystem.mlink.Yd.common.YDMAProperties;
import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.aes256util.AES256Util;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class DBCPInit {
    private static final Log LOGGER = LogFactory.getLog(DBCPInit.class);
    private static DBCPInit instance;
    static int connectionCount;

    static {
        connectionCount = 0;
    }

    public static DBCPInit getInstance() throws Exception {
        if (instance == null) {
            instance = new DBCPInit();
            LOGGER.info((Object)"DBManager initialize: {}");
        }
        return instance;
    }

    public DBCPInit() throws Exception {
        this.initConnectionPool();
    }

    public void initConnectionPool() throws Exception {
        LOGGER.info((Object)"================Apache DBCP2 Init Start================");
        String jdbcDriver = YDMAProperties.getInstance().getAppProperty("jdbc.driver");
        Class.forName(jdbcDriver);
        String jdbcurl = YDMAProperties.getInstance().getAppProperty("jdbc.url");
        String user = YDMAProperties.getInstance().getAppProperty("jdbc.username");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        user = AES256Util.decrypt((String)user);
        String pwd = YDMAProperties.getInstance().getAppProperty("jdbc.password");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        pwd = AES256Util.decrypt((String)pwd);
        if (YDMASessonUtil.getConnectip() != null && !YDMASessonUtil.getConnectip().getProgcd().equals("") && !YDMASessonUtil.getConnectip().getProgcd().equals("localhost:43306")) {
            jdbcurl = jdbcurl.replace("localhost:43306", YDMASessonUtil.getConnectip().getProgcd());
        }
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(jdbcurl, user, pwd);
        PoolableConnectionFactory poolableConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        poolableConnFactory.setValidationQuery("select 1");
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setTimeBetweenEvictionRunsMillis(300000L);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTestOnBorrow(false);
        int maxCount = 5;
        poolConfig.setMinIdle(3);
        poolConfig.setMaxIdle(maxCount);
        poolConfig.setMaxTotal(maxCount);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnFactory, poolConfig);
        poolableConnFactory.setPool((ObjectPool)connectionPool);
        Class.forName("org.apache.commons.dbcp2.PoolingDriver");
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool("ydincdb", (ObjectPool)connectionPool);
        LOGGER.info((Object)"================Apache DBCP2 Init End================");
    }

    public Connection getConnection() throws Exception {
        Connection con = null;
        con = DriverManager.getConnection("jdbc:apache:commons:dbcp:ydincdb");
        ++connectionCount;
        return con;
    }

    public void freeConnection(Connection con, List<PreparedStatement> list, ResultSet rs) {
        try {
            this.freeResultSet(rs);
            for (PreparedStatement pstmt : list) {
                this.freeStatement(pstmt);
            }
            this.freeConnection(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void freeConnection(Connection con, List<PreparedStatement> pstmtlist, List<ResultSet> rsList) {
        try {
            for (ResultSet rs : rsList) {
                this.freeResultSet(rs);
            }
            for (PreparedStatement pstmt : pstmtlist) {
                this.freeStatement(pstmt);
            }
            this.freeConnection(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void freeConnection(Connection con, PreparedStatement pstmt, ResultSet rs) {
        try {
            this.freeResultSet(rs);
            this.freeStatement(pstmt);
            this.freeConnection(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void freeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
                --connectionCount;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void freeStatement(PreparedStatement pstmt) {
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void freeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

