/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.p2Handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

abstract class PreloadingRepositoryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        this.doExecuteAndLoad();
        return null;
    }

    void doExecuteAndLoad() {
        if (this.preloadRepositories()) {
            Job.getJobManager().cancel(LoadMetadataRepositoryJob.LOAD_FAMILY);
            final LoadMetadataRepositoryJob loadJob = new LoadMetadataRepositoryJob(this.getProvisioningUI());
            this.setLoadJobProperties((Job)loadJob);
            if (this.waitForPreload()) {
                loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (PlatformUI.isWorkbenchRunning() && event.getResult().isOK()) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PreloadingRepositoryHandler.this.doExecute(loadJob);
                                }
                            });
                        }
                    }
                });
                loadJob.setUser(true);
                loadJob.schedule();
            } else {
                loadJob.setSystem(true);
                loadJob.setUser(false);
                loadJob.schedule();
                this.doExecute(null);
            }
        } else {
            this.doExecute(null);
        }
    }

    protected abstract void doExecute(LoadMetadataRepositoryJob var1);

    protected boolean preloadRepositories() {
        return true;
    }

    protected boolean waitForPreload() {
        return true;
    }

    protected void setLoadJobProperties(Job loadJob) {
        loadJob.setProperty(LoadMetadataRepositoryJob.ACCUMULATE_LOAD_ERRORS, (Object)Boolean.toString(true));
    }

    protected ProvisioningUI getProvisioningUI() {
        return ProvisioningUI.getDefaultUI();
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
    }
}

