/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.ui;

import com.kdjsystem.mlink.Yd.common.YDMAPluginUtils;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.HousingDao;
import com.kdjsystem.mlink.Yd.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.Yd.ui.CommandDialog;
import com.kdjsystem.mlink.Yd.ui.InventorySpareRackDetail;
import com.kdjsystem.mlink.Yd.ui.MyColumnHeaderRenderer;
import com.kdjsystem.mlink.Yd.ui.WarehouseProductList;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class InventoryDetailDialog
extends CommandDialog {
    private static final int S = 0;
    public static String TITLE = "\uc0c1\uc138 \uc7ac\uace0\ud604\ud669";
    String[][] column_name = new String[][]{{"No.", "50"}, {"\uc77c  \uc790", "150"}, {"\uae30\ucd08\uc7ac\uace0", "90"}, {"\uc785  \uace0", "150"}, {"\ud310  \ub9e4", "150"}, {"\ucc3d\uace0\uc7ac\uace0", "90"}};
    WarehouseProductList opener;
    public String sDate;
    public String eDate;
    public int selectedIdx = -1;
    public int sumbasicStock;
    public int sumwearing;
    public int sumsale;
    public int sumwarehouseStock;
    String orderListFullPath;
    Composite composite_table;
    public Grid table;
    GridTableViewer tableViewer;
    private DateTime dt_recvsuppTo;
    private DateTime dt_recvsuppFrom;
    private Text txt_prodcd;
    private Text txt_prodnm;
    public String prodcd;
    public String prodnm;
    public String maxDate;
    private Label lblNewLabel;
    private Grid grid;
    private GridTableViewer gridTableViewer;
    GridTableViewer tableViewer2;
    Grid table2;
    GridColumn tableViewerColumn_sumbasicStock;
    GridColumn tableViewerColumn_sumwearing;
    GridColumn tableViewerColumn_sumsale;
    GridColumn tableViewerColumn_sumwarehouseStock;
    private Button btn_excell;
    private Label lblNewLabel_2;
    int brandcd;
    private Button btn_cancel;

    public InventoryDetailDialog(Shell parentShell, WarehouseProductList opener, String maxDate, String prodcd, String prodnm, int brandcd) {
        super(parentShell);
        this.setShellStyle(0x870 | InventoryDetailDialog.getDefaultOrientation());
        this.opener = opener;
        this.brandcd = brandcd;
        this.prodcd = prodcd;
        this.prodnm = prodnm;
        this.maxDate = maxDate;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite_1 = new Composite(container, 0);
        GridLayout gl_composite_1 = new GridLayout(8, false);
        composite_1.setLayout((Layout)gl_composite_1);
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_1 = new Label(composite_1, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_1.setText("\uc7ac\uace0\uc218\uc9d1\uc77c");
        this.dt_recvsuppFrom = new DateTime(composite_1, 2048);
        this.lblNewLabel = new Label(composite_1, 0);
        this.lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblNewLabel.setText("~");
        this.dt_recvsuppTo = new DateTime(composite_1, 2048);
        Button btn_search_order = new Button(composite_1, 0);
        btn_search_order.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InventoryDetailDialog.this.getInventoryDetailList();
            }
        });
        GridData gd_btn_search_order = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_search_order.heightHint = 25;
        btn_search_order.setLayoutData((Object)gd_btn_search_order);
        btn_search_order.setBounds(0, 0, 93, 30);
        btn_search_order.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.Yd", "icons/N\uac80\uc0c9.png"));
        this.txt_prodcd = new Text(composite_1, 2048);
        this.txt_prodcd.setEnabled(false);
        this.txt_prodcd.setEditable(false);
        GridData gd_txt_prodcd = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_txt_prodcd.heightHint = 17;
        gd_txt_prodcd.widthHint = 76;
        this.txt_prodcd.setLayoutData((Object)gd_txt_prodcd);
        this.txt_prodcd.setBounds(0, 0, 73, 26);
        this.txt_prodnm = new Text(composite_1, 2048);
        this.txt_prodnm.setEnabled(false);
        this.txt_prodnm.setEditable(false);
        GridData gd_txt_prodnm = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_txt_prodnm.heightHint = 17;
        gd_txt_prodnm.widthHint = 163;
        this.txt_prodnm.setLayoutData((Object)gd_txt_prodnm);
        this.composite_table = new Composite(container, 0);
        this.composite_table.setBackground(SWTResourceManager.getColor(15));
        GridLayout gl_composite_table = new GridLayout(1, false);
        gl_composite_table.verticalSpacing = 0;
        gl_composite_table.marginWidth = 0;
        gl_composite_table.marginHeight = 0;
        this.composite_table.setLayout((Layout)gl_composite_table);
        this.composite_table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.composite_table.setBounds(0, 0, 64, 64);
        this.gridTableViewer = new GridTableViewer(this.composite_table, 770);
        this.grid = this.gridTableViewer.getGrid();
        this.grid.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.gridTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                InventoryDetailDialog.this.openSpareRack();
            }
        });
        this.grid.setLinesVisible(true);
        this.grid.setLineColor(SWTResourceManager.getColor(18));
        this.grid.setHeaderVisible(true);
        this.grid.setFont(SWTResourceManager.getFont(".AppleSystemUIFont", 10, 0));
        this.grid.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setBGC(14);
        myHeaderRender.setFGC(1);
        int i = 0;
        while (i < this.column_name.length) {
            String[] column = this.column_name[i];
            GridColumn tableViewerColumn_x = new GridColumn(this.grid, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setWidth(Integer.parseInt(column[1]));
            tableViewerColumn_x.setText(column[0]);
            ++i;
        }
        Composite composite_sub = new Composite(container, 2048);
        GridLayout gl_composite_sub = new GridLayout(2, false);
        gl_composite_sub.verticalSpacing = 0;
        gl_composite_sub.marginWidth = 0;
        gl_composite_sub.marginHeight = 0;
        gl_composite_sub.horizontalSpacing = 0;
        composite_sub.setLayout((Layout)gl_composite_sub);
        GridData gd_composite_sub = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_composite_sub.heightHint = 30;
        gd_composite_sub.widthHint = 200;
        composite_sub.setLayoutData((Object)gd_composite_sub);
        this.tableViewer2 = new GridTableViewer(composite_sub, 66306);
        this.table2 = this.tableViewer2.getGrid();
        this.table2.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.table2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.table2.setLinesVisible(true);
        this.table2.setLineColor(SWTResourceManager.getColor(18));
        this.table2.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender2 = new MyColumnHeaderRenderer();
        myHeaderRender2.setBGC(14);
        myHeaderRender2.setFGC(1);
        GridColumn tableViewerColumn_x = new GridColumn(this.table2, 0x1000000);
        tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender2);
        tableViewerColumn_x.setWidth(Integer.parseInt(this.column_name[0][1]) + Integer.parseInt(this.column_name[1][1]));
        tableViewerColumn_x.setText("\ud569\uacc4");
        this.tableViewerColumn_sumbasicStock = new GridColumn(this.table2, 0x1000000);
        this.tableViewerColumn_sumbasicStock.setWidth(Integer.parseInt(this.column_name[2][1]));
        this.tableViewerColumn_sumbasicStock.setText(Integer.toString(this.sumbasicStock));
        this.tableViewerColumn_sumwearing = new GridColumn(this.table2, 0x1000000);
        this.tableViewerColumn_sumwearing.setWidth(Integer.parseInt(this.column_name[3][1]));
        this.tableViewerColumn_sumwearing.setText(Integer.toString(this.sumwearing));
        this.tableViewerColumn_sumsale = new GridColumn(this.table2, 0x1000000);
        this.tableViewerColumn_sumsale.setWidth(Integer.parseInt(this.column_name[4][1]));
        this.tableViewerColumn_sumsale.setText(Integer.toString(this.sumsale));
        this.tableViewerColumn_sumwarehouseStock = new GridColumn(this.table2, 0x1000000);
        this.tableViewerColumn_sumwarehouseStock.setWidth(Integer.parseInt(this.column_name[5][1]));
        this.tableViewerColumn_sumwarehouseStock.setText(Integer.toString(this.sumwarehouseStock));
        new Label(composite_sub, 0);
        new Label(composite_sub, 0);
        new Label(composite_sub, 0);
        new Label(composite_sub, 0);
        new Label(composite_sub, 0);
        this.gridTableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.gridTableViewer.setLabelProvider((IBaseLabelProvider)new MyLableProvider());
        this.txt_prodcd.setText(this.prodcd);
        this.txt_prodnm.setText(this.prodnm);
        this.btn_excell = new Button(composite_1, 0);
        GridData gd_btn_excell = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_excell.heightHint = 25;
        this.btn_excell.setLayoutData((Object)gd_btn_excell);
        this.btn_excell.setText("\uc5d1\uc140\uc800\uc7a5");
        this.btn_excell.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.Yd", "icons/N\uc5d1\uc140\uc800\uc7a5.png"));
        this.lblNewLabel_2 = new Label(container, 0);
        GridData gd_lblNewLabel_2 = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_2.heightHint = 24;
        this.lblNewLabel_2.setLayoutData((Object)gd_lblNewLabel_2);
        this.lblNewLabel_2.setText("\u203b \ub799 \uc704\uce58\ud655\uc778\uc2dc\uc5d0\ub294 \uc785\uace0\ubd80\ubd84\uc5d0 \uc7ac\uace0\uac00 \uc788\ub294\uc81c\ud488\uc744 \ub354\ube14\ud074\ub9ad\uc2dc \uc0c1\uc138\ud654\uba74\uc774 \ub098\uc624\ub2c8 \ucc38\uace0\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
        this.btn_excell.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InventoryDetailDialog.this.saveAsExcel();
            }
        });
        this.setDefaultDate();
        this.getInventoryDetailList();
        return container;
    }

    public String[] setDefaultDate() {
        String[] days = YDMATimeUtil.getZMonthBaseStkDay(1, "yyyyMMdd", this.maxDate);
        int yearCurrnet = Integer.valueOf(days[0].substring(0, 4));
        int monCurrnet = Integer.valueOf(days[0].substring(4, 6));
        int dayCurrnet = Integer.valueOf(days[0].substring(6, 8));
        this.dt_recvsuppTo.setYear(yearCurrnet);
        this.dt_recvsuppTo.setMonth(monCurrnet - 1);
        this.dt_recvsuppTo.setDay(dayCurrnet);
        int yearOff = Integer.valueOf(days[1].substring(0, 4));
        int monOff = Integer.valueOf(days[1].substring(4, 6));
        int dayOff = Integer.valueOf(days[1].substring(6, 8));
        this.dt_recvsuppFrom.setYear(yearOff);
        this.dt_recvsuppFrom.setMonth(monOff - 1);
        this.dt_recvsuppFrom.setDay(dayOff);
        this.sDate = days[1];
        this.eDate = days[0];
        return days;
    }

    void setRorddtByCutomer() {
    }

    private void getInventoryDetailList() {
        try {
            this.sDate = YDMATimeUtil.getClaimmDate(this.dt_recvsuppFrom);
            this.eDate = YDMATimeUtil.getClaimmDate(this.dt_recvsuppTo);
            HousingDao dao = new HousingDao();
            List<List<String>> contents = dao.getInventoryDetail(this.prodcd, this.sDate, this.eDate, this.brandcd);
            this.gridTableViewer.setInput(null);
            this.gridTableViewer.setInput(contents);
            this.gridTableViewer.refresh();
            this.sumbasicStock = this.getSumOfbasicStock(contents);
            this.sumwearing = this.getSumOfwearing(contents);
            this.sumsale = this.getSumOfsale(contents);
            this.sumwarehouseStock = this.getSumOfwarehouseStock(contents);
            this.updateColumnGirdHeader(this.sumbasicStock, this.sumwearing, this.sumsale, this.sumwarehouseStock);
            this.tableViewer2.refresh();
            if (contents == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc870\uac74\uc5d0 \ub9de\ub294 \uac70\ub798\ub0b4\uc5ed\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    protected void openSpareRack() {
        String prodcd = this.txt_prodcd.getText();
        int selectedIdx = this.grid.getSelectionIndex();
        List list = (List)((List)this.gridTableViewer.getInput()).get(selectedIdx);
        if (((String)list.get(3)).equals("0")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc785\uace0\uc5d0 \uc7ac\uace0\uac00 \uc788\ub294\uc77c\uc790\ub97c \ud074\ub9ad\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
            return;
        }
        InventorySpareRackDetail d = new InventorySpareRackDetail(this.getShell(), this.opener, prodcd, (String)list.get(1), (String)list.get(3));
        d.open();
    }

    public int getSumOfbasicStock(List<List<String>> contents) {
        int sumbasicStock = 0;
        for (List<String> list : contents) {
            sumbasicStock += Integer.parseInt(list.get(2));
        }
        return sumbasicStock;
    }

    public int getSumOfwearing(List<List<String>> contents) {
        int sumwearing = 0;
        for (List<String> list : contents) {
            sumwearing += Integer.parseInt(list.get(3));
        }
        return sumwearing;
    }

    public int getSumOfsale(List<List<String>> contents) {
        int sumsale = 0;
        for (List<String> list : contents) {
            sumsale += Integer.parseInt(list.get(4));
        }
        return sumsale;
    }

    public int getSumOfwarehouseStock(List<List<String>> contents) {
        int sumwarehouseStock = 0;
        sumwarehouseStock = this.sumbasicStock + this.sumwearing - this.sumsale;
        return sumwarehouseStock;
    }

    public void updateColumnGirdHeader(int sumbasicStock, int sumwearing, int sumsale, int sumwarehouseStock) {
        this.tableViewerColumn_sumbasicStock.setText(Integer.toString(sumbasicStock));
        this.tableViewerColumn_sumwearing.setText(Integer.toString(sumwearing));
        this.tableViewerColumn_sumsale.setText(Integer.toString(sumsale));
        this.tableViewerColumn_sumwarehouseStock.setText(Integer.toString(sumwarehouseStock));
    }

    private void saveAsExcel() {
        if (this.gridTableViewer.getInput() == null || ((List)this.gridTableViewer.getInput()).size() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5d1\uc140\ud30c\uc77c\ub85c \uc800\uc7a5\ud560 \uc8fc\ubb38\ub0b4\uc5ed\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        FileDialog fileSelectionDialog = MyDataManagerFactory.createExcelFileSaveDialog();
        String fileSavePath = fileSelectionDialog.open();
        if (fileSavePath == null) {
            return;
        }
        try {
            this.printWarePeriodProdList(fileSavePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    private int printWarePeriodProdList(String fileSavePath) throws Exception {
        List sheetContents = (List)this.gridTableViewer.getInput();
        String newfile = fileSavePath;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFColor color_fail = new XSSFColor();
        color_fail.setIndexed((int)IndexedColors.RED.getIndex());
        XSSFColor color_pass = new XSSFColor();
        color_pass.setIndexed((int)IndexedColors.BLUE.getIndex());
        XSSFColor color_normal = new XSSFColor();
        color_normal.setIndexed((int)IndexedColors.WHITE.getIndex());
        XSSFCellStyle cs_left = workbook.createCellStyle();
        cs_left.setAlignment((short)1);
        cs_left.setFillForegroundColor(color_normal);
        cs_left.setFillPattern((short)1);
        XSSFCellStyle cs_right = workbook.createCellStyle();
        cs_right.setAlignment((short)3);
        cs_right.setFillForegroundColor(color_normal);
        cs_right.setFillPattern((short)1);
        XSSFCellStyle cs_center = workbook.createCellStyle();
        cs_center.setAlignment((short)2);
        cs_center.setFillForegroundColor(color_normal);
        cs_center.setFillPattern((short)1);
        XSSFSheet sheet = workbook.createSheet("\uc7ac\uace0\ud604\ud669\uc0c1\uc138");
        if (sheet == null) {
            return -1;
        }
        Row row_head = sheet.createRow(0);
        int i = 0;
        while (i < this.column_name.length) {
            Cell cell = row_head.createCell(i);
            cell.setCellValue(this.column_name[i][0]);
            sheet.setColumnWidth(i, Integer.parseInt(this.column_name[i][1]) * 10 * 3);
            cell.setCellStyle((CellStyle)cs_center);
            ++i;
        }
        int rowIdx = 1;
        for (List rowContents : sheetContents) {
            Row row = sheet.createRow(rowIdx);
            int i2 = 0;
            while (i2 < this.column_name.length) {
                Cell cell = row.createCell(i2);
                String value = (String)rowContents.get(i2);
                cell.setCellValue(value);
                if (i2 == 1 || i2 == 2 || i2 == 3) {
                    cell.setCellStyle((CellStyle)cs_left);
                } else {
                    cell.setCellStyle((CellStyle)cs_center);
                }
                ++i2;
            }
            ++rowIdx;
        }
        FileOutputStream fileOut = new FileOutputStream(newfile);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
        YDMAStringUtil.Print(String.valueOf(newfile) + "\uc7ac\uace0\ud604\ud669\uc0c1\uc138 \uc0dd\uc131 \uc885\ub8cc");
        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)("\uc7ac\uace0\ud604\ud669\uc0c1\uc138\uc744 \uc5d1\uc140\ud30c\uc77c\ub85c \uc800\uc7a5\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + fileSavePath));
        return 0;
    }

    protected void okPressed() {
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.Yd", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        YDMAPluginUtils.getMonitorSize();
        return new Point(748, 668);
    }

    class MyContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class MyLableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = "";
            List rowContent = (List)element;
            value = (String)rowContent.get(columnIndex);
            if (columnIndex == 1) {
                value = YDMATimeUtil.convertSabangNetClaimDateToClmdt(value, false);
            }
            return value;
        }

        public Color getBackground(Object element, int columnIndex) {
            return SWTResourceManager.getColor(1);
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

