/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.ui;

import com.kdjsystem.mlink.Yd.ui.ProcdParseDialog;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;

public class ProdcdParserThread
extends Thread {
    ProcdParseDialog opener;
    private ProgressBar progressBar;
    List<List<String>> origin_Contents;

    public ProdcdParserThread(ProcdParseDialog opener, ProgressBar progressBar, List<List<String>> data) {
        this.progressBar = progressBar;
        this.opener = opener;
        this.origin_Contents = data;
    }

    @Override
    public void run() {
        int x = 0;
        for (List<String> order : this.origin_Contents) {
            this.parse(order);
            this.updateGUIInProgress(x++, this.origin_Contents.size());
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.updateGUIWhenFinish();
    }

    private void parse(final List<String> order) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String data_k = (String)order.get(10);
                String data_r = (String)order.get(18);
                String data_s = (String)order.get(19);
                boolean flag = false;
                if (!flag && data_k.length() >= 5) {
                    flag = ProdcdParserThread.this.analyze(data_k, order);
                }
                if (!flag && data_r.length() >= 5) {
                    flag = ProdcdParserThread.this.analyze(data_r, order);
                }
                if (!flag && data_s.length() >= 5) {
                    flag = ProdcdParserThread.this.analyze(data_s, order);
                }
            }
        });
    }

    private boolean analyze(String cellStr, List<String> order) {
        if (cellStr != null && cellStr.length() < 5) {
            return false;
        }
        if (!cellStr.contains("(") || !cellStr.contains(")")) {
            return false;
        }
        boolean flag = false;
        int beginIndex = cellStr.indexOf("(");
        int endIndex = cellStr.indexOf(")");
        if (endIndex - beginIndex - 1 >= 5) {
            String parsedStr = cellStr.substring(beginIndex + 1, endIndex);
            if (this.isEng(parsedStr)) {
                order.set(11, parsedStr);
                order.set(order.size() - 1, "F");
                flag = true;
            } else {
                flag = this.analyze(cellStr.substring(endIndex + 1), order);
            }
        } else {
            flag = this.analyze(cellStr.substring(endIndex + 1), order);
        }
        return flag;
    }

    private boolean isEng(String str) {
        boolean isEng = false;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '~' || ch == '!' || ch == '@' || ch == '#' || ch == '$' || ch == '%' || ch == '^' || ch == '&' || ch == '*' || ch == '-' || ch == '+' || ch == '-' || ch == '`' || ch == '_' || ch == '?' || ch == '/' || ch == '{' || ch == '}' || ch == '[' || ch == ']' || ch == '|' || ch == '=' || ch == '\\' || ch == '\'' || ch == ':' || ch == ';' || ch == '\"')) {
                return false;
            }
            isEng = true;
            ++i;
        }
        return isEng;
    }

    private void updateGUIWhenFinish() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProdcdParserThread.this.progressBar.setSelection(0);
                ProdcdParserThread.this.progressBar.setMaximum(1);
                ProdcdParserThread.this.opener.close();
            }
        });
    }

    private void updateGUIInProgress(final int value, final int count) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProdcdParserThread.this.progressBar.setMaximum(count);
                ProdcdParserThread.this.progressBar.setSelection(value);
            }
        });
    }
}

