/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.DBCPInit;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShopWorkDao {
    private static ShopWorkDao daoInstance = new ShopWorkDao();
    Map<String, String> mapAddrList = new HashMap<String, String>();

    private ShopWorkDao() {
    }

    public static ShopWorkDao get() {
        return daoInstance;
    }

    public void setWorkListInsert(List<ShopProductDto> prodList, ShopProductAdditionDto shopProductAdditionDto, ShoppingMallDetailDto shoppingMallDetailDto, String \uc0c1\ud488\ub4f1\ub85d, String \ub300\uae30) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO workmngr\r\n (WORKGRP,WORKSEQ, SHOPCD, COMPNO, WORKCD, WORKDETCD, INSERTID, WORKDATEFROM, WORKDATETO, WORKDLAPSED, WORKSTATS, WORKCURRRATE, WORKMESSAGE, WORKLOG, \r\n  PRODSEQ, SHOPSEQ, USER_ID, ADDRSEQ, SHOPCATNO ) \r\n VALUES(?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  \t   ?, ?, ?, ?, ? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopProductDto dto : prodList) {
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, dto.getWorkgrp());
                    pstmt.setString(++rowIdx, dto.getWorkseq());
                    pstmt.setString(++rowIdx, shoppingMallDetailDto.getShopcd());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++rowIdx, \uc0c1\ud488\ub4f1\ub85d);
                    pstmt.setString(++rowIdx, \ub300\uae30);
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? YDMATimeUtil.getCurrentTimeByYDFormat() : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "0" : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "1\uac74\uc2e4\ud328" : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "100%" : "0%");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, dto.getResult_text());
                    pstmt.setString(++rowIdx, dto.getProdseq());
                    pstmt.setString(++rowIdx, shoppingMallDetailDto.getShopseq());
                    pstmt.setString(++rowIdx, shoppingMallDetailDto.getShoppingid());
                    pstmt.setString(++rowIdx, shopProductAdditionDto.getSeq());
                    pstmt.setString(++rowIdx, dto.getShopCatInDto() == null ? "0" : dto.getShopCatInDto().getShopcatno());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setWorkListInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int getMultiThreadCnt() throws Exception {
        int result = 1;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(SUGGPROCNT,'0')    from systemconf   where compno=? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getsystemconf]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void setSchProdinfoDelete() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "truncate table SCH_PRODINFO";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[setSchProdinfoDelete]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void setSchProdinfoInsert(List<ShopProductDto> Prods) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO SCH_PRODINFO(PRODSEQ) VALUES(?) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopProductDto dto : Prods) {
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, dto.getCompayny_goods_cd());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setSchProdinfoInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }
}

