/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.kakaostore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopKakaoStoreAdditionalDto;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.kakaostore.KakaoStoreProductDto;
import com.kdjsystem.mlink.shop.data.kakaostore.ShopKakaoStoreUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreProductModifyService
extends IProductModifyStatusApi {
    private static final String Host = "https://kapi.kakao.com";
    List<ShopOptionDto> options;

    @Override
    public boolean deleteProduct(ShopProductDto shopProductDto) throws Exception {
        return false;
    }

    private void setProductStop(String status, ShoppingMallDetailDto shoppingMallDetailDto, ShopProductDto shopProductDto, ShopProductAdditionDto dtllist, ShopProductSendDto shopProductSendDto) throws Exception {
        String body = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/update").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getApikey()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("productId", shopProductDto.getShopprodno()).data("saleStatus", "OFF").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            if (object.has("productId")) {
                shopProductDto.setResult_code("1");
            } else {
                shopProductDto.setResult_code("-1");
                shopProductDto.setResult_text(body);
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(body);
            if (e.getMessage().equals("HTTP error fetching URL")) {
                throw new Exception("\uc774\ubbf8 \ud310\ub9e4\uc911\uc9c0 \ub41c \uc0c1\ud488\uc785\ub2c8\ub2e4. \uc1fc\ud551\ubab0\uc5d0\uc11c \uc9c1\uc811 \uc0ad\uc81c\ud574\uc8fc\uc138\uc694.");
            }
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    private String iSExistsProdNo(String prodNo, Map<String, String> loginCookies) {
        return null;
    }

    private String setProductReg(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest productRequest = new KakaoStoreProductDto.ProdRequest.ProductRequest();
            this.setProductName(dto, dtllist, productRequest);
            this.setCategory(dto, productRequest, shoppingMallDetailDto, dtllist);
            this.setCert(dto, productRequest);
            this.setModel(dtllist, productRequest);
            this.setDelivery(dto, dtllist, productRequest);
            this.setDiscount(dtllist, productRequest);
            this.setShareDiscount(dtllist, productRequest);
            this.setGroupDiscount(dtllist, productRequest);
            this.setMaxNMinsetting(dtllist, productRequest);
            this.setMinorPurchasable(dto, dtllist, productRequest);
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            resultMarketPrice = this.setSaleCost(dto, dtllist, resultMarketPrice, productRequest);
            this.setOption(dto, dtllist, resultMarketPrice, productRequest);
            this.setImageRemark(dto, dtllist, shoppingMallDetailDto, strImages, productRequest);
            this.setOrigin(dto, dtllist, productRequest);
            this.setNotice(dto, dtllist, productRequest);
            productRequest.productId = dto.getShopprodno();
            productRequest.storeManagementCode = dto.getCompayny_goods_cd();
            productRequest.taxType = dtllist.getTax();
            productRequest.displayStatus = dtllist.getDisplaystatus();
            productRequest.productCondition = dtllist.getProdcondition();
            productRequest.plusFriendSubscriberExclusive = dtllist.getPlusfriend().equals("true");
            productRequest.shoppingHowDisplayable = dtllist.getShophowdisplayable().equals("true");
            productRequest.useSalePeriod = dtllist.getSaleperiod().equals("Y");
            if (dtllist.getSaleperiod().equals("Y")) {
                KakaoStoreProductDto.ProdRequest.ProductRequest.Period salePeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.Period();
                salePeriod.from = YDMATimeUtil.getCurrentTime();
                salePeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getSalefrom()).replaceAll("-", "").concat("235959");
                productRequest.salePeriod = salePeriod;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productRequest);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private void setProductName(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String value = "";
        try {
            switch (dtllist.getProdnmoutput()) {
                case "1": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    value = dto.getModel_nm();
                    break;
                }
                case "3": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmaddfront().equals("")) {
                value = dtllist.getProdnmaddfront().concat(value);
            }
            if (!dtllist.getProdnmaddback().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmaddback());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 69);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            if (dtllist.getProdnmedit().equals("Y")) {
                value = value.replaceAll("[@|#|$|^|{|}|\u00a7|\u203b|\u2606|\u2605|\u266a|\u321c|\u2122|;|\uff06|-|\uff0a|:|`|<|>|\u2191|\u2192|\u2193|\u00b7|\u2103|\u339d|\u3396|\u2665|\u2661|&]", "");
            }
            if (dto.getProdnmlenyn().equals("Y") && value.length() > 138) {
                value = value.substring(0, 130);
            }
            productRequest.name = value;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCategory(ShopProductDto dto, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest, ShoppingMallDetailDto shoppingMallDetailDto, ShopKakaoStoreAdditionalDto dtllist) throws Exception {
        String cateNum = "";
        try {
            if (dtllist.getIsCategory().equals("1")) {
                cateNum = dtllist.getShopcatno();
            } else {
                if (dto.getShopCid() == null || dto.getShopCid().equals("")) {
                    throw new Exception("\ud574\ub2f9\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \ucf54\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                cateNum = dto.getShopCid();
            }
            productRequest.categoryId = cateNum;
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCert(ShopProductDto dto, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Cert> certs = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Cert>();
            String certTypeVal = dto.getCert_type();
            List<Object> result = new ArrayList<String>();
            if (certTypeVal.equals("0")) {
                result.add("NOT_APPLICABLE");
            } else if (certTypeVal.equals("1")) {
                String certVal = dto.getCert();
                String certTypeCode = dto.getCertno();
                result = this.setCertTypeAndCertCode(certVal, certTypeCode);
            } else if (certTypeVal.equals("2")) {
                result.add("DETAIL_REF");
            }
            if (result.get(0) != null) {
                KakaoStoreProductDto.ProdRequest.ProductRequest.Cert cert = new KakaoStoreProductDto.ProdRequest.ProductRequest.Cert();
                cert.certType = (String)result.get(0);
                if (result.size() > 1 && !((String)result.get(1)).equals("")) {
                    cert.certCode = (String)result.get(1);
                }
                certs.add(cert);
                productRequest.certs = certs;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<String> setCertTypeAndCertCode(String certVal, String certTypeCode) {
        ArrayList<String> result = new ArrayList<String>();
        String requestedCertType = "";
        String requestedCertCode = "";
        switch (certVal) {
            case "2": {
                requestedCertType = "KC_1";
                requestedCertCode = certTypeCode;
                break;
            }
            case "3": {
                requestedCertType = "KC_5";
                requestedCertCode = certTypeCode;
                break;
            }
            case "4": {
                requestedCertType = "KC_2";
                requestedCertCode = certTypeCode;
                break;
            }
            case "5": {
                requestedCertType = "KC_6";
                requestedCertCode = certTypeCode;
                break;
            }
            case "7": {
                requestedCertType = "FOOD_3";
                requestedCertCode = certTypeCode;
                break;
            }
            case "8": {
                requestedCertType = "FOOD_1";
                requestedCertCode = certTypeCode;
                break;
            }
            case "11": {
                requestedCertType = "FOOD_2";
                requestedCertCode = certTypeCode;
                break;
            }
            case "25": {
                requestedCertType = "FOOD_14";
                requestedCertCode = certTypeCode;
                break;
            }
            case "32": {
                requestedCertType = "KC_3";
                requestedCertCode = certTypeCode;
                break;
            }
            case "34": {
                requestedCertType = "KC_4";
                break;
            }
            case "35": {
                requestedCertType = "KC_7";
                break;
            }
            case "40": {
                requestedCertType = "KC_8";
                requestedCertCode = certTypeCode;
                break;
            }
            case "41": {
                requestedCertType = "KC_9";
                requestedCertCode = certTypeCode;
                break;
            }
            case "42": {
                requestedCertType = "KC_10";
                break;
            }
            case "44": {
                requestedCertType = "ECOLIFE_1";
                requestedCertCode = certTypeCode;
                break;
            }
            case "45": {
                requestedCertType = "ECOLIFE_1";
                requestedCertCode = certTypeCode;
                break;
            }
        }
        result.add(requestedCertType);
        result.add(requestedCertCode);
        return result;
    }

    private void setModel(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            String string = productRequest.modelId = dtllist.getModelid().equals("") ? "" : dtllist.getModelid();
            if (dtllist.getModelid().equals("")) {
                productRequest.brand = dtllist.getBrand().equals("") ? "\uae30\ud0c0" : dtllist.getBrand();
                productRequest.manufacturer = dtllist.getManufacturer().equals("") ? "\uae30\ud0c0" : dtllist.getManufacturer();
            } else {
                productRequest.brand = "";
                productRequest.manufacturer = "";
            }
        }
        catch (Exception exception) {
            throw new Exception("\ubaa8\ub378,\ube0c\ub79c\ub4dc,\uc81c\uc870\uc0ac\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDelivery(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Delivery delivery = new KakaoStoreProductDto.ProdRequest.ProductRequest.Delivery();
            delivery.deliveryMethodType = dtllist.getDelivery();
            delivery.bundleGroupAvailable = dtllist.getBundlegroup().equals("true");
            if (dtllist.getDeliverytype().equals("Y")) {
                if (dto.getDelv_type().equals("1")) {
                    delivery.deliveryFeeType = "FREE";
                    delivery.baseFee = new BigDecimal(0);
                    delivery.deliveryFeePaymentType = "COLLECT";
                } else if (dto.getDelv_type().equals("2")) {
                    delivery.deliveryFeeType = "PAID";
                    delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                    delivery.deliveryFeePaymentType = "COLLECT";
                } else if (dto.getDelv_type().equals("3")) {
                    delivery.deliveryFeeType = "QUANTITY_PAID";
                    delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                    delivery.bundleGroupAvailable = false;
                    delivery.repeatQuantity = new Integer(dto.getDelv_qty());
                    delivery.deliveryFeePaymentType = "PAID";
                } else {
                    delivery.deliveryFeeType = "PAID";
                    delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                    delivery.deliveryFeePaymentType = "PAID";
                }
            } else {
                String deliveryFee = "";
                delivery.deliveryFeeType = dtllist.getDeliveryfeetype();
                delivery.deliveryFeePaymentType = dtllist.getDeliverypaymenttype();
                if (dtllist.getDeliveryfeetype().equals("FREE")) {
                    delivery.baseFee = new BigDecimal(0);
                } else if (dtllist.getDeliveryfeetype().equals("PAID")) {
                    if (dtllist.getBasefee().equals("9999")) {
                        if (!dto.getDelv_cost().equals("0")) {
                            deliveryFee = dto.getDelv_cost();
                        } else {
                            ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                            deliveryFee = systemconf.getDeliverycost();
                        }
                    } else {
                        deliveryFee = dtllist.getBasefee();
                    }
                    delivery.baseFee = new BigDecimal(deliveryFee);
                } else if (dtllist.getDeliveryfeetype().equals("CONDITIONAL_FREE")) {
                    if (dtllist.getBasefee().equals("9999")) {
                        if (!dto.getDelv_cost().equals("0")) {
                            deliveryFee = dto.getDelv_cost();
                        } else {
                            ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                            deliveryFee = systemconf.getDeliverycost();
                        }
                    } else {
                        deliveryFee = dtllist.getBasefee();
                    }
                    delivery.baseFee = new BigDecimal(deliveryFee);
                    delivery.freeConditionalAmount = new BigDecimal(dtllist.getAddbasefee());
                } else if (dtllist.getDeliveryfeetype().equals("QUANTITY_PAID")) {
                    delivery.bundleGroupAvailable = false;
                    delivery.baseFee = new BigDecimal(dtllist.getBasefee());
                    delivery.repeatQuantity = new Integer(dtllist.getAddbasefee());
                }
            }
            delivery.returnDeliveryFee = new BigDecimal(dtllist.getReturndeliveryfee());
            delivery.exchangeDeliveryFee = new BigDecimal(dtllist.getExchangedeliveryfee());
            delivery.shippingAddressId = new Long(dtllist.getShippingaddrid());
            delivery.returnAddressId = new Long(dtllist.getReturnaddrid());
            delivery.asPhoneNumber = dtllist.getAsphonenumber();
            delivery.asGuideWords = dtllist.getAsguidewords();
            delivery.usePickUpDelivery = false;
            delivery.useQuickDelivery = false;
            delivery.useIsolatedAreaNotice = dtllist.getUseisolatedarea().equals("true");
            if (dtllist.getUseisolatedarea().equals("true")) {
                delivery.isolatedAreaNotice = dtllist.getIsolateareanotice();
            }
            if (dtllist.getJjmt_delv_yn().equals("Y")) {
                delivery.availableIsolatedArea = true;
                if (dtllist.getJejuMountYn().equals("Y")) {
                    delivery.useIsolatedAreaFee = true;
                    delivery.jejuAreaAdditionalFee = new BigDecimal(dtllist.getJejuDeliveryFee().equals("") ? "0" : dtllist.getJejuDeliveryFee());
                    delivery.isolatedAreaAdditionalFee = new BigDecimal(dtllist.getMountDeliveryFee().equals("") ? "0" : dtllist.getMountDeliveryFee());
                }
            } else {
                delivery.availableIsolatedArea = false;
            }
            productRequest.delivery = delivery;
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Discount discount = new KakaoStoreProductDto.ProdRequest.ProductRequest.Discount();
            discount.useDiscount = dtllist.getDiscount().equals("true");
            discount.useDiscountPeriod = dtllist.getDiscountperiod().equals("true");
            if (dtllist.getDiscount().equals("true")) {
                discount.type = dtllist.getDiscounttype();
                discount.value = new Integer(dtllist.getDiscountval().equals("") ? null : dtllist.getDiscountval());
                if (dtllist.getDiscountperiod().equals("true")) {
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Discount.Period discountPeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.Discount.Period();
                    discountPeriod.from = YDMATimeUtil.getCurrentTime();
                    discountPeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getDiscountfrom()).replaceAll("-", "").concat("235959");
                    discount.discountPeriod = discountPeriod;
                }
            }
            productRequest.discount = discount;
        }
        catch (Exception exception) {
            throw new Exception("\uc989\uc2dc\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setShareDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest shareDiscount = new KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest();
            shareDiscount.useShareDiscount = dtllist.getSharediscount().equals("true");
            if (dtllist.getSharediscount().equals("true")) {
                shareDiscount.value = new Long(dtllist.getSharediscountval());
                shareDiscount.slotCount = new Integer(dtllist.getSharedslotcnt());
                shareDiscount.useSalePeriod = true;
                KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest.Period discountPeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest.Period();
                discountPeriod.from = YDMATimeUtil.getCurrentTime();
                discountPeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getSharedfrom()).replaceAll("-", "").concat("235959");
                shareDiscount.discountPeriod = discountPeriod;
            } else {
                shareDiscount.value = new Long("0");
                shareDiscount.useSalePeriod = false;
            }
            productRequest.shareDiscount = shareDiscount;
        }
        catch (Exception exception) {
            throw new Exception("\uc18c\ubb38\ub0b4\uba74\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setGroupDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String groupfrom = "";
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest groupDiscount = new KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest();
            groupDiscount.useGroupDiscount = dtllist.getGroupdiscount().equals("true");
            if (dtllist.getGroupdiscount().equals("true")) {
                groupDiscount.price = new BigDecimal(dtllist.getGroupprice());
                groupDiscount.useStock = dtllist.getGroupstockyn().equals("true");
                groupDiscount.stock = new Integer(dtllist.getGroupstock().equals("") ? null : dtllist.getGroupstock());
                KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest.Period period = new KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest.Period();
                period.from = YDMATimeUtil.getCurrentTime();
                groupfrom = dtllist.getGroupfrom().equals("24") ? "1" : (dtllist.getGroupfrom().equals("48") ? "2" : "3");
                period.to = YDMATimeUtil.getSaleEndDt(groupfrom).replaceAll("-", "").concat("235959");
                groupDiscount.period = period;
            } else {
                groupDiscount.price = new BigDecimal(0);
                groupDiscount.useStock = false;
            }
            productRequest.groupDiscount = groupDiscount;
        }
        catch (Exception exception) {
            throw new Exception("\ud1a1\ub51c\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setMaxNMinsetting(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            productRequest.minPurchaseQuantity = new Integer(dtllist.getMinpurchaseqty().equals("") ? "0" : dtllist.getMinpurchaseqty());
            productRequest.maxPurchaseQuantity = new Integer(dtllist.getMaxpurchaseqty().equals("") ? "0" : dtllist.getMaxpurchaseqty());
            productRequest.maxPurchaseQuantityOfBuyer = 999;
        }
        catch (Exception exception) {
            throw new Exception("\ucd5c\ub300,\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setMinorPurchasable(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            productRequest.minorPurchasable = dtllist.getTypeaddi().equals("Y") ? Boolean.valueOf(dto.getAdult().equals("0")) : Boolean.valueOf(true);
        }
        catch (Exception exception) {
            throw new Exception("\uc131\uc778\uc0c1\ud488\uc5ec\ubd80\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice setSaleCost(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ResultMarketPrice resultMarketPrice, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        int deliveryFee = 0;
        long price_cost = YDMAStringUtil.convertToLong(dto.getGoods_cost());
        try {
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = Integer.parseInt(dtllist.getExpprc());
                }
                price_cost += (long)deliveryFee;
            }
            Long salePrice = price_cost;
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            productRequest.salePrice = new BigDecimal(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return resultMarketPrice;
    }

    private void setOption(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ResultMarketPrice resultMarketPrice, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        this.options = this.getProductOptions(dto);
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Option option = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option();
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination> combinations = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination>();
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute> combinationAttributes = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute>();
                for (ShopOptionDto opt : this.options) {
                    String resultOptionValue;
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name name;
                    if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination combination = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination();
                    ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name> names = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name>();
                    List<String> typeLst = Arrays.asList(opt.getName().split(":"));
                    List<String> nameLst = Arrays.asList(opt.getOptspecdes().split(":"));
                    option.type = "COMBINATION";
                    if (typeLst.size() == 3) {
                        combination.usable = true;
                        combination.price = new BigDecimal(opt.getAmt().equals("") ? "0" : opt.getAmt());
                        combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                        combination.managedCode = opt.getOptcompanycd();
                        combination.name = names;
                        combinations.add(combination);
                        int i = 0;
                        while (i < typeLst.size()) {
                            name = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                            resultOptionValue = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(i));
                            name.key = typeLst.get(i);
                            name.value = resultOptionValue;
                            names.add(name);
                            ++i;
                        }
                        continue;
                    }
                    if (typeLst.size() == 2) {
                        combination.usable = true;
                        combination.price = new BigDecimal(opt.getAmt().equals("") ? "0" : opt.getAmt());
                        combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                        combination.managedCode = opt.getOptcompanycd();
                        combination.name = names;
                        combinations.add(combination);
                        int i = 0;
                        while (i < typeLst.size()) {
                            name = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                            resultOptionValue = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(i));
                            name.key = typeLst.get(i);
                            name.value = resultOptionValue;
                            names.add(name);
                            ++i;
                        }
                        continue;
                    }
                    combination.usable = true;
                    combination.price = new BigDecimal(opt.getAmt().equals("") ? "0" : opt.getAmt());
                    combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                    combination.managedCode = opt.getOptcompanycd();
                    combination.name = names;
                    combinations.add(combination);
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name name2 = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                    String resultOptionValue2 = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(0));
                    name2.key = opt.getName();
                    name2.value = resultOptionValue2;
                    names.add(name2);
                }
                option.combinations = combinations;
                Function<List, List> getStr = list -> list.stream().map(p -> String.valueOf(p.key) + ":" + p.value).collect(Collectors.toList());
                List options = combinations.stream().flatMap(p -> ((List)getStr.apply(p.name)).stream()).distinct().collect(Collectors.toList());
                int i = 0;
                while (i < options.size()) {
                    String[] strOption = ((String)options.get(i)).split(":");
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute combinationAttribute = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute();
                    combinationAttribute.name = strOption[0];
                    combinationAttribute.value = ShopKakaoStoreUtil.addText(dtllist, strOption[1]);
                    combinationAttributes.add(combinationAttribute);
                    option.combinationAttributes = combinationAttributes;
                    ++i;
                }
            } else {
                productRequest.stockQuantity = new Integer("999");
                option.type = "NONE";
            }
            productRequest.option = option;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc635\uc158\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private int setOptPrice(ShopKakaoStoreAdditionalDto dtllist, Long salePrice, ShopOptionDto shopOptionDto) throws Exception {
        int amt = YDMAStringUtil.convertToInt(shopOptionDto.getAmt());
        try {
            salePrice = salePrice + YDMAStringUtil.convertToLong(shopOptionDto.getAmt());
            int limit_price = YDMAStringUtil.convertToInt(shopOptionDto.getLimit_price());
            ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            amt = Integer.parseInt(optionprice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return amt;
    }

    private void setImageRemark(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String remark = dto.getGoods_remarks();
        String addDetailPlus = "";
        try {
            remark = dtllist.getProddetailfront().concat(remark);
            remark = remark.concat(dtllist.getProddetailback());
            if (dtllist.getRemarktop().equals("Y")) {
                remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat(remark);
            }
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            productRequest.productDetailDescription = String.valueOf(addDetailPlus) + remark;
            List<String> url = this.getImage(dto, strImages, dtllist, shoppingMallDetailDto);
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage productImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage();
            productImage.imageRatio = "SQUARE";
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.RepresentImage representImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.RepresentImage();
            representImage.url = url.get(0);
            if (url.size() > 1) {
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage> optionalImages = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage>();
                int i = 1;
                while (i < url.size()) {
                    if (i <= 3) {
                        KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage optionalImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage();
                        optionalImage.url = url.get(i);
                        optionalImages.add(optionalImage);
                    }
                    ++i;
                }
                productImage.optionalImages = optionalImages;
            }
            productImage.representImage = representImage;
            productRequest.productImage = productImage;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\uc138\uc124\uba85 \ubc0f \uc774\ubbf8\uc9c0\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String getImagePath(String path, String apikey) throws Exception {
        try {
            Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/store/product/image/check/url?url=" + path)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = response.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            if (jsonObject.get("code").getAsString().equals("ACCEPTED")) {
                this.getImagePath(path, apikey);
            }
            path = jsonObject.get("url").getAsString();
        }
        catch (Exception e) {
            throw new Exception("\uc774\ubbf8\uc9c0 \ubcc0\ud658 \uc624\ub958" + e);
        }
        return path;
    }

    private List<String> getImage(ShopProductDto dto, List<String> strImages, ShopKakaoStoreAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String imgpath;
        JsonObject jsonObject;
        JsonParser jsonParser;
        String body;
        Connection.Response response;
        String fileName;
        String localFilePath;
        Path sourceDirectory;
        String uploadedImageUrl;
        String img;
        ArrayList<String> decodedString = new ArrayList<String>();
        int i = 0;
        while (i < strImages.size()) {
            uploadedImageUrl = img = strImages.get(0);
            if (!img.startsWith("http") && !img.startsWith("https")) {
                sourceDirectory = Paths.get(img, new String[0]);
                localFilePath = sourceDirectory.toString();
                fileName = sourceDirectory.getFileName().toString();
                uploadedImageUrl = ShopCommon.uploadImageToServer(localFilePath, fileName);
            }
            try {
                response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/image/upload/url").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getApikey()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("url", uploadedImageUrl).data("ratio", "SQUARE").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonParser = new JsonParser();
                jsonObject = (JsonObject)jsonParser.parse(body);
                imgpath = jsonObject.get("url").getAsString();
                imgpath = this.getImagePath(imgpath, shoppingMallDetailDto.getApikey());
                decodedString.add(imgpath);
            }
            catch (Exception e) {
                throw new Exception("\ub300\ud45c \uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
            }
            ++i;
        }
        if (dtllist.getAddimage().equals("Y")) {
            i = 1;
            while (i < strImages.size()) {
                uploadedImageUrl = img = strImages.get(i);
                if (!img.startsWith("http") && !img.startsWith("https")) {
                    sourceDirectory = Paths.get(img, new String[0]);
                    localFilePath = sourceDirectory.toString();
                    fileName = sourceDirectory.getFileName().toString();
                    uploadedImageUrl = ShopCommon.uploadImageToServer(localFilePath, fileName);
                }
                try {
                    response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/options/image/upload/url").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getApikey()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("url", String.valueOf(uploadedImageUrl) + ".jpeg").data("type", "OPTION_REPRESENTATION").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                    body = response.body();
                    jsonParser = new JsonParser();
                    jsonObject = (JsonObject)jsonParser.parse(body);
                    imgpath = jsonObject.get("url").getAsString();
                    imgpath = this.getImagePath(imgpath, shoppingMallDetailDto.getApikey());
                    decodedString.add(imgpath);
                }
                catch (Exception e) {
                    throw new Exception("\uc635\uc158 \uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
                }
                ++i;
            }
        }
        return decodedString;
    }

    private void setOrigin(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductOriginAreaInfo productOriginAreaInfo = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductOriginAreaInfo();
            if (dtllist.getOriginyn().equals("N")) {
                productOriginAreaInfo.originAreaType = dtllist.getOriginlagid();
                productOriginAreaInfo.originAreaCode = dtllist.getOriginid();
                productOriginAreaInfo.originAreaContent = dtllist.getOrigin();
            } else {
                productOriginAreaInfo.originAreaContent = dto.getOrigin();
                if (dto.getOrigin().contains("\uad6d\ub0b4") || dto.getOrigin().contains("\ub300\ud55c\ubbfc\uad6d")) {
                    productOriginAreaInfo.originAreaCode = "0002190";
                    productOriginAreaInfo.originAreaType = "LOCAL";
                } else if (dto.getOrigin().contains("\ud574\uc678")) {
                    productOriginAreaInfo.originAreaCode = "0200037";
                    productOriginAreaInfo.originAreaType = "IMPORT";
                } else {
                    productOriginAreaInfo.originAreaCode = "03";
                    productOriginAreaInfo.originAreaType = "USER_INPUT";
                }
            }
            productOriginAreaInfo.registerWithOtherOriginArea = false;
            productRequest.productOriginAreaInfo = productOriginAreaInfo;
        }
        catch (Exception exception) {
            throw new Exception("\uc6d0\uc0b0\uc9c0\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setNotice(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception, JAXBException {
        try {
            String announcementType = ShopProductDao.get().getAttrcd(dto);
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            KakaoStoreProductDto.ProdRequest.ProductRequest.AnnouncementInfo announcementInfo = new KakaoStoreProductDto.ProdRequest.ProductRequest.AnnouncementInfo();
            announcementInfo.announcementType = announcementType;
            List<ShopProdAttrnmDto> kakaoProductAttrList = ShopProductDao.get().getProductKakaoNotice(dto.getProp1_cd(), "shop0273");
            announcementInfo.announcement.put("announcementType", announcementType);
            announcementInfo.announcement.put("ignoreAll", false);
            for (ShopProdAttrnmDto kakaoProduct : kakaoProductAttrList) {
                ShopProdAttrnmDto shopProdAttrnmDtos = dto.getShopProdAttrnmDtos().stream().filter(p -> p.getAttrnm().contains(kakaoProduct.getAttrvl())).findAny().orElse(null);
                if (shopProdAttrnmDtos != null) {
                    if (shopProdAttrnmDtos.getProp_val().equals("")) {
                        shopProdAttrnmDtos.setProp_val("\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                    }
                    if (dtllist.getCollectapplication().equals("Y")) {
                        if (dtllist.getNoticetitleyn().equals("Y")) {
                            announcementInfo.announcement.put(kakaoProduct.getColseq(), String.valueOf(kakaoProduct.getColseq()) + " : \uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                            continue;
                        }
                        announcementInfo.announcement.put(kakaoProduct.getColseq(), "\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                        continue;
                    }
                    if (dtllist.getNoticetitleyn().equals("Y")) {
                        announcementInfo.announcement.put(kakaoProduct.getColseq(), String.valueOf(kakaoProduct.getColseq()) + " : " + shopProdAttrnmDtos.getProp_val());
                        continue;
                    }
                    announcementInfo.announcement.put(kakaoProduct.getColseq(), shopProdAttrnmDtos.getProp_val());
                    continue;
                }
                announcementInfo.announcement.put(kakaoProduct.getColseq(), shopProdAttrnmDtos.getProp_val().equals(null) ? "\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870" : shopProdAttrnmDtos.getProp_val());
            }
            productRequest.announcementInfo = announcementInfo;
        }
        catch (IOException iOException) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4\ub97c \ubd88\ub7ec\uc624\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void DownLoadImage(ShopKakaoStoreAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            if (dtllist.getImageresize().equals("Y")) {
                ShopCommon.downloadImgFile(img, 600, 600);
                Thread.sleep(1000L);
                continue;
            }
            if (dtllist.getImgThreeOnFour().equals("Y")) {
                ShopCommon.downloadImgFile(img, 450, 600);
                Thread.sleep(1000L);
                continue;
            }
            ShopCommon.downloadImgFile(img);
            Thread.sleep(1000L);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean modifyProductStatusDto(ShopProductDto shopProductDto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, String status, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        int cnt = this.getMultithreadCount();
        try {
            int slp = 0;
            shopProductSendDto.getWorkMngDto().getWorkcd();
            switch (status) {
                case "7": 
                case "8": {
                    this.setProductStop(status, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    shopProductDto.setShopprodno("");
                    slp = 2000 * cnt;
                    Thread.sleep(slp);
                    break;
                }
                case "0": {
                    Thread.sleep(1000L);
                    String forbiddenKeywords = shoppingMallDetailDto.getForbiddenKeywords();
                    ArrayList forbiddenKeywordList = forbiddenKeywords != null && !forbiddenKeywords.isEmpty() ? Arrays.asList(forbiddenKeywords.split(",")) : new ArrayList();
                    String productName = shopProductDto.getGoods_nm();
                    for (String keyword : forbiddenKeywordList) {
                        if (!productName.contains(keyword)) continue;
                        throw new Exception("\uc0c1\ud488\uba85\uc5d0 \uae08\uc9c0\ub41c \ud0a4\uc6cc\ub4dc\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4: " + keyword);
                    }
                    ShopKakaoStoreAdditionalDto kakaodtllist = null;
                    kakaodtllist = (ShopKakaoStoreAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    ArrayList<String> strImages = new ArrayList();
                    strImages = this.editProductImage(shopProductDto, kakaodtllist.getChangesize(), kakaodtllist.getChangeSizeX(), kakaodtllist.getChangeSizeY(), kakaodtllist.getChangeSizeW(), kakaodtllist.getChangeSizeH(), kakaodtllist.getAngle(), kakaodtllist.getScalePercent(), kakaodtllist.getImgThreeOnFour(), "", kakaodtllist.getMirrorImgYN(), "", "");
                    this.DownLoadImage(kakaodtllist, shoppingMallDetailDto, strImages);
                    String json = this.setProductReg(shopProductDto, kakaodtllist, shoppingMallDetailDto, strImages);
                    this.productRegSend(json, shopProductDto, shoppingMallDetailDto.getApikey());
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    slp = 5000 * cnt;
                    Thread.sleep(slp);
                    break;
                }
                case "6": {
                    this.setProductStop(status, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    shopProductDto.setShopprodno("");
                    slp = 2000 * cnt;
                    Thread.sleep(slp);
                }
                default: {
                    break;
                }
                case "9": {
                    return true;
                }
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean isExistProdNo(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        String productId;
        block3: {
            productId = "";
            try {
                if (!dto.getShopprodno().equals("")) break block3;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/store/product/store_managed_code?code=" + dto.getCompayny_goods_cd())).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getApikey()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = response.body();
        JsonParser parser = new JsonParser();
        JsonArray jsonArray = (JsonArray)parser.parse(body);
        JsonObject jsonObject = (JsonObject)jsonArray.get(0);
        productId = jsonObject.get("productId").getAsString();
        return !productId.equals("");
    }

    private synchronized void productRegSend(String json, ShopProductDto dto, String apiKey) throws Exception {
        String body = "";
        try {
            Connection.Response response = Jsoup.connect((String)Host.concat("/v1/store/product/update")).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel_ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("product", json).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            dto.setShopprodno(object.get("productId").getAsString());
            if (!dto.getShopprodno().equals("")) {
                dto.setResult_code("1");
            } else {
                dto.setResult_code("-1");
                dto.setResult_text(body);
            }
        }
        catch (Exception e) {
            dto.setResult_code("-1");
            dto.setResult_text(body);
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    private int getMultithreadCount() {
        int cnt;
        try {
            cnt = ShopWorkDao.get().getMultiThreadCnt();
            int cores = Runtime.getRuntime().availableProcessors();
            if (cnt != 1 && cnt > cores / 2) {
                cnt = cores / 2;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return cnt;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    private static class AdminDiscount {
        private String type;
        private boolean useDiscount;
        private boolean useDiscountPeriod;
        private String value;

        private AdminDiscount() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isUseDiscount() {
            return this.useDiscount;
        }

        public void setUseDiscount(boolean useDiscount) {
            this.useDiscount = useDiscount;
        }

        public boolean isUseDiscountPeriod() {
            return this.useDiscountPeriod;
        }

        public void setUseDiscountPeriod(boolean useDiscountPeriod) {
            this.useDiscountPeriod = useDiscountPeriod;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private static class AnnouncementInfo {
        private String announcementType;
        public Map<String, Object> announcement = new HashMap<String, Object>();

        private AnnouncementInfo() {
        }

        public Map<String, Object> addContent(String name, String value) {
            this.announcement.put(name, value);
            return this.announcement;
        }

        public String getAnnouncementType() {
            return this.announcementType;
        }

        public void setAnnouncementType(String announcementType) {
            this.announcementType = announcementType;
        }

        public class Announcement {
            private boolean ignoreAll;
            private List<String> ignoreKeys = new ArrayList<String>();
            public Map<String, String> Announcement = new HashMap<String, String>();

            public Map<String, String> addContent(String name, String value) {
                this.Announcement.put(name, value);
                return this.Announcement;
            }

            public boolean isIgnoreAll() {
                return this.ignoreAll;
            }

            public void setIgnoreAll(boolean ignoreAll) {
                this.ignoreAll = ignoreAll;
            }

            public List<String> getIgnoreKeys() {
                return this.ignoreKeys;
            }

            public void setIgnoreKeys(List<String> ignoreKeys) {
                this.ignoreKeys = ignoreKeys;
            }
        }
    }

    private static class CategorySupplements {
        private String categoryType;
        private Supplement supplement;
        private String id;

        private CategorySupplements() {
        }

        public String getCategoryType() {
            return this.categoryType;
        }

        public void setCategoryType(String categoryType) {
            this.categoryType = categoryType;
        }

        public Supplement getSupplement() {
            return this.supplement;
        }

        public void setSupplement(Supplement supplement) {
            this.supplement = supplement;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    private static class Certs {
        private String certType;
        private String title;
        private String outputType;

        private Certs() {
        }

        public String getCertType() {
            return this.certType;
        }

        public void setCertType(String certType) {
            this.certType = certType;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getOutputType() {
            return this.outputType;
        }

        public void setOutputType(String outputType) {
            this.outputType = outputType;
        }
    }

    private static class CombinationAttributes {
        private String name;
        private String value;
        private String index;
        private String price;
        private OptionImage optionImage;

        private CombinationAttributes() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getPrice() {
            return this.price;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public OptionImage getOptionImage() {
            return this.optionImage;
        }

        public void setOptionImage(OptionImage optionImage) {
            this.optionImage = optionImage;
        }
    }

    private static class Combinations {
        public Map<String, Object> combinatios = new HashMap<String, Object>();

        private Combinations() {
        }

        public Combinations addContent(String name, Object value) {
            this.combinatios.put(name, value);
            return this;
        }
    }

    private static class Data {
        private String animated;
        private String fileSize;
        private String height;
        private String originUrl;
        private String thumbnailUrl;
        private String width;

        private Data() {
        }

        public String getAnimated() {
            return this.animated;
        }

        public void setAnimated(String animated) {
            this.animated = animated;
        }

        public String getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(String fileSize) {
            this.fileSize = fileSize;
        }

        public String getHeight() {
            return this.height;
        }

        public void setHeight(String height) {
            this.height = height;
        }

        public String getOriginUrl() {
            return this.originUrl;
        }

        public void setOriginUrl(String originUrl) {
            this.originUrl = originUrl;
        }

        public String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        public void setThumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
        }

        public String getWidth() {
            return this.width;
        }

        public void setWidth(String width) {
            this.width = width;
        }
    }

    private static class Delivery {
        private String templateId;
        private String deliveryMethodType;
        private boolean bundleGroupAvailable;
        private String deliveryFeeType;
        private String baseFee;
        private String freeConditionalAmount;
        private String repeatQuantity;
        private String deliveryFeePaymentType;
        private String shippingAddressId;
        private String returnAddressId;
        private String returnDeliveryFee;
        private String exchangeDeliveryFee;
        private String asPhoneNumber;
        private String asGuideWords;
        private boolean isIsolatedAreaDeliverable;
        private String isolatedAreaNotice;
        private boolean useIsolatedAreaNotice;
        private boolean isOverseaDirectDeliverable;
        private String recentData;
        private boolean usePickUpDelivery;
        private boolean useQuickDelivery;

        private Delivery() {
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public String getDeliveryMethodType() {
            return this.deliveryMethodType;
        }

        public void setDeliveryMethodType(String deliveryMethodType) {
            this.deliveryMethodType = deliveryMethodType;
        }

        public boolean isBundleGroupAvailable() {
            return this.bundleGroupAvailable;
        }

        public void setBundleGroupAvailable(boolean bundleGroupAvailable) {
            this.bundleGroupAvailable = bundleGroupAvailable;
        }

        public String getDeliveryFeeType() {
            return this.deliveryFeeType;
        }

        public void setDeliveryFeeType(String deliveryFeeType) {
            this.deliveryFeeType = deliveryFeeType;
        }

        public String getBaseFee() {
            return this.baseFee;
        }

        public void setBaseFee(String baseFee) {
            this.baseFee = baseFee;
        }

        public String getFreeConditionalAmount() {
            return this.freeConditionalAmount;
        }

        public void setFreeConditionalAmount(String freeConditionalAmount) {
            this.freeConditionalAmount = freeConditionalAmount;
        }

        public String getRepeatQuantity() {
            return this.repeatQuantity;
        }

        public void setRepeatQuantity(String repeatQuantity) {
            this.repeatQuantity = repeatQuantity;
        }

        public String getDeliveryFeePaymentType() {
            return this.deliveryFeePaymentType;
        }

        public void setDeliveryFeePaymentType(String deliveryFeePaymentType) {
            this.deliveryFeePaymentType = deliveryFeePaymentType;
        }

        public String getShippingAddressId() {
            return this.shippingAddressId;
        }

        public void setShippingAddressId(String shippingAddressId) {
            this.shippingAddressId = shippingAddressId;
        }

        public String getReturnAddressId() {
            return this.returnAddressId;
        }

        public void setReturnAddressId(String returnAddressId) {
            this.returnAddressId = returnAddressId;
        }

        public String getReturnDeliveryFee() {
            return this.returnDeliveryFee;
        }

        public void setReturnDeliveryFee(String returnDeliveryFee) {
            this.returnDeliveryFee = returnDeliveryFee;
        }

        public String getExchangeDeliveryFee() {
            return this.exchangeDeliveryFee;
        }

        public void setExchangeDeliveryFee(String exchangeDeliveryFee) {
            this.exchangeDeliveryFee = exchangeDeliveryFee;
        }

        public String getAsPhoneNumber() {
            return this.asPhoneNumber;
        }

        public void setAsPhoneNumber(String asPhoneNumber) {
            this.asPhoneNumber = asPhoneNumber;
        }

        public String getAsGuideWords() {
            return this.asGuideWords;
        }

        public void setAsGuideWords(String asGuideWords) {
            this.asGuideWords = asGuideWords;
        }

        public boolean isIsolatedAreaDeliverable() {
            return this.isIsolatedAreaDeliverable;
        }

        public void setIsolatedAreaDeliverable(boolean isIsolatedAreaDeliverable) {
            this.isIsolatedAreaDeliverable = isIsolatedAreaDeliverable;
        }

        public String getIsolatedAreaNotice() {
            return this.isolatedAreaNotice;
        }

        public void setIsolatedAreaNotice(String isolatedAreaNotice) {
            this.isolatedAreaNotice = isolatedAreaNotice;
        }

        public boolean isUseIsolatedAreaNotice() {
            return this.useIsolatedAreaNotice;
        }

        public void setUseIsolatedAreaNotice(boolean useIsolatedAreaNotice) {
            this.useIsolatedAreaNotice = useIsolatedAreaNotice;
        }

        public boolean isOverseaDirectDeliverable() {
            return this.isOverseaDirectDeliverable;
        }

        public void setOverseaDirectDeliverable(boolean isOverseaDirectDeliverable) {
            this.isOverseaDirectDeliverable = isOverseaDirectDeliverable;
        }

        public String getRecentData() {
            return this.recentData;
        }

        public void setRecentData(String recentData) {
            this.recentData = recentData;
        }

        public boolean isUsePickUpDelivery() {
            return this.usePickUpDelivery;
        }

        public void setUsePickUpDelivery(boolean usePickUpDelivery) {
            this.usePickUpDelivery = usePickUpDelivery;
        }

        public boolean isUseQuickDelivery() {
            return this.useQuickDelivery;
        }

        public void setUseQuickDelivery(boolean useQuickDelivery) {
            this.useQuickDelivery = useQuickDelivery;
        }
    }

    private static class Discount {
        private boolean useDiscount;
        private String type;
        private boolean useDiscountPeriod;
        private DiscountPeriod discountPeriod;
        private String value;

        private Discount() {
        }

        public boolean isUseDiscount() {
            return this.useDiscount;
        }

        public void setUseDiscount(boolean useDiscount) {
            this.useDiscount = useDiscount;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isUseDiscountPeriod() {
            return this.useDiscountPeriod;
        }

        public void setUseDiscountPeriod(boolean useDiscountPeriod) {
            this.useDiscountPeriod = useDiscountPeriod;
        }

        public DiscountPeriod getDiscountPeriod() {
            return this.discountPeriod;
        }

        public void setDiscountPeriod(DiscountPeriod discountPeriod) {
            this.discountPeriod = discountPeriod;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private static class DiscountPeriod {
        private String from;
        private String to;

        private DiscountPeriod() {
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }

    private static class GroupDiscount {
        private boolean useGroupDiscount;
        private String id;
        private String groupSize;
        private String price;
        private String status;
        private String stock;
        private boolean useStock;
        private boolean hasOngoingRoom;

        private GroupDiscount() {
        }

        public String getGroupSize() {
            return this.groupSize;
        }

        public void setGroupSize(String groupSize) {
            this.groupSize = groupSize;
        }

        public String getPrice() {
            return this.price;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public boolean isUseStock() {
            return this.useStock;
        }

        public void setUseStock(boolean useStock) {
            this.useStock = useStock;
        }

        public boolean isUseGroupDiscount() {
            return this.useGroupDiscount;
        }

        public void setUseGroupDiscount(boolean useGroupDiscount) {
            this.useGroupDiscount = useGroupDiscount;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStock() {
            return this.stock;
        }

        public void setStock(String stock) {
            this.stock = stock;
        }

        public boolean isHasOngoingRoom() {
            return this.hasOngoingRoom;
        }

        public void setHasOngoingRoom(boolean hasOngoingRoom) {
            this.hasOngoingRoom = hasOngoingRoom;
        }
    }

    private static class Images {
        private Images() {
        }
    }

    private static class Info {
        private String length;

        private Info() {
        }

        public String getLength() {
            return this.length;
        }

        public void setLength(String length) {
            this.length = length;
        }
    }

    private static class Liquor {
        private String categoryType;
        private _Supplement supplement;
        private String id;

        private Liquor() {
        }

        public String getCategoryType() {
            return this.categoryType;
        }

        public void setCategoryType(String categoryType) {
            this.categoryType = categoryType;
        }

        public _Supplement getSupplement() {
            return this.supplement;
        }

        public void setSupplement(_Supplement supplement) {
            this.supplement = supplement;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    private static class Notice {
        private List<Result> result;

        private Notice() {
        }

        public List<Result> getResult() {
            return this.result;
        }

        public void setResult(List<Result> result) {
            this.result = result;
        }
    }

    private static class Option {
        private String type;
        private String selectType;
        private int selectTypeCount;
        private int customCount;
        private List<Map<String, Object>> combinations = new ArrayList<Map<String, Object>>();
        private List<CombinationAttributes> combinationAttributes;
        private String combinationSortType;
        private String simpleSortType;
        private List<String> customs;
        private List<String> simples;

        private Option() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSelectType() {
            return this.selectType;
        }

        public void setSelectType(String selectType) {
            this.selectType = selectType;
        }

        public int getSelectTypeCount() {
            return this.selectTypeCount;
        }

        public void setSelectTypeCount(int selectTypeCount) {
            this.selectTypeCount = selectTypeCount;
        }

        public int getCustomCount() {
            return this.customCount;
        }

        public void setCustomCount(int customCount) {
            this.customCount = customCount;
        }

        public List<CombinationAttributes> getCombinationAttributes() {
            return this.combinationAttributes;
        }

        public void setCombinationAttributes(List<CombinationAttributes> combinationAttributes) {
            this.combinationAttributes = combinationAttributes;
        }

        public String getCombinationSortType() {
            return this.combinationSortType;
        }

        public void setCombinationSortType(String combinationSortType) {
            this.combinationSortType = combinationSortType;
        }

        public String getSimpleSortType() {
            return this.simpleSortType;
        }

        public void setSimpleSortType(String simpleSortType) {
            this.simpleSortType = simpleSortType;
        }

        public List<String> getCustoms() {
            return this.customs;
        }

        public void setCustoms(List<String> customs) {
            this.customs = customs;
        }

        public List<String> getSimples() {
            return this.simples;
        }

        public void setSimples(List<String> simples) {
            this.simples = simples;
        }
    }

    private static class OptionImage {
        private OptionImage() {
        }
    }

    private static class OptionalImages {
        private String url;

        private OptionalImages() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    private static class ProductCommission {
        private ProductCommission() {
        }
    }

    private static class ProductImage {
        private String imageRatio;
        private RepresentImage representImage;
        private List<OptionalImages> optionalImages;

        private ProductImage() {
        }

        public String getImageRatio() {
            return this.imageRatio;
        }

        public void setImageRatio(String imageRatio) {
            this.imageRatio = imageRatio;
        }

        public RepresentImage getRepresentImage() {
            return this.representImage;
        }

        public void setRepresentImage(RepresentImage representImage) {
            this.representImage = representImage;
        }

        public List<OptionalImages> getOptionalImages() {
            return this.optionalImages;
        }

        public void setOptionalImages(List<OptionalImages> optionalImages) {
            this.optionalImages = optionalImages;
        }
    }

    private static class ProductOriginAreaInfo {
        private String originAreaContent;
        private String originAreaCode;
        private String originAreaType;
        private boolean registerWithOtherOriginArea;

        private ProductOriginAreaInfo() {
        }

        public String getOriginAreaContent() {
            return this.originAreaContent;
        }

        public void setOriginAreaContent(String originAreaContent) {
            this.originAreaContent = originAreaContent;
        }

        public String getOriginAreaCode() {
            return this.originAreaCode;
        }

        public void setOriginAreaCode(String originAreaCode) {
            this.originAreaCode = originAreaCode;
        }

        public String getOriginAreaType() {
            return this.originAreaType;
        }

        public void setOriginAreaType(String originAreaType) {
            this.originAreaType = originAreaType;
        }

        public boolean isRegisterWithOtherOriginArea() {
            return this.registerWithOtherOriginArea;
        }

        public void setRegisterWithOtherOriginArea(boolean registerWithOtherOriginArea) {
            this.registerWithOtherOriginArea = registerWithOtherOriginArea;
        }
    }

    private static class ProductReg {
        private String saleChannel;
        private AnnouncementInfo announcementInfo;
        private String itemType;
        private boolean booked;
        private String brand;
        private String categoryId;
        private List<CategorySupplements> categorySupplements;
        private List<Certs> certs;
        private Delivery delivery;
        private Discount discount;
        private AdminDiscount adminDiscount;
        private String displayStatus;
        private String gift;
        private GroupDiscount groupDiscount;
        private String manufactureDate;
        private String manufacturer;
        private PurchaseQuantity purchaseQuantity;
        private boolean minorPurchasable;
        private String model;
        private String name;
        private String noticeId;
        private Option option;
        private ProductCommission productCommission;
        private boolean plusFriendSubscriberExclusive;
        private String productCondition;
        private String productDetailDescription;
        private String productId;
        private ProductImage productImage;
        private ProductOriginAreaInfo productOriginAreaInfo;
        private String productSaleStatus;
        private boolean purchaseReviewExposure;
        private String relatedGroupId;
        private String salePrice;
        private ShareDiscount shareDiscount;
        private boolean shoppingHowDisplayable;
        private Stock stock;
        private String storeDomain;
        private String storeId;
        private String storeManagementCode;
        private String storeName;
        private String storeProfileImage;
        private StyleDisplay styleDisplay;
        private boolean talkDisplayable;
        private String taxType;
        private String validDate;
        private String wholeCategoryName;
        private TotalPrice totalPrice;
        private Liquor liquor;
        private String culturalTax;
        private String modelId;
        private boolean useSalePeriod;
        private String bookedDate;
        private String maxPurchaseQuantity;
        private String maxPurchaseQuantityOfBuyer;
        private String minPurchaseQuantity;
        private String stockQuantity;
        private boolean styleDisplayable;
        private _StyleProduct styleProduct;

        private ProductReg() {
        }

        public String getSaleChannel() {
            return this.saleChannel;
        }

        public void setSaleChannel(String saleChannel) {
            this.saleChannel = saleChannel;
        }

        public AnnouncementInfo getAnnouncementInfo() {
            return this.announcementInfo;
        }

        public void setAnnouncementInfo(AnnouncementInfo announcementInfo) {
            this.announcementInfo = announcementInfo;
        }

        public String getItemType() {
            return this.itemType;
        }

        public void setItemType(String itemType) {
            this.itemType = itemType;
        }

        public boolean isBooked() {
            return this.booked;
        }

        public void setBooked(boolean booked) {
            this.booked = booked;
        }

        public String getBrand() {
            return this.brand;
        }

        public void setBrand(String brand) {
            this.brand = brand;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(String categoryId) {
            this.categoryId = categoryId;
        }

        public List<CategorySupplements> getCategorySupplements() {
            return this.categorySupplements;
        }

        public void setCategorySupplements(List<CategorySupplements> categorySupplements) {
            this.categorySupplements = categorySupplements;
        }

        public List<Certs> getCerts() {
            return this.certs;
        }

        public void setCerts(List<Certs> certs) {
            this.certs = certs;
        }

        public Delivery getDelivery() {
            return this.delivery;
        }

        public void setDelivery(Delivery delivery) {
            this.delivery = delivery;
        }

        public Discount getDiscount() {
            return this.discount;
        }

        public void setDiscount(Discount discount) {
            this.discount = discount;
        }

        public AdminDiscount getAdminDiscount() {
            return this.adminDiscount;
        }

        public void setAdminDiscount(AdminDiscount adminDiscount) {
            this.adminDiscount = adminDiscount;
        }

        public String getDisplayStatus() {
            return this.displayStatus;
        }

        public void setDisplayStatus(String displayStatus) {
            this.displayStatus = displayStatus;
        }

        public String getGift() {
            return this.gift;
        }

        public void setGift(String gift) {
            this.gift = gift;
        }

        public GroupDiscount getGroupDiscount() {
            return this.groupDiscount;
        }

        public void setGroupDiscount(GroupDiscount groupDiscount) {
            this.groupDiscount = groupDiscount;
        }

        public String getManufactureDate() {
            return this.manufactureDate;
        }

        public void setManufactureDate(String manufactureDate) {
            this.manufactureDate = manufactureDate;
        }

        public String getManufacturer() {
            return this.manufacturer;
        }

        public void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        public PurchaseQuantity getPurchaseQuantity() {
            return this.purchaseQuantity;
        }

        public void setPurchaseQuantity(PurchaseQuantity purchaseQuantity) {
            this.purchaseQuantity = purchaseQuantity;
        }

        public boolean isMinorPurchasable() {
            return this.minorPurchasable;
        }

        public void setMinorPurchasable(boolean minorPurchasable) {
            this.minorPurchasable = minorPurchasable;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNoticeId() {
            return this.noticeId;
        }

        public void setNoticeId(String noticeId) {
            this.noticeId = noticeId;
        }

        public Option getOption() {
            return this.option;
        }

        public void setOption(Option option) {
            this.option = option;
        }

        public ProductCommission getProductCommission() {
            return this.productCommission;
        }

        public void setProductCommission(ProductCommission productCommission) {
            this.productCommission = productCommission;
        }

        public boolean isPlusFriendSubscriberExclusive() {
            return this.plusFriendSubscriberExclusive;
        }

        public void setPlusFriendSubscriberExclusive(boolean plusFriendSubscriberExclusive) {
            this.plusFriendSubscriberExclusive = plusFriendSubscriberExclusive;
        }

        public String getProductCondition() {
            return this.productCondition;
        }

        public void setProductCondition(String productCondition) {
            this.productCondition = productCondition;
        }

        public String getProductDetailDescription() {
            return this.productDetailDescription;
        }

        public void setProductDetailDescription(String productDetailDescription) {
            this.productDetailDescription = productDetailDescription;
        }

        public String getProductId() {
            return this.productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public ProductImage getProductImage() {
            return this.productImage;
        }

        public void setProductImage(ProductImage productImage) {
            this.productImage = productImage;
        }

        public ProductOriginAreaInfo getProductOriginAreaInfo() {
            return this.productOriginAreaInfo;
        }

        public void setProductOriginAreaInfo(ProductOriginAreaInfo productOriginAreaInfo) {
            this.productOriginAreaInfo = productOriginAreaInfo;
        }

        public String getProductSaleStatus() {
            return this.productSaleStatus;
        }

        public void setProductSaleStatus(String productSaleStatus) {
            this.productSaleStatus = productSaleStatus;
        }

        public boolean isPurchaseReviewExposure() {
            return this.purchaseReviewExposure;
        }

        public void setPurchaseReviewExposure(boolean purchaseReviewExposure) {
            this.purchaseReviewExposure = purchaseReviewExposure;
        }

        public String getRelatedGroupId() {
            return this.relatedGroupId;
        }

        public void setRelatedGroupId(String relatedGroupId) {
            this.relatedGroupId = relatedGroupId;
        }

        public String getSalePrice() {
            return this.salePrice;
        }

        public void setSalePrice(String salePrice) {
            this.salePrice = salePrice;
        }

        public ShareDiscount getShareDiscount() {
            return this.shareDiscount;
        }

        public void setShareDiscount(ShareDiscount shareDiscount) {
            this.shareDiscount = shareDiscount;
        }

        public boolean isShoppingHowDisplayable() {
            return this.shoppingHowDisplayable;
        }

        public void setShoppingHowDisplayable(boolean shoppingHowDisplayable) {
            this.shoppingHowDisplayable = shoppingHowDisplayable;
        }

        public Stock getStock() {
            return this.stock;
        }

        public void setStock(Stock stock) {
            this.stock = stock;
        }

        public String getStoreDomain() {
            return this.storeDomain;
        }

        public void setStoreDomain(String storeDomain) {
            this.storeDomain = storeDomain;
        }

        public String getStoreId() {
            return this.storeId;
        }

        public void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        public String getStoreManagementCode() {
            return this.storeManagementCode;
        }

        public void setStoreManagementCode(String storeManagementCode) {
            this.storeManagementCode = storeManagementCode;
        }

        public String getStoreName() {
            return this.storeName;
        }

        public void setStoreName(String storeName) {
            this.storeName = storeName;
        }

        public String getStoreProfileImage() {
            return this.storeProfileImage;
        }

        public void setStoreProfileImage(String storeProfileImage) {
            this.storeProfileImage = storeProfileImage;
        }

        public StyleDisplay getStyleDisplay() {
            return this.styleDisplay;
        }

        public void setStyleDisplay(StyleDisplay styleDisplay) {
            this.styleDisplay = styleDisplay;
        }

        public boolean isTalkDisplayable() {
            return this.talkDisplayable;
        }

        public void setTalkDisplayable(boolean talkDisplayable) {
            this.talkDisplayable = talkDisplayable;
        }

        public String getTaxType() {
            return this.taxType;
        }

        public void setTaxType(String taxType) {
            this.taxType = taxType;
        }

        public String getValidDate() {
            return this.validDate;
        }

        public void setValidDate(String validDate) {
            this.validDate = validDate;
        }

        public String getWholeCategoryName() {
            return this.wholeCategoryName;
        }

        public void setWholeCategoryName(String wholeCategoryName) {
            this.wholeCategoryName = wholeCategoryName;
        }

        public TotalPrice getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(TotalPrice totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Liquor getLiquor() {
            return this.liquor;
        }

        public void setLiquor(Liquor liquor) {
            this.liquor = liquor;
        }

        public String getCulturalTax() {
            return this.culturalTax;
        }

        public void setCulturalTax(String culturalTax) {
            this.culturalTax = culturalTax;
        }

        public String getModelId() {
            return this.modelId;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public boolean isUseSalePeriod() {
            return this.useSalePeriod;
        }

        public void setUseSalePeriod(boolean useSalePeriod) {
            this.useSalePeriod = useSalePeriod;
        }

        public String getBookedDate() {
            return this.bookedDate;
        }

        public void setBookedDate(String bookedDate) {
            this.bookedDate = bookedDate;
        }

        public String getMaxPurchaseQuantity() {
            return this.maxPurchaseQuantity;
        }

        public void setMaxPurchaseQuantity(String maxPurchaseQuantity) {
            this.maxPurchaseQuantity = maxPurchaseQuantity;
        }

        public String getMaxPurchaseQuantityOfBuyer() {
            return this.maxPurchaseQuantityOfBuyer;
        }

        public void setMaxPurchaseQuantityOfBuyer(String maxPurchaseQuantityOfBuyer) {
            this.maxPurchaseQuantityOfBuyer = maxPurchaseQuantityOfBuyer;
        }

        public String getMinPurchaseQuantity() {
            return this.minPurchaseQuantity;
        }

        public void setMinPurchaseQuantity(String minPurchaseQuantity) {
            this.minPurchaseQuantity = minPurchaseQuantity;
        }

        public String getStockQuantity() {
            return this.stockQuantity;
        }

        public void setStockQuantity(String stockQuantity) {
            this.stockQuantity = stockQuantity;
        }

        public boolean isStyleDisplayable() {
            return this.styleDisplayable;
        }

        public void setStyleDisplayable(boolean styleDisplayable) {
            this.styleDisplayable = styleDisplayable;
        }

        public _StyleProduct getStyleProduct() {
            return this.styleProduct;
        }

        public void setStyleProduct(_StyleProduct styleProduct) {
            this.styleProduct = styleProduct;
        }
    }

    private static class PurchaseQuantity {
        private String maxPurchaseQuantity;
        private String maxPurchaseQuantityOfBuyer;
        private String minPurchaseQuantity;

        private PurchaseQuantity() {
        }

        public String getMaxPurchaseQuantity() {
            return this.maxPurchaseQuantity;
        }

        public void setMaxPurchaseQuantity(String maxPurchaseQuantity) {
            this.maxPurchaseQuantity = maxPurchaseQuantity;
        }

        public String getMaxPurchaseQuantityOfBuyer() {
            return this.maxPurchaseQuantityOfBuyer;
        }

        public void setMaxPurchaseQuantityOfBuyer(String maxPurchaseQuantityOfBuyer) {
            this.maxPurchaseQuantityOfBuyer = maxPurchaseQuantityOfBuyer;
        }

        public String getMinPurchaseQuantity() {
            return this.minPurchaseQuantity;
        }

        public void setMinPurchaseQuantity(String minPurchaseQuantity) {
            this.minPurchaseQuantity = minPurchaseQuantity;
        }
    }

    private static class RepresentImage {
        private String url;

        private RepresentImage() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    private static class Result {
        private String description;
        private Info info;
        private String name;
        private String title;
        private String type;

        private Result() {
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Info getInfo() {
            return this.info;
        }

        public void setInfo(Info info) {
            this.info = info;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    private static class ShareDiscount {
        private boolean useShareDiscount;
        private String id;
        private String productId;
        private String storeId;
        private String value;
        private String slotCount;
        private boolean useStock;
        private String stock;
        private String paymentSupportRate;
        private String storeName;
        private String createdAt;
        private String reviewedAt;
        private boolean isRecreating;
        private String rejectionReason;
        private String discountStatus;
        private DiscountPeriod discountPeriod;

        private ShareDiscount() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getSlotCount() {
            return this.slotCount;
        }

        public void setSlotCount(String slotCount) {
            this.slotCount = slotCount;
        }

        public boolean isUseStock() {
            return this.useStock;
        }

        public void setUseStock(boolean useStock) {
            this.useStock = useStock;
        }

        public String getStock() {
            return this.stock;
        }

        public void setStock(String stock) {
            this.stock = stock;
        }

        public boolean isUseShareDiscount() {
            return this.useShareDiscount;
        }

        public void setUseShareDiscount(boolean useShareDiscount) {
            this.useShareDiscount = useShareDiscount;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProductId() {
            return this.productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public String getStoreId() {
            return this.storeId;
        }

        public void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        public String getPaymentSupportRate() {
            return this.paymentSupportRate;
        }

        public void setPaymentSupportRate(String paymentSupportRate) {
            this.paymentSupportRate = paymentSupportRate;
        }

        public String getStoreName() {
            return this.storeName;
        }

        public void setStoreName(String storeName) {
            this.storeName = storeName;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getReviewedAt() {
            return this.reviewedAt;
        }

        public void setReviewedAt(String reviewedAt) {
            this.reviewedAt = reviewedAt;
        }

        public boolean isRecreating() {
            return this.isRecreating;
        }

        public void setRecreating(boolean isRecreating) {
            this.isRecreating = isRecreating;
        }

        public String getRejectionReason() {
            return this.rejectionReason;
        }

        public void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        public String getDiscountStatus() {
            return this.discountStatus;
        }

        public void setDiscountStatus(String discountStatus) {
            this.discountStatus = discountStatus;
        }
    }

    private static class Stock {
        private String stockQuantity;
        private boolean unlimitedStockQuantity;

        private Stock() {
        }

        public String getStockQuantity() {
            return this.stockQuantity;
        }

        public void setStockQuantity(String stockQuantity) {
            this.stockQuantity = stockQuantity;
        }

        public boolean isUnlimitedStockQuantity() {
            return this.unlimitedStockQuantity;
        }

        public void setUnlimitedStockQuantity(boolean unlimitedStockQuantity) {
            this.unlimitedStockQuantity = unlimitedStockQuantity;
        }
    }

    private static class StyleDisplay {
        private boolean styleDisplayable;
        private StyleProduct styleProduct;

        private StyleDisplay() {
        }

        public boolean isStyleDisplayable() {
            return this.styleDisplayable;
        }

        public void setStyleDisplayable(boolean styleDisplayable) {
            this.styleDisplayable = styleDisplayable;
        }

        public StyleProduct getStyleProduct() {
            return this.styleProduct;
        }

        public void setStyleProduct(StyleProduct styleProduct) {
            this.styleProduct = styleProduct;
        }
    }

    private static class StyleProduct {
        private List<Images> images;
        private String wholeCategoryName;
        private String rejectionReason;
        private boolean resubmit;
        private String status;
        private String styleManagementCode;
        private List<TagIds> tagIds;

        private StyleProduct() {
        }

        public List<Images> getImages() {
            return this.images;
        }

        public void setImages(List<Images> images) {
            this.images = images;
        }

        public String getWholeCategoryName() {
            return this.wholeCategoryName;
        }

        public void setWholeCategoryName(String wholeCategoryName) {
            this.wholeCategoryName = wholeCategoryName;
        }

        public String getRejectionReason() {
            return this.rejectionReason;
        }

        public void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        public boolean isResubmit() {
            return this.resubmit;
        }

        public void setResubmit(boolean resubmit) {
            this.resubmit = resubmit;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStyleManagementCode() {
            return this.styleManagementCode;
        }

        public void setStyleManagementCode(String styleManagementCode) {
            this.styleManagementCode = styleManagementCode;
        }

        public List<TagIds> getTagIds() {
            return this.tagIds;
        }

        public void setTagIds(List<TagIds> tagIds) {
            this.tagIds = tagIds;
        }
    }

    private static class Supplement {
        private String eachCount;

        private Supplement() {
        }

        public String getEachCount() {
            return this.eachCount;
        }

        public void setEachCount(String eachCount) {
            this.eachCount = eachCount;
        }
    }

    private static class TagIds {
        private TagIds() {
        }
    }

    private static class TotalPrice {
        private String price;
        private String rate;

        private TotalPrice() {
        }

        public String getPrice() {
            return this.price;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public String getRate() {
            return this.rate;
        }

        public void setRate(String rate) {
            this.rate = rate;
        }
    }

    private static class UploadImage {
        private String result;
        private Data data;

        private UploadImage() {
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }
    }

    private static class _Images {
        private _Images() {
        }
    }

    private static class _StyleProduct {
        private List<_Images> images;
        private String wholeCategoryName;
        private String rejectionReason;
        private boolean resubmit;
        private String status;
        private String styleManagementCode;
        private List<_TagIds> tagIds;

        private _StyleProduct() {
        }

        public List<_Images> getImages() {
            return this.images;
        }

        public void setImages(List<_Images> images) {
            this.images = images;
        }

        public String getWholeCategoryName() {
            return this.wholeCategoryName;
        }

        public void setWholeCategoryName(String wholeCategoryName) {
            this.wholeCategoryName = wholeCategoryName;
        }

        public String getRejectionReason() {
            return this.rejectionReason;
        }

        public void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        public boolean isResubmit() {
            return this.resubmit;
        }

        public void setResubmit(boolean resubmit) {
            this.resubmit = resubmit;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStyleManagementCode() {
            return this.styleManagementCode;
        }

        public void setStyleManagementCode(String styleManagementCode) {
            this.styleManagementCode = styleManagementCode;
        }

        public List<_TagIds> getTagIds() {
            return this.tagIds;
        }

        public void setTagIds(List<_TagIds> tagIds) {
            this.tagIds = tagIds;
        }
    }

    private static class _Supplement {
        private String eachCount;

        private _Supplement() {
        }

        public String getEachCount() {
            return this.eachCount;
        }

        public void setEachCount(String eachCount) {
            this.eachCount = eachCount;
        }
    }

    private static class _TagIds {
        private _TagIds() {
        }
    }
}

