/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.domaemart;

import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.mlink.MLinkOption;
import com.kdjsystem.mlink.shop.mlink.MLinkOptionList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class DomaemartOrderCommon {
    public static DomaemartOrderCommon instance = new DomaemartOrderCommon();

    private DomaemartOrderCommon() {
    }

    public static DomaemartOrderCommon get() {
        return instance;
    }

    public List<ShopOrderMstDto> getSearchDomaemartProd(Map<String, String> cookies, List<ShopOrderMstDto> list, ChromeDriver driver) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        ChromeDriver js = driver;
        try {
            for (ShopOrderMstDto dto : list) {
                Connection.Response response = Jsoup.connect((String)("https://www.domaemart.com/shop/search.php?skey=" + dto.getCompayny_goods_cd().replaceAll("DMT", ""))).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Origin", "www.domaemart.com").referrer("https://www.domaemart.com/shop/").data("skey", dto.getCompayny_goods_cd().replaceAll("DMT", "")).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                Elements productElements = body.select("ul.sct_ul > li.sct_li");
                for (Element productElement : productElements) {
                    List closeButtonList;
                    String imageUrl = productElement.select("div.sct_img img").attr("src");
                    String productTitle = productElement.select("div.sct_name a").first().text();
                    String productCodeText = ((Element)productElement.select("div.sct_name a").get(1)).text();
                    String productCode = productCodeText.replaceAll("\uc0c1\ud488\ucf54\ub4dc : ", "");
                    String price = productElement.select("div.sct_cost em.cost2").text().replaceAll("[^\\d]", "");
                    dto.setOrdimg(imageUrl);
                    dto.setDsGoods_cost(price);
                    dto.setProduct_name(productTitle);
                    if (productTitle.contains("[\ud488\uc808]")) {
                        dto.setDosinstatus("\ud488\uc808");
                    } else {
                        dto.setDosinstatus("\ud310\ub9e4\uc911");
                    }
                    dto.setGoods_keyword("shop9985");
                    String productDetailUrl = "https://www.domaemart.com/shop/item.php?code=" + productCode + "&ev_code=";
                    driver.get(productDetailUrl);
                    InterruptSource.Thread.sleep((long)2000L);
                    WebElement rightWrap = driver.findElement(By.id((String)"right_wrap"));
                    if (!rightWrap.getAttribute("class").contains("mini") && !(closeButtonList = driver.findElements(By.cssSelector((String)".cart_close a"))).isEmpty()) {
                        WebElement closeButton = (WebElement)closeButtonList.get(0);
                        js.executeScript("arguments[0].click();", new Object[]{closeButton});
                        InterruptSource.Thread.sleep((long)1000L);
                    }
                    StringBuilder options = new StringBuilder();
                    StringBuilder skuBuilder = new StringBuilder();
                    try {
                        List optionTitles = (List)wait.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.xpath((String)"//*[@id='sit_ov']/table/tbody/tr/th[contains(text(), '\uc0c1\ud488\uc120\ud0dd')]")));
                        for (WebElement optionTitleElement : optionTitles) {
                            String optionTitle = optionTitleElement.getText().trim();
                            optionTitleElement.findElement(By.xpath((String)"following-sibling::td"));
                            options.append("[").append(optionTitle).append("]\n");
                            List optionElements = (List)wait.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.tagName((String)"option")));
                            for (WebElement optionElement : optionElements) {
                                String optionValue = optionElement.getText().trim();
                                if (optionValue.contains("\uc120\ud0dd") || optionValue.isEmpty()) continue;
                                options.append(optionValue).append("=").append(price).append("=").append(price).append("=0=0\n");
                            }
                            skuBuilder.append(optionTitle).append(":");
                        }
                        String sku_value = skuBuilder.toString();
                        if (sku_value.endsWith(":")) {
                            sku_value = sku_value.substring(0, sku_value.length() - 1);
                        }
                        dto.setDosinoption(options.toString());
                        dto.setSku_value(sku_value);
                    }
                    catch (TimeoutException timeoutException) {
                        dto.setDosinoption("");
                        dto.setSku_value("\ub2e8\ud488");
                    }
                    this.getDeliveryCost(driver, dto);
                    ret.add(dto);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void getDeliveryCost(ChromeDriver driver, ShopOrderMstDto dto) throws Exception {
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        WebElement deliveryCostElement = (WebElement)wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//th[contains(text(), '\ubc30\uc1a1\ube44')]/following-sibling::td")));
        String deliveryCostText = deliveryCostElement.getText();
        String[] deliveryCostLines = deliveryCostText.split("\n");
        TreeMap<Integer, Integer> deliveryCostMap = new TreeMap<Integer, Integer>();
        String[] stringArray = deliveryCostLines;
        int n = deliveryCostLines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parts;
            String line = stringArray[n2];
            if (line.contains("\uc218\ub7c9 1\uac1c \ub9c8\ub2e4 \ubc30\uc1a1\ube44\ucc45\uc815")) {
                parts = line.split(" ");
                int costPerItem = Integer.parseInt(parts[0].replaceAll("[^0-9]", ""));
                int saleCount = Integer.parseInt(dto.getSale_cnt());
                dto.setDsdelv_cost(String.valueOf(costPerItem * saleCount));
                dto.setDsdelv_type("3");
                dto.setDsdelv_qty(String.valueOf("1"));
                return;
            }
            parts = (line = line.replaceAll("[^0-9 ]", " ").replaceAll(" +", " ").replaceAll("\uc6d0", "").trim()).split(" ");
            if (parts.length >= 4) {
                try {
                    Integer.parseInt(parts[0]);
                    int maxCount = Integer.parseInt(parts[1]);
                    int cost = Integer.parseInt(String.valueOf(parts[2]) + parts[3].replace(",", ""));
                    deliveryCostMap.put(maxCount, cost);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        int saleCount = Integer.parseInt(dto.getSale_cnt());
        int deliveryCost = 0;
        int deliveryUnit = 0;
        for (Map.Entry entry : deliveryCostMap.entrySet()) {
            if (saleCount >= (Integer)entry.getKey()) continue;
            deliveryCost = (Integer)entry.getValue();
            deliveryUnit = (Integer)entry.getKey() - saleCount;
            break;
        }
        dto.setDsdelv_cost(String.valueOf(deliveryCost));
        dto.setDsdelv_type("3");
        dto.setDsdelv_qty(String.valueOf(deliveryUnit));
    }

    public List<ShopOrderMstDto> domaemartOptionSetting(List<ShopOrderMstDto> list) {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        for (ShopOrderMstDto dto : list) {
            String optinon = "\uc635\uc158\uc120\ud0dd``";
            List<MLinkOption> options = this.getOptionList((String)dto.getDosinoption()).options;
            for (MLinkOption option : options) {
                int optionPrice = option.getOptionPrice() - Integer.parseInt(dto.getDsGoods_cost());
                optinon = String.valueOf(optinon) + (!option.getOptionName1().equals("") ? option.getOptionName1().concat(option.getOptionName2().equals("") ? "+" + optionPrice : ":" + option.getOptionName2() + "+" + optionPrice) : "");
                optinon = String.valueOf(optinon) + "``";
            }
            dto.setDosinoption(optinon);
            ret.add(dto);
        }
        return ret;
    }

    public MLinkOptionList getOptionList(String option) {
        MLinkOptionList optionList = new MLinkOptionList();
        ArrayList<MLinkOption> ret_options = new ArrayList<MLinkOption>();
        List lines = Arrays.stream(option.split("\\r|\\n")).collect(Collectors.toList());
        YDMAStringUtil.Print();
        String title = (String)lines.get(0);
        lines.remove(0);
        title = title.replace("[", "");
        title = title.replace("]", "");
        int dan = title.indexOf("=") > 0 ? 2 : 1;
        optionList.setDan(dan);
        if (dan == 1) {
            String char_1_nm = title.indexOf("\uc0c9\uc0c1") > 0 ? "\uce7c\ub77c" : title;
            optionList.setChar_1_nm(char_1_nm);
        } else {
            String[] charnms = title.split("=");
            if (charnms[0].indexOf("\uc0c9\uc0c1") > 0) {
                optionList.setChar_1_nm("\uce7c\ub77c");
            } else {
                optionList.setChar_1_nm(charnms[0]);
            }
            optionList.setChar_2_nm(charnms[1]);
        }
        for (String line : lines) {
            MLinkOption dto = new MLinkOption();
            List<String> lst_option = Arrays.asList(line.split("="));
            if (dan == 1) {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2("");
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt("0"));
            } else {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2(lst_option.get(1));
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            }
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(p -> p.getOptionName2()).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }
}

