/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.HomeObserver;
import com.kdjsystem.mlink.shop.mlink.HomeObserverable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class HomeWorkDataQueue
implements HomeObserverable {
    private static HomeWorkDataQueue instance = new HomeWorkDataQueue();
    private ArrayList<HomeObserver> observers;
    ExecutorService executorService;
    Map<String, ShoppingMallDetailDto> queue = new LinkedHashMap<String, ShoppingMallDetailDto>();

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void stopExecutorService() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private HomeWorkDataQueue() {
        int corePoolSize = 1;
        int maximumPoolSize = 1;
        long keepAliveTime = 3L;
        TimeUnit unit = TimeUnit.SECONDS;
        this.executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
        this.observers = new ArrayList();
    }

    public static HomeWorkDataQueue get() {
        return instance;
    }

    public void add(ShoppingMallDetailDto shopdtl) {
        String grp = String.valueOf(shopdtl.getShopcd()) + shopdtl.getShopseq();
        this.queue.put(grp, shopdtl);
        this.notifyObservers();
    }

    public void modify(ShoppingMallDetailDto shopdtl) {
        String grp = String.valueOf(shopdtl.getShopcd()) + shopdtl.getShopseq();
        this.queue.put(grp, shopdtl);
        this.notifyObservers();
    }

    public synchronized List<ShoppingMallDetailDto> getAllData() {
        if (this.queue.size() == 0) {
            return new ArrayList<ShoppingMallDetailDto>();
        }
        return this.queue.entrySet().stream().map(p -> (ShoppingMallDetailDto)p.getValue()).collect(Collectors.toList());
    }

    public synchronized List<ShoppingMallDetailDto> getWaitData() {
        if (this.queue.size() == 0) {
            return null;
        }
        List<ShoppingMallDetailDto> shopdtl = this.queue.entrySet().stream().map(p -> (ShoppingMallDetailDto)p.getValue()).collect(Collectors.toList());
        if (shopdtl == null) {
            return null;
        }
        this.notifyObservers();
        return shopdtl;
    }

    @Override
    public void addObserver(HomeObserver o) {
        this.observers.add(o);
    }

    @Override
    public void deleteObserver(HomeObserver o) {
        int i = this.observers.indexOf(o);
        if (i >= 0) {
            this.observers.remove(i);
        }
    }

    @Override
    public void notifyObservers() {
        int i = 0;
        while (i < this.observers.size()) {
            HomeObserver observer = this.observers.get(i);
            observer.update(this);
            ++i;
        }
    }
}

