/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.wtrading;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMAProgressBar;
import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.chrome.ChromeDriver;

public class WtradingCommon {
    private static final String DATA_HOST = null;
    private static final String KeyVal = null;
    OkHttpClient client = new OkHttpClient().newBuilder().build();
    public static WtradingCommon instance = new WtradingCommon();

    private WtradingCommon() {
    }

    public static WtradingCommon get() {
        return instance;
    }

    public List<ProductItemDto> getProductInfo(List<ShopOrderMstDto> list, ShoppingMallDetailDto dto) {
        ArrayList<ProductItemDto> datasource = new ArrayList<ProductItemDto>();
        try {
            ShopPreferencesDto shopPreferencesDto = ShopCommonDao.get().getSystemConf();
            for (ShopOrderMstDto orderDto : list) {
                MLinkCommon.get().setCompanyGoodsCd(orderDto, shopPreferencesDto);
                Request request = new Request.Builder().url("http://www.w-trading.co.kr/api/product_api.php?id=" + dto.getShoppingid() + "&" + "apikey=" + dto.getApikey() + "&" + "mode=3&" + "load_page=0&" + "rdate=&" + "search_target=code&" + "search_value=" + orderDto.getCompayny_goods_cd()).method("GET", null).addHeader("Host", "www.w-trading.co.kr").build();
                try {
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (Response response = this.client.newCall(request).execute();){
                        ProductItemDto productItemDto;
                        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ReaponseProductSearch.class});
                        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                        String tt = response.body().string();
                        StringReader reader = new StringReader(tt);
                        ReaponseProductSearch result1 = (ReaponseProductSearch)jaxbUnmarshaller.unmarshal((Reader)reader);
                        if (result1.product.state.equals("0")) {
                            productItemDto = this.getOrderMapping(result1);
                            datasource.add(productItemDto);
                            continue;
                        }
                        productItemDto = this.getOrderMapping(result1);
                        datasource.add(productItemDto);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return datasource;
    }

    private boolean alertPresent(ChromeDriver driver) {
        try {
            driver.switchTo().alert();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List<ShopOrderMstDto> WtradingSendOrder(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopdto) throws Exception {
        String data = "";
        List keys = list.stream().filter(d -> d.getDosinstatus() != null && !d.getDosinstatus().equals("\ud488\uc808")).map(p -> String.valueOf(String.valueOf(p.getReceive_name()) + p.getReceive_cel() + p.getReceive_tel() + p.getReceive_addr())).distinct().collect(Collectors.toList());
        YDMAProgressBar.get().setValue("\ud488\uc808\uc0c1\ud488 \ubc0f \ub3d9\uc77c\ubc30\uc1a1\uc9c0 \uc81c\uc678 " + keys.size() + "\uac74\uc758 \uc8fc\ubb38\uc815\ubcf4 \uc804\uc1a1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4", 0);
        ShoppingMallDetailDto dto1 = ShopCommonDao.get().getShopDtlOneIdWithDome("shop9992");
        ChromeDriver driver = IShopCommonLogin.loginWtrading(dto1.getShoppingid(), dto1.getPassword(), dto1.getShopcd(), true);
        Map<String, String> cookies = ChromeScript.get().getCookies(driver);
        ArrayList<ShopOrderMstDto> result = new ArrayList<ShopOrderMstDto>();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\WtradingOrder.xls");
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)in);
            FileOutputStream out = new FileOutputStream(new File(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\WtradingOrder1.xls"));
            HSSFSheet sheet = workbook.getSheetAt(0);
            int i = 1;
            for (ShopOrderMstDto dto : list) {
                HSSFRow row = sheet.getRow(i);
                row.getCell(0).setCellValue(dto.getP_product_name());
                row.getCell(1).setCellValue(dto.getCompayny_goods_cd());
                row.getCell(2).setCellValue(dto.getP_sku_value2());
                row.getCell(3).setCellValue(dto.getSale_cnt());
                row.getCell(4).setCellValue(dto.getDelivery_method_str2());
                row.getCell(5).setCellValue(ShopCommon.getShoppingMallName(dto.getShopid()).concat("_" + dto.getOrder_id() + "_" + dto.getMall_exp_cd()));
                row.getCell(6).setCellValue(dto.getUser_name());
                row.getCell(7).setCellValue(dto.getUser_tel());
                row.getCell(8).setCellValue(dto.getUser_cel());
                row.getCell(9).setCellValue(dto.getReceive_name());
                row.getCell(10).setCellValue(dto.getReceive_tel());
                row.getCell(11).setCellValue(dto.getReceive_cel());
                row.getCell(12).setCellValue(dto.getReceive_zipcode());
                row.getCell(13).setCellValue(dto.getReceive_addr());
                row.getCell(14).setCellValue(dto.getDelv_msg());
                ++i;
            }
            workbook.write((OutputStream)out);
            out.close();
            File excel_file = new File(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\WtradingOrder1.xls");
            FileInputStream file = new FileInputStream(excel_file);
            Connection.Response response = Jsoup.connect((String)"http://w-trading.co.kr/mypage/order_excel.php").cookies(cookies).header("Host", "w-trading.co.kr").header("Content-Type", "multipart/form-data;").data("mode", "step1").data("excel_type", "wdome").data("file_excel", excel_file.getName(), (InputStream)file).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36").referrer("http://w-trading.co.kr/mypage/order_excel.php").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)response.body());
            Elements rows = doc.select("#contentWrap > form:nth-child(5) > textarea[name='lists']");
            String orderlists = rows.text();
            Thread.sleep(1000L);
            ((InputStream)file).close();
            ((InputStream)in).close();
            Connection.Response nextResponse = Jsoup.connect((String)"http://w-trading.co.kr/mypage/order_excel.php").cookies(cookies).header("Host", "w-trading.co.kr").header("Content-Type", "application/x-www-form-urlencoded").data("lists", orderlists).data("errcnt", "0").data("ordercnt", "1").data("mode", "step2").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36").referrer("http://w-trading.co.kr/mypage/order_excel.php").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            Document doc1 = Jsoup.parseBodyFragment((String)nextResponse.body());
            Elements rows1 = doc1.select("#table_orders > tbody");
            Elements orderInfo = rows1.select("tr");
            String option = "";
            int goods_price = 0;
            int addOptionPrice = 0;
            int delivery_fee = 0;
            String optNum = "";
            int order_count = 0;
            String option_state = "";
            String etc = "";
            int sell_price = 0;
            int total = 0;
            int total_goods_price = 0;
            int final_total_goods_price = 0;
            String op_ori = "";
            int j = 0;
            while (j < orderInfo.size()) {
                option = ((Element)orderInfo.get(j)).select("#options_text > span").text();
                String target = ((Element)orderInfo.get(j)).select("#list_tr_2 > td:nth-child(5) > div:nth-child(1) > a").attr("target").toString();
                String goodsNum = ((Element)orderInfo.get(j)).select("#goods_num").attr("value").toString();
                order_count = Integer.parseInt(((Element)orderInfo.get(j)).select("#order_count").attr("value").toString());
                String opt1 = ((Element)orderInfo.get(j)).select("#opt1").attr("value").toString();
                etc = ((Element)orderInfo.get(j)).select("#option_etc_state").attr("value").toString();
                option_state = ((Element)orderInfo.get(j)).select("#option_state").attr("value").toString();
                String opt_text = ((Element)orderInfo.get(j)).select("tr > td:nth-child(4) > div.txt_center.color_blue2").text();
                String optDetail1 = opt_text.substring(0, opt_text.indexOf(":")).trim();
                delivery_fee = Integer.parseInt(((Element)orderInfo.get(j)).select("#delivery_price").attr("value").toString());
                if (option.equals("\uc635\uc158\uc744 \uc120\ud0dd\ud558\uc138\uc694.")) {
                    Jsoup.connect((String)("http://w-trading.co.kr/mypage/order_excel_options.popup.php?target=" + target + "&goodsNum=" + goodsNum + "&order_count=" + order_count + "&opt1=" + opt1)).cookies(cookies).header("Host", "w-trading.co.kr").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36").referrer("http://w-trading.co.kr/mypage/order_excel.php").method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
                    Connection.Response optionResponse = Jsoup.connect((String)"http://w-trading.co.kr/proc/item/ajax_goods.php?f=load_options").header("Host", "w-trading.co.kr").cookies(cookies).data("itemNum", goodsNum).data("option", option_state).data("etc", etc).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36").referrer("http://w-trading.co.kr/mypage/order_excel_options.popup.php?target=" + target + "&goodsNum=" + goodsNum + "&order_count=" + order_count + "&opt1=" + opt1).method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
                    String body = optionResponse.body();
                    JsonParser parser = new JsonParser();
                    JsonObject bodyObject = parser.parse(body).getAsJsonObject();
                    JsonObject optionObject = bodyObject.get("option").getAsJsonObject();
                    JsonArray listArray = optionObject.get("list").getAsJsonArray();
                    Thread.sleep(1000L);
                    int k = 0;
                    while (k < listArray.size()) {
                        JsonObject opt = listArray.get(k).getAsJsonObject();
                        if (opt.get("on").getAsString().equals(optDetail1)) {
                            optNum = opt.get("num").getAsString();
                            addOptionPrice = Integer.parseInt(opt.get("op").getAsString());
                            op_ori = opt.get("op_ori").getAsString();
                            break;
                        }
                        ++k;
                    }
                    goods_price = Integer.parseInt(optionObject.get("sell_price").getAsString()) + addOptionPrice;
                } else {
                    sell_price = Integer.parseInt(((Element)orderInfo.get(j)).select("#sell_price").attr("value").toString());
                    goods_price = sell_price / order_count;
                }
                total_goods_price = goods_price * order_count;
                final_total_goods_price += goods_price * order_count;
                int reserves = Integer.parseInt(doc1.select("#myPoint > span").text().replaceAll("[^0-9]", ""));
                if ((total += goods_price * order_count + delivery_fee) > reserves) {
                    YDMAProgressBar.get().setValue("\uc801\ub9bd\uae08\uc774 \ubd80\uc871\ud569\ub2c8\ub2e4.\ucda9\uc804 \ud6c4\uc5d0 \ub2e4\uc2dc \uc804\uc1a1\ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.", 0);
                    throw new Exception("\uc801\ub9bd\uae08\uc774 \ubd80\uc871\ud569\ub2c8\ub2e4.\ucda9\uc804 \ud6c4\uc5d0 \ub2e4\uc2dc \uc804\uc1a1\ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.");
                }
                StringBuilder builder = new StringBuilder();
                if (option.equals("\uc635\uc158\uc744 \uc120\ud0dd\ud558\uc138\uc694.")) {
                    builder.append("option|\uff0b|" + optDetail1 + "|\uff0b|" + optNum + "|\uff0b|" + order_count + "|\uff0b|" + addOptionPrice + "|\uff0b|" + op_ori);
                } else {
                    builder.append("option|\uff0b|\uc8fc\ubb38\uc218\ub7c9|\uff0b|0|\uff0b|" + order_count + "|\uff0b|" + total_goods_price);
                }
                builder.toString();
                String delivery_pay_type = "";
                String dev_type = ((Element)orderInfo.get(j)).select("#dev_type").attr("value").toString();
                delivery_pay_type = dev_type.equals("\uc120\ubd88") || dev_type.equals("\uc720\ub8cc") ? "2" : (dev_type.equals("\ucc29\ubd88") ? "3" : "1");
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("goods_num", ((Element)orderInfo.get(j)).select("#goods_num").attr("value").toString());
                param.put("o_name", ((Element)orderInfo.get(j)).select("#o_name").attr("value").toString());
                param.put("o_phone", ((Element)orderInfo.get(j)).select("#o_phone").attr("value").toString());
                param.put("o_hphone", ((Element)orderInfo.get(j)).select("#o_hphone").attr("value").toString());
                param.put("r_name", ((Element)orderInfo.get(j)).select("#r_name").attr("value").toString());
                param.put("r_phone", ((Element)orderInfo.get(j)).select("#r_phone").attr("value").toString());
                param.put("r_hphone", ((Element)orderInfo.get(j)).select("#r_hphone").attr("value").toString());
                param.put("r_post", ((Element)orderInfo.get(j)).select("#r_post").attr("value").toString());
                param.put("r_address", ((Element)orderInfo.get(j)).select("#r_address").attr("value").toString());
                param.put("dev_memo", ((Element)orderInfo.get(j)).select("#dev_memo").attr("value").toString());
                param.put("order_memo", ((Element)orderInfo.get(j)).select("#order_memo").attr("value").toString());
                param.put("options_text", builder.toString());
                param.put("order_total_price_tmp", String.valueOf(total_goods_price));
                param.put("order_total_dc_price_tmp", String.valueOf(total_goods_price));
                param.put("order_count", String.valueOf(order_count));
                param.put("dev_pay_type", delivery_pay_type);
                param.put("option_state", option_state);
                param.put("option_etc_state", etc);
                data = String.valueOf(data) + this.getStringParam(j, param);
                ++j;
            }
            data = String.valueOf(data) + "total_goods_price=" + String.valueOf(final_total_goods_price) + "&total_price=" + String.valueOf(total);
            Thread.sleep(1000L);
            Connection.Response orderResponse = Jsoup.connect((String)"http://w-trading.co.kr/proc/order/ajax_order.php?f=excel_order").cookies(cookies).header("Host", "w-trading.co.kr").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").requestBody(data).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36").referrer("http://w-trading.co.kr/mypage/order_excel.php").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            String body = orderResponse.body();
            if (!body.equals("ok")) {
                throw new Exception("\uc8fc\ubb38 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            if (excel_file.exists()) {
                if (excel_file.delete()) {
                    Thread.sleep(1000L);
                    YDMAStringUtil.Print("\ud30c\uc77c\uc0ad\uc81c \uc131\uacf5");
                } else {
                    YDMAStringUtil.Print("\ud30c\uc77c \uc0ad\uc81c \uc2e4\ud328");
                }
            }
            this.getOrderId(cookies, list);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return result;
    }

    private StringBuilder builder(ShopOrderMstDto dto, StringBuilder builder) {
        return null;
    }

    private void getOrderId(Map<String, String> cookies, List<ShopOrderMstDto> list) throws Exception {
        try {
            int page = 0;
            Connection.Response rs = Jsoup.connect((String)("http://w-trading.co.kr/mypage/order.php?calendar%5B%5D=9&calendar%5B%5D=10&calendar%5B%5D=11&search_date_start=" + list.get(0).getStartDt() + "&search_date_end=" + list.get(0).getEndDt() + "&order_talk=&search_input=&order_state=100&limit=10")).cookies(cookies).header("Host", "w-trading.co.kr").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36").referrer("http://w-trading.co.kr/mypage/order.php?calendar%5B%5D=9&calendar%5B%5D=10&calendar%5B%5D=11&search_date_start=" + list.get(0).getStartDt() + "&search_date_end=" + list.get(0).getEndDt() + "&order_talk=&search_input=&order_state=100&limit=10").method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements rows = doc.select("#contentListInner > table > tbody > tr");
            int i = 0;
            while (i < rows.size()) {
                String[] hide_orderno_list = ((Element)rows.get(i)).select("tr > td.p5 > div:nth-child(2) > div > button").attr("onclick").toString().replaceAll("order_process", "").split(",");
                String hide_orderno = hide_orderno_list[1].toString();
                String orderCnt = hide_orderno_list[3].toString().replaceAll("[^0-9]", "");
                Connection.Response rs1 = Jsoup.connect((String)("http://w-trading.co.kr/mypage/order_detail.popup.php?orderNumber=" + hide_orderno + "&orderCnt=" + orderCnt)).cookies(cookies).header("Host", "w-trading.co.kr").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36").referrer("http://w-trading.co.kr/mypage/order.php").method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
                Document doc1 = Jsoup.parseBodyFragment((String)rs1.body());
                Elements rows1 = doc1.select("#wrap");
                String orderno = rows1.select("#popup_sub_title").text().replaceAll("[^0-9]", "");
                String name1 = rows1.select("#orderDetailWrap > table:nth-child(7) > tbody > tr:nth-child(1) > td").text();
                String[] phone = rows1.select("#orderDetailWrap > table:nth-child(7) > tbody > tr:nth-child(2) > td").text().split("/");
                String cellPhone = phone[1].toString().replaceAll(" ", "");
                for (ShopOrderMstDto dto : list) {
                    if (!name1.equals(dto.getReceive_name()) || !cellPhone.equals(dto.getReceive_cel()) || !dto.getOrder_status().equals("100")) continue;
                    dto.setDs_order_status("\ub3c4\ub9e4\uc2e0\uaddc");
                    dto.setOrder_status("500");
                    dto.setDosinOrder_code(orderno);
                    dto.setResult_code("1");
                    ArrayList<ShopOrderMstDto> result = new ArrayList<ShopOrderMstDto>();
                    result.add(dto);
                    ShopOrderDao.get().SaveOrUpdate(result);
                    YDMAProgressBar.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s \uc8fc\ubb38\uc774 \uc131\uacf5\ud588\uc2b5\ub2c8\ub2e4.", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt()), ++page);
                }
                ++i;
            }
            YDMAProgressBar.get().setValue("---------------------------------------------------------------------------------------", page);
            YDMAProgressBar.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \uc8fc\ubb38\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", page), page);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public ProductItemDto getOrderMapping(ReaponseProductSearch response) {
        ProductItemDto item = new ProductItemDto();
        try {
            item.setSearch("shop9992");
            item.setIcode(response.product.code);
            item.setIname(response.product.prdtname);
            StringBuffer sb = new StringBuffer();
            String option = response.product.option;
            option = option.replaceAll("\n", "").trim();
            if (!option.equals("")) {
                String[] optionValues1 = option.split("]");
                String[] optionValues2 = optionValues1[1].trim().split("\\^\\|\\^");
                int optionCount = StringUtils.countMatches((CharSequence)optionValues2[0], (CharSequence)"||");
                if (optionCount == 2) {
                    sb.append("[" + optionValues1[0].substring(optionValues1[0].indexOf("|") + 1, optionValues1[0].length()) + "]\n");
                    int i = 0;
                    while (i < optionValues2.length) {
                        String optValue = optionValues2[i];
                        String[] optvValue1 = optValue.split("\\|");
                        sb.append(optvValue1[0].concat("==").concat(String.valueOf(Integer.parseInt(optvValue1[2]) + Integer.parseInt(response.product.price.buyprice))).concat("=0=0=").concat(optvValue1[4].equals("0") ? "1" : "0").concat("\n"));
                        ++i;
                    }
                } else if (optionCount == 3) {
                    String[] optionTitle = optionValues1[0].split("\\|");
                    sb.append("[" + optionTitle[1] + "=" + optionTitle[3] + "]\n");
                    int k = 0;
                    while (k < optionValues2.length) {
                        String optValue = optionValues2[k];
                        String[] optvValue1 = optValue.split("\\|");
                        sb.append(optvValue1[0].concat("=").concat(optvValue1[2]).concat("=").concat(String.valueOf(Integer.parseInt(optvValue1[4]) + Integer.parseInt(response.product.price.buyprice))).concat("=0=0=").concat(optvValue1[6].equals("0") ? "1" : "0").concat("\n"));
                        ++k;
                    }
                }
                item.setSelect_option(sb.toString());
                item.setText_option("");
            }
            item.setPrice(response.product.price.buyprice);
            item.setVender_code("");
            item.setDelivery_amount(response.product.delivery.price);
            item.setStatus(response.product.state.equals("0") ? "0" : "1");
            item.setDelivery_type(response.product.delivery.type.equals("1") ? "0" : (response.product.delivery.type.equals("0") ? "1" : ""));
            item.setDelivery_qty(response.product.delivery.terms);
            item.setIsreturn(response.product.baseinfo.notReturn.equals("0") ? "1" : "0");
            String[] img = new String[10];
            img[0] = response.product.img.url;
            item.setImg(img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public List<ShopOrderMstDto> WtradingOrderSearch(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopDto) throws Exception {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        int page = 0;
        String startDate = "";
        String endDate = "";
        endDate = list.get(0).getEndDt().replaceAll("-", "");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        startDate = new SimpleDateFormat("yyyyMMdd").format(calendar.getTime());
        Request request = new Request.Builder().url("http://w-trading.co.kr/api2/get_order_list_data.php?wtrading_id=" + shopDto.getShoppingid() + "&api_key=" + shopDto.getApikey() + "&order_start_date=" + startDate + "&order_end_date=" + endDate).method("GET", null).addHeader("Host", "w-trading.co.kr").build();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (Response response = client.newCall(request).execute();){
                JsonParser parser = new JsonParser();
                JsonArray totalOrderList = (JsonArray)parser.parse(response.body().string());
                if (totalOrderList.size() != 0) {
                    for (ShopOrderMstDto orderDto : list) {
                        for (JsonElement oneOrder : totalOrderList) {
                            String delvNo;
                            JsonObject order = oneOrder.getAsJsonObject();
                            String prodNo = order.get("goods_code").getAsString();
                            String orderNo = order.get("order_num").getAsString();
                            String orderState = order.get("order_state").getAsString();
                            String delv = order.get("delivery_company").isJsonNull() ? "" : order.get("delivery_company").getAsString();
                            ShopDeliveryDto delvname = null;
                            String string = delvNo = order.get("delivery_number").isJsonNull() ? "" : order.get("delivery_number").getAsString();
                            if (!orderDto.getCompayny_goods_cd().equals(prodNo) || !orderDto.getDosinOrder_code().equals(orderNo)) continue;
                            if (orderState.equals("\uc2e0\uaddc\uc8fc\ubb38")) {
                                orderDto.setOrder_status("500");
                                orderDto.setDs_order_status(orderState);
                                continue;
                            }
                            if (orderState.equals("\ucd9c\uace0\uc900\ube44\uc911")) {
                                orderDto.setOrder_status("501");
                                orderDto.setDs_order_status(orderState);
                                continue;
                            }
                            if (orderState.equals("\ucd9c\uace0\uc644\ub8cc")) {
                                List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(orderDto.getShopid());
                                if (delv.equals("")) continue;
                                delvname = orderDto.getShopid().equals("shop0003") && delv.equals("\ud3b8\uc758\uc810\ud0dd\ubc30") || orderDto.getShopid().equals("shop0003") && delv.equals("CU\ud3b8\uc758\uc810\ud0dd\ubc30") ? datasource.stream().filter(d -> d.getDs_code().equals(delv)).findAny().get() : (orderDto.getShopid().equals("shop0075") && delv.equals("CJ\ub300\ud55c\ud1b5\uc6b4") ? datasource.stream().filter(d -> d.getDs_code().replaceAll(" ", "").contains(delv)).findAny().get() : (orderDto.getShopid().equals("shop9984") ? datasource.stream().filter(d -> d.getDivNM().replaceAll(" ", "").contains(delv.replaceAll(" ", ""))).findAny().get() : datasource.stream().filter(d -> d.getDs_code().replace(" ", "").contains(delv)).findAny().get()));
                                orderDto.setDelivery_id(delvname.getDlvID());
                                orderDto.setInvoice_no(delvNo == null ? "" : delvNo);
                                orderDto.setOrder_status("402");
                                orderDto.setDs_order_status(orderState);
                                continue;
                            }
                            orderDto.setDs_order_status(orderState);
                        }
                        orderDto.setResult_code("1");
                        YDMAProgressBar.get().setValue(String.format("\uc8fc\ubb38\ucf54\ub4dc : %s \uc218\ucde8\uc778\uba85 : %s \ub3c4\ub9e4\ubab0\uc0c1\ud0dc : %s ", orderDto.getDosinOrder_code(), orderDto.getReceive_name(), orderDto.getDs_order_status()), ++page);
                    }
                } else {
                    YDMAProgressBar.get().setValue("\uc870\ud68c\uacb0\uacfc : \uc8fc\ubb38 \ub370\uc774\ud130\uac00 \uc870\ud68c\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.\uc8fc\ubb38\uc870\ud68c\ub294 \uc624\ub298\ubd80\ud130 7\uc77c\uc804 \ub370\uc774\ud130\uae4c\uc9c0\ub9cc \uc870\ud68c \uac00\ub2a5\ud569\ub2c8\ub2e4.", page);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("\uc8fc\ubb38 \uc218\uc9d1\ud558\ub294 \uacfc\uc815\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.\uad00\ub9ac\uc790\uc5d0\uac8c \ubb38\uc758 \ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.");
        }
        YDMAProgressBar.get().setValue("---------------------------------------------------------------------------------------", page);
        YDMAProgressBar.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \ub3d9\uae30\ud654 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \ub3d9\uae30\ud654\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", page), page);
        return list;
    }

    private String getStringParam(int i, Map<String, String> value) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lists_arr[" + i + "][order_buy_type]=2&");
        stringBuilder.append("lists_arr[" + i + "][goods_num]=" + value.get("goods_num") + "&");
        stringBuilder.append("lists_arr[" + i + "][o_name]=" + value.get("o_name") + "&");
        stringBuilder.append("lists_arr[" + i + "][o_phone]=" + value.get("o_phone") + "&");
        stringBuilder.append("lists_arr[" + i + "][o_hphone]=" + value.get("o_hphone") + "&");
        stringBuilder.append("lists_arr[" + i + "][r_name]=" + value.get("r_name") + "&");
        stringBuilder.append("lists_arr[" + i + "][r_phone]=" + value.get("r_phone") + "&");
        stringBuilder.append("lists_arr[" + i + "][r_hphone]=" + value.get("r_hphone") + "&");
        stringBuilder.append("lists_arr[" + i + "][r_post]=" + value.get("r_post") + "&");
        stringBuilder.append("lists_arr[" + i + "][r_address]=" + value.get("r_address") + "&");
        stringBuilder.append("lists_arr[" + i + "][dev_memo]=" + value.get("dev_memo") + "&");
        stringBuilder.append("lists_arr[" + i + "][order_memo]=" + value.get("order_memo") + "&");
        stringBuilder.append("lists_arr[" + i + "][options_text]=" + value.get("options_text") + "&");
        stringBuilder.append("lists_arr[" + i + "][order_total_price_tmp]=" + value.get("order_total_price_tmp") + "&");
        stringBuilder.append("lists_arr[" + i + "][order_total_dc_price_tmp]=" + value.get("order_total_dc_price_tmp") + "&");
        stringBuilder.append("lists_arr[" + i + "][order_count]=" + value.get("order_count") + "&");
        stringBuilder.append("lists_arr[" + i + "][dev_pay_type]=" + value.get("dev_pay_type") + "&");
        stringBuilder.append("lists_arr[" + i + "][option_state]=" + value.get("option_state") + "&");
        stringBuilder.append("lists_arr[" + i + "][option_etc_state]=" + value.get("option_etc_state") + "&");
        return stringBuilder.toString();
    }

    private String[] getReString(String value) {
        String[] result = null;
        if (value != null) {
            result = value.replaceAll(" ", "").replaceAll("\uc885\ub958:", "").replaceAll("\uc885\ub958", "").replaceAll("-[0-9]\uac1c", "").replaceAll("\uc120\ud0dd/\uc120\ud0dd.", "").replaceAll("\uc81c\ud488\uc120\ud0dd:", "").replaceAll(",", "").split(":");
        }
        return result;
    }

    public static class Baseinfo {
        @XmlAttribute(name="origin")
        String origin;
        @XmlAttribute(name="maker")
        String maker;
        @XmlAttribute(name="brand")
        String brand;
        @XmlAttribute(name="model")
        String model;
        @XmlAttribute(name="makeDate")
        String makeDate;
        @XmlAttribute(name="eftDate")
        String eftDate;
        @XmlAttribute(name="buyMinQty")
        String buyMinQty;
        @XmlAttribute(name="buyMaxQty")
        String buyMaxQty;
        @XmlAttribute(name="frrgift")
        String frrgift;
        @XmlAttribute(name="adultOnly")
        String adultOnly;
        @XmlAttribute(name="realQty")
        String realQty;
        @XmlAttribute(name="bestProduct")
        String bestProduct;
        @XmlAttribute(name="fastDev")
        String fastDev;
        @XmlAttribute(name="wProduct")
        String wProduct;
        @XmlAttribute(name="goodPrice")
        String goodPrice;
        @XmlAttribute(name="type")
        String type;
        @XmlAttribute(name="notReturn")
        String notReturn;
    }

    public static class Delivery {
        @XmlAttribute(name="bundle")
        String bundle;
        @XmlAttribute(name="code")
        String code;
        @XmlAttribute(name="deadline")
        String deadline;
        @XmlAttribute(name="type")
        String type;
        @XmlAttribute(name="payType")
        String payType;
        @XmlAttribute(name="price")
        String price;
        @XmlAttribute(name="terms")
        String terms;
    }

    public static class Img {
        @XmlAttribute(name="url")
        String url;
    }

    public static class OrderJson {
        String delivery_num;
        String order_num;
        String goods_code;
        String option1_name;
        String option2_name;
        String order_qty;
        String delivery_pay_type;
        String order_name;
        String order_phone1;
        String order_phone2;
        String receive_name;
        String receive_phone1;
        String receive_phone2;
        String receive_post;
        String receive_address1;
        String receive_address2;
        String delivery_msg;
        String order_memo;
        String wtrading_id;
        String wtrading_pw;
    }

    public static class OrderJsonData {
        List<OrderJson> orderJson;
    }

    public static class Price {
        @XmlAttribute(name="buyprice")
        String buyprice;
        @XmlAttribute(name="consumerprice")
        String consumerprice;
        @XmlAttribute(name="consumerg")
        String consumerg;
        @XmlAttribute(name="vatfree")
        String vatfree;
    }

    public static class Product {
        @XmlElement(name="baseinfo")
        Baseinfo baseinfo;
        @XmlElement(name="prdtname")
        String prdtname;
        @XmlElement(name="price")
        Price price;
        @XmlElement(name="delivery")
        Delivery delivery;
        @XmlElement(name="listimg")
        Img img;
        @XmlAttribute(name="state")
        String state;
        @XmlAttribute(name="code")
        String code;
        @XmlElement(name="option")
        String option;
    }

    @XmlRootElement(name="wtrading")
    public static class ReaponseProductSearch {
        @XmlElement(name="product")
        Product product;
    }
}

