/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.data.dao;

import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.BaseStockDto;
import com.kdjsystem.mlink.Yd.data.dao.DBCPInit;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class BaseStockDao {
    public List<BaseStockDto> getProdcutListByDate(int opt, String name, String date, int brandcd) throws Exception {
        ArrayList<BaseStockDto> list = new ArrayList<BaseStockDto>();
        Connection connection = null;
        CallableStatement callstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                YDMAStringUtil.Print("date : " + date);
                callstmt = connection.prepareCall("{call YWM_BASSTK_CRTNQURY(?,?,?,?,?)}");
                callstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                callstmt.setInt(2, brandcd);
                callstmt.setInt(3, opt);
                callstmt.setString(4, "%" + name + "%");
                callstmt.setString(5, date);
                rs = callstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    BaseStockDto dto = new BaseStockDto();
                    dto.setRowno("" + ++rowno);
                    dto.setProdcd(rs.getString(++i));
                    dto.setImg(rs.getString(++i));
                    dto.setProdnm(rs.getString(++i));
                    if (rs.getString(++i) == null) {
                        dto.setSpecdes("");
                    } else {
                        dto.setSpecdes(rs.getString(i));
                    }
                    dto.setQty(rs.getString(++i));
                    dto.setRealQty(rs.getString(++i));
                    dto.setDiffQty(rs.getString(++i));
                    dto.setReason(rs.getString(++i));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, callstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, callstmt, rs);
        return list;
    }

    public void insertBaseStockByDateID(int brandcd, String date) throws Exception {
        Connection connection = null;
        CallableStatement callstmt = null;
        ResultSet rs = null;
        String id = YDMASessonUtil.getUserInfo().getUserId();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                callstmt = connection.prepareCall("{call YWM_BASESTOCKAUTO_PROC(?,?,?,?)}");
                callstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                callstmt.setInt(2, brandcd);
                callstmt.setString(3, date);
                callstmt.setString(4, id);
                callstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, callstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, callstmt, rs);
    }

    public void processBaseStkMstDtlInsert(int brandcd, List<BaseStockDto> dto, String date) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.insertBaseStkDtl(brandcd, connection, statementlist, dto, date);
                this.insertBaseStkMst(brandcd, connection, statementlist, date);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void insertBaseStkDtl(int brandcd, Connection connection, List<PreparedStatement> statementlist, List<BaseStockDto> dto, String date) throws Exception {
        PreparedStatement pstmt_prodmst = null;
        String sql_prodmst = "insert into basstkdtl (compno, brandcd, stkdt, stkseq, prodcd, qty, realqty, diffqty, reason) values (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        int max = this.maxNumberInDay(brandcd, date);
        sql_prodmst = sql_prodmst.toUpperCase();
        pstmt_prodmst = connection.prepareStatement(sql_prodmst);
        statementlist.add(pstmt_prodmst);
        int i = 0;
        while (i < dto.size()) {
            int j = 0;
            pstmt_prodmst.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt_prodmst.setInt(++j, brandcd);
            pstmt_prodmst.setString(++j, date);
            pstmt_prodmst.setString(++j, Integer.toString(++max));
            pstmt_prodmst.setString(++j, dto.get(i).getProdcd());
            pstmt_prodmst.setString(++j, dto.get(i).getQty());
            pstmt_prodmst.setString(++j, dto.get(i).getRealQty());
            pstmt_prodmst.setString(++j, dto.get(i).getDiffQty());
            pstmt_prodmst.setString(++j, dto.get(i).getReason());
            pstmt_prodmst.addBatch();
            pstmt_prodmst.clearParameters();
            ++i;
        }
        pstmt_prodmst.executeBatch();
        pstmt_prodmst.clearBatch();
    }

    public void insertBaseStkMst(int brandcd, Connection connection, List<PreparedStatement> statementlist, String date) throws Exception {
        PreparedStatement pstmt_prodmst = null;
        String sql_prodmst = "insert into basstkmst (compno, brandcd, stkdt, recvdt, recvseq, insertdt, insertid, updatedt, updateid) values (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        sql_prodmst = sql_prodmst.toUpperCase();
        pstmt_prodmst = connection.prepareStatement(sql_prodmst);
        statementlist.add(pstmt_prodmst);
        pstmt_prodmst.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt_prodmst.setInt(2, brandcd);
        pstmt_prodmst.setString(3, date);
        pstmt_prodmst.setString(4, "");
        pstmt_prodmst.setInt(5, 0);
        pstmt_prodmst.setString(6, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt_prodmst.setString(7, YDMASessonUtil.getUserInfo().getUserId());
        pstmt_prodmst.setString(8, "");
        pstmt_prodmst.setString(9, "");
        pstmt_prodmst.executeUpdate();
    }

    public void insertRealStock(int brandcd, List<BaseStockDto> dto, String date) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmt_prodmst = null;
                String sql_prodmst = "insert into basstkdtl (compno, brandcd, stkdt, stkseq, prodcd, qty, realqty, diffqty, reason) values (?, ?, ?, ?, ?, ?, ?, ?, ? ) ";
                int max = this.maxNumberInDay(brandcd, date);
                sql_prodmst = sql_prodmst.toUpperCase();
                pstmt_prodmst = connection.prepareStatement(sql_prodmst);
                statementlist.add(pstmt_prodmst);
                int i = 0;
                while (i < dto.size()) {
                    int j = 0;
                    pstmt_prodmst.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_prodmst.setString(++j, date);
                    pstmt_prodmst.setInt(++j, brandcd);
                    pstmt_prodmst.setString(++j, Integer.toString(++max));
                    pstmt_prodmst.setString(++j, dto.get(i).getProdcd());
                    pstmt_prodmst.setString(++j, dto.get(i).getQty());
                    pstmt_prodmst.setString(++j, dto.get(i).getRealQty());
                    pstmt_prodmst.setString(++j, dto.get(i).getDiffQty());
                    pstmt_prodmst.setString(++j, dto.get(i).getReason());
                    pstmt_prodmst.addBatch();
                    pstmt_prodmst.clearParameters();
                    ++i;
                }
                pstmt_prodmst.executeBatch();
                pstmt_prodmst.clearBatch();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void insertRealStock(int brandcd, BaseStockDto dto, String date) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmt_prodmst = null;
                String sql_prodmst = "insert into basstkdtl (compno, brandcd, stkdt, stkseq, prodcd, qty, realqty, diffqty, reason) values (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
                int max = this.maxNumberInDay(brandcd, date);
                sql_prodmst = sql_prodmst.toUpperCase();
                pstmt_prodmst = connection.prepareStatement(sql_prodmst);
                statementlist.add(pstmt_prodmst);
                int j = 0;
                pstmt_prodmst.setString(j, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_prodmst.setString(++j, date);
                pstmt_prodmst.setInt(++j, brandcd);
                pstmt_prodmst.setString(++j, Integer.toString(++max));
                pstmt_prodmst.setString(++j, dto.getProdcd());
                pstmt_prodmst.setString(++j, dto.getQty());
                pstmt_prodmst.setString(++j, dto.getRealQty());
                pstmt_prodmst.setString(++j, dto.getDiffQty());
                pstmt_prodmst.setString(++j, dto.getReason());
                pstmt_prodmst.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void updateBaseStock(int brandcd, BaseStockDto dto, String date) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.updateBaseStockDtl(brandcd, connection, statementlist, dto, date);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void updateBaseStockDtl(int brandcd, Connection connection, List<PreparedStatement> statementlist, BaseStockDto dto, String date) throws Exception {
        PreparedStatement pstmt_prodmst = null;
        String sql_prodmst = "update basstkdtl set realqty=?, diffqty=?, reason=?  where prodcd=? and compno = ? and brandcd = ? ";
        sql_prodmst = sql_prodmst.toUpperCase();
        pstmt_prodmst = connection.prepareStatement(sql_prodmst);
        statementlist.add(pstmt_prodmst);
        pstmt_prodmst.setString(1, dto.getRealQty());
        pstmt_prodmst.setString(2, dto.getDiffQty());
        pstmt_prodmst.setString(3, dto.getReason());
        pstmt_prodmst.setString(4, dto.getProdcd());
        pstmt_prodmst.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt_prodmst.setInt(6, brandcd);
        pstmt_prodmst.executeUpdate();
    }

    public void updateRealStock(int brandcd, List<BaseStockDto> dtoList, String date) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.updateRealStockDtl(brandcd, connection, statementlist, dtoList, date);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void updateRealStockDtl(int brandcd, Connection connection, List<PreparedStatement> statementlist, List<BaseStockDto> dtoList, String date) throws Exception {
        PreparedStatement pstmt_prodmst = null;
        String sql_prodmst = "update basstkdtl set realqty=?, diffqty=?, reason=?  where prodcd=? and compno = ? and brandcd = ? ";
        sql_prodmst = sql_prodmst.toUpperCase();
        pstmt_prodmst = connection.prepareStatement(sql_prodmst);
        statementlist.add(pstmt_prodmst);
        int i = 0;
        while (i < dtoList.size()) {
            BaseStockDto dto = dtoList.get(i);
            pstmt_prodmst.setString(1, dto.getRealQty());
            pstmt_prodmst.setString(2, dto.getDiffQty());
            pstmt_prodmst.setString(3, dto.getReason());
            pstmt_prodmst.setString(4, dto.getProdcd());
            pstmt_prodmst.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt_prodmst.setInt(6, brandcd);
            pstmt_prodmst.addBatch();
            pstmt_prodmst.clearParameters();
            ++i;
        }
        pstmt_prodmst.executeBatch();
        pstmt_prodmst.clearBatch();
    }

    public String getRecvDtAndSeq(String date, int brandcd) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select recvdt, recvseq  from basstkmst where stkdt=? and compno = ? and brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    result = String.valueOf(rs.getString(1)) + "-" + rs.getString(2);
                    if (rs.getString(1) == null || rs.getString(2) == null) {
                        result = "";
                    }
                } else {
                    YDMAStringUtil.Print("???");
                    result = "???";
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public boolean isBlockSaveButton(int brandcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select count(*) from basstkmst  where recvdt is not null    and compno = ?    and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && Integer.parseInt(rs.getString(1)) > 0) {
                    flag = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistrecvdt(int brandcd, String date) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select 1 from basstkmst where recvdt =? and stkdt=? and compno = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, date);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
                    flag = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistBasstkmst(String date, int brandcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select 1 from basstkmst where stkdt=? and compno = ? and brandcd =? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
                    flag = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistBasstkdtl(int brandcd, String date) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select 1 from basstkdtl where stkdt=? and compno = ? and brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
                    flag = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public int maxNumberInDay(int brandcd, String date) throws Exception {
        int max = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT max(stkseq) FROM basstkdtl WHERE stkdt = ? and compno = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    max = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return max;
    }

    public String getMaxStkdt(int brandcd) throws Exception {
        String max = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT max(stkdt) FROM basstkmst where compno = ? and brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && (max = rs.getString(1)) == null) {
                    max = "20181231";
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return max;
    }

    public List<String> getBaseStockDateList(int brandcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT DISTINCT STKDT   FROM BASSTKMST where compno = ? and brandcd = ?  ORDER BY 1 DESC ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                YDMAStringUtil.Print("[getBaseStockDateList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public String getMaxRecvdt(int brandcd) throws Exception {
        String max = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT max(recvdt) FROM basstkmst where compno = ? and brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && (max = rs.getString(1)) == null) {
                    max = "20181231";
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return max;
    }

    public int maxRecvseqInDay(int brandcd, String date) throws Exception {
        int max = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT max(recvseq)  FROM recvmst WHERE recvdt = ? and compno = ? and brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    max = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return max;
    }

    public boolean isExistRealStock(int brandcd, String date, String prodcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select 1 from basstkdtl where stkdt=? and prodcd=? and compno = ? and brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, prodcd);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
                    flag = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistRealStockInProdmst(int brandcd, String prodcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select 1 from prodmst where prodcd=? and compno = ? brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                rs = pstmt.executeQuery();
                if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
                    flag = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public void updateBaseStockSameDate(int brandcd, BaseStockDto dto, String date) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmt_prodmst = null;
                String sql_prodmst = "update basstkdtl set realqty=?, reason=?  where prodcd=? and stkdt=? and compno = ? and brandcd = ? ";
                sql_prodmst = sql_prodmst.toUpperCase();
                pstmt_prodmst = connection.prepareStatement(sql_prodmst);
                statementlist.add(pstmt_prodmst);
                pstmt_prodmst.setString(1, dto.getRealQty());
                pstmt_prodmst.setString(2, dto.getDiffQty());
                pstmt_prodmst.setString(3, dto.getReason());
                pstmt_prodmst.setString(4, dto.getProdcd());
                pstmt_prodmst.setString(5, date);
                pstmt_prodmst.setString(6, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_prodmst.setInt(7, brandcd);
                pstmt_prodmst.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void deleteBaseStkMst(int brandcd, String date) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = "DELETE FROM basstkmst where stkdt=? and compno = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void deleteBaseStkDtl(int brandcd, String date) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = "DELETE FROM basstkdtl where stkdt=? and compno = ? and brandcd = ?";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }
}

