/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import java.math.BigInteger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACUtil {
    public static String hmac256(String secretKey, String message) {
        byte[] hmacSha256 = HMAC.hmac256(secretKey, message);
        String base64HmacSha256 = String.format("%032x", new BigInteger(1, hmacSha256));
        return base64HmacSha256;
    }

    public static class HMAC {
        public static byte[] hmac256(String secretKey, String message) {
            try {
                return HMAC.hmac256(secretKey.getBytes("UTF-8"), message.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate HMACSHA256 encrypt", e);
            }
        }

        public static byte[] hmac256(byte[] secretKey, byte[] message) {
            byte[] hmac256 = null;
            try {
                Mac mac = Mac.getInstance("HmacSHA256");
                SecretKeySpec sks = new SecretKeySpec(secretKey, "HmacSHA256");
                mac.init(sks);
                hmac256 = mac.doFinal(message);
                return hmac256;
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to generate HMACSHA256 encrypt ");
            }
        }
    }
}

