/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.DriverPool;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IShopProductListener;
import com.kdjsystem.mlink.shop.common.ProductFactory;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class IProductMultiple
implements IProduct {
    public Map<Integer, Integer> getThreadGroup(int threadCnt, int totalSize) {
        int block = totalSize / threadCnt;
        int mod = totalSize % threadCnt;
        HashMap<Integer, Integer> threadPool = new HashMap<Integer, Integer>();
        if (threadCnt >= totalSize) {
            threadPool.put(1, totalSize);
        } else {
            Integer i = 0;
            i = 0;
            while (i < block) {
                threadPool.put(i + 1, threadCnt);
                i = i + 1;
            }
            if (mod > 0) {
                threadPool.put(i + 1, mod);
            }
        }
        return threadPool;
    }

    @Override
    public synchronized ShopProductSendDto excute(ShopProductSendDto shopProductSendDto) throws Exception {
        List<ShopProductDto> prodList = shopProductSendDto.getShopProductDto();
        ShopProductAdditionDto dtllist = shopProductSendDto.getProductAdditionDto();
        ShoppingMallDetailDto idlist = shopProductSendDto.getShoppingMallDetailDto();
        String shopinfo = String.format("(%s) %s", idlist.getShopnm(), idlist.getShoppingid());
        int threadCnt = shopProductSendDto.getMulticnt();
        int totalCount = prodList.size();
        int block = 10;
        int coolpoolSize = block > threadCnt ? threadCnt : block;
        Map<Integer, List<ShopProductDto>> map_list = ShopCommon.getBlockGroup(block, totalCount, prodList);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(prodList.size());
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(coolpoolSize, threadCnt, 3L, TimeUnit.SECONDS, queue);
        for (Integer key : map_list.keySet()) {
            String uid = ShopCommon.getUUID();
            List<ShopProductDto> shopList = map_list.get(key);
            Integer k = 0;
            while (k < shopList.size()) {
                String seq = String.valueOf(k + 1);
                shopList.get(k).setWorkgrp(uid);
                shopList.get(k).setWorkseq(seq);
                k = k + 1;
            }
            ShopWorkDao.get().setWorkListInsert(shopList, dtllist, idlist, "100", "W01");
        }
        for (Integer key : map_list.keySet()) {
            IShopProductListener callBack = new IShopProductListener(){

                @Override
                public void onReturnProduct(List<ShopProductDto> list, ShopProductAdditionDto dtllist, ShoppingMallDetailDto idlist) {
                    for (ShopProductDto dto : list) {
                        if (dto.getResult_code().equals("1")) {
                            // empty if block
                        }
                        if (!dto.getResult_code().equals("-1")) continue;
                    }
                }
            };
            DriverPool driverPool = ChromeExtention.getInstace().getDriverPool();
            Runnable r = ProductFactory.getRegisterRunalbeList(map_list.get(key), dtllist, idlist, driverPool, key, shopinfo, callBack);
            executorService.execute(r);
        }
        executorService.awaitTermination(5L, TimeUnit.SECONDS);
        executorService.shutdown();
        return shopProductSendDto;
    }
}

