/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.AlimTalkChargeDao;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDao;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.job.JobContext;
import com.kdjsystem.mlink.shop.job.JobProduct;
import com.kdjsystem.mlink.shop.job.ShopOrderJob;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SchedulerService {
    private static SchedulerService instance = new SchedulerService();
    public String ZONE_URL = "https://oapi.ecounterp.com/OAPI/V2/Zone";
    public String REQ_METHOD = "POST";
    public String ACCEPT = "application/json";
    public String CONTENT_TYPE = "application/json";

    private SchedulerService() {
    }

    public static SchedulerService get() {
        return instance;
    }

    public void schedulerSetup(int jobcd, String key, String value) {
        ArrayList<ScheduleInfoDto> schedlist = new ArrayList();
        List<Object> list = new ArrayList();
        ScheduleInfoDto dto = new ScheduleInfoDto();
        List<Integer> hour = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23);
        try {
            JobContext.get().clearKey(key);
            JobContext.get().addJobNamGroup(key, value, null, null);
            schedlist = ScheduleInfoDao.get().getScheduleInfoNSite(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), jobcd);
            dto = this.setDto(schedlist);
            list = dto.getSitechk().equals("N") ? this.getShopOrderAllList() : ScheduleInfoDao.get().getShopDetailList(dto.getJobcd());
            this.startDateSetting(list);
            if (dto.getJobstat().equals("Y")) {
                String hourList;
                String weekday;
                List<Object> iNotTime3;
                List<Object> iNotTime2;
                List<Integer> iNotTime1;
                if (dto.getWeekchk1().equals("Y")) {
                    iNotTime1 = new ArrayList<Integer>();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * MON,TUE,WED,THU *", dto.getFewminu1());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * MON,TUE,WED,THU *", dto.getFewminu1(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value, dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
                if (dto.getWeekchk2().equals("Y")) {
                    iNotTime1 = new ArrayList();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * FRI *", dto.getFewminu2());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * FRI *", dto.getFewminu2(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value, dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
                if (dto.getWeekchk3().equals("Y")) {
                    iNotTime1 = new ArrayList();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * SAT *", dto.getFewminu3());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * SAT *", dto.getFewminu3(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value, dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
                if (dto.getWeekchk4().equals("Y")) {
                    iNotTime1 = new ArrayList();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * SUN *", dto.getFewminu4());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * SUN *", dto.getFewminu4(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value, dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
            } else {
                JobContext.get().stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startDateSetting(List<ShopOrderMstDto> list) {
        try {
            ShopPreferencesDto dto = ShopCommonDao.get().getSystemConf();
            Calendar calender_dateTime_from = Calendar.getInstance();
            int period = Integer.parseInt(dto.getOrdimptper());
            calender_dateTime_from.add(5, -period - 1);
            Date date_from = calender_dateTime_from.getTime();
            String generalDate = new SimpleDateFormat("yyyyMMdd").format(date_from);
            String withinOneMonthDate = "";
            if (period > 30) {
                calender_dateTime_from.add(5, -29);
                date_from = calender_dateTime_from.getTime();
                withinOneMonthDate = new SimpleDateFormat("yyyyMMdd").format(date_from);
            } else {
                withinOneMonthDate = generalDate;
            }
            for (ShopOrderMstDto shop : list) {
                if (shop.getShopid().equals("shop0075") || shop.getShopid().equals("shop0273") || shop.getShopid().equals("shop0287")) {
                    shop.setStartDt(withinOneMonthDate.concat("0000"));
                    continue;
                }
                shop.setStartDt(generalDate.concat("0000"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void productSchedulerSetup(int jobcd, String key) {
        int compno = Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno());
        try {
            List<ScheduleInfoDto> schedulerInfos = ScheduleInfoDao.get().getScheduleInfoNSite(compno, jobcd);
            schedulerInfos = schedulerInfos.stream().sorted(Comparator.comparing(ScheduleInfoDto::getWorkseq)).collect(Collectors.toList());
            JobContext.get().clearKey(key);
            JobContext.get().addJobNamGroup(key, "", null);
            if (schedulerInfos.get(0).getJobstat().equals("Y")) {
                List<ProductSchedulerSyncDTO> syncInfos;
                String timeCron;
                String[] timeArray;
                if (schedulerInfos.get(0).getWeekchk1().equals("Y")) {
                    timeArray = schedulerInfos.get(0).getFewminu1().split(":");
                    timeCron = String.format("0 %s %s ? * MON *", timeArray[1], timeArray[0]);
                    JobContext.get().addJobNamGroup(key, "OLD_PROD_MON", schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron).start();
                }
                if (schedulerInfos.get(0).getWeekchk2().equals("Y")) {
                    timeArray = schedulerInfos.get(0).getFewminu2().split(":");
                    timeCron = String.format("0 %s %s ? * TUE *", timeArray[1], timeArray[0]);
                    JobContext.get().addJobNamGroup(key, "OLD_PROD_TUE", schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron).start();
                }
                if (schedulerInfos.get(0).getWeekchk3().equals("Y")) {
                    timeArray = schedulerInfos.get(0).getFewminu3().split(":");
                    timeCron = String.format("0 %s %s ? * WED *", timeArray[1], timeArray[0]);
                    JobContext.get().addJobNamGroup(key, "OLD_PROD_WED", schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron).start();
                }
                if (schedulerInfos.get(0).getWeekchk4().equals("Y")) {
                    timeArray = schedulerInfos.get(0).getFewminu4().split(":");
                    timeCron = String.format("0 %s %s ? * THU *", timeArray[1], timeArray[0]);
                    JobContext.get().addJobNamGroup(key, "OLD_PROD_THU", schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron).start();
                }
                if (schedulerInfos.get(0).getWeekchk5().equals("Y")) {
                    timeArray = schedulerInfos.get(0).getFewminu5().split(":");
                    timeCron = String.format("0 %s %s ? * FRI *", timeArray[1], timeArray[0]);
                    JobContext.get().addJobNamGroup(key, "OLD_PROD_FRI", schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron).start();
                }
                if (schedulerInfos.get(0).getWeekchk6().equals("Y")) {
                    timeArray = schedulerInfos.get(0).getFewminu6().split(":");
                    timeCron = String.format("0 %s %s ? * SAT *", timeArray[1], timeArray[0]);
                    JobContext.get().addJobNamGroup(key, "OLD_PROD_SAT", schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron).start();
                }
                if (schedulerInfos.get(0).getWeekchk7().equals("Y")) {
                    timeArray = schedulerInfos.get(0).getFewminu7().split(":");
                    timeCron = String.format("0 %s %s ? * SUN *", timeArray[1], timeArray[0]);
                    JobContext.get().addJobNamGroup(key, "OLD_PROD_SUN", schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron).start();
                }
                if (schedulerInfos.get(0).getSyncChk().equals("Y") && (syncInfos = ScheduleInfoDao.get().getProductScheduleSyncSiteByJobcd(compno, jobcd)).size() > 0) {
                    List syncDates = syncInfos.stream().map(p -> p.getDate()).distinct().collect(Collectors.toList());
                    for (String syncDate : syncDates) {
                        List infos = syncInfos.stream().filter(p -> p.getDate().equals(syncDate)).collect(Collectors.toList());
                        if (infos.size() <= 0) continue;
                        String[] dateArray = syncDate.split(":");
                        String day = dateArray[0];
                        String hour = dateArray[1];
                        String minute = dateArray[2];
                        String timeCron2 = String.format("0 %s %s ? * %s *", minute, hour, day);
                        JobContext.get().addJobNamGroup(key, String.format("SYNC_%s_%s%s", day, hour, minute), infos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron2).start();
                    }
                }
                if (schedulerInfos.get(0).getClearChk().equals("Y")) {
                    String timeCron3 = String.format("0 %s %s ? * %s *", schedulerInfos.get(0).getClearMin(), schedulerInfos.get(0).getClearHour(), schedulerInfos.get(0).getClearDay());
                    JobContext.get().addJobNamGroup(key, String.format("CLEAR_%s", schedulerInfos.get(0).getClearDay()), schedulerInfos).addJob(JobProduct.class, schedulerInfos.get(0).getExeckey(), timeCron3).start();
                }
            } else {
                JobContext.get().stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ScheduleInfoDto setDto(List<ScheduleInfoDto> schedlist) {
        ScheduleInfoDto dto = new ScheduleInfoDto();
        dto.setCompno(schedlist.get(0).getCompno());
        dto.setJobcd(schedlist.get(0).getJobcd());
        dto.setJobstat(schedlist.get(0).getJobstat());
        dto.setExecid(schedlist.get(0).getExecid());
        dto.setExecdt(schedlist.get(0).getExecdt());
        dto.setWeekchk1(schedlist.get(0).getWeekchk1());
        dto.setFewminu1(schedlist.get(0).getFewminu1());
        dto.setJobexe11(schedlist.get(0).getJobexe11());
        dto.setJobexe21(schedlist.get(0).getJobexe21());
        dto.setJobexe31(schedlist.get(0).getJobexe31());
        dto.setJobexe41(schedlist.get(0).getJobexe41());
        dto.setWeekchk2(schedlist.get(0).getWeekchk2());
        dto.setFewminu2(schedlist.get(0).getFewminu2());
        dto.setJobexe12(schedlist.get(0).getJobexe12());
        dto.setJobexe22(schedlist.get(0).getJobexe22());
        dto.setJobexe32(schedlist.get(0).getJobexe32());
        dto.setJobexe42(schedlist.get(0).getJobexe42());
        dto.setWeekchk3(schedlist.get(0).getWeekchk3());
        dto.setFewminu3(schedlist.get(0).getFewminu3());
        dto.setJobexe13(schedlist.get(0).getJobexe13());
        dto.setJobexe23(schedlist.get(0).getJobexe23());
        dto.setJobexe33(schedlist.get(0).getJobexe33());
        dto.setJobexe43(schedlist.get(0).getJobexe43());
        dto.setWeekchk4(schedlist.get(0).getWeekchk4());
        dto.setFewminu4(schedlist.get(0).getFewminu4());
        dto.setJobexe14(schedlist.get(0).getJobexe14());
        dto.setJobexe24(schedlist.get(0).getJobexe24());
        dto.setJobexe34(schedlist.get(0).getJobexe34());
        dto.setJobexe44(schedlist.get(0).getJobexe44());
        dto.setSitechk(schedlist.get(0).getSitechk());
        dto.setTypechk(schedlist.get(0).getTypechk());
        dto.setMaxchk(schedlist.get(0).getMaxchk());
        dto.setMaxcnt(schedlist.get(0).getMaxcnt());
        dto.setExcepchk1(schedlist.get(0).getExcepchk1());
        dto.setExceps1(schedlist.get(0).getExceps1());
        dto.setExcepe1(schedlist.get(0).getExcepe1());
        dto.setExcepchk2(schedlist.get(0).getExcepchk2());
        dto.setExceps2(schedlist.get(0).getExceps2());
        dto.setExcepe2(schedlist.get(0).getExcepe2());
        dto.setExcepchk3(schedlist.get(0).getExcepchk3());
        dto.setExceps3(schedlist.get(0).getExceps3());
        dto.setExcepe3(schedlist.get(0).getExcepe3());
        dto.setOutofexe(schedlist.get(0).getOutofexe());
        dto.setSmschk(schedlist.get(0).getSmschk());
        dto.setSmsno(schedlist.get(0).getSmsno());
        dto.setDontchk(schedlist.get(0).getDontchk());
        dto.setDontstr(schedlist.get(0).getDontstr());
        dto.setDontend(schedlist.get(0).getDontend());
        dto.setEmailchk(schedlist.get(0).getEmailchk());
        dto.setEmailaddr(schedlist.get(0).getEmailaddr());
        String shopcd = "";
        String shopseq = "";
        int i = 0;
        while (i < schedlist.size()) {
            if (i + 1 == schedlist.size()) {
                shopcd = String.valueOf(shopcd) + schedlist.get(i).getShopcd();
                shopseq = String.valueOf(shopseq) + schedlist.get(i).getShopseq();
            } else {
                shopcd = String.valueOf(shopcd) + schedlist.get(i).getShopcd() + ",";
                shopseq = String.valueOf(shopseq) + schedlist.get(i).getShopseq() + ",";
            }
            ++i;
        }
        dto.setShopcd(shopcd);
        dto.setShopseq(shopseq);
        dto.setJobexe51(schedlist.get(0).getJobexe51());
        dto.setJobexe61(schedlist.get(0).getJobexe61());
        dto.setJobexe52(schedlist.get(0).getJobexe52());
        dto.setJobexe62(schedlist.get(0).getJobexe62());
        dto.setJobexe53(schedlist.get(0).getJobexe53());
        dto.setJobexe63(schedlist.get(0).getJobexe63());
        dto.setJobexe54(schedlist.get(0).getJobexe54());
        dto.setJobexe64(schedlist.get(0).getJobexe64());
        dto.setExeckey(schedlist.get(0).getExeckey());
        return dto;
    }

    private List<ShopOrderMstDto> getShopOrderAllList() {
        ArrayList<ShopOrderMstDto> params = new ArrayList<ShopOrderMstDto>();
        try {
            List<ShoppingMallDetailDto> list = ShopCommonDao.get().ShoppingMallDetailList();
            for (ShoppingMallDetailDto d : list) {
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setShopid(d.getShopcd());
                dto.setShop_userid(d.getShoppingid());
                dto.setShopnm(d.getShopnm());
                dto.setShopPw(d.getPassword());
                dto.setApikey(d.getApikey());
                dto.setAuthkey1(d.getAuthkey1());
                dto.setAuthKey2(d.getAuthkey2());
                dto.setVendorId(d.getVendorId());
                dto.setSuppstditem(d.getSuppstditem());
                dto.setSuppstdrati(d.getSuppstdrati());
                dto.setShopseq(d.getShopseq());
                dto.setSuppcostitem(d.getSuppcostitem());
                dto.setSuppcostrati(d.getSuppcostrati());
                dto.setStartDt(YDMATimeUtil.getCurrentDateHanjin().concat("0000"));
                dto.setEndDt(YDMATimeUtil.getCurrentTime().substring(0, 8).concat("2359"));
                dto.setEDITAUTHKEY1(d.getEditauthkey1());
                dto.setEDITAPIKEY(d.getEditapikey());
                params.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    private List<Integer> getNotHour(Integer start, Integer end) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Integer cnt = start;
        while (cnt != end) {
            if (cnt == 24) {
                cnt = 0;
            }
            ret.add(cnt);
            cnt = cnt + 1;
        }
        ret.add(cnt);
        return ret;
    }

    private List<Integer> getHourList(List<Integer> hourList, List<Integer> notHour) {
        ArrayList<Integer> retList = new ArrayList<Integer>();
        for (Integer hour : hourList) {
            if (notHour.contains(hour)) continue;
            retList.add(hour);
        }
        return retList;
    }

    private String getHourString(List<Integer> hourList) {
        String ret = "";
        ret = hourList.stream().map(h -> String.valueOf(h)).collect(Collectors.joining(","));
        return ret;
    }

    public void sendEmail(List<String> complist, String emailaddr) throws Exception {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.auth", (Object)true);
            props.put("mail.smtp.starttls.enable", (Object)true);
            props.put("mail.smtp.host", "smtp.gmail.com");
            props.put("mail.smtp.port", "587");
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("hosikan@kdjsystem.com", "dksghtlr1");
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress("hosikan@kdjsystem.com"));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emailaddr));
            message.setSubject("\uc2a4\ucf00\uc974\ub9c1 \ucc98\ub9ac\ud604\ud669");
            String body = String.valueOf(YDMATimeUtil.getCurrentDate()) + " \uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.";
            message.setText(body);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public List<String> sendKakao(String smsno, String startdt, String enddt, String smschk, List<String> comlist) {
        ArrayList<String> responContents = new ArrayList<String>();
        try {
            String userid = "kdjsystem";
            String real_profile_key = comlist.get(21);
            String url = "https://alimtalk-api.sweettracker.net/v2/" + real_profile_key + "/sendMessage";
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            AlimTalkChargeDao aldao = new AlimTalkChargeDao();
            List<String> allist = aldao.getAlimTalkChargeList(comlist.get(25));
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setRequestProperty("userid", userid);
            httpConnection.setDoOutput(true);
            int seq = Integer.parseInt(allist.get(7));
            StringBuffer payload = new StringBuffer();
            payload.append("[");
            String num = String.format("%011d", seq + 1);
            payload.append("{");
            payload.append("\"msgid\"").append(":\"").append(String.valueOf(comlist.get(24)) + num).append("\",");
            payload.append("\"profile_key\"").append(":\"").append(real_profile_key).append("\",");
            if (comlist.get(0).equals("1")) {
                payload.append("\"template_code\"").append(":\"").append("").append("\",");
            } else if (comlist.get(0).equals("2")) {
                payload.append("\"template_code\"").append(":\"").append("udt001").append("\",");
            } else {
                payload.append("\"template_code\"").append(":\"").append("kdj002").append("\",");
            }
            payload.append("\"receiver_num\"").append(":\"").append(this.splitMark(smsno)).append("\",");
            payload.append("\"message\"").append(":\"").append(String.valueOf(YDMATimeUtil.getCurrentDate()) + "\uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.").append("\",");
            payload.append("\"reserved_time\"").append(":\"").append("00000000000000").append("\",");
            payload.append("\"sms_message\"").append(":\"").append(String.valueOf(YDMATimeUtil.getCurrentDate()) + "\uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.").append("\",");
            payload.append("\"sms_title\"").append(":\"").append("\",");
            payload.append("\"sms_kind\"").append(":\"").append("S").append("\",");
            payload.append("\"sender_num\"").append(":\"").append("0326751102").append("\",");
            payload.append("\"parcel_company\"").append(":\"").append("08").append("\",");
            payload.append("\"parcel_invoice\"").append(":\"").append("").append("\"");
            payload.append("} ");
            payload.append("\n");
            payload.append("] ");
            YDMAStringUtil.Print(payload);
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.write(payload.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("\uce74\uce74\uc624\ud1a1: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            YDMAStringUtil.Print(response.toString());
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonObject = jsonParser.parse(response.toString());
            JsonArray dataObject = jsonObject.getAsJsonArray();
            int i = 0;
            while (i < dataObject.getAsJsonArray().size()) {
                JsonElement jsonElement = dataObject.getAsJsonArray().get(i);
                String result = jsonElement.getAsJsonObject().get("result").getAsString();
                if (result.equals("Y")) {
                    String msgid = jsonElement.getAsJsonObject().get("msgid").getAsString();
                    String code = jsonElement.getAsJsonObject().get("code").getAsString();
                    String error = jsonElement.getAsJsonObject().get("error").getAsString();
                    String kind = jsonElement.getAsJsonObject().get("kind").getAsString();
                    String sendtime = jsonElement.getAsJsonObject().get("sendtime").getAsString();
                    new ArrayList();
                    responContents.add(result);
                    responContents.add(msgid);
                    responContents.add(code);
                    responContents.add(error);
                    responContents.add(kind);
                    responContents.add(smsno);
                    responContents.add(String.valueOf(YDMATimeUtil.getCurrentDate()) + "\uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                    responContents.add(sendtime);
                } else {
                    new ArrayList();
                    responContents.add(jsonElement.getAsJsonObject().get("result").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("msgid").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("code").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("error").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("kind").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("sendtime").getAsString());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public String splitMark(String text) {
        String[] split = text.split("-| ");
        String complite = "";
        int j = 0;
        while (j < split.length) {
            complite = String.valueOf(complite) + split[j];
            complite = complite.trim();
            ++j;
        }
        return complite;
    }

    public void schedulerYesorNo() {
        try {
            List<ScheduleInfoDto> scheduleInfos = ScheduleInfoDao.get().getJobcd();
            for (ScheduleInfoDto scheduleInfo : scheduleInfos) {
                if (scheduleInfo.getJobcd() == 1) {
                    this.productSchedulerSetup(scheduleInfo.getJobcd(), "PRODUCT");
                    continue;
                }
                if (scheduleInfo.getJobcd() != 2) continue;
                this.schedulerSetup(scheduleInfo.getJobcd(), "Order", "Ordergroup1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

