/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.coupang;

import com.coupang.openapi.sdk.Hmac;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CoupangOrderSearchCommand
implements IShopOrderCommand {
    private static IShopOrderCommand instance = new CoupangOrderSearchCommand();
    private String dateFrom;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private CoupangOrderSearchCommand() {
    }

    private int findIndex(List<ShopOrderMstDto> list, Predicate<ShopOrderMstDto> predicate) {
        int i = 0;
        while (i < list.size()) {
            ShopOrderMstDto dto = list.get(i);
            if (predicate.test(dto)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<ShopOrderMstDto> ExchangeGetApiList(List<ShopOrderMstDto> param) throws Exception {
        block35: {
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            try {
                String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/exchangeRequests";
                String acessKey = param.get(0).getAuthkey1();
                String secretKey = param.get(0).getAuthKey2();
                String vendorid = param.get(0).getVendorId();
                ShopPreferencesDto dto1 = ShopCommonDao.get().getSystemConf();
                if (Integer.parseInt(dto1.getOrdimptper()) > 30) {
                    Calendar calender_dateTime_from = Calendar.getInstance();
                    calender_dateTime_from.add(5, -6);
                    Date date_from = calender_dateTime_from.getTime();
                    this.dateFrom = new SimpleDateFormat("yyyy-MM-dd").format(date_from);
                }
                String startdt = String.valueOf(this.dateFrom) + "T00:00:00";
                String enddt = String.valueOf(param.get(0).getEndDt().substring(0, 4)) + "-" + param.get(0).getEndDt().substring(4, 6) + "-" + param.get(0).getEndDt().substring(6, 8) + "T23:59:59";
                URL2 = String.format(URL2, vendorid);
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("createdAtFrom", startdt).addParameter("createdAtTo", enddt);
                String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                client = HttpClients.createDefault();
                HttpGet get = new HttpGet(uriBuilder.build().toString());
                get.addHeader("Authorization", authorization);
                get.addHeader("content-type", "application/json");
                response = client.execute((HttpUriRequest)get);
                int status = response.getStatusLine().getStatusCode();
                response.getStatusLine().getReasonPhrase();
                if (status != 200) break block35;
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                YDMAStringUtil.Print(resObject);
                JsonArray datas = (JsonArray)resObject.get("data");
                int i = 0;
                while (i < datas.size()) {
                    block36: {
                        JsonObject data = (JsonObject)datas.get(i);
                        this.jsonElementNullStr(data.get("exchangeId"));
                        JsonArray items = (JsonArray)data.get("exchangeItemDtoV1s");
                        JsonObject exchangeItemDtoV1s = (JsonObject)items.get(0);
                        String orderid = this.jsonElementNullStr(data.get("orderId"));
                        String exchangeStatus = this.jsonElementNullStr(data.get("exchangeStatus"));
                        String mallid = exchangeItemDtoV1s.get("orderItemId").getAsString();
                        String mall_exp_cd = exchangeItemDtoV1s.get("originalShipmentBoxId").getAsString();
                        int index = this.findIndex(param, d -> d.getOrder_id().equals(orderid) && d.getSku_id().equals(mallid) && d.getMall_exp_cd().equals(mall_exp_cd));
                        if (index <= -1) break block36;
                        ShopOrderMstDto dto = param.get(index);
                        switch (exchangeStatus) {
                            case "PROGRESS": 
                            case "RECEIPT": {
                                dto.setResult_code("1");
                                dto.setOrder_status("E01");
                                break;
                            }
                            case "SUCCESS": {
                                dto.setResult_code("1");
                                dto.setOrder_status(this.getStatus("ORDER", this.jsonElementNullStr(data.get("orderDeliveryStatusCode"))));
                                ShopOrderMstDto temp = dto.clone("E02");
                                temp.setOrder_date(this.jsonElementNullStr(data.get("modifiedAt")).replace("T", " "));
                                param.add(temp);
                                break;
                            }
                            case "REJECT": {
                                dto.setResult_code("1");
                                dto.setOrder_status("E01");
                                break;
                            }
                            case "CANCEL": {
                                dto.setResult_code("1");
                                dto.setOrder_status("E01");
                            }
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return param;
    }

    private String getStatus(String type, String status) {
        switch (type) {
            case "RETURN": {
                switch (status) {
                    case "RELEASE_STOP_UNCHECKED": {
                        return "C01";
                    }
                    case "RETURNS_UNCHECKED": {
                        return "R01";
                    }
                    case "VENDOR_WAREHOUSE_CONFIRM": {
                        return "R01";
                    }
                    case "REQUEST_COUPANG_CHECK": {
                        return "R01";
                    }
                    case "RETURNS_COMPLETED": {
                        return "R02";
                    }
                }
                break;
            }
            case "CANCEL": {
                switch (status) {
                    case "RELEASE_STOP_UNCHECKED": {
                        return "C01";
                    }
                    case "RETURNS_UNCHECKED": {
                        return "C01";
                    }
                    case "VENDOR_WAREHOUSE_CONFIRM": {
                        return "C01";
                    }
                    case "REQUEST_COUPANG_CHECK": {
                        return "C01";
                    }
                    case "RETURNS_COMPLETED": {
                        return "C02";
                    }
                }
                break;
            }
            case "ORDER": {
                switch (status) {
                    case "ACCEPT": {
                        return "100";
                    }
                    case "INSTRUCT": {
                        return "100";
                    }
                    case "DEPARTURE": {
                        return "403";
                    }
                    case "DELIVERING": {
                        return "403";
                    }
                    case "FINAL_DELIVERY": {
                        return "410";
                    }
                    case "NONE_TRACKING": {
                        return "410";
                    }
                }
                break;
            }
            case "EXCHANGE": {
                switch (status) {
                    case "RECEIPT": {
                        return "E01";
                    }
                    case "PROGRESS": {
                        return "E01";
                    }
                    case "SUCCESS": {
                        return "E02";
                    }
                    case "REJECT": {
                        return "E01";
                    }
                    case "CANCEL": {
                        return "E01";
                    }
                }
            }
        }
        return "";
    }

    private List<ShopOrderMstDto> ReturnGetApiList(List<ShopOrderMstDto> param) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/returnRequests";
            String acessKey = param.get(0).getAuthkey1();
            String secretKey = param.get(0).getAuthKey2();
            String vendorid = param.get(0).getVendorId();
            String startdt = String.valueOf(param.get(0).getStartDt().substring(0, 4)) + "-" + param.get(0).getStartDt().substring(4, 6) + "-" + param.get(0).getStartDt().substring(6, 8);
            String enddt = String.valueOf(param.get(0).getEndDt().substring(0, 4)) + "-" + param.get(0).getEndDt().substring(4, 6) + "-" + param.get(0).getEndDt().substring(6, 8);
            URL2 = String.format(URL2, vendorid);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("searchType", "timeFrame").addParameter("createdAtFrom", startdt.concat("T01:00")).addParameter("createdAtTo", enddt.concat("T23:59"));
            String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
            uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
            client = HttpClients.createDefault();
            HttpGet get = new HttpGet(uriBuilder.build().toString());
            get.addHeader("Authorization", authorization);
            get.addHeader("content-type", "application/json");
            get.addHeader("X-EXTENDED-TIMEOUT", "90000");
            response = client.execute((HttpUriRequest)get);
            int status = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                JsonArray datas = (JsonArray)resObject.get("data");
                int i = 0;
                while (i < datas.size()) {
                    JsonObject data = (JsonObject)datas.get(i);
                    String orderid = data.get("orderId").getAsString();
                    String receiptType = data.get("receiptType").getAsString();
                    String receiptStatus = data.get("receiptStatus").getAsString();
                    JsonArray returnItems = (JsonArray)data.get("returnItems");
                    int j = 0;
                    while (j < returnItems.size()) {
                        JsonObject ret = (JsonObject)returnItems.get(j);
                        String mallid = ret.get("sellerProductId").getAsString();
                        String shipmentId = ret.get("shipmentBoxId").getAsString();
                        int returnqty = ret.get("cancelCount").getAsInt();
                        int k = 0;
                        while (k < param.size()) {
                            if (receiptType.equals("RETURN") && receiptStatus.equals("RETURNS_COMPLETED")) {
                                if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                    String stats = param.get(k).getOrder_status();
                                    param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                    ShopOrderMstDto temp = param.get(k).clone("R02");
                                    if (data.get("releaseStopStatus").getAsString().equals("\ucc98\ub9ac(\ucd9c\uace0\uc911\uc9c0)")) {
                                        param.get(k).setOrder_status("C02");
                                        temp = param.get(k).clone("C02");
                                    }
                                    param.get(k).setResult_code("1");
                                    temp.setOrder_date(this.jsonElementNullStr(data.get("modifiedAt")).replace("T", " "));
                                    temp.setCopy_idx("");
                                    if (YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) > returnqty) {
                                        int cost = YDMAStringUtil.convertToInt(param.get(k).getSale_cost()) * -1;
                                        int cnt = returnqty * -1;
                                        int woncost = YDMAStringUtil.convertToInt(param.get(k).getWon_cost()) / YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) * returnqty;
                                        temp.setSale_cnt(String.valueOf(cnt));
                                        temp.setSale_cost(String.valueOf(cost));
                                        temp.setTotal_cost(String.valueOf(cost));
                                        temp.setWon_cost(String.valueOf(woncost));
                                        param.get(k).setOrder_status(stats);
                                    }
                                    param.add(temp);
                                }
                            } else if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                param.get(k).getOrder_status();
                                param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                if (receiptType.equals("CALCEL") && receiptStatus.equals("RETURNS_COMPLETED")) {
                                    ShopOrderMstDto temp = param.get(k).clone("C02");
                                    temp.setOrder_date(this.jsonElementNullStr(data.get("modifiedAt")).replace("T", " "));
                                    param.add(temp);
                                }
                                param.get(k).setResult_code("1");
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return param;
    }

    private List<ShopOrderMstDto> CancelGetApiList(List<ShopOrderMstDto> param) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/returnRequests";
            String acessKey = param.get(0).getAuthkey1();
            String secretKey = param.get(0).getAuthKey2();
            String vendorid = param.get(0).getVendorId();
            String startdt = String.valueOf(param.get(0).getStartDt().substring(0, 4)) + "-" + param.get(0).getStartDt().substring(4, 6) + "-" + param.get(0).getStartDt().substring(6, 8);
            String enddt = String.valueOf(param.get(0).getEndDt().substring(0, 4)) + "-" + param.get(0).getEndDt().substring(4, 6) + "-" + param.get(0).getEndDt().substring(6, 8);
            URL2 = String.format(URL2, vendorid);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("searchType", "timeFrame").addParameter("createdAtFrom", startdt.concat("T01:00")).addParameter("createdAtTo", enddt.concat("T23:59")).addParameter("cancelType", "CANCEL");
            String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
            uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
            client = HttpClients.createDefault();
            HttpGet get = new HttpGet(uriBuilder.build().toString());
            get.addHeader("Authorization", authorization);
            get.addHeader("content-type", "application/json");
            get.addHeader("X-EXTENDED-TIMEOUT", "90000");
            response = client.execute((HttpUriRequest)get);
            int status = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                JsonArray datas = (JsonArray)resObject.get("data");
                int i = 0;
                while (i < datas.size()) {
                    JsonObject data = (JsonObject)datas.get(i);
                    String orderid = data.get("orderId").getAsString();
                    String receiptType = data.get("receiptType").getAsString();
                    String receiptStatus = data.get("receiptStatus").getAsString();
                    JsonArray returnItems = (JsonArray)data.get("returnItems");
                    int j = 0;
                    while (j < returnItems.size()) {
                        JsonObject ret = (JsonObject)returnItems.get(j);
                        String mallid = ret.get("sellerProductId").getAsString();
                        String shipmentId = ret.get("shipmentBoxId").getAsString();
                        int returnqty = ret.get("cancelCount").getAsInt();
                        int k = 0;
                        while (k < param.size()) {
                            if (receiptType.equals("CANCEL") && receiptStatus.equals("RETURNS_COMPLETED")) {
                                if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                    String stats = param.get(k).getOrder_status();
                                    param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                    param.get(k).setResult_code("1");
                                    ShopOrderMstDto temp = param.get(k).clone("C02");
                                    temp.setOrder_date(this.jsonElementNullStr(data.get("modifiedAt")).replace("T", " "));
                                    temp.setCopy_idx("");
                                    if (YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) > returnqty) {
                                        int cost = YDMAStringUtil.convertToInt(param.get(k).getSale_cost()) * -1;
                                        int cnt = returnqty * -1;
                                        int woncost = YDMAStringUtil.convertToInt(param.get(k).getWon_cost()) / YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) * returnqty;
                                        temp.setSale_cnt(String.valueOf(cnt));
                                        temp.setSale_cost(String.valueOf(cost));
                                        temp.setTotal_cost(String.valueOf(cost));
                                        temp.setWon_cost(String.valueOf(woncost));
                                        param.get(k).setOrder_status(stats);
                                    }
                                    param.add(temp);
                                }
                            } else if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                param.get(k).getOrder_status();
                                param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                param.get(k).setResult_code("1");
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return param;
    }

    private List<ShopOrderMstDto> getApiList(List<ShopOrderMstDto> param) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL1 = "/v2/providers/openapi/apis/api/v4/vendors/%s/ordersheets/%s/history";
            String acessKey = param.get(0).getAuthkey1();
            String secretKey = param.get(0).getAuthKey2();
            String vendorid = param.get(0).getVendorId();
            for (ShopOrderMstDto dto : param) {
                if (dto.getCopy_idx().isEmpty()) continue;
                String URL2 = String.format(URL1, vendorid, dto.getCopy_idx());
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                client = HttpClients.createDefault();
                HttpGet get = new HttpGet(uriBuilder.build().toString());
                get.addHeader("Authorization", authorization);
                get.addHeader("content-type", "application/json");
                response = client.execute((HttpUriRequest)get);
                int status = response.getStatusLine().getStatusCode();
                response.getStatusLine().getReasonPhrase();
                if (status == 200) {
                    JsonObject ret;
                    String deliveryStatus;
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonParser parser = new JsonParser();
                    JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                    YDMAStringUtil.Print(resObject);
                    JsonObject data = (JsonObject)resObject.get("data");
                    JsonArray detail = (JsonArray)data.get("details");
                    if (detail.size() <= 0 || !dto.getMall_exp_cd().equals(data.get("shipmentBoxId").getAsString()) || (deliveryStatus = this.jsonElementNullStr((ret = (JsonObject)detail.get(0)).get("deliveryStatus"))).equals("INSTRUCT") || deliveryStatus.equals("ACCEPT")) continue;
                    dto.setOrder_status(this.getStatus("ORDER", deliveryStatus));
                    dto.setResult_code("1");
                    continue;
                }
                dto.setResult_code("0");
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return param;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        List<ShopOrderMstDto> result_dto = this.getApiList(param);
        result_dto = this.ReturnGetApiList(result_dto);
        result_dto = this.ExchangeGetApiList(result_dto);
        result_dto = this.CancelGetApiList(result_dto);
        return result_dto;
    }

    @Override
    public void Login(String loginID, String loginPw, String gubun) throws Exception {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public int Search_conf(String URL2, String startdt, String enddt, String searchkeyword) throws Exception {
        return 0;
    }
}

