/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.DBCPInit;
import com.kdjsystem.mlink.shop.dao.ShopCallServiceDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ShopCallServiceDao {
    private static ShopCallServiceDao daoInstance = new ShopCallServiceDao();

    public static ShopCallServiceDao get() {
        return daoInstance;
    }

    public List<ShopCallServiceDto> getShopCSList(String startdt, String enddt, String searchText, String search2, String search3) throws Exception {
        ArrayList<ShopCallServiceDto> list = new ArrayList<ShopCallServiceDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(a.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(a.CSSEQ,  '' ) AS CSSEQ,  \r\n");
                sql.append("IFNULL(a.CSCLOSE,  '' ) AS CSCLOSE,  \r\n");
                sql.append("IFNULL((select SHOPNM from shopinfo AS C WHERE C.SHOPCD=M.SHOPID),  '' ) AS SHOPNM,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(a.CSMEMO,  '' ) AS CSMEMO,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE  \r\n");
                sql.append(" FROM shopordcs AS a JOIN shopordmst AS M ON a.ORDSEQ=M.ORDSEQ \r\n");
                sql.append(" WHERE M.COMPNO = ? \r\n");
                boolean isNum = searchText.matches("-?\\d+(\\.\\d+)?");
                List<String> cols = null;
                cols = isNum ? Arrays.asList("  AND ( ", "  (SALE_CNT %s)", " OR (WON_COST %s)", " OR (MALL_WON_COST %s)", " OR (SALE_COST  %s)", " OR (DELV_COST %s) )") : Arrays.asList("  AND ( ", "  (ORDER_STATUS %s)", " OR (SHOPID %s)", " OR (SHOP_USERID %s)", " OR (RECEIVE_NAME %s)", " OR (USER_NAME %s)", " OR (MALL_PRODUCT_ID %s)", " OR (COMPAYNY_GOODS_CD %s)", " OR (P_PRODUCT_NAME %s)", " OR (P_SKU_VALUE %s)", " OR (DELIVERY_METHOD_STR2 %s)", " OR (DELV_MSG %s)", " OR (DELIVERY_ID %s)", " OR (INVOICE_NO %s)", " OR (LABEL %s) ) ");
                if (!searchText.trim().equals("") && !search2.trim().equals("")) {
                    sql.append(String.format(" AND M.%s LIKE '%s%s%s' ", search2, "%", searchText, "%"));
                } else {
                    String query = "";
                    query = cols.stream().map(p -> String.format(p, " LIKE '%" + searchText + "%'")).collect(Collectors.joining());
                    sql.append(query);
                }
                sql.append(String.format(" AND (M.%s >= ? AND  M.%s <= ?)  ORDER BY %s DESC ", search3, search3, search3));
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMATimeUtil.convertSabangNetOrderDateToOrddt(startdt, false));
                pstmt.setString(3, YDMATimeUtil.convertSabangNetOrderDateToOrddt(enddt, false));
                YDMAStringUtil.Print("[getShopCSList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                Integer rowNum = 0;
                while (rs.next()) {
                    ShopCallServiceDto dto = new ShopCallServiceDto();
                    rowNum = rowNum + 1;
                    dto.setNo(rowNum.toString());
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCsseq(rs.getString("CSSEQ"));
                    dto.setCsClose(rs.getString("CSCLOSE"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setCsmemo(rs.getString("CSMEMO"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setReg_date(rs.getString("REG_DATE"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<List<String>> getCSList(String ordseq) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(ORDSEQ,''),ifnull(CSSEQ,''),ifnull(CSMEMO,''),ifnull(CSCLOSE,''),ifnull(INSERTDT,''),ifnull(INSERTID,''),ifnull(UPDATEDT,''),ifnull(UPDATEID,'')  from shopordcs where ORDSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, ordseq);
                YDMAStringUtil.Print("[getCSList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowNum = 0;
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(String.valueOf(++rowNum));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getCSsearchList(String ordseq, String search, int dt, String fromdt, String todt) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(ORDSEQ,''),ifnull(CSSEQ,''),ifnull(CSMEMO,''),ifnull(CSCLOSE,''),ifnull(INSERTDT,''),ifnull(INSERTID,''),ifnull(UPDATEDT,''),ifnull(UPDATEID,'')  from shopordcs where  ";
                sql = dt == 0 ? String.valueOf(sql) + "insertdt >= ? and insertdt <= ? " : String.valueOf(sql) + "UPDATEDT >= ? and UPDATEDT <= ? ";
                sql = String.valueOf(sql) + "and csmemo like ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, fromdt);
                pstmt.setString(2, todt);
                pstmt.setString(3, "%" + search + "%");
                YDMAStringUtil.Print("[getCSList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowNum = 0;
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(String.valueOf(++rowNum));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int ShopCallServiceDelete(List<ShopCallServiceDto> contents) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        int result = 0;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "delete from shopordcs where ordseq = ? and csseq = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopCallServiceDto list : contents) {
                    int i = 0;
                    pstmt.setString(++i, list.getOrdseq());
                    pstmt.setString(++i, list.getCsseq());
                    YDMAStringUtil.Print("[ShopCallServiceDelete]" + pstmt.toString());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int ShopCallServiceDeleteOne(ShopCallServiceDto list) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopordcs where ordseq = ? and csseq = ? ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int i = 0;
                pstmt.setString(++i, list.getOrdseq());
                pstmt.setString(++i, list.getCsseq());
                YDMAStringUtil.Print("[ShopCallServiceDeleteOne]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int deleteCSList(List<List<String>> contents) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        int result = 0;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "delete from shopordcs where ordseq = ? and csseq = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (List<String> list : contents) {
                    int i = 0;
                    pstmt.setString(++i, list.get(1));
                    pstmt.setString(++i, list.get(2));
                    YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void updateCsClose(List<List<String>> contents) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "update shopordcs set csclose = 'N' where ordseq = ? and csseq = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (List<String> list : contents) {
                    int i = 0;
                    pstmt.setString(++i, list.get(1));
                    pstmt.setString(++i, list.get(2));
                    YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void updateCsCloseback(List<List<String>> contents) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "update shopordcs set csclose = 'Y' where ordseq = ? and csseq = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (List<String> list : contents) {
                    int i = 0;
                    pstmt.setString(++i, list.get(1));
                    pstmt.setString(++i, list.get(2));
                    YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void updateCsClosebackOne(ShopCallServiceDto list) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopordcs set csclose = 'Y' where ordseq = ? and csseq = ? ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int i = 0;
                pstmt.setString(++i, list.getOrdseq());
                pstmt.setString(++i, list.getCsseq());
                YDMAStringUtil.Print("[updateCsClosebackOne]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void updateCsCloseOne(ShopCallServiceDto list) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopordcs set csclose = 'N' where ordseq = ? and csseq = ? ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int i = 0;
                pstmt.setString(++i, list.getOrdseq());
                pstmt.setString(++i, list.getCsseq());
                YDMAStringUtil.Print("[updateCsCloseOne]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void updateCsMemoOne(ShopCallServiceDto list) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopordcs set csmemo = ? where ordseq = ? and csseq = ? ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int i = 0;
                pstmt.setString(++i, list.getCsmemo());
                pstmt.setString(++i, list.getOrdseq());
                pstmt.setString(++i, list.getCsseq());
                YDMAStringUtil.Print("[updateCsMemoOne]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }
}

