/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.shop.data.naverstore.NaverStoreGenerateSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class NaverStoreOrderConfirmCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderConfirmCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderConfirmCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        if (param.get(0).getVendorId().equals("N")) {
            IShopCommonLogin is = new IShopCommonLogin(){};
            Map<Object, Object> cookies = new HashMap();
            List<String> list = Arrays.asList(param.get(0).getApikey().split(","));
            cookies = list != null && list.size() > 1 ? is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), list.get(0), list.get(1)) : is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1());
            for (ShopOrderMstDto dto : param) {
                String json = "{\"productOrderIds\":\"" + dto.getMall_exp_cd() + "\",\"onlyValidation\":true,\"patch\":\"placeOrder\",\"validationSuccess\":true}";
                JsonParser jsonparser = new JsonParser();
                Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/oa/delivery/placeOrder").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                String body = rs.body();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
                boolean success = jsonobject.get("bSuccess").getAsBoolean();
                if (success) {
                    dto.setOrder_status("100");
                    dto.setResult_code("1");
                    dto.setResult_text("\uc815\uc0c1 \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                } else {
                    dto.setResult_code("-1");
                }
                retList.add(dto);
            }
        }
        NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
        for (ShopOrderMstDto dto : param) {
            Long timestamp;
            String clientSecret;
            String productId = dto.getMall_exp_cd();
            String clientId = param.get(0).getEDITAUTHKEY1();
            String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret = param.get(0).getEDITAPIKEY(), timestamp = Long.valueOf(System.currentTimeMillis()));
            String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
            boolean success = this.orderConfirmation(accessToken, productId);
            if (success) {
                dto.setOrder_status("100");
                dto.setResult_code("1");
                dto.setResult_text("\uc815\uc0c1 \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            } else {
                dto.setResult_code("-1");
            }
            retList.add(dto);
        }
        return retList;
    }

    private boolean orderConfirmation(String accessToken, String productId) throws Exception {
        boolean success;
        OkHttpClient client = new OkHttpClient();
        try {
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)("{\"productOrderIds\":[" + productId + "]}"));
            Request request = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/confirm").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            Call call = client.newCall(request);
            String bodys = call.execute().body().string();
            JsonParser parser = new JsonParser();
            JsonObject jsonobject = (JsonObject)parser.parse(bodys);
            JsonObject object = jsonobject.getAsJsonObject("data");
            success = object.getAsJsonArray("successProductOrderInfos").size() > 0;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return success;
    }
}

