/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMAProgressBar;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.CoupangItemWinnerRequestDTO;
import com.kdjsystem.mlink.shop.dao.CoupangReturnProductRequestDTO;
import com.kdjsystem.mlink.shop.dao.MallDTO;
import com.kdjsystem.mlink.shop.dao.NaverCatalogRequestDTO;
import com.kdjsystem.mlink.shop.dao.NaverCatalogViewDataRequestDTO;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.RegProductOption;
import com.kdjsystem.mlink.shop.dao.ResultDto;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductShortDto;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkProductConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobProduct
implements Job {
    private static volatile boolean isCanceled = false;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        YDMAProgressBar.get().setOperationCanceledListener(new YDMAProgressBar.OperationCanceledListener(){

            @Override
            public void onOperationCanceled() {
                isCanceled = true;
            }
        });
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String group = (String)data.get((Object)"WORK_GROUP");
        String execKey = (String)data.get((Object)"EXEC_KEY");
        String macAddr = IShopCommonLogin.getLocalMacAddress();
        if (!execKey.equals(macAddr)) {
            return;
        }
        if (group.contains("OLD_PROD")) {
            List schedulerInfos = (List)data.get((Object)"PRODUCT");
            this.changeProductState(schedulerInfos);
        } else if (group.contains("SYNC")) {
            List syncInfos = (List)data.get((Object)"PRODUCT");
            this.syncProduct(syncInfos);
        } else if (group.contains("CLEAR")) {
            List schedulerInfos = (List)data.get((Object)"PRODUCT");
            this.clearProductInfo(schedulerInfos);
        }
    }

    private void changeProductState(List<ScheduleInfoDto> schedulerInfos) {
        YDMAProgressBar console = new YDMAProgressBar();
        console.start("\uc2a4\ucf00\uc974\ub7ec(\uc0c1\ud488)", 100, 100, true);
        String shopString = "";
        try {
            List<ShoppingMallDetailDto> shopInfos = ShopCommonDao.get().ShoppingMallDetailList();
            if (schedulerInfos.get(0).getSitechk().equals("Y")) {
                this.oldModifyProcess(console, schedulerInfos, shopInfos);
                if (schedulerInfos.get(0).getAutoprodregchk().equals("Y")) {
                    this.regProcess(console, schedulerInfos, shopInfos);
                }
            }
            if (schedulerInfos.get(0).getCoupprodchk().equals("Y")) {
                this.coupangItemWinnerProcess(console, schedulerInfos, shopInfos);
            }
            if (schedulerInfos.get(0).getNaverprodchk().equals("Y")) {
                this.naverCatalogProcess(console, schedulerInfos, shopInfos);
            }
            if (schedulerInfos.get(0).getTossprodchk().equals("Y")) {
                this.tossReturnItemProcess(console, schedulerInfos, shopInfos);
            }
            if (schedulerInfos.get(0).getCoupprodchk2().equals("Y")) {
                this.coupangReturnItemProcess(console, schedulerInfos, shopInfos);
            }
            if (schedulerInfos.get(0).getMelprodchk().equals("Y")) {
                this.melchiWaitItemProcess(console, schedulerInfos, shopInfos);
            }
            console.setValue("[INFO] \uc124\uc815\ud558\uc2e0 \ubaa8\ub4e0 \uc2a4\ucf00\uc974\ub7ec \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 100);
            Thread.sleep(5000L);
            console.end();
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
        }
    }

    private void oldModifyProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValue("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \ud310\ub9e4\uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 14);
        String shopString = "";
        try {
            for (ScheduleInfoDto schedulerInfo : schedulerInfos) {
                String shopName = ShopCommon.getShoppingMallName(schedulerInfo.getShopcd());
                String shopNickName = shopInfos.stream().filter(p -> p.getShopcd().equals(schedulerInfo.getShopcd()) && p.getShopseq().equals(schedulerInfo.getShopseq())).map(p -> p.getNicknm1()).findFirst().orElse("");
                shopString = String.valueOf(shopName) + "-" + shopNickName;
                List<ShopProductDto> sendseqs = ShopProductDao.get().getProductDeleteSchedulerList(schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), Integer.parseInt(schedulerInfo.getExcludeDate()), schedulerInfo.getProdQty());
                if (sendseqs.size() <= 0) continue;
                int result = 0;
                for (ShopProductDto sendseq : sendseqs) {
                    result += ShopCommonDao.get().setProductStatusIn(sendseq, 7000);
                }
                console.setValue(String.format("[%s] %s\uac74\uc758 \uc0c1\ud488\uc744 \uc218\uc815\ub300\uae30\ub85c \ubcc0\uacbd\ud588\uc2b5\ub2c8\ub2e4.", shopString, result), 14);
            }
            console.setValue("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \ud310\ub9e4\uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 14);
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 14);
        }
    }

    private void regProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValue("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \uc0c1\ud488 \uc790\ub3d9\ub4f1\ub85d\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 28);
        String shopString = "";
        try {
            ShopWorkDao.get().setSchProdinfoDelete();
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            for (ScheduleInfoDto schedulerInfo : schedulerInfos) {
                if (schedulerInfo.getRegqty() == 0 || schedulerInfo.getAddition_seq() < 1) continue;
                String shopName = ShopCommon.getShoppingMallName(schedulerInfo.getShopcd());
                String shopNickName = shopInfos.stream().filter(p -> p.getShopcd().equals(schedulerInfo.getShopcd()) && p.getShopseq().equals(schedulerInfo.getShopseq())).map(p -> p.getNicknm1()).findFirst().orElse("");
                shopString = String.valueOf(shopName) + "-" + shopNickName;
                int sendState = 0;
                if (schedulerInfo.getReg_target().equals("WAIT")) {
                    sendState = 9000;
                } else {
                    if (!schedulerInfo.getReg_target().equals("SELF")) continue;
                    sendState = 6100;
                }
                List<ShopProductDto> prods = ShopProductDao.get().getShopProductInfoList("", "", "", "COMPAYNY_GOODS_CD", "", "", "", schedulerInfo.getRegqty(), 1, "U", schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), sendState, true);
                prods = MLinkCommon.get().getCategorysShopCidSetting(null, prods);
                ArrayList<MallDTO> malls = new ArrayList<MallDTO>();
                malls.add(new MallDTO(schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), String.valueOf(schedulerInfo.getAddition_seq())));
                List<ShopProductDto> filterProds = MLinkProductConnection.get().getQueueRegProductSendList(prods, malls);
                if (filterProds == null || filterProds.size() == 0) continue;
                ResultDto ret = MLinkProductConnection.get().sendQueueRegProduct(malls, shopInfos, filterProds, conf, new RegProductOption("N", "N", "N", "N"));
                List<Object> filters = new ArrayList();
                List sendList = (List)ret.getItems();
                if (sendList != null) {
                    List sendProdNums = sendList.stream().map(p -> p.getCompayny_goods_cd()).collect(Collectors.toList());
                    filters = filterProds.stream().filter(p -> !sendProdNums.contains(p.getCompayny_goods_cd())).collect(Collectors.toList());
                } else {
                    filters = filterProds;
                }
                ShopWorkDao.get().setSchProdinfoInsert(filterProds);
                console.setValue(String.format("[%s] %s\uac74\uc758 \uc0c1\ud488\uc774 \uc791\uc5c5\ub9ac\uc2a4\ud2b8\uc5d0 \ub4f1\ub85d\ub418\uace0 %s\uac74\uc774 \ud544\ud130\ub9c1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, sendList.size(), filters.size()), 28);
                Thread.sleep(60000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 28);
        }
    }

    private void coupangItemWinnerProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValue("[INFO] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 42);
        String shopString = "";
        try {
            List coupangInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0075")).collect(Collectors.toList());
            if (coupangInfos != null) {
                for (ShoppingMallDetailDto coupangInfo : coupangInfos) {
                    List<String> shopprodnos;
                    String shopName = ShopCommon.getShoppingMallName(coupangInfo.getShopcd());
                    String shopNickName = coupangInfo.getNicknm1();
                    shopString = String.valueOf(shopName) + "-" + shopNickName;
                    console.setValue(String.format("[%s] \uc1fc\ud551\ubab0\uc758 \uc544\uc774\ud15c\uc704\ub108 \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4..", shopString), 42);
                    IShopCommonLogin i = new IShopCommonLogin(){};
                    Map<String, String> cookies = i.loginCookie(coupangInfo.getShoppingid(), coupangInfo.getPassword(), coupangInfo.getShopcd(), true, coupangInfo.getAuthkey1() == null ? "" : coupangInfo.getAuthkey1());
                    int page = 0;
                    do {
                        shopprodnos = this.getCoupangItemWinnerProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            int result;
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(coupangInfo.getShopcd(), coupangInfo.getShopseq(), shopprodno);
                            if (prodIn == null || (result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000)) != 1) continue;
                            console.setValue(String.format("[%s] \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\uc744 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopString), 42);
                            console.setValue(String.format("  - \uc0c1\ud488\ubc88\ud638: %s", shopprodno), 42);
                            Thread.sleep(300L);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                }
            }
            console.setValue("[INFO] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4..", 42);
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 42);
        }
    }

    private void naverCatalogProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValue("[INFO] \ub124\uc774\ubc84 \uce74\ud0c8\ub85c\uadf8 \uac00\uaca9\uad00\ub9ac \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 56);
        String shopString = "";
        try {
            List naverInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0055")).collect(Collectors.toList());
            if (naverInfos != null) {
                for (ShoppingMallDetailDto naverInfo : naverInfos) {
                    List<String> shopprodnos;
                    String shopName = ShopCommon.getShoppingMallName(naverInfo.getShopcd());
                    String shopNickName = naverInfo.getNicknm1();
                    shopString = String.valueOf(shopName) + "-" + shopNickName;
                    console.setValue(String.format("[%s] \uc1fc\ud551\ubab0\uc758 \uce74\ud0c8\ub85c\uadf8 \uac00\uaca9\uad00\ub9ac \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4..", shopString), 56);
                    IShopCommonLogin i = new IShopCommonLogin(){};
                    Map<Object, Object> cookies = new HashMap();
                    List<String> apiKeyList = Arrays.asList(naverInfo.getApikey().split(","));
                    cookies = apiKeyList != null && apiKeyList.size() > 1 ? i.loginCookie(naverInfo.getShoppingid(), naverInfo.getPassword(), naverInfo.getShopcd(), true, naverInfo.getAuthkey1(), apiKeyList.get(0), apiKeyList.get(1)) : i.loginCookie(naverInfo.getShoppingid(), naverInfo.getPassword(), naverInfo.getShopcd(), true, naverInfo.getAuthkey1());
                    int page = 0;
                    do {
                        shopprodnos = this.getNaverCatalogProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            int result;
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(naverInfo.getShopcd(), naverInfo.getShopseq(), shopprodno);
                            if (prodIn == null || (result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000)) != 1) continue;
                            console.setValue(String.format("[%s] \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\uc744 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopString), 56);
                            console.setValue(String.format("  - \uc0c1\ud488\ubc88\ud638: %s", shopprodno), 56);
                            Thread.sleep(300L);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                }
                console.setValue("[INFO] \ub124\uc774\ubc84 \uce74\ud0c8\ub85c\uadf8 \uac00\uaca9\uad00\ub9ac \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4..", 56);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 56);
        }
    }

    private void tossReturnItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValue("[INFO] \ud1a0\uc2a4\uc1fc\ud551 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 72);
        String shopString = "";
        try {
            List tossInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop9982")).collect(Collectors.toList());
            if (tossInfos != null) {
                for (ShoppingMallDetailDto tossInfo : tossInfos) {
                    List<String> shopprodnos;
                    String shopName = ShopCommon.getShoppingMallName(tossInfo.getShopcd());
                    String shopNickName = tossInfo.getNicknm1();
                    shopString = String.valueOf(shopName) + "-" + shopNickName;
                    console.setValue(String.format("[%s] \uc1fc\ud551\ubab0\uc758 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4..", shopString), 72);
                    Map<String, String> cookies = this.getCookie(console, tossInfo, shopString);
                    int page = 0;
                    do {
                        shopprodnos = this.getTossReturnProducts(cookies, tossInfo, page);
                        for (String shopprodno : shopprodnos) {
                            int result;
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(tossInfo.getShopcd(), tossInfo.getShopseq(), shopprodno);
                            if (prodIn == null || (result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000)) != 1) continue;
                            console.setValue(String.format("[%s] \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\uc744 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopString), 72);
                            console.setValue(String.format("  - \uc0c1\ud488\ubc88\ud638: %s", shopprodno), 72);
                            Thread.sleep(300L);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 72);
        }
    }

    private void coupangReturnItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValue("[INFO] \ucfe0\ud321 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 86);
        String shopString = "";
        try {
            List coupangInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0075")).collect(Collectors.toList());
            if (coupangInfos != null) {
                for (ShoppingMallDetailDto coupangInfo : coupangInfos) {
                    List<String> shopprodnos;
                    String shopName = ShopCommon.getShoppingMallName(coupangInfo.getShopcd());
                    String shopNickName = coupangInfo.getNicknm1();
                    shopString = String.valueOf(shopName) + "-" + shopNickName;
                    console.setValue(String.format("[%s] \uc1fc\ud551\ubab0\uc758 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4..", shopString), 86);
                    IShopCommonLogin i = new IShopCommonLogin(){};
                    Map<String, String> cookies = i.loginCookie(coupangInfo.getShoppingid(), coupangInfo.getPassword(), coupangInfo.getShopcd(), true, coupangInfo.getAuthkey1() == null ? "" : coupangInfo.getAuthkey1());
                    int page = 1;
                    do {
                        shopprodnos = this.getCoupangReturnProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            int result;
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(coupangInfo.getShopcd(), coupangInfo.getShopseq(), shopprodno);
                            if (prodIn == null || (result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000)) != 1) continue;
                            console.setValue(String.format("[%s] \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\uc744 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopString), 86);
                            console.setValue(String.format("  - \uc0c1\ud488\ubc88\ud638: %s", shopprodno), 86);
                            Thread.sleep(300L);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 86);
        }
    }

    private void melchiWaitItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValue("[INFO] \uba78\uce58\uc1fc\ud551 \ud310\ub9e4\ub300\uae30 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 95);
        String shopString = "";
        try {
            List melchiInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0106")).collect(Collectors.toList());
            if (melchiInfos != null) {
                for (ShoppingMallDetailDto melchiInfo : melchiInfos) {
                    String start;
                    List<String> shopprodnos;
                    String shopName = ShopCommon.getShoppingMallName(melchiInfo.getShopcd());
                    String shopNickName = melchiInfo.getNicknm1();
                    shopString = String.valueOf(shopName) + "-" + shopNickName;
                    console.setValue(String.format("[%s] \uc1fc\ud551\ubab0\uc758 \ud310\ub9e4\ub300\uae30 \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4..", shopString), 99);
                    String standardDate = YDMATimeUtil.getDateMinusDays(30);
                    Map<String, String> cookies = this.getCookie(console, melchiInfo, shopString);
                    while ((shopprodnos = this.getMelchiWaitProducts(cookies, start = YDMATimeUtil.subtractDays(standardDate, 30), standardDate)).size() > 0) {
                        for (String shopprodno : shopprodnos) {
                            int result;
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(melchiInfo.getShopcd(), melchiInfo.getShopseq(), shopprodno);
                            if (prodIn == null || (result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000)) != 1) continue;
                            console.setValue(String.format("[%s] \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\uc744 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopString), 99);
                            console.setValue(String.format("  - \uc0c1\ud488\ubc88\ud638: %s", shopprodno), 99);
                            Thread.sleep(300L);
                        }
                        standardDate = YDMATimeUtil.subtractDays(standardDate, 30);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
        }
    }

    private void syncProduct(List<ProductSchedulerSyncDTO> syncInfos) {
        YDMAProgressBar console = new YDMAProgressBar();
        console.startTest("\uc2a4\ucf00\uc974\ub7ec(\uc0c1\ud488)", 100, 100, true);
        console.setValue("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \ub3d9\uae30\ud654 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 0);
        String shopString = "";
        try {
            List<ShoppingMallDetailDto> shopInfos = ShopCommonDao.get().ShoppingMallDetailList();
            for (ProductSchedulerSyncDTO syncInfo : syncInfos) {
                if (isCanceled) {
                    YDMAProgressBar.get().end();
                    return;
                }
                ShoppingMallDetailDto shopInfo = shopInfos.stream().filter(p -> p.getShopcd().equals(syncInfo.getShopcd()) && p.getShopseq().equals(String.valueOf(syncInfo.getShopseq()))).findFirst().orElse(null);
                if (shopInfo == null) continue;
                String shopName = ShopCommon.getShoppingMallName(syncInfo.getShopcd());
                String shopNickName = syncInfo.getNickname();
                shopString = String.valueOf(shopName) + "-" + shopNickName;
                List<ShopProductDto> prodIns = ShopProductDao.get().getScheduleSyncProductIn(syncInfo.getShopcd(), String.valueOf(syncInfo.getShopseq()), 8000);
                if (prodIns.size() <= 0) continue;
                console.setValue(String.format("[%s] \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub3d9\uae30\ud654 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", shopString, prodIns.size()), 50);
                ArrayList<ShopProductShortDto> syncProds = new ArrayList<ShopProductShortDto>();
                Map<String, String> cookie = this.getCookie(console, shopInfo, shopString);
                int allCount = prodIns.size();
                int processedCount = 0;
                int i = 0;
                while (i < prodIns.size()) {
                    if (isCanceled) {
                        YDMAProgressBar.get().end();
                        return;
                    }
                    String shopprodno = this.getShopprodno(cookie, shopInfo, prodIns.get(i));
                    if (!prodIns.get(i).getShopprodno().equals(shopprodno)) {
                        console.setValue(String.format("[%s] \uc0c1\ud488\ubc88\ud638:'%s' \ub3d9\uae30\ud654 \ub300\uc0c1\uc744 \ucc3e\uc558\uc2b5\ub2c8\ub2e4..", shopString, prodIns.get(i).getCompayny_goods_cd()), 50);
                        ShopProductShortDto syncProd = new ShopProductShortDto();
                        syncProd.setCompayny_goods_cd(prodIns.get(i).getCompayny_goods_cd());
                        syncProd.setSendseq(prodIns.get(i).getSendseq());
                        syncProd.setShopcd(prodIns.get(i).getShopcd());
                        syncProd.setShopseq(prodIns.get(i).getShopseq());
                        syncProd.setShopsendstatus(prodIns.get(i).getSendstats());
                        syncProd.setShopprodno(shopprodno);
                        syncProds.add(syncProd);
                    } else {
                        console.setValue(String.format("[%s] '%s' \uc870\ud68c\uc911...", shopString, prodIns.get(i).getCompayny_goods_cd()), 50);
                    }
                    if (++processedCount % 100 == 0 || processedCount == allCount) {
                        console.setValue(String.format("[%s] \ucd1d %s\uac1c\uc758 \uc0c1\ud488 \uc911 %s\uac1c\ub97c \uc870\ud68c\ud588\uc2b5\ub2c8\ub2e4..", shopString, allCount, processedCount), 50);
                    }
                    ++i;
                }
                if (syncProds.size() > 0) {
                    int result = ShopProductDao.get().setProductInUpdate(syncProds);
                    if (result <= 0) continue;
                    console.setValue(String.format("[%s] \ucd1d %s\uac74\uc758 \uc0c1\ud488\uc744 \ub3d9\uae30\ud654 \ud588\uc2b5\ub2c8\ub2e4.", shopString, result), 100);
                    continue;
                }
                console.setValue(String.format("[%s] \ub3d9\uae30\ud654\ud560 \uc0c1\ud488 \ub370\uc774\ud130 \uba85\uc138\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", shopString), 100);
            }
            console.end();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearProductInfo(List<ScheduleInfoDto> schedulerInfos) {
        YDMAProgressBar console = new YDMAProgressBar();
        console.start("\uc2a4\ucf00\uc974\ub7ec(\uc0c1\ud488)", 100, 100, true);
        console.setValue("[INFO] \ud488\ub2e8\uc885 \uc0c1\ud488\uc815\ubcf4 \uc0ad\uc81c \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4..", 0);
        try {
            List<ShopProductDto> prodIns = ShopProductDao.get().setProductInConditionDelete("", "", "", "STATUS", "1,2,3", "", "");
            List<ShopProductDto> prodInfos = ShopProductDao.get().setProductInfoConditionDelete("", "STATUS", "1,2,3", "", "");
            if (prodIns.size() > 0 || prodInfos.size() > 0) {
                console.setValue(String.format("[INFO] \uc1fc\ud551\ubab0 \ud310\ub9e4\uc0c1\ud488 %s\uac74, \uc0c1\ud488 \uae30\ubcf8\uc815\ubcf4 %s\uac74 \r\n[INFO] \ucd1d %s\uac74\uc758 Clear \ub300\uc0c1\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4..", prodIns.size(), prodInfos.size(), prodIns.size() + prodInfos.size()), 50);
                int retIn = 0;
                if (prodIns.size() > 0) {
                    retIn = ShopProductDao.get().setProductInDelete(prodIns);
                }
                int retInfo = 0;
                if (prodInfos.size() > 0) {
                    retInfo = ShopProductDao.get().setProductInfoDelete(prodInfos);
                }
                if (retIn > 0 || retInfo > 0) {
                    console.setValue(String.format("[INFO] \uc1fc\ud551\ubab0 \ud310\ub9e4\uc0c1\ud488 %s\uac74, \uc0c1\ud488 \uae30\ubcf8\uc815\ubcf4 %s\uac74\uc758 \ub300\uc0c1\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4. ", retIn, retInfo), 100);
                }
            } else {
                console.setValue("[INFO] \uc0ad\uc81c \ub300\uc0c1\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4..", 100);
            }
            console.end();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getCookie(YDMAProgressBar console, ShoppingMallDetailDto shopInfo, String shopString) {
        Map<String, String> cookie = null;
        IShopCommonLogin i = new IShopCommonLogin(){};
        try {
            if (!(shopInfo.getShopcd().equals("shop0287") || shopInfo.getShopcd().equals("shop0372") || shopInfo.getShopcd().equals("shop0075") || shopInfo.getShopcd().equals("shop0273") || shopInfo.getShopcd().equals("shop9984"))) {
                if (shopInfo.getShopcd().equals("shop9982")) {
                    cookie = i.getTossCookies(shopInfo.getShoppingid(), shopInfo.getPassword());
                } else {
                    List<String> list;
                    cookie = shopInfo.getShopcd().equals("shop0055") ? ((list = Arrays.asList(shopInfo.getApikey().split(","))) != null && list.size() > 1 ? i.loginCookie(shopInfo.getShoppingid(), shopInfo.getPassword(), shopInfo.getShopcd(), true, shopInfo.getAuthkey1(), list.get(0), list.get(1)) : i.loginCookie(shopInfo.getShoppingid(), shopInfo.getPassword(), shopInfo.getShopcd(), true, shopInfo.getAuthkey1())) : i.loginCookie(shopInfo.getShoppingid(), shopInfo.getPassword(), shopInfo.getShopcd(), true, shopInfo.getAuthkey1());
                    if (cookie == null) {
                        console.setValue(String.format("[%s] \ud574\ub2f9 \uc1fc\ud551\ubab0\uc5d0 \uc811\uc18d \ubd88\uac00\ud569\ub2c8\ub2e4.. \uc1fc\ud551\ubab0 \uc811\uc18d\uc815\ubcf4 \ud655\uc778 \ud544\uc694..", shopString), 50);
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            console.setValue(String.format("[%s] \ud574\ub2f9 \uc1fc\ud551\ubab0 \uc811\uc18d\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.. %s", shopString, e.getMessage()), 50);
        }
        return cookie;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getShopprodno(Map<String, String> cookie, ShoppingMallDetailDto shopInfo, ShopProductDto prodIn) {
        int n;
        try {
            String string = shopInfo.getShopcd();
            n = -1;
            switch (string.hashCode()) {
                case -346424326: {
                    if (!string.equals("shop0004")) break;
                    n = 1;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        {
        }
        switch (n) {
            case 1: {
                return "";
            }
        }
        return "";
    }

    private List<String> getCoupangItemWinnerProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String json = this.getCoupangItemWinnerJson(page);
            Connection.Response response = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-price-management/getProductList").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").cookies(cookies).header("Host", "wing.coupang.com").header("Content-Type", "application/json").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            JsonArray resultArr = (JsonArray)object.get("result");
            int i = 0;
            while (i < resultArr.size()) {
                JsonObject item = (JsonObject)resultArr.get(i);
                String shopprodno = item.get("vendorInventoryId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> getTossReturnProducts(Map<String, String> cookies, ShoppingMallDetailDto shopInfo, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String merchantID = this.getMerchantID(cookies, shopInfo);
            String url = this.getTossReturnProductURL(merchantID, page);
            Connection.Response response = Jsoup.connect((String)url).cookies(cookies).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonParser parser = new JsonParser();
            JsonObject body = (JsonObject)parser.parse(response.body());
            JsonObject success = body.get("success").getAsJsonObject();
            JsonArray results = success.get("results").getAsJsonArray();
            int i = 0;
            while (i < results.size()) {
                JsonObject item = results.get(i).getAsJsonObject();
                String shopprodno = item.get("productId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> getCoupangReturnProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result;
        block4: {
            result = new ArrayList<String>();
            try {
                String json = this.getCoupangReturnProductJson(page);
                Connection.Response response = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-web/v2/vendor-inventory/search").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").cookies(cookies).header("Host", "wing.coupang.com").header("Content-Type", "application/json").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                String body = response.body();
                JsonParser parser = new JsonParser();
                JsonObject object = parser.parse(body).getAsJsonObject();
                boolean success = object.get("success").getAsBoolean();
                if (success) {
                    JsonObject data = object.get("data").getAsJsonObject();
                    JsonArray productList = data.get("productList").getAsJsonArray();
                    int i = 0;
                    while (i < productList.size()) {
                        JsonObject item = productList.get(i).getAsJsonObject();
                        String shopprodno = item.get("vendorInventoryId").getAsString();
                        result.add(shopprodno);
                        ++i;
                    }
                    break block4;
                }
                return new ArrayList<String>();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private List<String> getMelchiWaitProducts(Map<String, String> cookies, String start, String end) {
        ArrayList<String> result = new ArrayList<String>();
        int page = 1;
        try {
            while (true) {
                Map<String, String> map = this.getMelchiWaitProductMap(start, end, page);
                Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/register/productList/list").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36").cookies(cookies).data(map).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                Elements datas = body.select("div.sub_section_01 table#table_style04 tbody tr");
                if (datas.size() <= 2) continue;
                Elements stop = ((Element)datas.get(2)).select("td.alCt");
                if (stop.size() <= 0) {
                    int i = 2;
                    while (i < datas.size()) {
                        if (i % 2 == 0) {
                            Elements aa = ((Element)datas.get(i)).getAllElements();
                            String shopprodno = ((Element)aa.get(11)).text();
                            result.add(shopprodno);
                        }
                        ++i;
                    }
                    ++page;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getMerchantID(Map<String, String> cookies, ShoppingMallDetailDto shopInfo) {
        JsonParser parser = new JsonParser();
        try {
            Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/my-info").cookies(cookies).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonObject body = (JsonObject)parser.parse(response.body());
            String resultType = body.get("resultType").getAsString();
            if (resultType.equals("SUCCESS")) {
                JsonObject success = (JsonObject)body.get("success");
                JsonArray merchantMappingArray = (JsonArray)success.get("merchantMappingInfo");
                JsonObject merchantMappingInfo = Integer.parseInt(shopInfo.getAuthkey1()) == 0 ? merchantMappingArray.get(0).getAsJsonObject() : merchantMappingArray.get(Integer.parseInt(shopInfo.getAuthkey1()) - 1).getAsJsonObject();
                int merchantID = merchantMappingInfo.get("merchantId").getAsInt();
                return String.valueOf(merchantID);
            }
            throw new Exception("MerchantID\ub97c \uac00\uc838\uc624\ub358 \uc911 \uc5d0\ub7ec\ubc1c\uc0dd . . .");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private List<String> getNaverCatalogProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String json = this.getNaverCatalogProudctJson(page);
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/best-price/products?_action=getBestPriceProductsListByAccountNo").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").cookies(cookies).header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json;charset=UTF-8").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            JsonArray content = (JsonArray)object.get("content");
            int i = 0;
            while (i < content.size()) {
                JsonObject item = (JsonObject)content.get(i);
                String shopprodno = item.get("productId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getCoupangItemWinnerJson(int page) {
        String json = "";
        try {
            CoupangItemWinnerRequestDTO request = new CoupangItemWinnerRequestDTO();
            request.setSearchIds("");
            request.setSortType("MY_VI_SALES_DESC");
            request.setKeywords("");
            request.setRevamp("B");
            request.setDisplayCategoryIds(new ArrayList<String>());
            request.setProductName("");
            request.setBrandName("");
            request.setAlarmStatus("ALL");
            request.setAutoPriceStatus("ALL");
            request.setVendorItemStatus("ON_SALE");
            request.setItemWinnerStatus("LOSE_NOT_SUPPRESSED");
            request.setRodBadge("ALL");
            request.setPageSize("100");
            request.setPage(page);
            request.setSearchPresets(null);
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return json;
    }

    private String getNaverCatalogProudctJson(int page) {
        String json = "";
        try {
            ArrayList<String> productStatusTypes = new ArrayList<String>();
            productStatusTypes.add("SALE");
            productStatusTypes.add("REJECTION");
            ArrayList<String> channelServiceTypes = new ArrayList<String>();
            channelServiceTypes.add("STOREFARM");
            channelServiceTypes.add("WINDOW");
            NaverCatalogViewDataRequestDTO viewData = new NaverCatalogViewDataRequestDTO();
            viewData.setProductStatusTypes(productStatusTypes);
            viewData.setChannelServiceTypes(channelServiceTypes);
            viewData.setPageSize(100);
            NaverCatalogRequestDTO request = new NaverCatalogRequestDTO();
            request.setSearchKeyword("");
            request.setProductName(null);
            request.setModelName(null);
            request.setMakerName(null);
            request.setBrandName(null);
            request.setAlarm("");
            request.setSearchPeriodType("PROD_REG_DAY");
            request.setBestPriceProductsSearchKeywordType("CHANNEL_PRODUCT_NO");
            request.setFromDate("");
            request.setToDate("");
            request.setViewData(viewData);
            request.setBestPriceProductSearchOrderType("HIGH_PRICE_POWER");
            request.setBestPriceProductStatusType("ALL");
            request.setProductStatusTypes(productStatusTypes);
            request.setChannelServiceTypes(channelServiceTypes);
            request.setPage(page);
            request.setSize(100);
            request.setSort(new ArrayList<String>());
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return json;
    }

    private String getTossReturnProductURL(String merchantID, int page) {
        StringBuilder url = new StringBuilder();
        try {
            url.append("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/");
            url.append(merchantID);
            url.append("/v1/products?page=");
            url.append(String.valueOf(page));
            url.append("&size=100&reviewStatuses=REJECT&displayStatuses=");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return url.toString();
    }

    private String getCoupangReturnProductJson(int page) {
        String json = "";
        try {
            ArrayList<String> productStatus = new ArrayList<String>();
            productStatus.add("REJECTED");
            CoupangReturnProductRequestDTO request = new CoupangReturnProductRequestDTO();
            request.setSearchKeywordType("ALL");
            request.setSearchKeywords("");
            request.setSalesMethod("ALL");
            request.setProductStatus(productStatus);
            request.setStockSearchType("ALL");
            request.setShippingFeeSearchType("ALL");
            request.setDisplayCategoryCodes(new ArrayList<String>());
            request.setListingStartTime(null);
            request.setListingEndTime(null);
            request.setSaleEndDateSearchType("ALL");
            request.setBundledShippingSearchType("ALL");
            request.setDisplayDeletedProduct(false);
            request.setShippingMethod("ALL");
            request.setExposureStatus("ALL");
            request.setSortMethod("SORT_BY_ITEM_LEVEL_UNIT_SOLD");
            request.setCountPerPage(100);
            request.setPage(page);
            request.setLocale("ko_KR");
            request.setCoupangAttributeOptimized(false);
            request.setUpBundleSearchOption("ALL");
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return json;
    }

    private Map<String, String> getMelchiWaitProductMap(String start, String end, int page) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("schYn", "Y");
            map.put("listType", "list");
            map.put("searchDateType", "01");
            map.put("searchDateStart", start);
            map.put("searchDateEnd", end);
            map.put("searchOptional", "01");
            map.put("searchStatus", "01");
            map.put("searchListCountType", "02");
            map.put("page", String.valueOf(page));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
        return map;
    }
}

