/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.data.dao;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.AlimTalkChargeDao;
import com.kdjsystem.mlink.Yd.data.dao.CompInfoDao;
import com.kdjsystem.mlink.Yd.data.dao.CustomerDao;
import com.kdjsystem.mlink.Yd.data.dao.DBCPInit;
import com.kdjsystem.mlink.Yd.data.dao.ProductIforDao;
import com.kdjsystem.mlink.Yd.data.dao.ProductMstDao;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class EcountDao {
    public String API_KEY;
    public String COM_CODE;
    public String USER_ID;
    public String ZONE_URL = "https://oapi.ecounterp.com/OAPI/V2/Zone";
    public String REQ_METHOD = "POST";
    public String ACCEPT = "application/json";
    public String CONTENT_TYPE = "application/json";
    String CUST = "00003";
    String WH_CD = "100";

    public EcountDao() throws Exception {
        try {
            CompInfoDao dao = new CompInfoDao();
            List<String> list = dao.getCompanyInfoByAll();
            this.API_KEY = list.get(5);
            this.COM_CODE = list.get(3);
            this.USER_ID = list.get(4);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private String getZone() throws Exception {
        String zoneStr = null;
        try {
            URL obj = new URL(this.ZONE_URL);
            HttpsURLConnection httpConnection = (HttpsURLConnection)obj.openConnection();
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setDoOutput(true);
            String payload = "{'COM_CODE':'" + this.COM_CODE + "'}";
            DataOutputStream wr = new DataOutputStream(httpConnection.getOutputStream());
            wr.writeBytes(payload);
            wr.flush();
            wr.close();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 404) {
                throw new UnknownHostException("\n\uc778\ud130\ub137 \uc8fc\uc18c\ub97c \ucc3e\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + this.ZONE_URL);
            }
            if (responseCode == 500) {
                throw new UnknownHostException("\nZone \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            if (responseCode == 200) {
                JsonElement status;
                String statusCode;
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonObject = jsonParser.parse(response.toString());
                if (jsonObject.getAsJsonObject().get("Data") != null) {
                    JsonElement jdata = jsonObject.getAsJsonObject().get("Data");
                    JsonElement jzone = jdata.getAsJsonObject().get("ZONE");
                    zoneStr = jzone.getAsString();
                } else if (jsonObject.getAsJsonObject().get("Status") != null && (statusCode = (status = jsonObject.getAsJsonObject().get("Status")).getAsString()).equals("500")) {
                    JsonElement errors = jsonObject.getAsJsonObject().get("Errors");
                    JsonArray array = errors.getAsJsonArray();
                    JsonElement message = array.get(0).getAsJsonObject().get("Message");
                    throw new Exception(message.getAsString());
                }
            }
        }
        catch (UnknownHostException uhe) {
            throw new Exception(String.valueOf(uhe.getMessage()) + "\n\uc778\ud130\ub137 \uc8fc\uc18c\ub97c \ucc3e\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + this.ZONE_URL);
        }
        return zoneStr;
    }

    private String getSessionID(String zoneStr) throws Exception {
        String sessionStr = null;
        String sessionUrl = null;
        try {
            JsonElement status;
            String statusCode;
            sessionUrl = "https://oapi" + zoneStr + ".ecounterp.com/OAPI/V2/OAPILogin";
            URL obj = new URL(sessionUrl);
            HttpsURLConnection httpConnection = (HttpsURLConnection)obj.openConnection();
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setDoOutput(true);
            String payload2 = "{'COM_CODE':'" + this.COM_CODE + "', " + "'USER_ID':'" + this.USER_ID + "', " + " 'API_CERT_KEY':'" + this.API_KEY + "', " + " 'LAN_TYPE':'ko-KR', " + " 'ZONE':'" + zoneStr + "'" + "}";
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.write(payload2.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 404) {
                throw new UnknownHostException("\n\uc778\ud130\ub137 \uc8fc\uc18c\ub97c \ucc3e\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + this.ZONE_URL);
            }
            if (responseCode == 500) {
                throw new Exception("\nEcount \ub2f4\ub2f9\uc790\uc5d0\uac8c \ubb38\uc758 \ubc14\ub78d\ub2c8\ub2e4.");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonObject = jsonParser.parse(response.toString());
            if (jsonObject.getAsJsonObject().get("Data") != null) {
                JsonElement jdata2 = jsonObject.getAsJsonObject().get("Data");
                JsonElement jdatas2 = jdata2.getAsJsonObject().get("Datas");
                if (jdatas2.getAsJsonObject().get("SESSION_ID") == null) {
                    JsonElement message = jdata2.getAsJsonObject().get("Message");
                    throw new Exception(message.getAsString());
                }
                JsonElement sessionID = jdatas2.getAsJsonObject().get("SESSION_ID");
                sessionStr = sessionID.getAsString();
            } else if (jsonObject.getAsJsonObject().get("Status") != null && (statusCode = (status = jsonObject.getAsJsonObject().get("Status")).getAsString()).equals("500")) {
                JsonElement errors = jsonObject.getAsJsonObject().get("Errors");
                JsonArray array = errors.getAsJsonArray();
                JsonElement message = array.get(0).getAsJsonObject().get("Message");
                throw new Exception(message.getAsString());
            }
        }
        catch (UnknownHostException uhe) {
            throw new Exception(String.valueOf(uhe.getMessage()) + "\n\uc778\ud130\ub137 \uc8fc\uc18c\ub97c \ucc3e\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + sessionUrl);
        }
        return sessionStr;
    }

    public List<List<String>> sendProductListToEcount(List<List<String>> contents) throws Exception {
        ArrayList<List<String>> responContents;
        block7: {
            String timeStamp;
            String statusCode;
            JsonElement jsonObject;
            block6: {
                responContents = new ArrayList<List<String>>();
                String zoneStr = this.getZone();
                String sessionId = this.getSessionID(zoneStr);
                String url = "https://oapi" + zoneStr + ".ecounterp.com/OAPI/V2/InventoryBasic/SaveBasicProduct?SESSION_ID=" + sessionId;
                URL obj = new URL(url);
                HttpsURLConnection httpConnection = (HttpsURLConnection)obj.openConnection();
                httpConnection.setRequestMethod(this.REQ_METHOD);
                httpConnection.setRequestProperty("Accept", this.ACCEPT);
                httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
                httpConnection.setDoOutput(true);
                StringBuffer payload = new StringBuffer();
                payload.append("{ 'ProductList': [ ");
                payload.append("\n");
                int i = 0;
                while (i < contents.size()) {
                    payload.append("{ 'Line':'");
                    payload.append(i);
                    payload.append("', 'BulkDatas': ");
                    List<String> list = contents.get(i);
                    payload.append("{ ").append("'PROD_CD'").append(":'").append(list.get(1)).append("'");
                    payload.append(", ").append("'PROD_DES'").append(":'").append(list.get(2)).append("'");
                    payload.append("} } ");
                    if (i < contents.size() - 1) {
                        payload.append(", ");
                    }
                    payload.append("\n");
                    ++i;
                }
                payload.append("] }");
                DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
                out.write(payload.toString().getBytes("UTF-8"));
                out.flush();
                out.close();
                httpConnection.getResponseCode();
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
                String inputLine = null;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                httpConnection.disconnect();
                JsonParser jsonParser = new JsonParser();
                jsonObject = jsonParser.parse(response.toString());
                statusCode = jsonObject.getAsJsonObject().get("Status").getAsString();
                timeStamp = "";
                if (!statusCode.equals("200")) break block6;
                JsonElement dataObject = jsonObject.getAsJsonObject().get("Data");
                JsonElement jsonObject_result = dataObject.getAsJsonObject().get("ResultDetails");
                JsonArray jsonArray_result = jsonObject_result.getAsJsonArray();
                int i2 = 0;
                while (i2 < jsonArray_result.size()) {
                    JsonElement jsonElement = jsonArray_result.get(i2);
                    int msgIndex = jsonElement.getAsJsonObject().get("Line").getAsInt();
                    boolean isSuccess = jsonElement.getAsJsonObject().get("IsSuccess").getAsBoolean();
                    String errorCod = "";
                    String errorMsg = "";
                    timeStamp = jsonObject.getAsJsonObject().get("Timestamp").getAsString();
                    if (!isSuccess) {
                        errorCod = jsonElement.getAsJsonObject().get("Errors").getAsJsonArray().get(0).getAsJsonObject().get("ColCd").getAsString();
                        errorMsg = jsonElement.getAsJsonObject().get("Errors").getAsJsonArray().get(0).getAsJsonObject().get("Message").getAsString();
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    List<String> errProdcut = contents.get(msgIndex);
                    String prodcd = errProdcut.get(1);
                    list.add("" + isSuccess);
                    list.add(errorCod);
                    list.add(errorMsg);
                    list.add(timeStamp);
                    list.add(prodcd);
                    responContents.add(list);
                    ++i2;
                }
                break block7;
            }
            if (!statusCode.equals("500")) break block7;
            JsonElement dataObject = jsonObject.getAsJsonObject().get("Errors");
            JsonArray dataObject_error = dataObject.getAsJsonArray();
            String errorCod = dataObject_error.get(0).getAsJsonObject().get("Code").getAsString();
            String errorMsg = dataObject_error.get(0).getAsJsonObject().get("Message").getAsString();
            timeStamp = YDMATimeUtil.getCurrentTimeByFreeFormat("yyyy-MM-dd HH:mm:ss");
            for (List<String> errorProduct : contents) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("false");
                list.add(errorCod);
                list.add(errorMsg);
                list.add(timeStamp);
                list.add(errorProduct.get(1));
                responContents.add(list);
            }
        }
        return responContents;
    }

    public List<List<String>> sendStockToEcount(List<List<String>> contents, String orddt, String ordseq) throws Exception {
        ArrayList<List<String>> responContents;
        block7: {
            String timeStamp;
            String statusCode;
            JsonElement jsonObject;
            block6: {
                responContents = new ArrayList<List<String>>();
                String zoneStr = this.getZone();
                String sessionId = this.getSessionID(zoneStr);
                String url = "https://oapi" + zoneStr + ".ecounterp.com/OAPI/V2/Sale/SaveSale?SESSION_ID=" + sessionId;
                URL obj = new URL(url);
                HttpsURLConnection httpConnection = (HttpsURLConnection)obj.openConnection();
                httpConnection.setRequestMethod(this.REQ_METHOD);
                httpConnection.setRequestProperty("Accept", this.ACCEPT);
                httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
                httpConnection.setDoOutput(true);
                StringBuffer payload = new StringBuffer();
                payload.append("{ 'SaleList': [ ");
                payload.append("\n");
                int i = 0;
                while (i < contents.size()) {
                    payload.append("{ 'Line':'");
                    payload.append(i);
                    payload.append("', 'BulkDatas': ");
                    List<String> list = contents.get(i);
                    payload.append("{");
                    payload.append("'IO_DATE'").append(":'',");
                    payload.append("'UPLOAD_SER_NO'").append(":'',");
                    payload.append("'CUST'").append(":'").append(this.CUST).append("', ");
                    payload.append("'CUST_DES'").append(":'',");
                    payload.append("'EMP_CD'").append(":'',");
                    payload.append("'WH_CD'").append(":'").append(this.WH_CD).append("', ");
                    payload.append("'IO_TYPE'").append(":'',");
                    payload.append("'EXCHANGE_TYPE'").append(":'',");
                    payload.append("'EXCHANGE_RATE'").append(":'',");
                    payload.append("'PJT_CD'").append(":'',");
                    payload.append("'DOC_NO'").append(":'',");
                    payload.append("'U_MEMO1'").append(":'',");
                    payload.append("'U_MEMO2'").append(":'',");
                    payload.append("'U_MEMO3'").append(":'',");
                    payload.append("'U_MEMO4'").append(":'',");
                    payload.append("'U_MEMO5'").append(":'',");
                    payload.append("'U_TXT1'").append(":'',");
                    payload.append("'PROD_CD'").append(":'").append(list.get(11)).append("', ");
                    payload.append("'PROD_DES'").append(":'").append(list.get(10)).append("', ");
                    payload.append("'SIZE_DES'").append(":'',");
                    payload.append("'UQTY'").append(":'',");
                    payload.append("'QTY'").append(":'").append(list.get(7)).append("', ");
                    payload.append("'PRICE'").append(":'").append(list.get(20)).append("', ");
                    payload.append("'USER_PRICE_VAT'").append(":'',");
                    payload.append("'SUPPLY_AMT'").append(":'',");
                    payload.append("'SUPPLY_AMT_F'").append(":'',");
                    payload.append("'VAT_AMT'").append(":'',");
                    payload.append("'REMARKS'").append(":'',");
                    payload.append("'ITEM_CD'").append(":'',");
                    payload.append("'P_AMT1'").append(":'',");
                    payload.append("'P_AMT2'").append(":'',");
                    payload.append("'P_REMARKS1'").append(":'',");
                    payload.append("'P_REMARKS2'").append(":'',");
                    payload.append("'P_REMARKS3'").append(":'',");
                    payload.append("'REL_DATE'").append(":'',");
                    payload.append("'REL_NO'").append(":'' ,");
                    payload.append("'MAKE_FLAG'").append(":'',");
                    payload.append("'CUST_AMT'").append(":''");
                    payload.append("} ");
                    payload.append("} ");
                    if (i < contents.size() - 1) {
                        payload.append(", ");
                    }
                    payload.append("\n");
                    ++i;
                }
                payload.append("]}");
                YDMAStringUtil.Print(payload);
                DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
                out.write(payload.toString().getBytes("UTF-8"));
                out.flush();
                out.close();
                int responseCode = httpConnection.getResponseCode();
                YDMAStringUtil.Print("\uc774\uce74\uc6b4\ud2b8 \uc7ac\uace0\ucc28\ub9c9 \uc751\ub2f5 : " + responseCode);
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
                String inputLine = null;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                httpConnection.disconnect();
                YDMAStringUtil.Print("SaveSaleOrder Api \uc751\ub2f5 \uba54\uc2dc\uc9c0-1: ====================================");
                YDMAStringUtil.Print(response.toString());
                YDMAStringUtil.Print("SaveSaleOrder Api \uc751\ub2f5 \uba54\uc2dc\uc9c0-2: ====================================");
                JsonParser jsonParser = new JsonParser();
                jsonObject = jsonParser.parse(response.toString());
                statusCode = jsonObject.getAsJsonObject().get("Status").getAsString();
                timeStamp = "";
                if (!statusCode.equals("200")) break block6;
                JsonElement dataObject = jsonObject.getAsJsonObject().get("Data");
                JsonElement jsonObject_result = dataObject.getAsJsonObject().get("ResultDetails");
                JsonArray jsonArray_result = jsonObject_result.getAsJsonArray();
                int i2 = 0;
                while (i2 < jsonArray_result.size()) {
                    JsonElement jsonElement = jsonArray_result.get(i2);
                    int msgIndex = jsonElement.getAsJsonObject().get("Line").getAsInt();
                    boolean isSuccess = jsonElement.getAsJsonObject().get("IsSuccess").getAsBoolean();
                    String errorCod = "";
                    String errorMsg = "";
                    if (!isSuccess) {
                        errorCod = "SaveSale_ERR";
                        errorMsg = jsonElement.getAsJsonObject().get("TotalError").getAsString();
                    }
                    timeStamp = jsonObject.getAsJsonObject().get("Timestamp").getAsString();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("" + isSuccess);
                    list.add(errorCod);
                    list.add(errorMsg);
                    list.add(timeStamp);
                    list.add(orddt);
                    list.add(ordseq);
                    list.add(contents.get(msgIndex).get(0));
                    responContents.add(list);
                    ++i2;
                }
                break block7;
            }
            if (!statusCode.equals("500")) break block7;
            JsonElement dataObject = jsonObject.getAsJsonObject().get("Errors");
            JsonArray dataObject_error = dataObject.getAsJsonArray();
            String errorCod = dataObject_error.get(0).getAsJsonObject().get("Code").getAsString();
            String errorMsg = dataObject_error.get(0).getAsJsonObject().get("Message").getAsString();
            timeStamp = YDMATimeUtil.getCurrentTimeByFreeFormat("yyyy-MM-dd HH:mm:ss");
            for (List<String> errProduct : contents) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("false");
                list.add(errorCod);
                list.add(errorMsg);
                list.add(timeStamp);
                list.add(orddt);
                list.add(ordseq);
                list.add(errProduct.get(0));
                responContents.add(list);
            }
        }
        return responContents;
    }

    public List<List<String>> sendStockToEcountForBusiness(List<List<String>> contents, String orddt, String ordseq) throws Exception {
        ArrayList<List<String>> responContents;
        block7: {
            String timeStamp;
            String statusCode;
            JsonElement jsonObject;
            block6: {
                responContents = new ArrayList<List<String>>();
                String zoneStr = this.getZone();
                String sessionId = this.getSessionID(zoneStr);
                String url = "https://oapi" + zoneStr + ".ecounterp.com/OAPI/V2/Sale/SaveSale?SESSION_ID=" + sessionId;
                URL obj = new URL(url);
                HttpsURLConnection httpConnection = (HttpsURLConnection)obj.openConnection();
                httpConnection.setRequestMethod(this.REQ_METHOD);
                httpConnection.setRequestProperty("Accept", this.ACCEPT);
                httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
                httpConnection.setDoOutput(true);
                StringBuffer payload = new StringBuffer();
                payload.append("{ 'SaleList': [ ");
                payload.append("\n");
                int i = 0;
                while (i < contents.size()) {
                    payload.append("{ 'Line':'");
                    payload.append(i);
                    payload.append("', 'BulkDatas': ");
                    List<String> list = contents.get(i);
                    payload.append("{");
                    payload.append("'IO_DATE'").append(":'',");
                    payload.append("'UPLOAD_SER_NO'").append(":'',");
                    String custStr = list.get(18).substring(1, list.get(18).indexOf(")"));
                    payload.append("'CUST'").append(":'").append(custStr).append("', ");
                    payload.append("'CUST_DES'").append(":'',");
                    payload.append("'EMP_CD'").append(":'',");
                    payload.append("'WH_CD'").append(":'").append(this.WH_CD).append("', ");
                    payload.append("'IO_TYPE'").append(":'',");
                    payload.append("'EXCHANGE_TYPE'").append(":'',");
                    payload.append("'EXCHANGE_RATE'").append(":'',");
                    payload.append("'PJT_CD'").append(":'',");
                    payload.append("'DOC_NO'").append(":'',");
                    payload.append("'U_MEMO1'").append(":'',");
                    payload.append("'U_MEMO2'").append(":'',");
                    payload.append("'U_MEMO3'").append(":'',");
                    payload.append("'U_MEMO4'").append(":'',");
                    payload.append("'U_MEMO5'").append(":'',");
                    payload.append("'U_TXT1'").append(":'',");
                    payload.append("'PROD_CD'").append(":'").append(list.get(11)).append("', ");
                    payload.append("'PROD_DES'").append(":'").append(list.get(10)).append("', ");
                    payload.append("'SIZE_DES'").append(":'',");
                    payload.append("'UQTY'").append(":'',");
                    payload.append("'QTY'").append(":'").append(list.get(7)).append("', ");
                    payload.append("'PRICE'").append(":'").append(list.get(21)).append("', ");
                    payload.append("'USER_PRICE_VAT'").append(":'',");
                    int suppAmt = Integer.parseInt(list.get(7)) * Integer.parseInt(list.get(21));
                    payload.append("'SUPPLY_AMT'").append(":'").append(Integer.toString(suppAmt)).append("', ");
                    payload.append("'SUPPLY_AMT_F'").append(":'',");
                    int suppVat = (int)Math.round((double)suppAmt * 0.1);
                    payload.append("'VAT_AMT'").append(":'").append(Integer.toString(suppVat)).append("', ");
                    payload.append("'REMARKS'").append(":'',");
                    payload.append("'ITEM_CD'").append(":'',");
                    payload.append("'P_AMT1'").append(":'',");
                    payload.append("'P_AMT2'").append(":'',");
                    payload.append("'P_REMARKS1'").append(":'',");
                    payload.append("'P_REMARKS2'").append(":'',");
                    payload.append("'P_REMARKS3'").append(":'',");
                    payload.append("'REL_DATE'").append(":'',");
                    payload.append("'REL_NO'").append(":'' ,");
                    payload.append("'MAKE_FLAG'").append(":'',");
                    payload.append("'CUST_AMT'").append(":''");
                    payload.append("} ");
                    payload.append("} ");
                    if (i < contents.size() - 1) {
                        payload.append(", ");
                    }
                    payload.append("\n");
                    ++i;
                }
                payload.append("]}");
                YDMAStringUtil.Print(payload);
                DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
                out.write(payload.toString().getBytes("UTF-8"));
                out.flush();
                out.close();
                int responseCode = httpConnection.getResponseCode();
                YDMAStringUtil.Print("\uc774\uce74\uc6b4\ud2b8 \uc7ac\uace0\ucc28\ub9c9 \uc751\ub2f5 : " + responseCode);
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
                String inputLine = null;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                httpConnection.disconnect();
                YDMAStringUtil.Print("SaveSaleOrder Api \uc751\ub2f5 \uba54\uc2dc\uc9c0-1: ====================================");
                YDMAStringUtil.Print(response.toString());
                YDMAStringUtil.Print("SaveSaleOrder Api \uc751\ub2f5 \uba54\uc2dc\uc9c0-2: ====================================");
                JsonParser jsonParser = new JsonParser();
                jsonObject = jsonParser.parse(response.toString());
                statusCode = jsonObject.getAsJsonObject().get("Status").getAsString();
                timeStamp = "";
                if (!statusCode.equals("200")) break block6;
                JsonElement dataObject = jsonObject.getAsJsonObject().get("Data");
                JsonElement jsonObject_result = dataObject.getAsJsonObject().get("ResultDetails");
                JsonArray jsonArray_result = jsonObject_result.getAsJsonArray();
                int i2 = 0;
                while (i2 < jsonArray_result.size()) {
                    JsonElement jsonElement = jsonArray_result.get(i2);
                    int msgIndex = jsonElement.getAsJsonObject().get("Line").getAsInt();
                    boolean isSuccess = jsonElement.getAsJsonObject().get("IsSuccess").getAsBoolean();
                    String errorCod = "";
                    String errorMsg = "";
                    if (!isSuccess) {
                        errorCod = "SaveSale_ERR";
                        errorMsg = jsonElement.getAsJsonObject().get("TotalError").getAsString();
                    }
                    timeStamp = jsonObject.getAsJsonObject().get("Timestamp").getAsString();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("" + isSuccess);
                    list.add(errorCod);
                    list.add(errorMsg);
                    list.add(timeStamp);
                    list.add(orddt);
                    list.add(ordseq);
                    list.add(contents.get(msgIndex).get(0));
                    responContents.add(list);
                    ++i2;
                }
                break block7;
            }
            if (!statusCode.equals("500")) break block7;
            JsonElement dataObject = jsonObject.getAsJsonObject().get("Errors");
            JsonArray dataObject_error = dataObject.getAsJsonArray();
            String errorCod = dataObject_error.get(0).getAsJsonObject().get("Code").getAsString();
            String errorMsg = dataObject_error.get(0).getAsJsonObject().get("Message").getAsString();
            timeStamp = YDMATimeUtil.getCurrentTimeByFreeFormat("yyyy-MM-dd HH:mm:ss");
            for (List<String> errProduct : contents) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("false");
                list.add(errorCod);
                list.add(errorMsg);
                list.add(timeStamp);
                list.add(orddt);
                list.add(ordseq);
                list.add(errProduct.get(0));
                responContents.add(list);
            }
        }
        return responContents;
    }

    public List<List<String>> getProdcutListSendToEcount(int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select p.prodcd, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,p.prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + " case ifnull(p.specdes,'') when '' then concat(ifnull(p.prodnm,'')) ELSE concat(ifnull(p.prodnm,''), '_',p.specdes) end " + " from  prodmst as p " + " where ifnull(P.ECOUNTCD, '')='' and p.compno = ? and p.brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                YDMAStringUtil.Print("[getProdcutListSendToEcount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("" + ++rowno);
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add("\ubbf8\ub4f1\ub85d");
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getProdcutListSendFail(String site, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = null;
                if (site.equals(ProductMstDao.GUBUN_E)) {
                    sql = "SELECT a.prodcd, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,a.prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "B.PRODNM , if(A.state='false','\ub4f1\ub85d\uc2e4\ud328','\uc54c\uc218\uc5c6\uc74c') , A.errcd,  A.errdsc " + " FROM  ecountprodlog A  LEFT JOIN  prodmst B " + " ON a.prodcd = b.PRODCD and A.compno = B.compno and A.brandcd = B.brandcd" + " where A.state = 'false' and a.compno = ? and a.brandcd = ? " + " and A.gubun = 'E' " + " Order by a.prodcd ";
                } else if (site.equals(ProductMstDao.GUBUN_S)) {
                    sql = "SELECT a.prodcd, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,a.prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "B.PRODNM , if(A.state='FAIL','\ub4f1\ub85d\uc2e4\ud328','\uc54c\uc218\uc5c6\uc74c') , A.errcd,  A.errdsc " + " FROM  ecountprodlog A  LEFT JOIN  prodmst B " + " ON a.prodcd = b.PRODCD and A.compno = B.compno  and A.brandcd = B.brandcd " + " where A.state = 'FAIL' and a.compno = ? and a.brandcd = ? " + " and A.gubun = 'S' " + " Order by a.prodcd ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                YDMAStringUtil.Print("[getProdcutListSendFail " + site + "]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("" + ++rowno);
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getOrderListEcountSendFail(String orddt, String ordseq) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select  B.errdsc, A.seq , ifnull(rorddt,''), ifnull(rcvnam,''), ifnull(pstno,''),  ";
                sql = String.valueOf(sql) + " ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,''),  ifnull(shpfee,''), ifnull(credit,''),";
                sql = String.valueOf(sql) + " ifnull(optdesc,''), ifnull(prodcd,''), ifnull(messge,''), ifnull(pkgclss,''), ";
                sql = String.valueOf(sql) + " ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,''), ";
                sql = String.valueOf(sql) + " ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt,''), ifnull(ECOUNTSNDYN,'N') ECOUNTSNDYN ";
                sql = String.valueOf(sql) + " from ecountstocklog B , orddtl  A ";
                sql = String.valueOf(sql) + " where B.orddt = ? and B.ordseq=? and B.compno = ? ";
                sql = String.valueOf(sql) + " and A.orddt = B.orddt AND A.ordseq = B.ordseq AND A.seq = B.seq and A.compno = B.compno ";
                sql = String.valueOf(sql) + " order by A.seq ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getOrderListEcountSendFail]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void processEcountProductLog(List<List<String>> contents) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.updateProdmst(connection, statementlist, contents);
                this.deleteEcountProdlog(connection, statementlist, contents);
                this.insertEcountProdlog(connection, statementlist, contents);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void updateProdmst(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" Update PRODMST set ecountcd = prodcd ");
        sqlBuffer.append(" where prodcd = ? and compno = ? ");
        String sql = sqlBuffer.toString().toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtlist.add(pstmt);
        for (List<String> list : contents) {
            if (!list.get(0).equals("true")) continue;
            String prodcd = list.get(4);
            pstmt.setString(1, prodcd);
            pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.addBatch();
            YDMAStringUtil.Print("[updateProdmst]" + pstmt.toString());
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void deleteEcountProdlog(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        String sql = "DELETE FROM ECOUNTPRODLOG where prodcd = ? and gubun='E' and compno = ? ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtlist.add(pstmt);
        for (List<String> list : contents) {
            pstmt.setString(1, list.get(4));
            pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            YDMAStringUtil.Print("[deleteEcountProdlog]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void insertEcountProdlog(Connection connection, List<PreparedStatement> pstmtList, List<List<String>> contents) throws Exception {
        String sql = "insert into ECOUNTPRODLOG  (compno, prodcd, gubun, state, errcd, errdsc, errtime)  values (?, ?, ?, ?, ?, ?, ?) ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtList.add(pstmt);
        for (List<String> list : contents) {
            if (!list.get(0).equals("false")) continue;
            int idx = 0;
            pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setString(++idx, list.get(4));
            pstmt.setString(++idx, ProductMstDao.GUBUN_E);
            pstmt.setString(++idx, list.get(0));
            pstmt.setString(++idx, list.get(1));
            pstmt.setString(++idx, list.get(2));
            pstmt.setString(++idx, list.get(3));
            YDMAStringUtil.Print("[insertEcountProdlog]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void processEcountStocklog(List<List<String>> contents) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.updateOrddtl(connection, statementlist, contents);
                this.deleteEcountStocklog(connection, statementlist, contents);
                this.insertEcountStocklog(connection, statementlist, contents);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void updateOrddtl(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" Update ORDDTL set ECOUNTSNDYN = ? ");
        sqlBuffer.append(" where ORDDT =? and ORDSEQ =? and SEQ =? and compno = ? ");
        String sql = sqlBuffer.toString().toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtlist.add(pstmt);
        YDMAStringUtil.Print("[updateOrddtl]" + pstmt.toString());
        for (List<String> list : contents) {
            if (!list.get(0).equals("true")) continue;
            pstmt.setString(1, "Y");
            pstmt.setString(2, list.get(4));
            pstmt.setString(3, list.get(5));
            pstmt.setString(4, list.get(6));
            pstmt.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void deleteEcountStocklog(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" DELETE FROM ECOUNTSTOCKLOG  ");
        sqlBuffer.append(" WHERE  orddt  IN (SELECT orddt   ");
        sqlBuffer.append("                   FROM (SELECT orddt  ");
        sqlBuffer.append("                         FROM ECOUNTSTOCKLOG ");
        sqlBuffer.append("                         WHERE orddt=? and ordseq=? and seq =? and compno = ? ) X) ");
        String sql = sqlBuffer.toString().toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtlist.add(pstmt);
        int i = 0;
        for (List<String> list : contents) {
            if (i == 0) {
                YDMAStringUtil.Print("[deleteEcountStocklog]" + pstmt.toString());
                ++i;
            }
            pstmt.setString(1, list.get(4));
            pstmt.setString(2, list.get(5));
            pstmt.setString(3, list.get(6));
            pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void insertEcountStocklog(Connection connection, List<PreparedStatement> pstmtlist, List<List<String>> contents) throws Exception {
        String sql = "insert into ECOUNTSTOCKLOG (compno, orddt, ordseq, seq, state, errcd, errdsc, errtime)  values (?, ?, ?, ?, ?, ?, ?, ?) ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtlist.add(pstmt);
        YDMAStringUtil.Print("[insertEcountProdlog]" + pstmt.toString());
        for (List<String> list : contents) {
            if (!list.get(0).equals("false")) continue;
            pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setString(2, list.get(4));
            pstmt.setString(3, list.get(5));
            pstmt.setString(4, list.get(6));
            pstmt.setString(5, list.get(0));
            pstmt.setString(6, list.get(1));
            pstmt.setString(7, list.get(2));
            pstmt.setString(8, list.get(3));
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public List<List<String>> sendKakao(Shell shell, List<List<String>> contents_target, String orddt, String ordseq, String template, boolean flag, int len, String sendtelno) {
        ArrayList<List<String>> responContents = new ArrayList<List<String>>();
        try {
            CompInfoDao comdao = new CompInfoDao();
            List<String> comlist = comdao.getServerCompany();
            String userid = "kdjsystem";
            String real_profile_key = comlist.get(21);
            ArrayList<String> msg = new ArrayList<String>();
            ArrayList<String> tel = new ArrayList<String>();
            String url = "https://alimtalk-api.sweettracker.net/v2/" + real_profile_key + "/sendMessage";
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            AlimTalkChargeDao aldao = new AlimTalkChargeDao();
            aldao.getAlimTalkChargeList(comlist.get(25));
            List<Object> templatecode = new ArrayList();
            if (!template.equals("sms")) {
                templatecode = aldao.getTemplateCodeList(comlist.get(0), template);
            }
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setRequestProperty("userid", userid);
            httpConnection.setDoOutput(true);
            List<Object> suplist = new ArrayList();
            List<Object> cumlist = new ArrayList();
            StringBuffer payload = new StringBuffer();
            payload.append("[");
            int i = 0;
            while (i < contents_target.size()) {
                long time = System.currentTimeMillis();
                List<String> list = contents_target.get(i);
                if (template.equals("sms")) {
                    msg.add(i, list.get(0));
                    payload.append("{");
                    payload.append("\"msgid\"").append(":\"").append(time).append("\",");
                    payload.append("\"profile_key\"").append(":\"").append(real_profile_key).append("\",");
                    if (comlist.get(0).equals("1")) {
                        payload.append("\"template_code\"").append(":\"").append("").append("\",");
                    } else if (comlist.get(0).equals("2")) {
                        payload.append("\"template_code\"").append(":\"").append("udt001").append("\",");
                    } else {
                        payload.append("\"template_code\"").append(":\"").append("kdj002").append("\",");
                    }
                    payload.append("\"receiver_num\"").append(":\"").append(this.splitMark(list.get(1))).append("\",");
                    tel.add(i, list.get(1));
                    payload.append("\"message\"").append(":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"reserved_time\"").append(":\"").append("00000000000000").append("\",");
                    payload.append("\"sms_message\"").append(":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"sms_title\"").append(":\"").append("\",");
                    if (len < 90) {
                        payload.append("\"sms_kind\"").append(":\"").append("S").append("\",");
                    } else {
                        payload.append("\"sms_kind\"").append(":\"").append("L").append("\",");
                    }
                } else {
                    ProductMstDao mstdao = new ProductMstDao();
                    ProductIforDao infodao = new ProductIforDao();
                    List<Object> infolist = new ArrayList();
                    CustomerDao ctdao = new CustomerDao();
                    if (list.size() > 2) {
                        if (!flag) {
                            infolist = template.equals("ord") || template.equals("autoord") ? mstdao.getProductMstList(list.get(23)) : mstdao.getProductMstList(list.get(6));
                        } else if (!list.get(15).equals("")) {
                            infolist = mstdao.getProductMstList(list.get(15));
                        } else {
                            MessageDialog.openError((Shell)shell, (String)"\uce74\uce74\uc624\ud1a1\uc804\uc1a1", (String)"\uc0c1\ud488\ucf54\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                            return responContents;
                        }
                        if (((String)infolist.get(24)).equals("")) {
                            MessageDialog.openError((Shell)shell, (String)"\uce74\uce74\uc624\ud1a1\uc804\uc1a1", (String)"\uc0c1\ud488\ub4f1\ub85d\uc5d0 \uae30\ubcf8\uc815\ubcf4\ubc88\ud638\uac00 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ud655\uc778\ud6c4\uc5d0 \ub2e4\uc2dc \uc9c4\ud589\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4");
                            return responContents;
                        }
                        suplist = infodao.getOpen((String)infolist.get(24));
                        if (!((String)suplist.get(21)).equals("")) {
                            cumlist = ctdao.getCustomerInfoByCustno(this.splitMark((String)suplist.get(21)));
                        } else {
                            MessageDialog.openError((Shell)shell, (String)"\uce74\uce74\uc624\ud1a1\uc804\uc1a1", (String)"\uc0ac\uc5c5\uc790\ubc88\ud638\uac00 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ud655\uc778\ud6c4\uc5d0 \ub2e4\uc2dc \uc9c4\ud589\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4");
                            return responContents;
                        }
                    }
                    if (comlist.get(0).equals("3")) {
                        if (!flag) {
                            if (template.equals("ord")) {
                                msg.add(i, "\ud558\ub298\ub2e4\uc6d0 \uc774\ub984\uc73c\ub85c \uc9c1\ubc1c\uc1a1 \ubd80\ud0c1 \ud569\ub2c8\ub2e4.\r\n\r\n" + (String)infolist.get(1) + " [" + list.get(7) + "]\uac1c\r\n" + list.get(2) + "\r\n[" + list.get(3) + "]" + list.get(4) + "\r\n\uc5f0\ub77d\ucc981:" + list.get(5) + "\r\n\uc5f0\ub77d\ucc982:" + list.get(6) + "\r\n\ubc30\uc1a1\uba54\uc2dc\uc9c0:" + list.get(13));
                            } else if (template.equals("autoord")) {
                                msg.add(i, "\ud558\ub298\ub2e4\uc6d0 \uc774\ub984\uc73c\ub85c \uc9c1\ubc1c\uc1a1 \ubd80\ud0c1 \ud569\ub2c8\ub2e4.\r\n\r\n" + (String)infolist.get(1) + " [" + list.get(7) + "]\uac1c\r\n" + list.get(2) + "\r\n[" + list.get(3) + "]" + list.get(4) + "\r\n\uc5f0\ub77d\ucc981:" + list.get(5) + "\r\n\uc5f0\ub77d\ucc982:" + list.get(6) + "\r\n\ubc30\uc1a1\uba54\uc2dc\uc9c0:" + list.get(13) + "\r\n\r\n\uc1a1\uc7a5\ubc88\ud638\uc785\ub825 : http://mlink.kdjsystem.com/user/invoice");
                            } else if (list.size() > 2) {
                                msg.add(i, list.get(20));
                            } else {
                                msg.add(i, list.get(0));
                            }
                        } else if (list.size() > 2) {
                            msg.add(i, list.get(38));
                        } else {
                            msg.add(i, list.get(0));
                        }
                    } else if (!flag) {
                        if (template.equals("ord")) {
                            msg.add(i, "\uc5b8\ub354\ud150\ub2ec\ub7ec\uc0f5 \uc774\ub984\uc73c\ub85c \uc9c1\ubc1c\uc1a1 \ubd80\ud0c1 \ud569\ub2c8\ub2e4.\r\n\r\n" + (String)infolist.get(1) + " [" + list.get(7) + "]\uac1c\r\n" + list.get(2) + "\r\n[" + list.get(3) + "]" + list.get(4) + "\r\n\uc5f0\ub77d\ucc981:" + list.get(5) + "\r\n\uc5f0\ub77d\ucc982:" + list.get(6) + "\r\n\ubc30\uc1a1\uba54\uc2dc\uc9c0:" + list.get(13));
                        } else if (template.equals("autoord")) {
                            msg.add(i, "\ud558\ub298\ub2e4\uc6d0 \uc774\ub984\uc73c\ub85c \uc9c1\ubc1c\uc1a1 \ubd80\ud0c1 \ud569\ub2c8\ub2e4.\r\n\r\n" + (String)infolist.get(1) + " [" + list.get(7) + "]\uac1c\r\n" + list.get(2) + "\r\n[" + list.get(3) + "]" + list.get(4) + "\r\n\uc5f0\ub77d\ucc981:" + list.get(5) + "\r\n\uc5f0\ub77d\ucc982:" + list.get(6) + "\r\n\ubc30\uc1a1\uba54\uc2dc\uc9c0:" + list.get(13) + "\r\n\r\n\uc1a1\uc7a5\ubc88\ud638\uc785\ub825 : http://mlink.kdjsystem.com/user/invoice");
                        } else if (list.size() > 2) {
                            msg.add(i, list.get(20));
                        } else {
                            msg.add(i, list.get(0));
                        }
                    } else if (list.size() > 2) {
                        msg.add(i, list.get(38));
                    } else {
                        msg.add(i, list.get(0));
                    }
                    payload.append("{");
                    payload.append("\"msgid\"").append(":\"").append(time).append("\",");
                    payload.append("\"profile_key\"").append(":\"").append(real_profile_key).append("\",");
                    payload.append("\"template_code\"").append(":\"").append((String)templatecode.get(2)).append("\",");
                    if (!flag) {
                        if (template.equals("ord")) {
                            payload.append("\"receiver_num\"").append(":\"").append(this.splitMark((String)cumlist.get(6))).append("\",");
                            tel.add(i, (String)cumlist.get(6));
                        } else if (template.equals("autoord")) {
                            payload.append("\"receiver_num\"").append(":\"").append(this.splitMark((String)cumlist.get(6))).append("\",");
                            tel.add(i, (String)cumlist.get(6));
                        } else if (list.size() > 2) {
                            payload.append("\"receiver_num\"").append(":\"").append(this.splitMark(list.get(21))).append("\",");
                            tel.add(i, list.get(21));
                        } else {
                            payload.append("\"receiver_num\"").append(":\"").append(this.splitMark(list.get(1))).append("\",");
                            tel.add(i, list.get(1));
                        }
                    } else if (list.size() > 2) {
                        payload.append("\"receiver_num\"").append(":\"").append(this.splitMark(list.get(39))).append("\",");
                        tel.add(i, list.get(39));
                    } else {
                        payload.append("\"receiver_num\"").append(":\"").append(this.splitMark(list.get(1))).append("\",");
                        tel.add(i, list.get(1));
                    }
                    payload.append("\"message\"").append(":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"reserved_time\"").append(":\"").append("00000000000000").append("\",");
                    payload.append("\"sms_message\"").append(":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"sms_title\"").append(":\"").append("\",");
                    if (!template.equals("ord")) {
                        if (len < 90) {
                            payload.append("\"sms_kind\"").append(":\"").append("S").append("\",");
                        } else {
                            payload.append("\"sms_kind\"").append(":\"").append("L").append("\",");
                        }
                    } else {
                        payload.append("\"sms_kind\"").append(":\"").append("N").append("\",");
                    }
                }
                payload.append("\"sender_num\"").append(":\"").append(sendtelno).append("\",");
                payload.append("\"parcel_company\"").append(":\"").append("08").append("\",");
                payload.append("\"parcel_invoice\"").append(":\"").append("").append("\"");
                payload.append("} ");
                if (i < contents_target.size() - 1) {
                    payload.append(", ");
                }
                payload.append("\n");
                ++i;
            }
            payload.append("] ");
            YDMAStringUtil.Print(payload);
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.write(payload.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("\uce74\uce74\uc624\ud1a1: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            YDMAStringUtil.Print(response.toString());
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonObject = jsonParser.parse(response.toString());
            JsonArray dataObject = jsonObject.getAsJsonArray();
            int i2 = 0;
            while (i2 < dataObject.getAsJsonArray().size()) {
                JsonElement jsonElement = dataObject.getAsJsonArray().get(i2);
                String result = jsonElement.getAsJsonObject().get("result").getAsString();
                if (result.equals("Y")) {
                    String msgid = jsonElement.getAsJsonObject().get("msgid").getAsString();
                    String code = jsonElement.getAsJsonObject().get("code").getAsString();
                    String error = jsonElement.getAsJsonObject().get("error").getAsString();
                    String kind = jsonElement.getAsJsonObject().get("kind").getAsString();
                    String sendtime = jsonElement.getAsJsonObject().get("sendtime").getAsString();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(result);
                    list.add(msgid);
                    list.add(code);
                    list.add(error);
                    list.add(kind);
                    list.add((String)tel.get(i2));
                    list.add((String)msg.get(i2));
                    list.add(sendtime);
                    responContents.add(list);
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(jsonElement.getAsJsonObject().get("result").getAsString());
                    list.add(jsonElement.getAsJsonObject().get("msgid").getAsString());
                    list.add(jsonElement.getAsJsonObject().get("code").getAsString());
                    list.add(jsonElement.getAsJsonObject().get("error").getAsString());
                    list.add(jsonElement.getAsJsonObject().get("kind").getAsString());
                    list.add(jsonElement.getAsJsonObject().get("sendtime").getAsString());
                    responContents.add(list);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public String splitMark(String text) {
        String[] split = text.split("-| ");
        String complite = "";
        int j = 0;
        while (j < split.length) {
            complite = String.valueOf(complite) + split[j];
            complite = complite.trim();
            ++j;
        }
        return complite;
    }
}

