/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.data.dao;

import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ExpDao {
    public boolean checkExpInfo(Connection connection, List<PreparedStatement> pstmtList, int brandcd, String prodcd) throws Exception {
        boolean flag = false;
        PreparedStatement pstmt = null;
        try (ResultSet rs = null;){
            String sql = "SELECT * FROM expprodmst  where prodcd = ?    and compno = ?    and brandcd = ? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            pstmtList.add(pstmt);
            pstmt.setString(1, prodcd);
            pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(3, brandcd);
            rs = pstmt.executeQuery();
            YDMAStringUtil.Print("[checkExpInfo]" + pstmt.toString());
            flag = rs.next();
        }
        return flag;
    }

    public List<List<String>> getProdcutListforExp(int brandcd, int opt, String optStr) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT  A.prodcd, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,A.prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "A.prodnm, ifnull(A.specdes,''),  ifnull(B.EXPOUTNM, ''), " + " ifnull(B.expcd,''), " + " ifnull(B.EXPSUMQTY, 0), ifnull(B.EXPBUNDCD,''), ifnull(B.EXPINVQTY, 0), " + " ifnull(B.EXPKINDNM,''), ifnull(B.EXPFILE,''), ifnull(B.EXPMINBUNQTY, 0), " + " ifnull(B.flagrack,''), ifnull(B.rackconts,'0'), " + " ifnull(B.expinner,''), ifnull(B.expcostnm,'0'), ifnull(B.EXPTABLEFLAG,'0') " + "  FROM prodmst A LEFT join expprodmst B ON A.PRODCD = B.PRODCD and A.compno = B.compno " + " where A.compno = ? ";
                if (brandcd != -1) {
                    sql = String.valueOf(sql) + "  and A.brandcd = ? ";
                }
                if (opt == 0) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  A.prodcd like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by A.prodcd ";
                } else if (opt == 1) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  A.prodnm like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by A.prodnm ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (brandcd != -1) {
                    pstmt.setInt(2, brandcd);
                    if (optStr.length() != 0) {
                        pstmt.setString(3, "%" + optStr + "%");
                    }
                } else if (optStr.length() != 0) {
                    pstmt.setString(2, "%" + optStr + "%");
                }
                YDMAStringUtil.Print("[getProdcutListforExp]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("" + ++rowno);
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    String expoutStr = rs.getString(++i);
                    list.add(expoutStr.equals("1") ? "v" : "");
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    String flagrackStr = rs.getString(++i);
                    list.add(flagrackStr.equals("1") ? "v" : "");
                    list.add(rs.getString(++i));
                    String expinnerStr = rs.getString(++i);
                    String expcostnmStr = rs.getString(++i);
                    list.add(expinnerStr.equals("1") ? "v" : "");
                    list.add(expcostnmStr.equals("1") ? "v" : "");
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<String> getExpMstInfo(int brandcd, String prodcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT  A.prodcd, ifnull(A.prodnm,''), ifnull(A.specdes,''), ifnull(B.EXPOUTNM, ''),             ifnull(B.expcd,''),  ifnull(B.EXPSUMQTY, 0), ifnull(B.EXPBUNDCD,''), ifnull(B.EXPINVQTY, 0),            ifnull(B.EXPKINDNM,''), ifnull(B.EXPFILE, ''), ifnull(B.EXPMINBUNQTY, 0),            ifnull(B.flagrack,''), ifnull(B.rackconts, '0'),            ifnull(B.expinner,''), ifnull(B.expcostnm, '0'), ifnull(B.EXPTABLEFLAG,'0')     FROM prodmst A LEFT join expprodmst B ON A.PRODCD = B.PRODCD and A.compno = B.compno     Where A.prodcd = ?        and A.compno = ?        and A.brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                YDMAStringUtil.Print("[getExpMstInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int i = 0;
                if (rs.next()) {
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    String expoutStr = rs.getString(++i);
                    list.add(expoutStr.equals("1") ? "v" : "");
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    String flagrackStr = rs.getString(++i);
                    list.add(flagrackStr.equals("1") ? "v" : "");
                    list.add(rs.getString(++i));
                    String expinnerStr = rs.getString(++i);
                    String expcostnmStr = rs.getString(++i);
                    list.add(expinnerStr.equals("1") ? "v" : "");
                    list.add(expcostnmStr.equals("1") ? "v" : "");
                    list.add(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public boolean checkExpQtyInfo(Connection connection, List<PreparedStatement> pstmtList, String prodcd) throws Exception {
        boolean flag = false;
        PreparedStatement pstmt = null;
        try (ResultSet rs = null;){
            String sql = "SELECT prodcd FROM expordqtytab  where prodcd = ? and compno = ? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            pstmtList.add(pstmt);
            pstmt.setString(1, prodcd);
            pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            YDMAStringUtil.Print("[checkExpQtyInfo]" + pstmt.toString());
            rs = pstmt.executeQuery();
            flag = rs.next();
        }
        return flag;
    }

    public List<List<String>> getExpQtyInfo(int brandcd, String prodcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(delivtabno, 0)  FROM expordqtytab   where prodcd = ?     and compno = ?     and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                YDMAStringUtil.Print("[getExpQtyInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public boolean checkExpCostInfo(Connection connection, List<PreparedStatement> pstmtList, String prodcd) throws Exception {
        boolean flag = false;
        PreparedStatement pstmt = null;
        try (ResultSet rs = null;){
            String sql = " SELECT prodcd FROM expcost  where prodcd = ? and compno = ? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, prodcd);
            pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmtList.add(pstmt);
            YDMAStringUtil.Print("[checkExpCostInfo]" + pstmt.toString());
            rs = pstmt.executeQuery();
            flag = rs.next();
        }
        return flag;
    }

    public List<List<String>> getExpCostInfo(int brandcd, String prodcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT ifnull(DELIVAMT, 0) FROM expcost   where prodcd = ? and compno = ?   and brandcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                YDMAStringUtil.Print("[getExpCostInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int[] processUpdateExpInfo(int brandcd, String prodcd, List<String> contentsExpInfo, List<List<String>> contentsQty, List<List<String>> contentsCost) throws Exception {
        int[] result = null;
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                if (!this.checkExpInfo(connection, statementlist, brandcd, prodcd)) {
                    this.insertExpInfo(connection, statementlist, brandcd, prodcd, contentsExpInfo);
                } else {
                    this.updateExpInfo(connection, statementlist, prodcd, contentsExpInfo, brandcd);
                }
                if (!this.checkExpQtyInfo(connection, statementlist, prodcd)) {
                    this.insertQty(connection, statementlist, brandcd, prodcd, contentsQty);
                } else {
                    this.updateQty(connection, statementlist, prodcd, contentsQty, brandcd);
                }
                if (!this.checkExpCostInfo(connection, statementlist, prodcd)) {
                    this.insertCost(connection, statementlist, brandcd, prodcd, contentsCost);
                } else {
                    this.updateCost(connection, statementlist, prodcd, contentsCost, brandcd);
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void updateExpInfo(Connection connection, List<PreparedStatement> statementlist, String prodcd, List<String> contentsExpInfo, int brandcd) throws Exception {
        String sql = "update expprodmst set EXPCD=?, EXPSUMQTY=?, EXPBUNDCD=? ";
        sql = String.valueOf(sql) + " , EXPINVQTY=?, EXPKINDNM=? , EXPFILE=?, EXPMINBUNQTY=?, EXPOUTNM=? ";
        sql = String.valueOf(sql) + " , flagrack=?, rackconts=? ";
        sql = String.valueOf(sql) + " , expinner=?, expcostnm=? , exptableflag = ? ";
        sql = String.valueOf(sql) + " , modifydt=?, modifyid=? ";
        sql = String.valueOf(sql) + " where prodcd=? and compno = ? and brandcd = ?";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        YDMAStringUtil.Print("[updateExpInfo]" + pstmt.toString());
        int i = 0;
        int index = 0;
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, YDMAStringUtil.replaceEmptyStringToNull(contentsExpInfo.get(index++)));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, YDMAStringUtil.replaceEmptyStringToNull(contentsExpInfo.get(index++)));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, YDMAStringUtil.replaceEmptyStringToNull(contentsExpInfo.get(index++)));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, contentsExpInfo.get(index++));
        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
        pstmt.setString(++i, prodcd);
        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++i, brandcd);
        pstmt.executeUpdate();
    }

    public void updateQty(Connection connection, List<PreparedStatement> pstmtList, String prodcd, List<List<String>> contentsExpInfo, int brandcd) throws Exception {
        String sql = "update EXPORDQTYTAB set DELIVTABNO =?  where PRODCD=? and ORDQTY=? and compno = ? and brandcd = ?";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtList.add(pstmt);
        YDMAStringUtil.Print("[updateQty]" + pstmt.toString());
        for (List<String> list : contentsExpInfo) {
            pstmt.setString(1, YDMAStringUtil.replaceEmptyStringToNull(list.get(1)));
            pstmt.setString(2, prodcd);
            pstmt.setString(3, YDMAStringUtil.replaceEmptyStringToNull(list.get(0)));
            pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(5, brandcd);
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void updateCost(Connection connection, List<PreparedStatement> pstmtList, String prodcd, List<List<String>> contentsCost, int brandcd) throws Exception {
        String sql = "replace into EXPCOST (COMPNO, BRANDCD, PRODCD, TABNO, DELIVAMT) values (?, ?, ?, ?, ?)";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtList.add(pstmt);
        YDMAStringUtil.Print("[updateCost]" + pstmt.toString());
        for (List<String> list : contentsCost) {
            pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(2, brandcd);
            pstmt.setString(3, prodcd);
            pstmt.setString(4, YDMAStringUtil.replaceEmptyStringToNull(list.get(0)));
            pstmt.setString(5, YDMAStringUtil.replaceEmptyStringToNull(list.get(1)));
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void insertExpInfo(Connection connection, List<PreparedStatement> statementlist, int brandcd, String prodcd, List<String> contentsExpInfo) throws Exception {
        String sql = "insert expprodmst (compno, brandcd, PRODCD, EXPCD, EXPSUMQTY, EXPBUNDCD ";
        sql = String.valueOf(sql) + " , EXPINVQTY, EXPKINDNM , EXPFILE, EXPMINBUNQTY , EXPOUTNM ";
        sql = String.valueOf(sql) + " , flagrack, rackconts, expinner, expcostnm, exptableflag ";
        sql = String.valueOf(sql) + " , insertdt, insertid) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int idx = 0;
        int i = 0;
        pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++idx, brandcd);
        pstmt.setString(++idx, prodcd);
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, YDMAStringUtil.replaceEmptyStringToNull(contentsExpInfo.get(i++)));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, YDMAStringUtil.replaceEmptyStringToNull(contentsExpInfo.get(i++)));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, YDMAStringUtil.replaceEmptyStringToNull(contentsExpInfo.get(i++)));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, contentsExpInfo.get(i++));
        pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
        YDMAStringUtil.Print("[insertExpInfo]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void insertQty(Connection connection, List<PreparedStatement> pstmtList, int brandcd, String prodcd, List<List<String>> contentsExpInfo) throws Exception {
        String sql = "insert EXPORDQTYTAB (compno, brandcd, PRODCD, ORDQTY, DELIVTABNO)  values (?,?, ?, ?, ?) ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtList.add(pstmt);
        YDMAStringUtil.Print("[insertQty]" + pstmt.toString());
        for (List<String> list : contentsExpInfo) {
            pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(2, brandcd);
            pstmt.setString(3, prodcd);
            pstmt.setString(4, YDMAStringUtil.replaceEmptyStringToNull(list.get(0)));
            pstmt.setString(5, YDMAStringUtil.replaceEmptyStringToNull(list.get(1)));
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void insertCost(Connection connection, List<PreparedStatement> pstmtList, int brandcd, String prodcd, List<List<String>> contentsCost) throws Exception {
        String sql = "replace into EXPCOST (compno, brandcd, PRODCD, TABNO, DELIVAMT) values (?, ?, ?, ?, ?) ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        pstmtList.add(pstmt);
        YDMAStringUtil.Print("[insertCost]" + pstmt.toString());
        for (List<String> list : contentsCost) {
            pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(2, brandcd);
            pstmt.setString(3, prodcd);
            pstmt.setString(4, YDMAStringUtil.replaceEmptyStringToNull(list.get(0)));
            pstmt.setString(5, YDMAStringUtil.replaceEmptyStringToNull(list.get(1)));
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public void setExpSiteInsertNdelete(Connection connection, List<PreparedStatement> statementlist, int brandcd, String prodcd, List<String> shopseq, List<String> shopcd) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "insert into expsite (COMPNO,brandcd,PRODCD,SHOPCD,SHOPSEQ) values(?, ?, ?, ?, ?)";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int k = 0;
        while (k < shopseq.size()) {
            int i = 0;
            pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(++i, brandcd);
            pstmt.setString(++i, prodcd);
            pstmt.setString(++i, shopcd.get(k));
            pstmt.setString(++i, shopseq.get(k));
            YDMAStringUtil.Print("[deleteOrder]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
            ++k;
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    private boolean isExistExpress(Connection connection, List<PreparedStatement> statementlist, int brandcd, String prodcd) throws Exception {
        boolean flag = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select PRODCD from expsite  where COMPNO = ?    and PRODCD = ?    and brandcd = ?";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(2, prodcd);
        pstmt.setInt(3, brandcd);
        YDMAStringUtil.Print("[isExistExpress]" + pstmt.toString());
        rs = pstmt.executeQuery();
        flag = rs.next();
        return flag;
    }

    private void scheduSiteDelete(Connection connection, List<PreparedStatement> statementlist, int brandcd, String prodcd) throws Exception {
        String sql = "delete from expsite  where COMPNO = ?    and PRODCD = ?    and brandcd = ? ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(2, prodcd);
        pstmt.setInt(3, brandcd);
        pstmt.executeUpdate();
    }

    public void setExpressSite(int brandcd, String prodcd, List<String> contentsExpInfo, List<List<String>> contentsQty, List<List<String>> contentsCost, List<String> shopseq, List<String> shopcd) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                if (contentsExpInfo.get(13).equals("1")) {
                    if (this.isExistExpress(connection, statementlist, brandcd, prodcd)) {
                        this.scheduSiteDelete(connection, statementlist, brandcd, prodcd);
                        this.setExpSiteInsertNdelete(connection, statementlist, brandcd, prodcd, shopseq, shopcd);
                    } else {
                        this.setExpSiteInsertNdelete(connection, statementlist, brandcd, prodcd, shopseq, shopcd);
                    }
                } else if (this.isExistExpress(connection, statementlist, brandcd, prodcd)) {
                    this.scheduSiteDelete(connection, statementlist, brandcd, prodcd);
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<List<String>> getExpSite(String prodcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT compno,prodcd,shopcd,shopseq FROM expsite  where prodcd = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getExpCostInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }
}

