/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.Yd.data.dao;

import com.kdjsystem.mlink.Yd.common.YDMASessonUtil;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.DBCPInit;
import com.kdjsystem.mlink.Yd.data.dao.ProductMstDao;
import com.kdjsystem.mlink.Yd.data.dao.ProductMstDto;
import com.kdjsystem.mlink.shop.dao.ShopProductOptionDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProductOptDao {
    public List<List<String>> getProdcutOptList(String prodcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select optprodcd, optprodnm, optspecdes, optea, optsale, optsaleout , optnotuse , optsafestock, optvertstock, optaddamt, optdelyn   from optprodmst   where prodcd = ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getProdcutOptList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int idx = 0;
                    list.add("" + ++rowno);
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int getProdcutOptCount(Connection connection, List<PreparedStatement> statementlist, String prodcd, String optprodcd) throws Exception {
        int count = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select prodcd  from optprodmst  where prodcd=? and optprodcd=? and compno = ? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            statementlist.add(pstmt);
            pstmt.setString(1, prodcd);
            pstmt.setString(2, optprodcd);
            pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
            YDMAStringUtil.Print("[getProdcutOptCount]" + pstmt.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ++count;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeResultSet(rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeResultSet(rs);
        return count;
    }

    public List<String> getProdcutOptInfo(String prodcd, String optprodcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select optprodcd, optprodnm, optspecdes, optea, optsale, optsaleout , optnotuse , optsafestock, optvertstock, optaddamt, optdelyn  from optprodmst where prodcd =? and optprodcd =? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, optprodcd);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getProdcutOptInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int idx = 0;
                    list.add("");
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                    list.add(rs.getString(++idx));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public String makeSubCode_Y(String code) {
        String code_new = "Y" + code;
        return code_new;
    }

    public String makeSubCode_W(String code) {
        String code_new = code.substring(1, code.length());
        code_new = "W" + code_new;
        return code_new;
    }

    public void insertProductSubAuto(Connection connection, List<PreparedStatement> statementlist, int brandcd, String prodcd, String proddtcd) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "insert into proddtl (compno, brandcd, prodcd, proddtcd, insertdt, insertid) ";
        sql = String.valueOf(sql) + " values (?, ?, ?, ?, ?, ?) ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int i = 0;
        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++i, brandcd);
        pstmt.setString(++i, prodcd);
        pstmt.setString(++i, proddtcd);
        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
        YDMAStringUtil.Print("[insertProductSubAuto]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void processProductOptInsert(int brandcd, String prodcd, String ecount, String optprodcd, String optprodnm, String optspecdes, String optea, String optsale, String optsaleout, String optnotuse, String optsafestock, String optvertstock, String optaddamt, String optdelyn, boolean isNew) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.optcheckProdcutMst(connection, statementlist, prodcd);
                this.insertProdcutOpt(connection, statementlist, brandcd, prodcd, optprodcd, optprodnm, optspecdes, optea, optsale, optsaleout, optnotuse, optsafestock, optvertstock, optaddamt, optdelyn);
                if (!isNew) {
                    this.copyProductOpt(connection, statementlist, brandcd, prodcd, ecount, optprodcd, optprodnm, optspecdes, optdelyn);
                }
                if (optprodcd.startsWith("YWD") || optprodcd.startsWith("YWC") || optprodcd.startsWith("YWT") || optprodcd.startsWith("YWS") || optprodcd.startsWith("YWL") || optprodcd.startsWith("YWH") || optprodcd.startsWith("YWM") || optprodcd.startsWith("YWR")) {
                    String subCodeY = this.makeSubCode_Y(optprodcd);
                    this.insertProductSubAuto(connection, statementlist, brandcd, optprodcd, subCodeY);
                    String subCodeW = this.makeSubCode_W(optprodcd);
                    this.insertProductSubAuto(connection, statementlist, brandcd, optprodcd, subCodeW);
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void optcheckProdcutMst(Connection connection, List<PreparedStatement> statementlist, String prodcd) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "update prodmst set optchk=? where prodcd=? and compno = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int idx = 0;
        pstmt.setString(++idx, "1");
        pstmt.setString(++idx, prodcd);
        pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
        YDMAStringUtil.Print("[optcheckProdcutMst]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void insertProdcutOpt(Connection connection, List<PreparedStatement> statementlist, int brandcd, String prodcd, String optprodcd, String optprodnm, String optspecdes, String optea, String optsale, String optsaleout, String optnotuse, String optsafestock, String optvertstock, String optaddamt, String optdelyn) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "insert into optprodmst (compno, brandcd, prodcd, optprodcd, optprodnm, optspecdes, ";
        sql = String.valueOf(sql) + " optea, optsale, optsaleout, optnotuse, optsafestock, optvertstock,  optaddamt, optdelyn, insertdt, insertid) ";
        sql = String.valueOf(sql) + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?) ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int idx = 0;
        pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++idx, brandcd);
        pstmt.setString(++idx, prodcd);
        pstmt.setString(++idx, optprodcd);
        pstmt.setString(++idx, optprodnm);
        pstmt.setString(++idx, optspecdes);
        pstmt.setString(++idx, optea);
        pstmt.setString(++idx, optsale);
        pstmt.setString(++idx, optsaleout);
        pstmt.setString(++idx, optnotuse);
        pstmt.setString(++idx, optsafestock);
        pstmt.setString(++idx, optvertstock);
        pstmt.setString(++idx, optaddamt);
        pstmt.setString(++idx, optdelyn);
        pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
        YDMAStringUtil.Print("[insertProdcutOpt]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void copyProductOpt(Connection connection, List<PreparedStatement> statementlist, int brandcd, String prodcd, String ecount, String optprodcd, String optprodnm, String optspecdes, String optdelyn) throws Exception {
        PreparedStatement pstmt = null;
        ProductMstDao dao = new ProductMstDao();
        ProductMstDto pmdto = dao.getProdcutInfoByProdcd(prodcd, brandcd);
        String sql = "insert into prodmst (compno, brandcd, prodcd, ecountcd,prodnm, specdes, flagset, flagplus, flagout,  price, tagprice, sabcd, remark, ea,  useyn, delyn, insertdt, insertid ,cusprice)   values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ) ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int idx = 0;
        pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++idx, brandcd);
        pstmt.setString(++idx, optprodcd);
        pstmt.setString(++idx, ecount);
        pstmt.setString(++idx, optprodnm);
        pstmt.setString(++idx, optspecdes);
        pstmt.setString(++idx, pmdto.getFlagset());
        pstmt.setString(++idx, pmdto.getFlagplus());
        pstmt.setString(++idx, pmdto.getFlagout());
        pstmt.setString(++idx, pmdto.getPrice());
        pstmt.setString(++idx, pmdto.getTagprice());
        pstmt.setString(++idx, pmdto.getSabcd());
        pstmt.setString(++idx, pmdto.getRemark());
        pstmt.setString(++idx, pmdto.getEa());
        pstmt.setString(++idx, pmdto.getUseyn());
        pstmt.setString(++idx, pmdto.getDelyn());
        pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
        pstmt.setInt(++idx, 0);
        YDMAStringUtil.Print("[copyProductOpt]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void deleteProductFromOptProdmst(Connection connection, List<PreparedStatement> statementlist, String prodcd, String optprodcd) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "update optprodmst set OPTDELYN=?, modifydt=?, modifyid=? where prodcd=? and optprodcd=? and compno = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int idx = 0;
        pstmt.setString(++idx, "N");
        pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
        pstmt.setString(++idx, prodcd);
        pstmt.setString(++idx, optprodcd);
        pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
        YDMAStringUtil.Print("[deleteProductFromOptProdmst]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void processProductOptUpdate(String prodcd, String optprodcd, String optprodnm, String optspecdes, String optea, String optsale, String optsaleout, String optnotuse, String optsafestock, String optvertstock, String optaddamt, String optdelyn) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.updateOptProdmst(connection, statementlist, prodcd, optprodcd, optprodnm, optspecdes, optea, optsale, optsaleout, optnotuse, optsafestock, optvertstock, optaddamt, optdelyn);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void updateProdmst(Connection connection, List<PreparedStatement> statementlist, String optprodcd, String optdelyn) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "update prodmst set delyn=?, modifydt=?, MODIFYID=? where prodcd=? and compno = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int idx = 0;
        pstmt.setString(++idx, optdelyn);
        pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
        pstmt.setString(++idx, optprodcd);
        pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
        YDMAStringUtil.Print("[updateProdmst-opt]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void updateOptProdmst(Connection connection, List<PreparedStatement> statementlist, String prodcd, String optprodcd, String optprodnm, String optspecdes, String optea, String optsale, String optsaleout, String optnotuse, String optsafestock, String optvertstock, String optaddamt, String optdelyn) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "update optprodmst set optprodnm=?, optspecdes=?, optea=?, optsale=?, optsaleout=?,    optnotuse=?, optsafestock=?, optvertstock=?,  optaddamt=?, optdelyn=? , modifydt=?, modifyid=?    where prodcd=? and  optprodcd=? and compno = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int idx = 0;
        pstmt.setString(++idx, optprodnm);
        pstmt.setString(++idx, optspecdes);
        pstmt.setString(++idx, optea);
        pstmt.setString(++idx, optsale);
        pstmt.setString(++idx, optsaleout);
        pstmt.setString(++idx, optnotuse);
        pstmt.setString(++idx, optsafestock);
        pstmt.setString(++idx, optvertstock);
        pstmt.setString(++idx, optaddamt);
        pstmt.setString(++idx, optdelyn);
        pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
        pstmt.setString(++idx, prodcd);
        pstmt.setString(++idx, optprodcd);
        pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
        YDMAStringUtil.Print("[updateOptProdmst]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public boolean isExistProductNProdcd(String optprodcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select optprodcd from optprodmst where optprodcd = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, optprodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistProduct]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public void deleteoptprodinfo(List<ShopProductOptionDto> list) throws Exception {
        block5: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "delete from shop_optprodinfo where prodseq = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setInt(1, list.get(0).getProdseq());
                    pstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void insertprodinfo(List<ShopProductOptionDto> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("PRODSEQ");
                lstInsert.add("SKUSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("PRODCD");
                lstInsert.add("OPTPRODCD");
                lstInsert.add("OPTPRODNM");
                lstInsert.add("OPTSPECDES");
                lstInsert.add("OPTSAFESTOCK");
                lstInsert.add("OPTVERTSTOCK");
                lstInsert.add("OPTADDAMT");
                lstInsert.add("LIMIT_PRICE");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                StringBuilder sb = new StringBuilder();
                String query = this.getInsertQueryMapper(lstInsert, "shop_optprodinfo");
                sb.append(query);
                String sql = sb.toString();
                YDMAStringUtil.Print(sql);
                sql = sql.toUpperCase();
                int i = 1;
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int j = 0;
                while (j < list.size()) {
                    int rowIdx2 = 0;
                    pstmt.setInt(++rowIdx2, list.get(j).getProdseq());
                    pstmt.setInt(++rowIdx2, i);
                    pstmt.setString(++rowIdx2, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++rowIdx2, list.get(j).getProdcd());
                    String optrprodcd = list.get(j).getProdcd().concat("-").concat(YDMAStringUtil.leftPad(String.valueOf(i), 2, "0"));
                    pstmt.setString(++rowIdx2, optrprodcd);
                    pstmt.setString(++rowIdx2, list.get(j).getOptprodnm());
                    pstmt.setString(++rowIdx2, list.get(j).getOptspecdes());
                    pstmt.setString(++rowIdx2, list.get(j).getOptvertstock());
                    pstmt.setString(++rowIdx2, list.get(j).getOptvertstock());
                    pstmt.setInt(++rowIdx2, list.get(j).getOptaddamt());
                    pstmt.setString(++rowIdx2, list.get(j).getLimit_price() == null ? "0" : list.get(j).getLimit_price());
                    pstmt.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                    ++i;
                    pstmt.executeUpdate();
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    connection.commit();
                    ++j;
                }
            }
            catch (Exception e) {
                connection.rollback();
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public String getInsertQueryMapper(List<String> lstInsert, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("INSERT INTO %s ", tableName));
        String head = lstInsert.stream().collect(Collectors.joining(",", "(", ") "));
        String bottom = lstInsert.stream().map(p -> String.valueOf("?")).collect(Collectors.joining(",", " VALUES (", ") "));
        sb_result.append(head);
        sb_result.append(bottom);
        return sb_result.toString();
    }
}

