/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.ProductFactory;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class ShopWorkBackground
extends Thread {
    private static ShopWorkBackground instance = new ShopWorkBackground();
    private ExecutorService executorService;
    private CompletionHandler<ShopProductSendDto, ShopProductSendDto> callback = new CompletionHandler<ShopProductSendDto, ShopProductSendDto>(){

        @Override
        public void completed(ShopProductSendDto result, ShopProductSendDto attachment) {
            result.getWorkMngDto().getWork_detail();
            List<ShopProductDto> shopProductDto = result.getShopProductDto().stream().filter(p -> p.getResult_code().equals("1")).collect(Collectors.toList());
            result.setShopProductDto(shopProductDto);
            try {
                result.getWorkMngDto().setWorkgrp(result.getWorkgrp());
                ShopWorkDataQueue.get().delete(result.getWorkMngDto().getWorkgrp());
                ShopWorkDataQueue.get().notifyObservers();
                ShopWorkDataQueue.get().notifyCompleteObservers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void failed(Throwable exc, ShopProductSendDto attachment) {
            if (attachment.getWorkMngDto().getWork_status().equals("-1") || attachment.getWorkMngDto().getWork_status().equals("W06")) {
                YDMAStringUtil.Print(exc.getMessage());
            }
        }
    };

    private ShopWorkBackground() {
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public static ShopWorkBackground get() {
        return instance;
    }

    public void startBackground() {
        Thread.State state = this.getState();
        if (state == Thread.State.NEW) {
            this.setDaemon(true);
            this.start();
            YDMAStringUtil.Print("\uc2a4\ub808\ub4dc \uc2dc\uc791");
        }
    }

    private Runnable getRunnableRegister(ShopProductSendDto senddto) {
        Runnable run = () -> {
            IProduct service = ProductFactory.getRegisterBean(senddto.getShopCd());
            try {
                ShopProductSendDto result_dto = service.excute(senddto);
                this.callback.completed(result_dto, result_dto);
            }
            catch (Exception exception) {
                this.callback.completed(senddto, senddto);
            }
        };
        return run;
    }

    private Runnable getRunnableModify(ShopProductSendDto senddto) {
        Runnable run = () -> {
            IProduct service = ProductFactory.getModifyBean(senddto.getShopCd());
            try {
                ShopProductSendDto result_dto = service.excute(senddto);
                this.callback.completed(result_dto, result_dto);
            }
            catch (Exception exception) {
                this.callback.completed(senddto, senddto);
            }
        };
        return run;
    }

    @Override
    public void run() {
        while (true) {
            ExecutorService executorService = ShopWorkDataQueue.get().getExecutorService();
            try {
                Thread.sleep(3000L);
                ShopProductSendDto senddto = ShopWorkDataQueue.get().getWaitData();
                ShopProductSendDto sendmodifydto = ShopWorkDataQueue.get().getModifyData();
                ShopProductSendDto sendmodifySoldoutdto = ShopWorkDataQueue.get().getModifySoldOutData();
                ShopProductSendDto sendmodifyDeletedto = ShopWorkDataQueue.get().getModifyDeleteData();
                if (senddto != null) {
                    executorService.submit(this.getRunnableRegister(senddto));
                }
                if (sendmodifydto != null) {
                    executorService.submit(this.getRunnableModify(sendmodifydto));
                }
                if (sendmodifySoldoutdto != null) {
                    executorService.submit(this.getRunnableModify(sendmodifySoldoutdto));
                }
                if (sendmodifyDeletedto == null) continue;
                executorService.submit(this.getRunnableModify(sendmodifyDeletedto));
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

